/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileTreePanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigPanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.deviceoperation.util.DirAndFileInfo;
import com.huawei.dc.deviceoperation.util.FileNode;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FileSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected FileTreePanel m_oFileTreePanel = null;
    protected FileTablePanel m_oFileTablePanel = null;
    private LoadFileInfoListParam m_oLoadSoftwareParam = null;
    private boolean isDMSDevice = false;
    private boolean m_isSelectLoadOpr = false;
    private int operationType = -1;
    private JButton m_oSelectBtn = null;
    private StartupConfigPanel m_oStartupCofigPanel = null;
    private Resource m_oSelectedResource = null;
    private int m_oContext;
    private boolean m_bLabelAdd = false;
    JLabel m_FileSelectLbl = null;
    private ITask m_oTask;

    public int getOperationType() {
        return this.operationType;
    }

    public FileSelectionPanel(int iOperationType, LoadFileInfoListParam oLoadSoftwareParam, ITask oTask, List<DeviceTypeInfo> oDevTypeInfoLst) throws DCException {
        this.m_oLoadSoftwareParam = oLoadSoftwareParam;
        this.operationType = iOperationType;
        this.m_oTask = oTask;
        this.jbinit(iOperationType, oDevTypeInfoLst);
    }

    public FileSelectionPanel(int iOperationType, LoadFileInfoListParam oLoadSoftwareParam, ITask oTask, Resource oRes) throws DCException {
        this.m_oLoadSoftwareParam = oLoadSoftwareParam;
        this.operationType = iOperationType;
        this.m_oTask = oTask;
        this.m_oSelectedResource = oRes;
        this.jbinit(iOperationType, null);
    }

    private void jbinit(int iOperationType, List<DeviceTypeInfo> oDevTypeInfoLst) throws DCException {
        if (null != this.m_oTask.getSelectedDeviceType()) {
            if (5 != iOperationType) {
                if (null == oDevTypeInfoLst || 0 == oDevTypeInfoLst.size()) {
                    String FileSelectText = ResourceManager.getInstance().getResString("SELECT_DEVICE_SPECIFIC_LOAD_FILES_LBL");
                    this.m_FileSelectLbl = new JLabel(FileSelectText);
                    this.m_bLabelAdd = true;
                    this.m_oFileTablePanel = new FileTablePanel(iOperationType, this.m_oLoadSoftwareParam, this.m_oTask);
                } else {
                    this.m_oFileTablePanel = new FileTablePanel(iOperationType, this.m_oLoadSoftwareParam, oDevTypeInfoLst, this.m_oTask);
                }
            } else {
                this.m_oFileTablePanel = new FileTablePanel(iOperationType, this.m_oLoadSoftwareParam, this.m_oSelectedResource, this.m_oTask);
            }
            this.m_oFileTablePanel.setName("DeviceOperation_FileSelectionPanel_m_oFileTablePanel");
        }
        this.initializePanelBorder();
        this.addComponentsToPanel();
        if (!this.isSelectLoadFileByInputPath()) {
            this.createTreePanel();
        }
        if (2 != this.m_oTask.getTaskTypeId() && 5 != this.operationType) {
            this.customizedPanelForDeviceLevelLoad(this.m_oTask.getSelectedDeviceType());
        }
        if (null != this.m_oFileTablePanel) {
            this.m_oFileTablePanel.setFileSelectionPanel(this);
        }
        if (this.m_oTask.isDMSDomain()) {
            this.isDMSDevice = true;
        }
        this.upgradeBootroomSelectState();
        if (iOperationType == 3) {
            DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_PATCH_U_LOAD_PATCH");
        } else {
            DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_SW_U_LOADSOFT");
        }
    }

    private void addComponentsToPanel() {
        this.setLayout(new GridBagLayout());
        if (this.isSelectLoadFileByInputPath()) {
            this.m_oFileTablePanel.createAddButton();
            this.add((Component)this.m_oFileTablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        } else if (this.m_bLabelAdd) {
            this.add((Component)this.m_FileSelectLbl, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 1, new Insets(0, 5, 10, 0), 0, 0));
            JPanel selectPanel = new JPanel();
            selectPanel.setLayout(new GridBagLayout());
            selectPanel.add((Component)this.createSelectButton(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)selectPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.m_oFileTablePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.m_bLabelAdd = false;
        } else {
            JPanel selectPanel = new JPanel();
            selectPanel.setLayout(new GridBagLayout());
            selectPanel.add((Component)this.createSelectButton(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)selectPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.m_oFileTablePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }
    }

    private boolean isSelectLoadFileByInputPath() {
        return this.m_oTask.isThirdPartySupported() && this.m_oTask.isDMSDomain();
    }

    private void initializePanelBorder() {
        Border deviceOptionBorder = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder selectLoadFilesTitledBorder = new TitledBorder(deviceOptionBorder, ResourceManager.getInstance().getResString("SELECTE_LOAD_FILE_TITLE_BORDER"));
        this.setBorder(selectLoadFilesTitledBorder);
    }

    private JButton createSelectButton() {
        this.m_oSelectBtn = new JButton();
        this.m_oSelectBtn.setName("DeviceOperation_FileSelectionPanel_oSelectBtn");
        ImageIcon forwardIcon = ResourceManager.getInstance().getImage("play.gif");
        this.m_oSelectBtn.setIcon(forwardIcon);
        this.m_oSelectBtn.setPreferredSize(new Dimension(25, 25));
        this.m_oSelectBtn.setToolTipText(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_SINGLE_BTN_TOOL_TIP"));
        this.m_oSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSelectionPanel.this.selectBtnActionPerformed();
            }
        });
        return this.m_oSelectBtn;
    }

    public void createTreePanel() throws DCException {
        this.m_oFileTreePanel = new FileTreePanel(this.m_oLoadSoftwareParam, this.m_oTask.isThirdPartySupported());
        this.m_oFileTreePanel.setName("DeviceOperation_FileSelectionPanel_m_oFileTreePanel");
        this.m_oFileTreePanel.initializeTree(false);
        if (2 == this.m_oTask.getTaskTypeId()) {
            TreeSelectionModel o_mTreeSelectionModel = this.m_oFileTreePanel.getTree().getSelectionModel();
            o_mTreeSelectionModel.setSelectionMode(1);
        }
        this.m_oFileTablePanel.setPreferredSize(new Dimension(296, 150));
        this.m_oFileTreePanel.setPreferredSize(new Dimension(255, 150));
        this.m_oFileTreePanel.setFileTablePanel(this.m_oFileTablePanel);
        this.add((Component)this.m_oFileTreePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectBtnActionPerformed() {
        int confirm;
        this.m_oFileTreePanel.m_bMessaseAlreadyShown = false;
        ArrayList<LoadFileInfo> oArrLoadFileLst = new ArrayList<LoadFileInfo>();
        TreePath treePath = this.m_oFileTreePanel.getTree().getSelectionPath();
        if (treePath == null) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOAD_FILE_NULL"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        FileNode treeNode = (FileNode)treePath.getLastPathComponent();
        DirAndFileInfo dirNode = (DirAndFileInfo)treeNode.getUserObject();
        if (!dirNode.isFile() && (confirm = DCOptionPane.showConfirmDialog((Component)this, ResourceManager.getInstance().getResString("MOVE_FOLDER_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0)) != 0) {
            return;
        }
        if (2 == this.operationType) {
            int iOption;
            if (!dirNode.isFile()) {
                return;
            }
            if (this.m_oFileTablePanel.getFileTable().getRowCount() > 0 && (iOption = DCOptionPane.showConfirmDialog((Component)this, ResourceManager.getInstance().getResString("PRINT_COVER_FILE"), ResourceManager.getInstance().getResString("PRINT_CONFIRM_TITLE"), 0)) != 0) {
                return;
            }
            this.m_oFileTablePanel.removeAllRows();
            LoadFileInfo[] serverFile = new LoadFileInfo[]{new LoadFileInfo()};
            serverFile[0].setFileName(dirNode.getPath());
            try {
                SystemManager sysMgr = new SystemManager();
                String strRootDir = sysMgr.getFTSInfo().getRootDirectory();
                this.m_oFileTablePanel.addSelectedFiles(serverFile, strRootDir);
            }
            catch (DCException ex) {
                DCDebugTracer.trace(ex);
            }
            oArrLoadFileLst.add(serverFile[0]);
            this.m_oLoadSoftwareParam.setLoadFileInfoList(oArrLoadFileLst);
        } else {
            try {
                DCFrameWorkUtil.setCursor(new Cursor(3));
                if (!this.m_oFileTreePanel.getSelectedFile()) {
                    DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOAD_FILE_NULL"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            }
            finally {
                DCFrameWorkUtil.setCursor(new Cursor(0));
            }
        }
    }

    public FileTablePanel getFileTablePanel() {
        return this.m_oFileTablePanel;
    }

    public FileTreePanel getFileTreePanel() {
        return this.m_oFileTreePanel;
    }

    public void setIsDMSDevice(boolean b) {
        this.isDMSDevice = b;
    }

    public boolean isDMSDevice() {
        return this.isDMSDevice;
    }

    public void setConfigPara(LoadFileInfoListParam oConfigPara) {
        this.m_oLoadSoftwareParam = oConfigPara;
    }

    private void customizedPanelForDeviceLevelLoad(DeviceType oDeviceType) {
        if (null == oDeviceType) {
            return;
        }
        THashSet<Resource> oSupportedResList = this.getDeviceLevelLoadSupportedResList(oDeviceType.getResources());
        if (null != oSupportedResList && 0 != oSupportedResList.size()) {
            this.m_oStartupCofigPanel = new StartupConfigPanel(oSupportedResList, this.m_oTask);
            this.m_oStartupCofigPanel.setDeviceLevelLoadConfigParam((LoadFileInfoListParam)CloneUtil.getClone(this.m_oLoadSoftwareParam));
            this.m_oStartupCofigPanel.setDeviceType(oDeviceType);
            String configPanelTitle = this.getConfigPanelTitle();
            TitledBorder oStartupCofigPanelTitledBorder = new TitledBorder(configPanelTitle);
            this.m_oStartupCofigPanel.setBorder(oStartupCofigPanelTitledBorder);
            this.m_oStartupCofigPanel.setPreferredSize(new Dimension(575, 160));
            this.m_oStartupCofigPanel.setMinimumSize(new Dimension(575, 160));
            this.add((Component)this.m_oStartupCofigPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 5, 5, 5), 0, 0));
        }
    }

    private String getConfigPanelTitle() {
        String configPanelTitle = DCFrameWorkUtil.getLocalizedString("SELECT_DEVICE_SPECIFIC_LOAD_FILES");
        int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(this.m_oTask);
        if (2 == iDeviceDomain) {
            configPanelTitle = DCFrameWorkUtil.getLocalizedString("SELECT_NE_GTL_LICENSE_LOAD_FILES");
        }
        return configPanelTitle;
    }

    public THashSet<Resource> getDeviceLevelLoadSupportedResList(THashSet<Resource> oSelectedResList) {
        THashSet oResList = new THashSet();
        Resource oRes2 = null;
        for (Resource oRes2 : oSelectedResList) {
            if (!this.isDeviceLevelLoadSupported(oRes2)) continue;
            oResList.add((Object)oRes2);
        }
        return oResList;
    }

    private boolean isDeviceLevelLoadSupported(Resource oRes) {
        IOperationPara oDeviceLevelLoadParameter;
        IParaList oParaList;
        IOperation oOperationObj;
        boolean bOprSupported = false;
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID());
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        int[] iDeviceIdLst = new int[]{oRes.getDeviceID()};
        if (0 != (oRes.getUpgradeMode() & 0x1000) && !DeviceInfoUtil.isClusterNE(oDeviceInfo) && oDeviceTypeInfo.getDevDomain() == 2) {
            oDeviceTypeInfo = DCFrameWorkUtil.addPostFixTelnet(oDeviceTypeInfo);
        }
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        oDeviceTypeInfo = DCFrameWorkUtil.removePostFixTelnet(oDeviceTypeInfo);
        if (null != deviceTypeConfigModel && null != (oOperationObj = deviceTypeConfigModel.getOperationObj(1, 6)) && null != (oParaList = oOperationObj.getoPerationParaList()) && 0 != oParaList.getNumOfParam() && null != (oDeviceLevelLoadParameter = oParaList.getParameter("SelectFileForEachDevice"))) {
            bOprSupported = oDeviceLevelLoadParameter.isRequired();
        }
        return bOprSupported;
    }

    public StartupConfigPanel getStartupConfigPanel() {
        return this.m_oStartupCofigPanel;
    }

    public void setContext(int iContext) {
        this.m_oContext = iContext;
    }

    public int getContext() {
        return this.m_oContext;
    }

    public void upgradeBootroomSelectState() {
        boolean bCotainsCCFile = false;
        if (this.isDMSDevice() && this.m_isSelectLoadOpr) {
            LoadFileInfo[] arrServerFiles = this.m_oFileTablePanel.getFilesFromTable();
            for (int i = 0; i < arrServerFiles.length; ++i) {
                if (!arrServerFiles[i].getAbsoluteFilePath().endsWith(".cc") && !arrServerFiles[i].getAbsoluteFilePath().endsWith(".CC")) continue;
                bCotainsCCFile = true;
                break;
            }
            TaskInfoUtil2.setUpgradeBootroomSelectState(this.m_oTask, true, bCotainsCCFile, this, null);
        }
    }

    public void setIsSelectLoadOpr(boolean isSelectLoadOpr) {
        this.m_isSelectLoadOpr = isSelectLoadOpr;
    }

    public boolean getIsSelectLoadOpr() {
        return this.m_isSelectLoadOpr;
    }
}

