/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.CheckDeviceMemoryButtonPanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionPanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.controller.LoadSoftwareCheckManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.createtask.ValidateISSU;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileSelectionDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private FileSelectionPanel m_oFileSelectionPanel;
    private LoadFileInfoListParam m_oLoadParam;
    private boolean isDMSDevice = false;
    private boolean isBMSDevice = false;
    private ITask m_oParentTask;
    private List<DeviceTypeInfo> m_oSlaveDevTypeInfoList;
    private Component m_oParentComponent = null;
    private LoadFileInfo[] m_oRiginalLoadFileInfos;
    private JCheckBox m_autoCleanCheckBox;
    private JCheckBox m_packetCustomizedCheckBox;
    private static int selectedDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
    private CheckDeviceMemoryButtonPanel m_oMemoryCheckButtonPanel = null;
    private boolean m_bShowAutoCleanCheckBox = false;
    private boolean m_bShowPacketCustomizedCheckBox = false;
    private static final int m_iPackCmtHeight = 80;
    private static final int ORIGIN_HEIGHT = 0;
    private static final int AUTO_HEIGHT = 30;
    private boolean bDoCleanUPInCloseDlg = true;

    public FileSelectionDialog(FileSelectionPanel oFileSelectionPanel, LoadFileInfoListParam oLoadParam, String strTitle, Component oParentComponent, ITask oParentTask) throws DCException {
        this.m_oParentTask = oParentTask;
        this.m_oRiginalLoadFileInfos = new LoadFileInfo[0];
        this.m_oLoadParam = oLoadParam;
        this.m_oParentComponent = oParentComponent;
        this.jbInit(oFileSelectionPanel);
        this.setTitle(strTitle);
    }

    public FileSelectionDialog(FileSelectionPanel oFileSelectionPanel, LoadFileInfoListParam oLoadParam, String strTitle, Component oParentComponent, ITask oParentTask, boolean bDoCleanUP) throws DCException {
        this.bDoCleanUPInCloseDlg = bDoCleanUP;
        this.m_oParentTask = oParentTask;
        this.m_oRiginalLoadFileInfos = new LoadFileInfo[0];
        this.m_oLoadParam = oLoadParam;
        this.m_oParentComponent = oParentComponent;
        this.jbInit(oFileSelectionPanel);
        this.setTitle(strTitle);
    }

    private boolean isHGMPDevice(ITask oTask) {
        THashSet<Resource> resourceLst = oTask.getDeviceType().getResources();
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        DeviceInfo oDeviceInfo = null;
        for (Resource resource : resourceLst) {
            oDeviceInfo = oDeviceInfoManager.getDevice(resource.getDeviceID());
            if (null == oDeviceInfo) {
                DCDebugTracer.traceError("[HGMP]isHGMPDevice:1.oDeviceInfo=null");
                return false;
            }
            DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null == oDeviceTypeInfo) {
                DCDebugTracer.traceError("[HGMP]isHGMPDevice:2.oDeviceTypeInfo=null,device=" + oDeviceInfo);
                return false;
            }
            DCDebugTracer.traceError("[HGMP]isHGMPDevice:3.device=" + oDeviceInfo);
            if (!oDeviceTypeInfo.isDMSDomain() || resource.getRoleType() != 1 && resource.getRoleType() != 2) continue;
            return true;
        }
        return false;
    }

    protected void jbInit(FileSelectionPanel oFileSelectionPanel) throws DCException {
        this.setDefaultCloseOperation(2);
        this.createFileSelectionPanel(oFileSelectionPanel);
        if (2 == this.m_oParentTask.getDeviceType().getDeviceDomain() && TaskInfoUtil2.isSupportAutoDeleteIamge(this.m_oParentTask.getSelectedDeviceType()) && !TaskInfoUtil.isContainsClusterNE(this.m_oParentTask)) {
            this.m_bShowAutoCleanCheckBox = true;
        }
        if (this.m_bShowAutoCleanCheckBox) {
            this.initializeAutoCleanSpace();
        }
        if (this.m_oParentTask.getTaskTypeId() != 7) {
            this.initPacketCustomized();
        }
        this.initializeOKButton();
        this.initializeCancelButton();
        DeviceType deviceType = this.m_oParentTask.getDeviceType();
        if (2 != this.m_oParentTask.getTaskTypeId() && !this.m_oParentTask.isThirdPartySupported() && deviceType != null && deviceType.isUpgradeModeSupportedByAllDevices(4096) && !this.isHGMPDevice(this.m_oParentTask)) {
            this.initializeCheckDeviceMemoryButtonPanel();
        }
        this.createContainerPanel();
        if (this.m_bShowPacketCustomizedCheckBox) {
            this.setSize(617, 477);
        } else {
            this.setSize(617, 397);
        }
        this.setResizable(false);
        Component oparentComponent = this.m_oParentComponent;
        if (null == this.m_oParentComponent) {
            oparentComponent = DCFrameWorkUtil.getMainFrame();
        }
        if (2 != this.m_oParentTask.getTaskTypeId() && 5 != oFileSelectionPanel.getOperationType()) {
            this.customizeForDeviceLevelLoad(oFileSelectionPanel);
        }
        this.setLocationRelativeTo(oparentComponent);
    }

    private void initializeAutoCleanSpace() {
        this.m_autoCleanCheckBox = new JCheckBox(StringUtils.getHtmlString(ResourceManager.getInstance().getResString("AUTO_CLEAN_SPACE")));
        this.m_autoCleanCheckBox.setName("com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog.m_autoCleanCheckBox");
        this.m_autoCleanCheckBox.setSelected(true);
        if (this.m_oParentTask.isThirdPartySupported()) {
            this.m_autoCleanCheckBox.setSelected(false);
            this.m_autoCleanCheckBox.setEnabled(false);
        }
    }

    private void initPacketCustomized() {
        this.m_bShowPacketCustomizedCheckBox = this.m_oLoadParam.getIsPacketCustomizedRequired();
        if (this.m_bShowPacketCustomizedCheckBox) {
            JLabel oInfoLabel = new JLabel(ResourceManager.getInstance().getResString("PACKET_CUSTOMIZED_DESTINATION"));
            oInfoLabel.setBounds(8, 328, 700, 60);
            this.m_packetCustomizedCheckBox = new JCheckBox();
            this.m_packetCustomizedCheckBox.setName("com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog.m_packetCustomizedCheckBox");
            this.m_packetCustomizedCheckBox.setBounds(5, 388, 150, 20);
            this.m_packetCustomizedCheckBox.setVerticalAlignment(3);
            this.m_packetCustomizedCheckBox.setText(ResourceManager.getInstance().getResString("PACKET_CUSTOMIZED_Text"));
            this.m_packetCustomizedCheckBox.setVisible(true);
            if (2 == this.m_oLoadParam.getpacketCustomizedResult()) {
                this.m_packetCustomizedCheckBox.setSelected(true);
            } else if (1 == this.m_oLoadParam.getpacketCustomizedResult()) {
                this.m_packetCustomizedCheckBox.setSelected(false);
            } else {
                DCDebugTracer.trace("initPacketCustomized do not need handle.");
            }
            this.add(this.m_packetCustomizedCheckBox);
            this.add(oInfoLabel);
        }
    }

    private void customizeForDeviceLevelLoad(FileSelectionPanel oFileSelectionPanel) {
        if (null == this.m_oParentTask.getSelectedDeviceType()) {
            return;
        }
        THashSet<Resource> oSupportedResList = oFileSelectionPanel.getDeviceLevelLoadSupportedResList(this.m_oParentTask.getSelectedDeviceType().getResources());
        if (null != oSupportedResList && 0 != oSupportedResList.size()) {
            if (!this.m_bShowAutoCleanCheckBox) {
                this.setNewPageLayout(0);
            } else {
                this.setNewPageLayout(30);
            }
        }
    }

    private void setNewPageLayout(int iAutoHeight) {
        int iAddHeight = iAutoHeight;
        if (this.m_bShowPacketCustomizedCheckBox) {
            iAddHeight += 80;
        }
        this.setSize(717, 497 + iAddHeight);
        if (this.m_bShowAutoCleanCheckBox) {
            this.m_autoCleanCheckBox.setBounds(5, 433, 700, 22);
        }
        if (this.m_bShowPacketCustomizedCheckBox) {
            this.m_packetCustomizedCheckBox.setBounds(5, 433 + iAutoHeight, 700, 22);
        }
        if (null != this.m_oMemoryCheckButtonPanel) {
            this.m_oMemoryCheckButtonPanel.setBounds(342, 433 + iAddHeight, 180, 22);
        }
        this.m_oFileSelectionPanel.setBounds(5, 5, 700, 420);
        this.m_oOKBtn.setBounds(530, 433 + iAddHeight, 82, 22);
        this.m_oCancelBtn.setBounds(620, 433 + iAddHeight, 83, 22);
    }

    private void initializeCheckDeviceMemoryButtonPanel() {
        THashSet<Resource> oSupportedResList = this.m_oFileSelectionPanel.getDeviceLevelLoadSupportedResList(this.m_oParentTask.getDeviceType().getResources());
        if (null != oSupportedResList && 0 != oSupportedResList.size()) {
            this.m_oMemoryCheckButtonPanel = new CheckDeviceMemoryButtonPanel(this.m_oParentTask.getTaskTypeId());
            this.m_oMemoryCheckButtonPanel.setM_oModalParent(this);
            this.m_oMemoryCheckButtonPanel.setResList(oSupportedResList);
            this.m_oMemoryCheckButtonPanel.setFileSelectionPanel(this.m_oFileSelectionPanel);
            this.m_oMemoryCheckButtonPanel.setStartupConfigPanel(this.m_oFileSelectionPanel.getStartupConfigPanel());
            this.m_oMemoryCheckButtonPanel.setBounds(242, 333, 180, 22);
        }
    }

    private void createFileSelectionPanel(FileSelectionPanel oFileSelectionPanel) throws DCException {
        this.m_oFileSelectionPanel = oFileSelectionPanel;
        this.m_oFileSelectionPanel.setBounds(5, 5, 600, 320);
        oFileSelectionPanel.setIsSelectLoadOpr(true);
        this.m_oRiginalLoadFileInfos = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
    }

    private void initializeOKButton() {
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.m_oOKBtn.setName("DeviceOperation_FileSelectionDlg_m_oOKBtn");
        if (this.m_bShowPacketCustomizedCheckBox) {
            this.m_oOKBtn.setBounds(430, 413, 82, 22);
        } else {
            this.m_oOKBtn.setBounds(430, 333, 82, 22);
        }
        this.getRootPane().setDefaultButton(this.m_oOKBtn);
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSelectionDialog.this.okButton_ActionPerformed();
            }
        });
    }

    private void initializeCancelButton() {
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL"));
        this.m_oCancelBtn.setName("DeviceOperation_FileSelectionDlg_m_oCancelBtn");
        if (this.m_bShowPacketCustomizedCheckBox) {
            this.m_oCancelBtn.setBounds(520, 413, 83, 22);
        } else {
            this.m_oCancelBtn.setBounds(520, 333, 83, 22);
        }
    }

    private void createContainerPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(null);
        mainPanel.add((Component)this.m_oFileSelectionPanel, null);
        if (this.m_bShowAutoCleanCheckBox) {
            mainPanel.add((Component)this.m_autoCleanCheckBox, null);
        }
        mainPanel.add((Component)this.m_oOKBtn, null);
        mainPanel.add((Component)this.m_oCancelBtn, null);
        if (null != this.m_oMemoryCheckButtonPanel) {
            mainPanel.add((Component)this.m_oMemoryCheckButtonPanel, null);
        }
        this.getContentPane().add(mainPanel);
    }

    private void okButton_ActionPerformed() {
        LoadFileInfoListParam oLoadParam;
        DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed start");
        LoadFileInfo[] arrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
        if (null == arrServerFiles || 0 == arrServerFiles.length) {
            boolean bFileSelected = false;
            if (null != this.m_oFileSelectionPanel.getStartupConfigPanel()) {
                oLoadParam = this.m_oFileSelectionPanel.getStartupConfigPanel().getDeviceLevelLoadConfigParam();
                THashSet<Resource> oSupportedResList = this.m_oFileSelectionPanel.getDeviceLevelLoadSupportedResList(this.m_oParentTask.getDeviceType().getResources());
                bFileSelected = this.isDeviceFileSelectionCorrect(oSupportedResList, oLoadParam.getLoadFileInfoList());
            }
            if (!bFileSelected) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_LOAD_FILE_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(1)");
                return;
            }
        } else {
            for (int count = 0; count < arrServerFiles.length; ++count) {
                if (Collator.getInstance().equals(arrServerFiles[count].getFileName().trim(), "")) {
                    this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                    DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("ENTER_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                    DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(2)");
                    return;
                }
                if ("".intern().equals(arrServerFiles[count].getContentType().getStrContentType())) {
                    this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                    DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_SELECT_CONTENT_TYPE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(3)");
                    return;
                }
                if (!arrServerFiles[count].getFileName().contains(" ") || !this.m_oFileSelectionPanel.isDMSDevice()) continue;
                this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(4)");
                return;
            }
        }
        if (this.isDMSDevice() && !this.m_oParentTask.isThirdPartySupported() || this.isBMSDevice()) {
            ValidationResult oValidationResult;
            LoadFileInfoListParam oLoadParam2 = new LoadFileInfoListParam();
            if (null != arrServerFiles) {
                for (int i = 0; i < arrServerFiles.length; ++i) {
                    LoadFileInfo oFileInfo = arrServerFiles[i];
                    if (!oFileInfo.getContentType().getId().equals("PROGRAM") && !oFileInfo.getContentType().getId().equals("PACKETFILE") && !oFileInfo.getContentType().getId().equals("PATCH")) continue;
                    oLoadParam2.addServerFile(arrServerFiles[i]);
                }
            }
            if (0 != oLoadParam2.getNumberOfFiles() && 0 != (oValidationResult = LoadSoftwareCheckManager.getInstance().validateLoadSoftwareFiles(this.m_oParentTask, oLoadParam2)).getErrorCode()) {
                if (4 == oValidationResult.getErrorType()) {
                    DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(1)");
                    return;
                }
                if (0 == oValidationResult.getErrorType()) {
                    DCOptionPane.showMessageDialog((Component)((Object)this), oValidationResult.getErrorMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                    DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(5)");
                    return;
                }
            }
        }
        this.m_oFileSelectionPanel.upgradeBootroomSelectState();
        if (null != this.m_oParentTask && this.m_oParentTask.isStackDevicePresent(3) && !this.validateFilesForStackDevices()) {
            DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(6)");
            return;
        }
        LoadFileInfo oPacketTool = this.m_oLoadParam.getPacketTool();
        this.m_oLoadParam.clearAllFilesFromList();
        if (null != oPacketTool) {
            this.m_oLoadParam.addPacketTool(oPacketTool);
        }
        this.m_oLoadParam.addServerFiles(arrServerFiles);
        if (null != this.m_oFileSelectionPanel.getStartupConfigPanel()) {
            oLoadParam = this.m_oFileSelectionPanel.getStartupConfigPanel().getDeviceLevelLoadConfigParam();
            this.m_oLoadParam.addDeviceLevelFile(oLoadParam.getLoadFileInfoList());
        }
        this.checkTaskSelectFiles();
        if (this.m_bShowAutoCleanCheckBox) {
            this.m_oLoadParam.setbAutoDelImage(this.m_autoCleanCheckBox.isSelected());
        }
        this.setPacketCustomizedResult();
        if (!this.validateISSUSelectedDevices(arrServerFiles)) {
            DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end(7)");
            return;
        }
        this.dispose(true);
        DCDebugTracer.trace("FileSelectionDialog.okButton_ActionPerformed end");
    }

    private void checkTaskSelectFiles() {
        if (!TaskInfoUtil.isFileSelectedForContentType(this.m_oParentTask, "PATCH") && TaskInfoUtil2.isSubOprForPostUpgradeSelected(this.m_oParentTask, "UpgradePatch", "PATCH")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("DESELECT_UPGRADE_PATCH_OPERTAION"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            TaskInfoUtil2.updatePostUpgradeForSubOperation(this.m_oParentTask, "UpgradePatch");
        }
        if (!TaskInfoUtil.isFileSelectedForContentType(this.m_oParentTask, "GTLLicense") && TaskInfoUtil2.isSubOprForPostUpgradeSelected(this.m_oParentTask, "ActiveGTL", "GTLLicense")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("DESELECT_ACTIVE_GTL_OPERTAION"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            TaskInfoUtil2.updatePostUpgradeForSubOperation(this.m_oParentTask, "ActiveGTL");
        }
        if (!TaskInfoUtil2.isStartupConfigFileSelectedForContentType(this.m_oParentTask, "PROGRAM") && !TaskInfoUtil.isFileSelectedForContentType(this.m_oParentTask, "PROGRAM") && TaskInfoUtil2.isSubOprForPreUpgradeSelected(this.m_oParentTask, "UpgradeBootROM", "PROGRAM")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("DESELECT_UPGRADE_BOOT_ROM_OPERTAION"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            TaskInfoUtil2.updatePrepareUpgradeForSubOperation(this.m_oParentTask, "UpgradeBootROM");
        }
    }

    private void setPacketCustomizedResult() {
        int packetCustomizedResult = 0;
        if (this.m_bShowPacketCustomizedCheckBox) {
            packetCustomizedResult = this.m_packetCustomizedCheckBox.isSelected() ? 2 : 1;
        }
        DCDebugTracer.trace("DC::FileSelectionDialog/setPacketCustomizedResult:Set packet customized result from page:" + packetCustomizedResult);
        this.m_oLoadParam.setPacketCustomizedResult(packetCustomizedResult);
    }

    private boolean isDeviceFileSelectionCorrect(THashSet<Resource> oSupportedResList, List oFileList) {
        boolean bFileSelection = true;
        int iFileSize = oFileList.size();
        LoadFileInfo oFileInfo = null;
        Resource oRes2 = null;
        for (Resource oRes2 : oSupportedResList) {
            boolean bFileSelectedForDevice = false;
            for (int j = 0; j < iFileSize; ++j) {
                oFileInfo = (LoadFileInfo)oFileList.get(j);
                if (1 != oFileInfo.getFileSelectionLevel() || oRes2.getDeviceID() != oFileInfo.getDeviceId()) continue;
                bFileSelectedForDevice = true;
                break;
            }
            if (bFileSelectedForDevice) continue;
            bFileSelection = false;
            break;
        }
        return bFileSelection;
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        List<LoadFileInfo> oFiles = this.m_oLoadParam.getLoadFileInfoList();
        if (null == oFiles || 0 >= oFiles.size()) {
            try {
                SystemManager sysMgr = new SystemManager();
                String strRootDir = sysMgr.getFTSInfo().getRootDirectory();
                int iCount = this.m_oRiginalLoadFileInfos.length;
                FileTablePanel fileTblPanel = this.m_oFileSelectionPanel.getFileTablePanel();
                fileTblPanel.removeAllRows();
                if (0 < iCount) {
                    fileTblPanel.addSelectedFiles(this.m_oRiginalLoadFileInfos, strRootDir);
                    this.m_oLoadParam.clearAllFilesFromList();
                    this.m_oLoadParam.addServerFiles(this.m_oRiginalLoadFileInfos);
                }
            }
            catch (DCException ex) {
                DCDebugTracer.trace(ex);
            }
        }
        this.closeDialog();
    }

    @Override
    public void closeDialog() {
        if (null != this.m_oFileSelectionPanel) {
            this.m_oFileSelectionPanel.removeAll();
            this.m_oFileSelectionPanel = null;
            ObjectStore.getInstance().removeObjectInstance("FileTreePanel");
        }
        if (null != this.m_oLoadParam) {
            this.m_oLoadParam = null;
        }
        if (null != this.m_oSlaveDevTypeInfoList) {
            this.m_oSlaveDevTypeInfoList.clear();
            this.m_oSlaveDevTypeInfoList = null;
        }
        if (null != this.m_oRiginalLoadFileInfos) {
            for (int i = 0; i < this.m_oRiginalLoadFileInfos.length; ++i) {
                this.m_oRiginalLoadFileInfos[i] = null;
            }
            this.m_oRiginalLoadFileInfos = null;
        }
        if (null != this.m_oMemoryCheckButtonPanel) {
            this.m_oMemoryCheckButtonPanel.removeAll();
            this.m_oMemoryCheckButtonPanel = null;
        }
        this.removeAll();
        this.dispose(false);
    }

    private boolean validateFilesForStackDevices() {
        boolean bFlag = true;
        if (null != this.m_oSlaveDevTypeInfoList) {
            List<DeviceTypeInfo> oFileDevTypeInfoList = this.getUnselectFileDevTypes();
            int devTypeSize = oFileDevTypeInfoList.size();
            StringBuilder errMessage = new StringBuilder();
            for (int i = 0; i < devTypeSize; ++i) {
                errMessage.append('\n');
                errMessage.append(oFileDevTypeInfoList.get(i));
            }
            if (oFileDevTypeInfoList.size() > 0) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("SLAVE_LOAD_FILE_INCORRECT_MATCH_ERROR"), new String[]{errMessage.toString()}), ResourceManager.getInstance().getResString("ERROR"), 0);
                bFlag = false;
            }
        }
        return bFlag;
    }

    public List<DeviceTypeInfo> getUnselectFileDevTypes() {
        ArrayList<DeviceTypeInfo> oFileDevTypeInfoList = new ArrayList<DeviceTypeInfo>(0);
        LoadFileInfo[] arrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
        DeviceTypeInfo oDevTypeInfo = null;
        for (int i = 0; i < arrServerFiles.length; ++i) {
            oDevTypeInfo = arrServerFiles[i].getDeviceTypeInfo();
            if (oFileDevTypeInfoList.contains(oDevTypeInfo)) continue;
            oFileDevTypeInfoList.add(oDevTypeInfo);
        }
        ArrayList<DeviceTypeInfo> oUnSelFileDevTypeInfoList = new ArrayList<DeviceTypeInfo>(0);
        int iDevTypeSize = this.m_oSlaveDevTypeInfoList.size();
        List<LoadFileInfo> oConfigFileList = null;
        if (null != this.m_oFileSelectionPanel.getStartupConfigPanel()) {
            LoadFileInfoListParam oLoadParam = this.m_oFileSelectionPanel.getStartupConfigPanel().getDeviceLevelLoadConfigParam();
            oConfigFileList = oLoadParam.getLoadFileInfoList();
        }
        for (int i = 0; i < iDevTypeSize; ++i) {
            oDevTypeInfo = this.m_oSlaveDevTypeInfoList.get(i);
            if (oFileDevTypeInfoList.contains(oDevTypeInfo) || this.isContainsDeviceType(oConfigFileList, oDevTypeInfo)) continue;
            oUnSelFileDevTypeInfoList.add(oDevTypeInfo);
        }
        return oUnSelFileDevTypeInfoList;
    }

    private boolean isContainsDeviceType(List<LoadFileInfo> oConfigFileList, DeviceTypeInfo oDevTypeInfo) {
        if (null == oConfigFileList || null == oDevTypeInfo || oConfigFileList.isEmpty()) {
            return false;
        }
        LoadFileInfo oLoadFile = null;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDevInfo = null;
        for (int i = 0; i < oConfigFileList.size(); ++i) {
            oLoadFile = oConfigFileList.get(i);
            if (null == oLoadFile || null == (oDevInfo = oDevMgr.getDevice(oLoadFile.getDeviceId())) || null == oDevInfo.getDeviceTypeInfo() || oDevTypeInfo.getDevTypeID() != oDevInfo.getDeviceTypeInfo().getDevTypeID()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getCurrentContext() {
        return "";
    }

    public void setIsDMSDevice(boolean b) {
        this.isDMSDevice = b;
        this.m_oFileSelectionPanel.setIsDMSDevice(b);
    }

    public boolean isDMSDevice() {
        return this.isDMSDevice;
    }

    public void setIsBMSDevice(boolean b) {
        this.isBMSDevice = b;
    }

    public boolean isBMSDevice() {
        return this.isBMSDevice;
    }

    public LoadFileInfoListParam getConfigPara() {
        return this.m_oLoadParam;
    }

    public LoadFileInfo[] getSelectedFiles() {
        if (null != this.m_oFileSelectionPanel) {
            return this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
        }
        return new LoadFileInfo[0];
    }

    public void setConfigPara(LoadFileInfoListParam oConfigPara) {
        this.m_oLoadParam = oConfigPara;
        if (null != this.m_oFileSelectionPanel) {
            this.m_oFileSelectionPanel.setConfigPara(oConfigPara);
        }
    }

    public void setParentTask(ITask oTask) {
        this.m_oParentTask = oTask;
    }

    public List<DeviceTypeInfo> getSlaveDevTypeInfoList() {
        return this.m_oSlaveDevTypeInfoList;
    }

    public void setSlaveDevTypeInfoList(List<DeviceTypeInfo> oDevTypeInfoList) {
        this.m_oSlaveDevTypeInfoList = oDevTypeInfoList;
    }

    private boolean validateISSUSelectedDevices(LoadFileInfo[] arrServerFiles) {
        ValidateISSU oValidateIssu;
        if (null != this.m_oParentTask && !this.m_oParentTask.getIsOffLineTask() && DCCommonUtil.isContainsDevTypeID(this.m_oParentTask, 1332) && (oValidateIssu = new ValidateISSU(this.m_oParentTask)).isSelectISSUForATN950()) {
            String strSoftwarePath = oValidateIssu.getSelectedSoftware();
            if ("".equals(strSoftwarePath)) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("CHECK_ISSU_NOT_SELECT_IMAGE"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                return false;
            }
            ValidationResult oResult = oValidateIssu.validateISSUSelectedDevices();
            if (0 != oResult.getErrorCode()) {
                DCOptionPane.showMessageDialog((Component)((Object)this), oResult.getErrorMessage(), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                return false;
            }
            if (oValidateIssu.isHasError()) {
                return false;
            }
        }
        return true;
    }

    public void dispose(boolean bOkButton) {
        TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
        if (null != oTaskMgmtOperationSelecPanel) {
            if (!bOkButton && !TaskInfoUtil.isTargerVerEqualSelectFile(this.m_oParentTask)) {
                oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
            }
            oTaskMgmtOperationSelecPanel.setAutoChange(false);
        }
        super.dispose();
    }

    protected void setDoCleanUpInCloseDlg(boolean bValue) {
        this.bDoCleanUPInCloseDlg = bValue;
    }
}

