/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.taskmgmt.model.ITask;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ViewLoadSoftwarepanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel m_oTableModel;
    private JTable m_oTable;
    private ResourceManager oResourceManager = ResourceManager.getInstance();
    private ITask m_oParentTask;
    private JSortTreeTable m_oFileTreeTable = null;
    private DCTreeTableModel m_oFileTreeTableModel = null;
    private TreeTableNode m_oRootNode = null;

    public ViewLoadSoftwarepanel(LoadFileInfoListParam oLoadFileInfoList, ITask m_oParentTask) {
        this.m_oParentTask = m_oParentTask;
        this.setLayout(null);
        boolean bPacketFileExists = false;
        LoadFileInfo oPacketTool = oLoadFileInfoList.getPacketTool();
        if (null != oPacketTool) {
            bPacketFileExists = true;
            JLabel oPacketToolLabel = new JLabel(this.oResourceManager.getResString("PACKET_TOOL_LABEL") + " :");
            oPacketToolLabel.setBounds(16, 10, 120, 25);
            this.add(oPacketToolLabel);
            JTextField oPacketToolName = new JTextField(oPacketTool.getFileName());
            oPacketToolName.setToolTipText(oPacketTool.getFileName());
            oPacketToolName.setCaretPosition(0);
            oPacketToolName.setBounds(105, 10, 320, 25);
            oPacketToolName.setEditable(false);
            this.add(oPacketToolName);
        }
        JScrollPane scrollPane = new JScrollPane();
        this.setBoundsForAllComponent(scrollPane, bPacketFileExists);
        this.add(scrollPane);
        if (!this.hasSomeDeviceLevelFiles(oLoadFileInfoList)) {
            int iIndex = 2;
            if (oLoadFileInfoList.isContentTypeRequired()) {
                ++iIndex;
            }
            if (oLoadFileInfoList.isDeviceTypeInfoRequired()) {
                ++iIndex;
            }
            Object[] arrColNames = new String[iIndex];
            arrColNames[0] = this.oResourceManager.getResString("DEVICE_SEQ_NO");
            arrColNames[1] = this.oResourceManager.getResString("PROGRAM_SELECTION_PROGRAM");
            if (oLoadFileInfoList.isContentTypeRequired()) {
                arrColNames[2] = this.oResourceManager.getResString("LOAD_FILE_TYPE");
            }
            if (oLoadFileInfoList.isDeviceTypeInfoRequired()) {
                arrColNames[3] = this.oResourceManager.getResString("PROGRAM_SELECTION_DEVICE_TYPE");
            }
            this.m_oTableModel = new DefaultTableModel(arrColNames, 0);
            this.m_oTable = new JTable(this.m_oTableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.m_oTable.setName("DeviceOperation_ViewLoadSftwarepanel_m_oTable");
            this.m_oTable.getTableHeader().setReorderingAllowed(false);
            this.m_oTable.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point oPoint = e.getPoint();
                    int iRow = ViewLoadSoftwarepanel.this.m_oTable.rowAtPoint(oPoint);
                    int iColumn = ViewLoadSoftwarepanel.this.m_oTable.columnAtPoint(oPoint);
                    String strValue = null;
                    strValue = ViewLoadSoftwarepanel.this.m_oTableModel.getValueAt(iRow, iColumn) instanceof String ? (String)ViewLoadSoftwarepanel.this.m_oTableModel.getValueAt(iRow, iColumn) : (ViewLoadSoftwarepanel.this.m_oTableModel.getValueAt(iRow, iColumn) instanceof Integer ? String.valueOf((Integer)ViewLoadSoftwarepanel.this.m_oTableModel.getValueAt(iRow, iColumn)) : "");
                    ViewLoadSoftwarepanel.this.m_oTable.setToolTipText(strValue);
                }
            });
            scrollPane.setViewportView(this.m_oTable);
            this.populateDataInTable(oLoadFileInfoList);
        } else {
            this.m_oFileTreeTable = this.getTreeTable();
            scrollPane.setViewportView((Component)((Object)this.m_oFileTreeTable));
            this.populateTreeTable(oLoadFileInfoList);
            this.expandAll(this.m_oFileTreeTable.getTree(), new TreePath(this.m_oRootNode), true);
            this.updateTableView();
        }
    }

    private JSortTreeTable getTreeTable() {
        this.createTreeTableModel();
        this.m_oFileTreeTable = new JSortTreeTable(this.m_oFileTreeTableModel);
        this.m_oFileTreeTable.setName("DeviceOperation_RecoverTablePanel_m_oTaskTreeTable");
        this.initializeSelectionSingleModel();
        this.initializeTreeTable();
        return this.m_oFileTreeTable;
    }

    private void createTreeTableModel() {
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("FILE_SELECTION_LEVEL_TABLE_HEADER"), DCFrameWorkUtil.getLocalizedString("SEQUENCE_NUMBER"), DCFrameWorkUtil.getLocalizedString("FILE_NAME"), DCFrameWorkUtil.getLocalizedString("LOAD_FILE_TYPE")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{false, false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false};
        this.m_oFileTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oRootNode = this.m_oFileTreeTableModel.getRoot();
    }

    private void initializeSelectionSingleModel() {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(0);
        this.m_oFileTreeTable.setSelectionModel(oTaskSelection);
    }

    private void initializeTreeTable() {
        this.m_oFileTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileTreeTable.getTree().setCellRenderer(new MyCellRenderer());
        this.m_oFileTreeTable.getTree().setToggleClickCount(2);
        this.m_oFileTreeTable.setRowHeight(20);
        this.m_oFileTreeTable.setShowHorizontalLines(true);
        this.m_oFileTreeTable.setShowVerticalLines(true);
        this.m_oFileTreeTable.setColumnSelectionAllowed(false);
        this.m_oFileTreeTable.setRowSelectionAllowed(true);
    }

    public void setCellRenderer(JLabel label, Object value) {
        label.setText(value.toString());
    }

    private void populateTreeTable(LoadFileInfoListParam oLoadFileParam) {
        Vector oRowData = null;
        oRowData = new Vector<String>(4){

            @Override
            public String toString() {
                return (String)this.elementAt(0);
            }
        };
        oRowData.add(DCFrameWorkUtil.getLocalizedString("TASK_LEVEL_LOAD_FILES"));
        oRowData.add("");
        oRowData.add("");
        oRowData.add("");
        TreeTableNode oTaskLevelNode = new TreeTableNode(oRowData);
        this.m_oRootNode.add(oTaskLevelNode);
        TreeTableNode oFileLevelNode = null;
        LoadFileInfo oLoadFileInfo = null;
        List<LoadFileInfo> loadFileLst = DCCommonUtil.getLoadFileInfo(oLoadFileParam, 0);
        int iSize = loadFileLst.size();
        for (int i = 0; i < iSize; ++i) {
            oLoadFileInfo = loadFileLst.get(i);
            oRowData = new Vector<String>(4){

                @Override
                public String toString() {
                    return (String)this.elementAt(0);
                }
            };
            oRowData.add("");
            oRowData.add("" + oLoadFileInfo.getSequenceNo());
            oRowData.add(oLoadFileInfo.getFileName());
            oRowData.add(oLoadFileInfo.getContentType().getStrContentType());
            oFileLevelNode = new TreeTableNode(oRowData);
            oTaskLevelNode.add(oFileLevelNode);
        }
        HashMap<Integer, List<LoadFileInfo>> oHashMap = this.getDeviceLoadFileInfoMap(oLoadFileParam);
        oRowData = new Vector<String>(4){

            @Override
            public String toString() {
                return (String)this.elementAt(0);
            }
        };
        oRowData.add(DCFrameWorkUtil.getLocalizedString("DEVICE_LEVEL_LOAD_FILES"));
        oRowData.add("");
        oRowData.add("");
        oRowData.add("");
        TreeTableNode oDeviceLevelNode = new TreeTableNode(oRowData);
        this.m_oRootNode.add(oDeviceLevelNode);
        Iterator<Map.Entry<Integer, List<LoadFileInfo>>> oFileInfoItr = oHashMap.entrySet().iterator();
        Integer oDevId = null;
        List<LoadFileInfo> oFileList = null;
        TreeTableNode oDevNode = null;
        TreeTableNode oFileNode = null;
        Vector<String> oDevRowData = null;
        Vector<String> oFileRowData = null;
        DeviceInfo oDevInfo = null;
        String strResourceInfo = null;
        String strFilePath = null;
        String strContentType = null;
        Map.Entry<Integer, List<LoadFileInfo>> oFileInfoEntry = null;
        while (oFileInfoItr.hasNext()) {
            oFileInfoEntry = oFileInfoItr.next();
            oDevId = oFileInfoEntry.getKey();
            oFileList = oFileInfoEntry.getValue();
            if (null == oFileList || 0 == oFileList.size()) continue;
            oDevRowData = new Vector<String>(3){

                @Override
                public String toString() {
                    return (String)this.elementAt(0);
                }
            };
            oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDevId);
            strResourceInfo = oDevInfo.getDevName() + '(' + oDevInfo.getDevIPAddress() + ')';
            strFilePath = "";
            strContentType = "";
            oDevRowData.add(strResourceInfo);
            oDevRowData.add("");
            oDevRowData.add(strFilePath);
            oDevRowData.add(strContentType);
            oDevNode = new TreeTableNode(oDevRowData);
            oDeviceLevelNode.add(oDevNode);
            int iFileSize = oFileList.size();
            for (int i = 0; i < iFileSize; ++i) {
                oFileRowData = new Vector<String>(3){

                    @Override
                    public String toString() {
                        return (String)this.elementAt(0);
                    }
                };
                oLoadFileInfo = oFileList.get(i);
                strResourceInfo = "";
                strFilePath = oLoadFileInfo.getFileName();
                strContentType = oLoadFileInfo.getContentType().getStrContentType();
                oFileRowData.add(strResourceInfo);
                oFileRowData.add("" + oLoadFileInfo.getSequenceNo());
                oFileRowData.add(strFilePath);
                oFileRowData.add(strContentType);
                oFileNode = new TreeTableNode(oFileRowData);
                oDevNode.add(oFileNode);
            }
        }
    }

    private HashMap<Integer, List<LoadFileInfo>> getDeviceLoadFileInfoMap(LoadFileInfoListParam oLoadFileParam) {
        HashMap<Integer, List<LoadFileInfo>> oHashMap = new HashMap<Integer, List<LoadFileInfo>>(0);
        List<Object> oFileList = null;
        List<LoadFileInfo> oFileInfoList = oLoadFileParam.getLoadFileInfoList();
        LoadFileInfo oLoadFileInfo = null;
        int iSize = oFileInfoList.size();
        for (int i = 0; i < iSize; ++i) {
            oLoadFileInfo = oFileInfoList.get(i);
            if (0 == oLoadFileInfo.getFileSelectionLevel()) continue;
            int iDevID = oLoadFileInfo.getDeviceId();
            if (!oHashMap.containsKey(iDevID) || null == oHashMap.get(iDevID)) {
                oFileList = new ArrayList(0);
                oHashMap.put(iDevID, oFileList);
            } else {
                oFileList = oHashMap.get(iDevID);
            }
            oFileList.add(oLoadFileInfo);
        }
        return oHashMap;
    }

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeTableNode node = (TreeTableNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeTableNode n = (TreeTableNode)e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewLoadSoftwarepanel.this.m_oFileTreeTable.getTableHeader().updateUI();
                ViewLoadSoftwarepanel.this.m_oFileTreeTable.updateUI();
                ViewLoadSoftwarepanel.this.updateUI();
            }
        });
    }

    private boolean hasSomeDeviceLevelFiles(LoadFileInfoListParam oLoadFileParam) {
        boolean bHasSomeDeviceLevelFiles = false;
        List<LoadFileInfo> oFileInfoList = oLoadFileParam.getLoadFileInfoList();
        LoadFileInfo oLoadFileInfo = null;
        int iSize = oFileInfoList.size();
        for (int i = 0; i < iSize; ++i) {
            oLoadFileInfo = oFileInfoList.get(i);
            if (1 != oLoadFileInfo.getFileSelectionLevel()) continue;
            bHasSomeDeviceLevelFiles = true;
            break;
        }
        return bHasSomeDeviceLevelFiles;
    }

    private void setBoundsForAllComponent(JScrollPane oScrollPane, boolean bPacketFileExists) {
        if (this.m_oParentTask.getTaskTypeId() == 3 || this.m_oParentTask.getTaskTypeId() == 5 || this.m_oParentTask.getTaskTypeId() == 4 || this.m_oParentTask.getTaskTypeId() == 12 || this.m_oParentTask.getTaskTypeId() == 13) {
            this.setSize(908, 560);
            if (bPacketFileExists) {
                oScrollPane.setBounds(12, 41, 862, 280);
            } else {
                oScrollPane.setBounds(12, 12, 862, 304);
            }
        } else {
            this.setSize(608, 400);
            if (bPacketFileExists) {
                oScrollPane.setBounds(16, 45, 591, 330);
            } else {
                oScrollPane.setBounds(16, 20, 591, 350);
            }
        }
    }

    private void populateDataInTable(LoadFileInfoListParam oLoadFileInfoList) {
        int oSizeOfLst = oLoadFileInfoList.getNumberOfFiles();
        Vector<Object> oRowDataVec = null;
        Vector<String> oFileNameVct = new Vector<String>(5);
        for (int i = 0; i < oSizeOfLst; ++i) {
            LoadFileInfo oLoadFileInfo = oLoadFileInfoList.getLoadFileInfo(i);
            if (DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oLoadFileInfo.getContentType())) continue;
            oRowDataVec = new Vector<Object>(5);
            oRowDataVec.add(this.m_oTableModel.getRowCount() + 1);
            oRowDataVec.add(oLoadFileInfo.getFileName());
            if (oLoadFileInfoList.isContentTypeRequired()) {
                oRowDataVec.add(oLoadFileInfo.getContentType().getStrContentType());
            }
            if (oLoadFileInfoList.isDeviceTypeInfoRequired()) {
                oRowDataVec.add(oLoadFileInfo.getDeviceTypeInfo());
            }
            if (oFileNameVct.contains(oLoadFileInfo.getFileName())) continue;
            oFileNameVct.add(oLoadFileInfo.getFileName());
            this.m_oTableModel.addRow(oRowDataVec);
        }
        oFileNameVct.clear();
        oFileNameVct = null;
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -3905322891212088102L;

        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ViewLoadSoftwarepanel.this.setCellRenderer(this, value);
            return this;
        }
    }
}

