/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;

public class MakeTypicalPacketUtil {
    public static boolean isOperationSupported(ITask oTask) {
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTask.getSelectedDeviceType());
        if (null == oDevTypeConfigModel) {
            return false;
        }
        IOperation oMakeTypFileOp = oDevTypeConfigModel.getOperationObj(5, 27);
        return null != oMakeTypFileOp;
    }

    public static boolean isOperationSupportedForFile(ITask oTask, ContentType oFileType) {
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTask.getSelectedDeviceType());
        if (null == oDevTypeConfigModel || null == oFileType) {
            return false;
        }
        IOperation oMakeTypFileOp = oDevTypeConfigModel.getOperationObj(5, 27);
        if (null == oMakeTypFileOp) {
            return false;
        }
        IParaList oGetOPerationParaList = oMakeTypFileOp.getoPerationParaList();
        Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetOPerationParaList);
        if (null == arrParaVals) {
            return false;
        }
        for (int j = 0; j < arrParaVals.length; ++j) {
            if (!oFileType.equals(arrParaVals[j])) continue;
            return true;
        }
        return false;
    }

    public static ValidationResult validateLoadConfigPara(ITask oTask, LoadFileInfoListParam oLoadFiles) {
        ValidationResult oResult = new ValidationResult();
        oResult.setErrorCode(0);
        LoadFileInfo oPacketTool = oLoadFiles.getPacketTool();
        int iMinFileCount = -1;
        iMinFileCount = null == oPacketTool ? 1 : 2;
        int iCurrentFileCount = oLoadFiles.getNumberOfFiles();
        if (iCurrentFileCount < iMinFileCount) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_SW_FILE_SELECTED"));
            return oResult;
        }
        boolean bAnySupportedFileSelected = false;
        LoadFileInfo oFileInfo = null;
        for (int i = 0; i < iCurrentFileCount; ++i) {
            oFileInfo = oLoadFiles.getLoadFileInfo(i);
            if (!MakeTypicalPacketUtil.isOperationSupportedForFile(oTask, oFileInfo.getContentType())) continue;
            bAnySupportedFileSelected = true;
            break;
        }
        if (!bAnySupportedFileSelected) {
            return oResult;
        }
        if (null == oPacketTool) {
            oResult.setErrorCode(-1);
            oResult.setErrorType(3);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_PACKET_TOOL_SELECTED_WARNING"));
            return oResult;
        }
        return oResult;
    }
}

