/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.Parameter;
import com.huawei.dc.devicemanagement.model.ContentTypeMgr;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.SoftwareType;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageBoardInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageFileInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LoadSoftwareOperationHelper {
    public static final int PACKAGE = 1;
    public static final int SIMULATION = 2;
    public static final int PATCH = 3;
    private static final int DEFAULT_CONTENT_TYPE_ID = 999;
    public static final String DEFAULT_CONTENT_TYPE = "";

    public static int getFileTypeID(ITask oTask) {
        int fileType = -1;
        if (oTask.getTaskTypeId() == 3) {
            fileType = 2;
        } else if (oTask.getTaskTypeId() == 4 || oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 12 || oTask.getTaskTypeId() == 13) {
            fileType = 1;
        } else if (oTask.getTaskTypeId() == 2) {
            fileType = 3;
        }
        return fileType;
    }

    public static boolean isSupportAutoDeleteImage(IParaList oParaList) {
        boolean bSupport = false;
        String sDelteImageID = "AutoFreeSpace";
        if (null == oParaList) {
            return bSupport;
        }
        Parameter oPara = (Parameter)oParaList.getParameter(sDelteImageID);
        if (null != oPara) {
            bSupport = oPara.isRequired();
        }
        return bSupport;
    }

    public static void createRowData(Vector rowData, StringBuffer rowsData) {
        rowsData.append("<dl><dd></dl><tr high = 0>");
        for (int m = 0; m < rowData.size(); ++m) {
            Object data = rowData.get(m);
            if (data == null) {
                rowsData.append("<td>").append("</td>");
                continue;
            }
            rowsData.append("<td>").append(data).append("</td>");
        }
        rowsData.append("</tr>");
    }

    public static DeviceType getDevTypeFromTaskObj(ITask m_oParentTask) {
        String oSelectedDevType = DEFAULT_CONTENT_TYPE;
        TaskMgmtOperationSelecPanel oTaskMgmtOperationPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
        if (null != oTaskMgmtOperationPanel && !DEFAULT_CONTENT_TYPE.equals(oTaskMgmtOperationPanel.getSelectedTragetVersion())) {
            oSelectedDevType = oTaskMgmtOperationPanel.getSelectedTragetDecType();
        }
        if (DEFAULT_CONTENT_TYPE.equals(oSelectedDevType)) {
            return m_oParentTask.getSelectedDeviceType();
        }
        THashSet<Resource> resources = m_oParentTask.getSelectedDeviceType().getResources();
        Iterator oResItor = resources.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            DeviceType oDeviceType = DeviceModelAdapter.populateDeviceTypeFromDeviceID(oRes.getDeviceID());
            if (!oSelectedDevType.equals(oDeviceType.getDeviceTypeName())) continue;
            return oDeviceType;
        }
        return null;
    }

    public static StringBuffer createCloumHead() {
        String[] colHead = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("BOARD_NALE"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_SOFTWARE_NAME"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_NEW_SOFTWARE_VERSION"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_TO_BE_LOADED")};
        StringBuffer columeHead = new StringBuffer(0);
        columeHead.append("<dl><dd></dl><tr high = 0>");
        for (int i = 0; i < colHead.length; ++i) {
            columeHead.append("<td>").append(colHead[i]).append("</td>");
        }
        columeHead.append("</tr>");
        return columeHead;
    }

    public static StringBuffer createRowsData(ITask oParentTask) {
        StringBuffer rowsData = new StringBuffer(0);
        LoadSimPackageInfo loadSimPackageInfo = oParentTask.getLoadSimPackageInfo();
        Vector devList = loadSimPackageInfo.getDevList();
        int devCount = devList.size();
        for (int i = 0; i < devCount; ++i) {
            LoadSimPackageDevInfo devInfo = (LoadSimPackageDevInfo)devList.get(i);
            Vector<String> rowData = new Vector<String>(5);
            rowData.add(0, devInfo.getDevName());
            rowData.add(1, null);
            rowData.add(2, null);
            rowData.add(3, null);
            rowData.add(4, null);
            LoadSoftwareOperationHelper.createRowData(rowData, rowsData);
            Vector boardList = devInfo.getBoardList();
            int boardCount = boardList.size();
            for (int j = 0; j < boardCount; ++j) {
                LoadSimPackageBoardInfo boardInfo = (LoadSimPackageBoardInfo)boardList.get(j);
                rowData = new Vector(5);
                rowData.add(0, null);
                rowData.add(1, boardInfo.getSlotLabel() + '_' + boardInfo.getSlotId());
                rowData.add(2, null);
                rowData.add(3, null);
                rowData.add(4, null);
                LoadSoftwareOperationHelper.createRowData(rowData, rowsData);
                Vector fileList = boardInfo.getFileList();
                int fileCount = fileList.size();
                for (int l = 0; l < fileCount; ++l) {
                    LoadSimPackageFileInfo fileInfo = (LoadSimPackageFileInfo)fileList.get(l);
                    rowData = new Vector(5);
                    rowData.add(0, null);
                    rowData.add(1, null);
                    rowData.add(2, fileInfo.getFileName());
                    rowData.add(3, fileInfo.getSoftwareNewVersion());
                    if (fileInfo.getToBeLoad() != 0) {
                        rowData.add(4, "yes");
                    } else {
                        rowData.add(4, "no");
                    }
                    LoadSoftwareOperationHelper.createRowData(rowData, rowsData);
                }
            }
        }
        return rowsData;
    }

    public static boolean checkIfSupportTypicalPkg(ITask m_oTaskDataObj) {
        THashSet<Resource> resList = m_oTaskDataObj.getDeviceType().getResources();
        for (Resource res : resList) {
            if ((res.getUpgradeMode() & 0x8000) != 0) continue;
            return false;
        }
        return true;
    }

    public static String getCurrentContextKey(ITask m_oTaskDataObj) {
        String sCurrentContext = DEFAULT_CONTENT_TYPE;
        if (null == m_oTaskDataObj) {
            return DEFAULT_CONTENT_TYPE;
        }
        int iTaskTypeID = m_oTaskDataObj.getTaskTypeId();
        switch (iTaskTypeID) {
            case 0: {
                sCurrentContext = "HELP_TOPIC_SW_U_LOADSOFT";
                break;
            }
            case 1: {
                sCurrentContext = "HELP_TOPIC_SW_D_LOADSOFT";
                break;
            }
            case 2: {
                sCurrentContext = "HELP_TOPIC_PATCH_U_LOADSOFT";
                break;
            }
            case 3: {
                sCurrentContext = "HELP_TOPIC_MINIC_LOADSOFT";
                break;
            }
            case 4: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_U_LOADSOFT";
                break;
            }
            case 13: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_D_LOADSOFT";
                break;
            }
            case 5: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_U_LOADSOFT";
                break;
            }
            case 12: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_D_LOADSOFT";
                break;
            }
        }
        return sCurrentContext;
    }

    public static List<DeviceTypeInfo> getStackDeviceTypeList(ITask m_oParentTask) {
        ArrayList<DeviceTypeInfo> oDevTypeInfoLst = new ArrayList<DeviceTypeInfo>(0);
        if (m_oParentTask.isStackDevicePresent(3)) {
            THashSet<Resource> oResList = m_oParentTask.getDeviceType().getResources();
            Iterator oResItor = oResList.iterator();
            Resource oRes = null;
            while (oResItor.hasNext()) {
                oRes = (Resource)oResItor.next();
                DeviceTypeInfo oDevTypeInfo = oRes.getStackDevTypeInfo();
                if (null == oDevTypeInfo || oDevTypeInfoLst.contains(oDevTypeInfo)) continue;
                oDevTypeInfoLst.add(oDevTypeInfo);
            }
        }
        return oDevTypeInfoLst;
    }

    public static ContentTypeMgr updateContentTypeManager(ITask oParentTask, IParaList oParaList) {
        List parameterValueList;
        int iSize;
        IOperationPara oContentTypeParameter;
        ContentTypeMgr oMger = new ContentTypeMgr();
        SoftwareType oSW = new SoftwareType();
        boolean isClusterDevice = oParentTask.isClusterChildDevice();
        if (null != oParaList && 0 != oParaList.getNumOfParam() && null != (oContentTypeParameter = oParaList.getParameter("ContentType")) && 0 < (iSize = (parameterValueList = oContentTypeParameter.getParameterValueList()).size())) {
            oSW.addContentDataType(999, DEFAULT_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            for (int iParaValueIndex = 0; iParaValueIndex < iSize; ++iParaValueIndex) {
                String strContentTypeName = ((ParaValue)parameterValueList.get(iParaValueIndex)).getDisplayName();
                int value = ((ParaValue)parameterValueList.get(iParaValueIndex)).getValue();
                String strId = ((ParaValue)parameterValueList.get(iParaValueIndex)).getId();
                if (isClusterDevice && "PATCH".equals(strId)) continue;
                oSW.addContentDataType(value, strContentTypeName, strId);
            }
        }
        oMger.setSoftwareType(oSW);
        return oMger;
    }

    public static String toString(ITask oParentTask, LoadFileInfoListParam oLoadParam) {
        StringBuffer strRetVal = new StringBuffer(0);
        if (oParentTask.getTaskTypeId() == 3) {
            strRetVal.append(ResourceManager.getInstance().getResString("LOAD_MIMIC_PACKAGE_PATH"));
            strRetVal.append(oParentTask.getLoadAllPath(0, oParentTask.getLoadSimPackageInfo()));
            strRetVal.append("<br>");
            strRetVal.append(ResourceManager.getInstance().getResString("SIMULATION_PACKAGE_INFO_TABLE"));
            String tableHead = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\">";
            StringBuffer columeHead = LoadSoftwareOperationHelper.createCloumHead();
            StringBuffer rowsData = LoadSoftwareOperationHelper.createRowsData(oParentTask);
            String tableLast = "</table>";
            strRetVal.append(tableHead);
            strRetVal.append(columeHead);
            strRetVal.append(rowsData);
            strRetVal.append(tableLast);
            strRetVal.append(ResourceManager.getInstance().getResString("ROLLBACK_FILE_PATH_MIMC"));
            strRetVal.append(oParentTask.getLoadAllPath(1, oParentTask.getTemporaryLoadSimPackageInfo()));
        } else {
            List<LoadFileInfo> oFileList = oLoadParam.getLoadFileInfoList();
            if (null == oFileList || 0 == oFileList.size()) {
                return strRetVal.toString();
            }
            int iFileCount = oFileList.size();
            strRetVal.append(ResourceManager.getInstance().getResString("LOAD_SOFTWARE_FILE_LIST"));
            for (int i = 0; i < iFileCount; ++i) {
                LoadFileInfo oFile = oFileList.get(i);
                if (DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oFile.getContentType())) continue;
                strRetVal.append("<br>");
                strRetVal.append(oFile.getAbsoluteFilePath());
            }
            LoadFileInfo oPacketTool = oLoadParam.getPacketTool();
            if (null != oPacketTool) {
                strRetVal.append("<br>");
                strRetVal.append("<br>");
                strRetVal.append(ResourceManager.getInstance().getResString("PACKET_TOOL_LABEL"));
                strRetVal.append(" : ");
                strRetVal.append("<br>");
                strRetVal.append(oPacketTool.getAbsoluteFilePath());
            }
        }
        strRetVal.append("<br>");
        return strRetVal.toString();
    }

    public static ValidationResult checkIfDefaultFilesAvailable(ITask oParentTask) {
        ValidationResult oResult = new ValidationResult();
        String strTargetVersion = oParentTask.getTargetVersion();
        if (null == strTargetVersion || DEFAULT_CONTENT_TYPE.equalsIgnoreCase(strTargetVersion) || oParentTask.isThirdPartySupported()) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_SW_FILE_SELECTED"));
            return oResult;
        }
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oParentTask.getSelectedDeviceType().getDeviceTypeID(), oParentTask.getSelectedDeviceType().getDeviceTypeVersionID());
        oSAMFileInfo.setDeviceTypeInfo(oDeviceTypeInfo);
        oSAMFileInfo.setVersion(strTargetVersion);
        boolean isDefaultFilePresent = SAMManager.getInstance().isLoadSoftwaresPresent(oSAMFileInfo);
        if (!isDefaultFilePresent) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_SW_FILE_SELECTED"));
        }
        return oResult;
    }

    public static boolean isDeviceFileSelectionCorrect(THashSet<Resource> oSupportedResList, List oFileList) {
        boolean bFileSelection = true;
        int iFileSize = oFileList.size();
        LoadFileInfo oFileInfo = null;
        Resource oRes2 = null;
        for (Resource oRes2 : oSupportedResList) {
            boolean bFileSelectedForDevice = false;
            for (int j = 0; j < iFileSize; ++j) {
                oFileInfo = (LoadFileInfo)oFileList.get(j);
                if (1 != oFileInfo.getFileSelectionLevel() || oRes2.getDeviceID() != oFileInfo.getDeviceId()) continue;
                bFileSelectedForDevice = true;
                break;
            }
            if (bFileSelectedForDevice) continue;
            bFileSelection = false;
            break;
        }
        return bFileSelection;
    }
}

