/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.asndatacenter.AsnDCFileDeleteOnDevRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.CheckDeviceMemoryUtil;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DeviceMemoryStatusDialog
extends DCModalDialog
implements ITaskNotificationListener {
    private static final long serialVersionUID = 2349779452445413364L;
    private JPanel m_oTablePanel = null;
    private JTable m_oTable = null;
    private DefaultTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private static final int TABLE_RESOURCE_NAME = 0;
    private static final int TABLE_RESOURCE_IP = 1;
    private static final int TABLE_RESOURCE_VERSION = 2;
    private static final int TABLE_DEVICE_FILES = 3;
    private static final int TABLE_RESOURCE_OBJ = 4;
    private HashMap<Integer, DeviceMemoryInfo> m_oDeviceMemoryInfoMap = null;
    private int iTaskTypeId;
    private HashMap<Integer, List<String>> m_oFileInfoMap = null;

    public DeviceMemoryStatusDialog(HashMap<Integer, DeviceMemoryInfo> oHashMap, int taskTypeId) {
        this.m_oDeviceMemoryInfoMap = oHashMap;
        this.iTaskTypeId = taskTypeId;
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.jbinit();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public DeviceMemoryStatusDialog(FileSelectionDialog parentDlg, HashMap<Integer, DeviceMemoryInfo> oHashMap, HashMap<Integer, List<String>> oFileInfoMap, int taskTypeId) {
        super(parentDlg);
        DCDebugTracer.trace("lxj:DeviceMemoryStatusDialog getModalParent before setting:" + this.getModalParent());
        if (null != parentDlg && (null == this.getModalParent() || this.getModalParent() instanceof SimpleProgressDlg)) {
            DCDebugTracer.trace("lxj: file choose modal child:" + parentDlg.getModalChild());
            this.setModalParent((InternalFrame)parentDlg);
            DCDebugTracer.trace("lxj:DeviceMemoryStatusDialog getModalParent after setting:" + this.getModalParent());
        }
        this.m_oDeviceMemoryInfoMap = oHashMap;
        this.m_oFileInfoMap = oFileInfoMap;
        this.iTaskTypeId = taskTypeId;
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.jbinit();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void jbinit() {
        this.initDialog();
        this.initPanel();
        this.initScrollPane();
        this.initButtons();
        this.populateTableData();
        this.refreshTable();
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        this.setTitle(DCFrameWorkUtil.getLocalizedString("MEMORY_STATUS_PANEL_TITLE"));
        this.setSize(600, 450);
    }

    private void populateTableData() {
        this.m_oTable.removeAll();
        Iterator<Integer> oDevIDItr = this.m_oDeviceMemoryInfoMap.keySet().iterator();
        Resource oRes = null;
        Vector<Object> oRowDataVector = null;
        DeviceMemoryInfo oDeviceMemoryInfo = null;
        while (oDevIDItr.hasNext()) {
            int iDevID = oDevIDItr.next();
            oDeviceMemoryInfo = this.m_oDeviceMemoryInfoMap.get(iDevID);
            if (2 == oDeviceMemoryInfo.getDeviceMemoryCheckResult()) continue;
            oRes = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
            oRowDataVector = new Vector<Object>(5);
            oRowDataVector.add(oRes.getDeviceName());
            oRowDataVector.add(oRes.getDeviceIP());
            oRowDataVector.add(oRes.getDeviceVersion());
            String strLink = this.getLinkDesc(iDevID);
            oRowDataVector.add(strLink);
            oRowDataVector.add(oRes);
            this.m_oTableModel.addRow(oRowDataVector);
        }
    }

    private String getLinkDesc(int iDevID) {
        DeviceMemoryInfo oDeviceMemoryInfo = this.m_oDeviceMemoryInfoMap.get(iDevID);
        String strLink = "";
        strLink = 0 == oDeviceMemoryInfo.getDeviceMemoryCheckResult() ? DCFrameWorkUtil.getLocalizedString("NEED_TO_CLEAR_LINK") : (1 == oDeviceMemoryInfo.getDeviceMemoryCheckResult() ? DCFrameWorkUtil.getLocalizedString("NO_NEED_TO_CLEAR_LINK") : DCFrameWorkUtil.getLocalizedString("MEMORY_CHECK_FAILED_LINK"));
        return strLink;
    }

    private void initPanel() {
        this.m_oTablePanel = new JPanel();
        this.m_oTablePanel.setName("TaskMgmt_StartupConfigPanel_m_oTablePanel");
        TitledBorder oStartupCofigPanelTitledBorder = new TitledBorder(DCFrameWorkUtil.getLocalizedString("MEMORY_STATUS_PANEL_TITLE"));
        this.m_oTablePanel.setBorder(oStartupCofigPanelTitledBorder);
        this.m_oTablePanel.setLayout(new GridBagLayout());
        this.add(this.m_oTablePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
    }

    private void initScrollPane() {
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setName("TaskMgmt_StartupConfigPanel_oTableScrollPane");
        this.m_oScrollPane.setViewportView(this.getOperationTable());
        this.m_oTablePanel.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 3, 5), 0, 0));
    }

    private void initButtons() {
        this.m_oCancelBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CLOSE"));
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
    }

    private Component getOperationTable() {
        Object[] arrcolHeader = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_IP"), DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"), DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_MEMORY_STATUS"), DCFrameWorkUtil.getLocalizedString("DEVICE_ID")};
        this.m_oTableModel = new DefaultTableModel(arrcolHeader, 0);
        this.m_oTable = new JTable(this.m_oTableModel);
        this.m_oTable.setName("TaskMgmt_StartupConfigPanel_m_oTable");
        this.customizeTable();
        return this.m_oTable;
    }

    private void customizeTable() {
        this.m_oTable.removeColumn(this.m_oTable.getColumnModel().getColumn(4));
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTable.setRowHeight(21);
        this.setPreferredColumnWidths(new double[]{0.2, 0.2, 0.2, 0.4});
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
        this.m_oTable.getColumnModel().getColumn(0).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(1).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(2).setCellRenderer(new MyRenderer());
        this.m_oTable.getColumnModel().getColumn(3).setCellRenderer(new ConfigOpLinkRenderer());
        this.m_oTable.getColumnModel().getColumn(3).setCellEditor(new ConfigOpLinkEditor());
        this.m_oTable.addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oTable.addMouseListener(new OperationTableMouseListener());
    }

    public void setPreferredColumnWidths(double[] arrColumnWidthPercentage) {
        int i;
        Dimension oTableDim = this.m_oTable.getPreferredSize();
        double dTotle = 0.0;
        for (i = 0; i < this.m_oTable.getColumnModel().getColumnCount(); ++i) {
            dTotle += arrColumnWidthPercentage[i];
        }
        for (i = 0; i < this.m_oTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn oColumn = this.m_oTable.getColumnModel().getColumn(i);
            oColumn.setPreferredWidth((int)((double)oTableDim.width * (arrColumnWidthPercentage[i] / dTotle)));
        }
    }

    private void checkDevMemory(int iDevId) {
        if (null != this.m_oFileInfoMap && this.m_oFileInfoMap.containsKey(iDevId)) {
            HashMap<Integer, List<String>> oTmpFileInfoMap = new HashMap<Integer, List<String>>();
            oTmpFileInfoMap.put(iDevId, this.m_oFileInfoMap.get(iDevId));
            CheckDeviceMemoryUtil checkDevMemoryUtil = new CheckDeviceMemoryUtil(oTmpFileInfoMap);
            HashMap<Object, Object> oDeviceMemoryInfoMap = new HashMap();
            oDeviceMemoryInfoMap = checkDevMemoryUtil.checkDeviceMemory();
            if (0 < oDeviceMemoryInfoMap.size() && oDeviceMemoryInfoMap.containsKey(iDevId)) {
                this.m_oDeviceMemoryInfoMap.put(iDevId, (DeviceMemoryInfo)oDeviceMemoryInfoMap.get(iDevId));
            }
        }
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DeviceMemoryStatusDialog.this.m_oTable) {
                    DeviceMemoryStatusDialog.this.m_oTable.updateUI();
                }
            }
        });
    }

    public boolean checkLinkRequired(int rowAtPoint) {
        boolean bLinkReqd = false;
        String strDesc = (String)this.m_oTable.getValueAt(rowAtPoint, 3);
        bLinkReqd = !Collator.getInstance().equals(strDesc, DCFrameWorkUtil.getLocalizedString("NO_NEED_TO_CLEAR_LINK"));
        return bLinkReqd;
    }

    @Override
    protected String getCurrentContext() {
        String currentContext = "";
        if (0 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_SOFTWARE_UPGRADE";
        } else if (1 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_SOFTWARE_DOWNGRADE";
        } else if (2 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_PATCH_UPGRADE";
        } else if (3 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_MIMIC_PACKAGE";
        } else if (4 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_PACKAGE_UPGRADE";
        } else if (13 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_PACKAGE_DOWNGRADE";
        } else if (5 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_PACKAGE_DIFF_UPGRADE";
        } else if (12 == this.iTaskTypeId) {
            currentContext = "HELP_TOPIC_LOAD_PACKAGE_DIFF_DOWNGRADE";
        } else {
            DCDebugTracer.trace("iTaskTypeId : " + this.iTaskTypeId);
        }
        return currentContext;
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnDCFileDeleteOnDevRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        AsnDCFileDeleteOnDevRsp oAsnDCFileDeleteOnDevRsp = (AsnDCFileDeleteOnDevRsp)oEvent.getSource();
        if (null == oAsnDCFileDeleteOnDevRsp) {
            return;
        }
        int iDevID = oAsnDCFileDeleteOnDevRsp.iDeviceID.intValue();
        String strFilePath = new String(oAsnDCFileDeleteOnDevRsp.strFileName);
        String strDir = strFilePath.substring(0, strFilePath.indexOf(47) + 1);
        String strFileName = strFilePath.substring(strFilePath.indexOf(47) + 1);
        DeviceMemoryInfo oDevMemoryInfo = this.m_oDeviceMemoryInfoMap.get(iDevID);
        if (null == oDevMemoryInfo) {
            return;
        }
        if (0 != oAsnDCFileDeleteOnDevRsp.oErrorInfo.iErrorNo.intValue()) {
            return;
        }
        HashMap<String, List<DeviceFileInfo>> oHashMap = oDevMemoryInfo.getDevDirFileInfoMap();
        if (null == oHashMap) {
            return;
        }
        List<DeviceFileInfo> oFileInfoList = oHashMap.get(strDir);
        if (null == oFileInfoList) {
            return;
        }
        for (int i = oFileInfoList.size() - 1; i >= 0; --i) {
            if (!Collator.getInstance().equals(oFileInfoList.get(i).getFileName(), strFileName)) continue;
            oFileInfoList.remove(i);
        }
        if (0 == oFileInfoList.size()) {
            oDevMemoryInfo.setDeviceMemoryCheckResult(1);
        }
        this.refreshTable();
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
    }

    private class MyRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)DeviceMemoryStatusDialog.this.m_oTableModel.getValueAt(row, column));
            this.setBackground(DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            return this;
        }
    }

    private class ConfigOpLinkRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ConfigOpLinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            String strOpDesc = DeviceMemoryStatusDialog.this.getLinkDesc(((Resource)DeviceMemoryStatusDialog.this.m_oTableModel.getValueAt(row, 4)).getDeviceID());
            String strOplink = "";
            strOplink = DeviceMemoryStatusDialog.this.checkLinkRequired(row) ? "<html><a href=\"x\">" + strOpDesc + "</a>" + "</html>" : strOpDesc;
            this.setText(strOplink);
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
            this.setBorder(oMatteBorder);
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    private class ConfigOpLinkEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = -4679417598303254962L;
        private JButton m_oLinkButton = new JButton();
        String m_strOpDesc = null;

        public ConfigOpLinkEditor() {
            this.m_oLinkButton.setBackground(DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            this.m_oLinkButton.setRolloverEnabled(true);
            this.m_oLinkButton.addActionListener(this);
        }

        private void updateButtonView(int iDevId) {
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            this.m_oLinkButton.setBorder(oMatteBorder);
            this.m_oLinkButton.setBackground(DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            String strOplink = this.m_strOpDesc = DeviceMemoryStatusDialog.this.getLinkDesc(iDevId);
            if (!Collator.getInstance().equals(this.m_strOpDesc, DCFrameWorkUtil.getLocalizedString("NO_NEED_TO_CLEAR_LINK"))) {
                strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            }
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String strOplink = this.m_strOpDesc = DeviceMemoryStatusDialog.this.getLinkDesc(((Resource)DeviceMemoryStatusDialog.this.m_oTableModel.getValueAt(row, 4)).getDeviceID());
            if (!Collator.getInstance().equals(this.m_strOpDesc, DCFrameWorkUtil.getLocalizedString("NO_NEED_TO_CLEAR_LINK"))) {
                strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            }
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
            this.m_oLinkButton.setEnabled(DeviceMemoryStatusDialog.this.isEnabled());
            return this.m_oLinkButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_strOpDesc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int iSelectedRow = DeviceMemoryStatusDialog.this.m_oTable.getSelectedRow();
            Resource oResource = (Resource)DeviceMemoryStatusDialog.this.m_oTableModel.getValueAt(iSelectedRow, 4);
            this.m_strOpDesc = DeviceMemoryStatusDialog.this.getLinkDesc(oResource.getDeviceID());
            this.m_oLinkButton.setBackground(DeviceMemoryStatusDialog.this.m_oTable.getBackground());
            String strOplink = this.m_strOpDesc;
            if (!Collator.getInstance().equals(this.m_strOpDesc, DCFrameWorkUtil.getLocalizedString("NO_NEED_TO_CLEAR_LINK"))) {
                strOplink = "<html><a href=\"x\">" + this.m_strOpDesc + "</a>" + "</html>";
            }
            this.m_oLinkButton.setText(strOplink);
            DeviceMemoryInfo oDevMemoryInfo = (DeviceMemoryInfo)DeviceMemoryStatusDialog.this.m_oDeviceMemoryInfoMap.get(oResource.getDeviceID());
            if (2 == oDevMemoryInfo.getDeviceMemoryCheckResult()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oDevMemoryInfo.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            } else if (0 == oDevMemoryInfo.getDeviceMemoryCheckResult()) {
                if (null == oDevMemoryInfo.getDeviceDiskInfoList() || 0 == oDevMemoryInfo.getDeviceDiskInfoList().size()) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("NO_DEVICE_FILE_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                } else {
                    DeleteDeviceFileDialog oDeleteDeviceFileDialog = new DeleteDeviceFileDialog(oResource, oDevMemoryInfo);
                    oDeleteDeviceFileDialog.setVisible(true);
                    if (oDeleteDeviceFileDialog.isDeleteFile()) {
                        DeviceMemoryStatusDialog.this.checkDevMemory(oResource.getDeviceID());
                    }
                }
            }
            this.updateButtonView(oResource.getDeviceID());
            this.fireEditingStopped();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceMemoryStatusDialog.this.m_oTable.updateUI();
                }
            });
        }
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            if (DeviceMemoryStatusDialog.this.m_oTable.columnAtPoint(oPoint) == 3) {
                TableCellRenderer oRenderer = DeviceMemoryStatusDialog.this.m_oTable.getCellRenderer(DeviceMemoryStatusDialog.this.m_oTable.rowAtPoint(oPoint), 3);
                if (oRenderer instanceof ConfigOpLinkRenderer && DeviceMemoryStatusDialog.this.checkLinkRequired(DeviceMemoryStatusDialog.this.m_oTable.rowAtPoint(oPoint))) {
                    Cursor cur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(DeviceMemoryStatusDialog.this.m_oTable, cur);
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(DeviceMemoryStatusDialog.this.m_oTable, cur);
                }
            } else {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(DeviceMemoryStatusDialog.this.m_oTable, cur);
            }
        }
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Cursor cur = new Cursor(0);
            DCFrameWorkUtil.setCursor(DeviceMemoryStatusDialog.this.m_oTable, cur);
        }
    }
}

