/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCFileDeleteOnDevRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncCancelReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileDialog;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class DeleteDeviceFileProgressDlg
extends ProgressDlg
implements ITaskNotificationListener {
    private static final long serialVersionUID = 1337608442632731555L;
    private Object m_oSyncObj = new Object();
    private DeleteDeviceFileDialog m_oDeleteDeviceFileDialog = null;
    private int counter = 0;
    private int delcounter = 0;
    private final int SELECTED_FILE_CNT;

    public DeleteDeviceFileProgressDlg(int iCommandCode, DeleteDeviceFileDialog oDeleteDeviceFileDialog, int selFileCnt) {
        super(iCommandCode);
        this.SELECTED_FILE_CNT = selFileCnt;
        this.m_oDeleteDeviceFileDialog = oDeleteDeviceFileDialog;
        this.m_iCommandCode = iCommandCode;
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.customizeTableForTelnetError();
    }

    @Override
    protected String[] getTableColumnNames() {
        String[] columnNames = new String[]{DCFrameWorkUtil.getLocalizedString("TASK_FILE_PATH"), DCFrameWorkUtil.getLocalizedString("OPERATE_RESULT"), ResourceManager.getInstance().getResString("ERROR_INFO")};
        return columnNames;
    }

    public void resetCounter() {
        this.counter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        DCDebugTracer.trace("DeleteDeviceFiles - Method onTaskNotification start");
        if (null == oEvent || !(oEvent.getSource() instanceof AsnDCFileDeleteOnDevRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        Object object = this.m_oSyncObj;
        synchronized (object) {
            DCDebugTracer.trace("DeleteDeviceFiles - Processing for response start");
            AsnDCFileDeleteOnDevRsp oAsnDCFileDeleteOnDevRsp = (AsnDCFileDeleteOnDevRsp)oEvent.getSource();
            if (null == oAsnDCFileDeleteOnDevRsp) {
                DCDebugTracer.trace("DeleteDeviceFiles - ASN Response is null");
                TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
                this.m_progressBar.setValue(100);
                this.m_progressBar.setIndeterminate(false);
                this.m_cancelBtn.setEnabled(false);
                this.m_closeBtn.setEnabled(true);
                return;
            }
            ++this.counter;
            String strResult = "";
            Vector<Object> oRowVector = new Vector<Object>(3);
            if (0 == oAsnDCFileDeleteOnDevRsp.oErrorInfo.iErrorNo.intValue()) {
                strResult = DCFrameWorkUtil.getLocalizedString("OPERTION_SUCCESS");
                ++this.delcounter;
            } else {
                strResult = ErrorCodeReader.getInstance().getErrorDesc(oAsnDCFileDeleteOnDevRsp.oErrorInfo.iErrorNo);
            }
            oRowVector.addElement(new String(oAsnDCFileDeleteOnDevRsp.strFileName));
            oRowVector.addElement(strResult);
            oRowVector.addElement(new ErrorInfo(oAsnDCFileDeleteOnDevRsp.oErrorInfo));
            this.m_oDetailsTableModel.addRow(oRowVector);
            this.m_oDeleteDeviceFileDialog.addoRowVector(oRowVector);
            if (oAsnDCFileDeleteOnDevRsp.bIsFinal) {
                DCDebugTracer.trace("DeleteDeviceFiles - bIsFinal is true");
                TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
                this.m_progressBar.setValue(100);
                this.m_progressBar.setIndeterminate(false);
                this.m_cancelBtn.setEnabled(false);
                this.m_closeBtn.setEnabled(true);
                DCFrameWorkUtil.getCommManager().removeMessageListener(44031, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            }
            this.m_progressBar.setValue(this.counter * 100 / this.SELECTED_FILE_CNT);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeleteDeviceFileProgressDlg.this.m_oScrollPane.repaint();
                }
            });
            DCDebugTracer.trace("DeleteDeviceFiles - Processing for response end");
        }
        DCDebugTracer.trace("DeleteDeviceFiles - Method onTaskNotification end");
    }

    @Override
    protected void cancelButtonActionPerformed() {
        DCDebugTracer.trace("DeleteDeviceFiles - Cancelling the operation start");
        AsnDCSyncCancelReq oAsnDCCancelOperation = new AsnDCSyncCancelReq();
        oAsnDCCancelOperation.oReqID = BigInteger.valueOf(this.getProgressDlgId());
        try {
            this.sendCancelRequestForDelete(oAsnDCCancelOperation);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        DCDebugTracer.trace("DeleteDeviceFiles - Cancelling the operation end");
    }

    private void sendCancelRequestForDelete(final AsnDCSyncCancelReq oAsnDCCancelOperation) throws DCException {
        int iErrorCode;
        DCDebugTracer.trace("DeleteDeviceFiles - send the Cancelling request to server start");
        final AsnDCSyncRsp oAsnDCOpertionRsp = this.getAsnDCOperationRspInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44032), (FStruct)oAsnDCCancelOperation, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        DCDebugTracer.trace("DeleteDeviceFiles - before cancel request start call");
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCDebugTracer.trace("DeleteDeviceFiles - After cancel request start call");
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            throw new DCException(iErrorCode, DCFrameWorkUtil.getLocalizedString("SEND_FAIL"));
        }
        if (0 != oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), DCFrameWorkUtil.getLocalizedString("CANCEL_REQUEST_FAILED"));
        }
        DCDebugTracer.trace("DeleteDeviceFiles - send the Cancelling request to server end");
    }

    @Override
    public void oKButton_ActionPerformed() {
        if (this.SELECTED_FILE_CNT == this.delcounter) {
            try {
                this.m_oDeleteDeviceFileDialog.delAllFile();
            }
            catch (Exception ignore) {
                DCDebugTracer.trace(ignore);
            }
        }
    }
}

