/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.BaseDeleteDeviceFilePanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceDiskInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;

public class DeleteDeviceFilePanel
extends BaseDeleteDeviceFilePanel {
    private static String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("FILE_INFO"), DCFrameWorkUtil.getLocalizedString("FILE_LIST_TABLE_FILE_SIZE_EN")};
    private static Class[] arrColumnTypes = new Class[]{TreeTableModel.class, Object.class, String.class};
    private static boolean[] arrSortableColumns = new boolean[]{false, false};
    private static boolean[] arrEditableColumns = new boolean[]{true, false};
    private static int TABLE_COLMUN_SIZE = 2;
    private static int TABLE_SELECT_FILE_PATH = 0;
    private static int TABLE_SELECT_FILE_SIZE = 1;
    private DeviceMemoryInfo m_oDeviceMemoryInfo = null;
    private DeleteDeviceFileDialog m_oDeleDevFileDlg = null;

    public DeleteDeviceFilePanel(DeviceMemoryInfo oDeviceMemoryInfo, DCModalDialog dlg) {
        super(arrColumnTypes, strColumnNames, arrSortableColumns, arrEditableColumns);
        this.m_oDeviceMemoryInfo = oDeviceMemoryInfo;
        this.m_oDeleDevFileDlg = (DeleteDeviceFileDialog)dlg;
        this.populateOperationTableData();
    }

    @Override
    protected void initOperTableLisener() {
        this.getOperationTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(DeleteDeviceFilePanel.this.getParent(), cur);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Object obj = e.getSource();
                if (obj instanceof DCSortableTreeTable) {
                    int[] selectRows = ((DCSortableTreeTable)((Object)obj)).getSelectedRows();
                    for (int i = 0; i < selectRows.length; ++i) {
                        if (selectRows[i] == 0) {
                            DeleteDeviceFilePanel.this.m_oDeleDevFileDlg.getSelectButton().setEnabled(false);
                            break;
                        }
                        if (selectRows.length > 0) {
                            DeleteDeviceFilePanel.this.m_oDeleDevFileDlg.getSelectButton().setEnabled(true);
                            continue;
                        }
                        DeleteDeviceFilePanel.this.m_oDeleDevFileDlg.getSelectButton().setEnabled(false);
                    }
                }
            }
        });
    }

    @Override
    public void populateOperationTableData() {
        this.getJTable().removeAll();
        List<DeviceDiskInfo> oDeviceDiskInfoList = this.m_oDeviceMemoryInfo.getDeviceDiskInfoList();
        DeviceDiskInfo oDeviceDiskInfo = null;
        List<DeviceFileInfo> oDeviceFileList = null;
        DeviceFileInfo oDeviceFileInfo = null;
        int iSize = oDeviceDiskInfoList.size();
        for (int i = 0; i < iSize; ++i) {
            oDeviceDiskInfo = oDeviceDiskInfoList.get(i);
            TreeTableNode oDiskNode = this.createDiskNodeInTable(oDeviceDiskInfo);
            this.getRootNode().add(oDiskNode);
            oDeviceFileList = oDeviceDiskInfo.getOFileOnDevList();
            int iCount = oDeviceFileList.size();
            for (int j = 0; j < iCount; ++j) {
                oDeviceFileInfo = oDeviceFileList.get(j);
                TreeTableNode oFileNode = this.createFileNodeInTable(oDeviceFileInfo);
                this.addNode(oDiskNode, oFileNode);
            }
        }
        this.refreshTable();
    }

    @Override
    public TreeTableNode createDiskNodeInTable(DeviceDiskInfo oDeviceDiskInfo) {
        TreeTableRowData oDiskRow = new TreeTableRowData(TABLE_COLMUN_SIZE);
        oDiskRow.setUserObject(oDeviceDiskInfo);
        TreeTableNodeCellData oDiskNameCell = new TreeTableNodeCellData(oDeviceDiskInfo.getStorageNameAndSize());
        oDiskRow.setColumnData(TABLE_SELECT_FILE_PATH, oDiskNameCell);
        TreeTableNode oDiskNode = new TreeTableNode(oDiskRow);
        oDiskNameCell.setAttachedTreeNode(oDiskNode);
        return oDiskNode;
    }

    private void addNode(TreeTableNode oDiskNode, TreeTableNode oFileNode) {
        if (null == oDiskNode || null == oFileNode) {
            return;
        }
        Object oDestObj = oFileNode.getUserObject();
        boolean bNodeExist = false;
        if (oDestObj instanceof TreeTableRowData) {
            DeviceFileInfo oDestFileInfo = (DeviceFileInfo)((TreeTableRowData)oDestObj).getUserObject();
            Enumeration<TreeNode> oChildEnum = oDiskNode.breadthFirstEnumeration();
            while (oChildEnum.hasMoreElements()) {
                DeviceFileInfo oFoundInfo;
                TreeTableRowData oRowData;
                TreeTableNode oNode = (TreeTableNode)oChildEnum.nextElement();
                Object obj = oNode.getUserObject();
                if (!(obj instanceof TreeTableRowData) || !((oRowData = (TreeTableRowData)obj).getUserObject() instanceof DeviceFileInfo) || !(oFoundInfo = (DeviceFileInfo)oRowData.getUserObject()).getFileName().equals(oDestFileInfo.getFileName())) continue;
                bNodeExist = true;
                int iChildCount = oFileNode.getChildCount();
                for (int i = 0; i < iChildCount; ++i) {
                    TreeTableNode oCNode = (TreeTableNode)oFileNode.getChildAt(i);
                    this.addNode(oNode, oCNode);
                }
            }
        }
        if (!bNodeExist) {
            oDiskNode.add(oFileNode);
        }
    }

    @Override
    public TreeTableNode createFileNodeInTable(DeviceFileInfo oDeviceFileInfo) {
        TreeTableNode oFileNode = null;
        String sFileName = oDeviceFileInfo.getFileName();
        if (sFileName.indexOf("/") >= 0) {
            String sPreFile = sFileName.substring(0, sFileName.indexOf("/"));
            String sPostFile = sFileName.substring(sFileName.indexOf("/") + 1);
            DeviceFileInfo oDevFileInfo = new DeviceFileInfo();
            oDevFileInfo.setFile(false);
            oDevFileInfo.setFileName(sPreFile);
            oDevFileInfo.setFileSize(oDeviceFileInfo.getFileSize());
            oFileNode = this.createFileNodeInTable(oDevFileInfo);
            DeviceFileInfo oChildDevFileInfo = new DeviceFileInfo();
            oChildDevFileInfo.setFileName(sPostFile);
            oChildDevFileInfo.setFileSize(oDeviceFileInfo.getFileSize());
            TreeTableNode oSonNode = this.createFileNodeInTable(oChildDevFileInfo);
            oFileNode.add(oSonNode);
        } else {
            if (!oDeviceFileInfo.isFile()) {
                oDeviceFileInfo.setFileSize(0);
            }
            TreeTableRowData oFileRow = new TreeTableRowData(TABLE_COLMUN_SIZE);
            oFileRow.setUserObject(oDeviceFileInfo);
            TreeTableNodeCellData oFileNameCell = new TreeTableNodeCellData(oDeviceFileInfo.getFileName());
            int iFileSize = oDeviceFileInfo.getFileSize();
            Locale oLocal = ResourceMng.getInstance().getLocale();
            NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
            String strFileSize = oNumberFormat.format(iFileSize);
            if (!oDeviceFileInfo.isFile()) {
                strFileSize = "";
            }
            TreeTableCellData oFileSizeCell1 = new TreeTableCellData(strFileSize);
            oFileRow.setColumnData(0, oFileNameCell);
            oFileRow.setColumnData(1, oFileSizeCell1);
            oFileNode = new TreeTableNode(oFileRow);
            oFileNameCell.setAttachedTreeNode(oFileNode);
        }
        return oFileNode;
    }

    @Override
    public TreeTableNode createDiskNode(TreeTableNode oDiskNode) {
        TreeTableRowData oTempDiskRow = (TreeTableRowData)oDiskNode.getUserObject();
        DeviceDiskInfo oTempDiskInfo = (DeviceDiskInfo)oTempDiskRow.getUserObject();
        DeviceDiskInfo m_oDiskInfo = new DeviceDiskInfo();
        m_oDiskInfo.setIStoragekFreeSpaceSize(oTempDiskInfo.getIStoragekFreeSpaceSize());
        m_oDiskInfo.setIStorageSpaceSize(oTempDiskInfo.getIStorageSpaceSize());
        m_oDiskInfo.setStrStorageName(oTempDiskInfo.getStrStorageName());
        m_oDiskInfo.setOFileOnDevList(oTempDiskInfo.getOFileOnDevList());
        TreeTableRowData oDiskRow = new TreeTableRowData(TABLE_COLMUN_SIZE);
        oDiskRow.setUserObject(m_oDiskInfo);
        TreeTableNodeCellData oDiskNameCell = new TreeTableNodeCellData(m_oDiskInfo.getStorageNameAndSize());
        oDiskRow.setColumnData(TABLE_SELECT_FILE_PATH, oDiskNameCell);
        TreeTableNode m_oDiskNode = new TreeTableNode(oDiskRow);
        oDiskNameCell.setAttachedTreeNode(m_oDiskNode);
        return m_oDiskNode;
    }

    @Override
    public TreeTableNode createFileNode(TreeTableNode oFileNode) {
        TreeTableNode m_oFileNode = this.transeformNode(oFileNode);
        TreeTableNode oParent = (TreeTableNode)oFileNode.getParent();
        TreeTableRowData pRowData = (TreeTableRowData)oParent.getUserObject();
        TreeTableNode oRtnNode = null;
        TreeTableNode oPNode = null;
        while (!(pRowData.getUserObject() instanceof DeviceDiskInfo)) {
            oPNode = this.transeformNode(oParent);
            if (null == oRtnNode) {
                oRtnNode = oPNode;
                oRtnNode.add(m_oFileNode);
            } else {
                oPNode.add(oRtnNode);
            }
            oParent = (TreeTableNode)oParent.getParent();
            pRowData = (TreeTableRowData)oParent.getUserObject();
        }
        oRtnNode = oPNode;
        int iChildCount = oFileNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode oTmpNode = (TreeTableNode)oFileNode.getChildAt(i);
            TreeTableNode oCNode = this.createSFileNode(oTmpNode);
            m_oFileNode.add(oCNode);
        }
        if (null != oRtnNode) {
            return oRtnNode;
        }
        return m_oFileNode;
    }

    public TreeTableNode transeformNode(TreeTableNode oFileNode) {
        TreeTableRowData oTempFileRow = (TreeTableRowData)oFileNode.getUserObject();
        DeviceFileInfo oTempFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
        DeviceFileInfo oFileInfo = new DeviceFileInfo();
        oFileInfo.setFileName(oTempFileInfo.getFileName());
        oFileInfo.setFileSize(oTempFileInfo.getFileSize());
        oFileInfo.setStareupFiles(oTempFileInfo.isStartupFiles());
        oFileInfo.setFile(oTempFileInfo.isFile());
        TreeTableRowData oFileRow = new TreeTableRowData(TABLE_COLMUN_SIZE);
        oFileRow.setUserObject(oFileInfo);
        TreeTableNodeCellData oFileNameCell = new TreeTableNodeCellData(oFileInfo.getFileName());
        int iFileSize = oFileInfo.getFileSize();
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        String strFileSize = oNumberFormat.format(iFileSize);
        if (!oFileInfo.isFile()) {
            strFileSize = "";
        }
        TreeTableCellData oFileSizeCell = new TreeTableCellData(strFileSize);
        oFileRow.setColumnData(TABLE_SELECT_FILE_PATH, oFileNameCell);
        oFileRow.setColumnData(TABLE_SELECT_FILE_SIZE, oFileSizeCell);
        TreeTableNode m_oFileNode = new TreeTableNode(oFileRow);
        oFileNameCell.setAttachedTreeNode(m_oFileNode);
        return m_oFileNode;
    }

    public TreeTableNode createSFileNode(TreeTableNode oFileNode) {
        TreeTableNode m_oFileNode = this.transeformNode(oFileNode);
        int iChildCount = oFileNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode oTmpNode = (TreeTableNode)oFileNode.getChildAt(i);
            TreeTableNode oCNode = this.createSFileNode(oTmpNode);
            m_oFileNode.add(oCNode);
        }
        return m_oFileNode;
    }

    @Override
    protected void handleSelectButtonState() {
        int[] selectRows = super.getOperationTable().getSelectedRows();
        int selectRowCount = selectRows.length;
        if (this.m_oDeleDevFileDlg == null || this.m_oDeleDevFileDlg.getSelectButton() == null) {
            return;
        }
        if (selectRowCount > 0) {
            this.m_oDeleDevFileDlg.getSelectButton().setEnabled(true);
        } else {
            this.m_oDeleDevFileDlg.getSelectButton().setEnabled(false);
        }
    }
}

