/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFilePanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileProgressDlg;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteFilePanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceDiskInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeleteDeviceFileDialog
extends DCModalDialog {
    private static final long serialVersionUID = 2349779452445413364L;
    private Resource m_oResource = null;
    private JLabel m_oResNameLabel = null;
    private JLabel m_oResIPLabel = null;
    private JLabel m_oResVersionLabel = null;
    private JTextField m_oResNameTextField = null;
    private JTextField m_oResIPTextField = null;
    private JTextField m_oResVersionTextField = null;
    private DeviceMemoryInfo m_oDeviceMemoryInfo = null;
    private DeleteDeviceFilePanel m_oDeleteDeviceFilePanel;
    private DeleteFilePanel m_oDeleteFilePanel;
    private JButton m_oSelectButton = null;
    private JButton m_oUnselectButton = null;
    private JButton m_oApplyButton = null;
    private Vector<Object> m_oRowVector = null;
    private TitledBorder oStartupCofigPanelTitledBorder = null;
    private int iSelectFileSizes = 0;
    private boolean m_isDeleteFile = false;

    public DeleteDeviceFileDialog(Resource oResource, DeviceMemoryInfo oDevMemoryInfo) {
        this.m_oResource = oResource;
        this.m_oDeviceMemoryInfo = oDevMemoryInfo;
        this.jbinit();
    }

    private void jbinit() {
        this.initDialog();
        this.initLabels();
        this.initTextFields();
        this.initButtons();
        this.initDeleteDeviceFilePanel();
        this.initSelectButtons();
        this.initDeleteFilePanel();
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        this.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_DEVICE_FILES"));
        this.setSize(860, 550);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initLabels() {
        this.m_oResNameLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_DEVICE_NAME_RAD_BTN") + " :");
        this.m_oResNameLabel.setMinimumSize(new Dimension(90, 20));
        this.m_oResNameLabel.setPreferredSize(new Dimension(90, 20));
        this.add(this.m_oResNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.m_oResIPLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("STANDALONE_DEVICE_IP_LABEL"));
        this.m_oResIPLabel.setMinimumSize(new Dimension(120, 20));
        this.m_oResIPLabel.setPreferredSize(new Dimension(120, 20));
        this.add(this.m_oResIPLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 54, 0, 0), 0, 0));
        this.m_oResVersionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_RESOURCE_VERSION") + " :");
        this.m_oResVersionLabel.setMinimumSize(new Dimension(80, 20));
        this.m_oResVersionLabel.setPreferredSize(new Dimension(80, 20));
        this.add(this.m_oResVersionLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 54, 0, 0), 0, 0));
    }

    private void initTextFields() {
        this.m_oResNameTextField = new JTextField(this.m_oResource.getDeviceName());
        this.m_oResNameTextField.setMinimumSize(new Dimension(150, 20));
        this.m_oResNameTextField.setPreferredSize(new Dimension(150, 20));
        this.add(this.m_oResNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 12, 0, 0), 0, 0));
        this.m_oResNameTextField.setEnabled(false);
        this.m_oResNameTextField.setToolTipText(this.m_oResNameTextField.getText());
        this.m_oResIPTextField = new JTextField(this.m_oResource.getDeviceIP());
        this.m_oResIPTextField.setMinimumSize(new Dimension(150, 20));
        this.m_oResIPTextField.setPreferredSize(new Dimension(150, 20));
        this.add(this.m_oResIPTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 12, 0, 0), 0, 0));
        this.m_oResIPTextField.setEnabled(false);
        this.m_oResIPTextField.setToolTipText(this.m_oResIPTextField.getText());
        this.m_oResVersionTextField = new JTextField(this.m_oResource.getDeviceVersion());
        this.m_oResVersionTextField.setMinimumSize(new Dimension(150, 20));
        this.m_oResVersionTextField.setPreferredSize(new Dimension(150, 20));
        this.add(this.m_oResVersionTextField, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 12, 0, 10), 0, 0));
        this.m_oResVersionTextField.setEnabled(false);
        this.m_oResVersionTextField.setToolTipText(this.m_oResVersionTextField.getText());
    }

    private void initButtons() {
        this.m_oOKBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oOKBtn");
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setName("TaskMgmt_StartupConfigSubOprDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CLOSE_BUTTON"));
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oApplyButton = new JButton();
        this.m_oApplyButton.setName("TaskMgmt_StartupConfigSubOprDialog_m_oApplyBtn");
        this.m_oApplyButton.setText(DCFrameWorkUtil.getLocalizedString("DELETEBUTTON"));
        this.m_oApplyButton.setPreferredSize(new Dimension(80, 20));
        this.m_oApplyButton.setMinimumSize(new Dimension(80, 20));
        this.m_oApplyButton.setMnemonic('D');
        this.m_oApplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteDeviceFileDialog.this.oApplyButton_ActionPerformed();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.add(this.m_oApplyButton);
        btnPanel.add(Box.createHorizontalStrut(5));
        btnPanel.add(this.m_oCancelBtn);
        this.getContentPane().add((Component)btnPanel, new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
    }

    protected void oApplyButton_ActionPerformed() {
        if (this.actionPerformed()) {
            this.refleshBtnActionPerformed();
        }
        this.m_oDeleteFilePanel.refreshTable();
    }

    private void deleteMemoryInfo(String fileName) {
        List<DeviceDiskInfo> oDeviceDiskInfoList = this.m_oDeviceMemoryInfo.getDeviceDiskInfoList();
        DeviceDiskInfo oDeviceDiskInfo = null;
        List<DeviceFileInfo> oDeviceFileList = null;
        DeviceFileInfo oDeviceFileInfo = null;
        int iSize = oDeviceDiskInfoList.size();
        for (int i = 0; i < iSize; ++i) {
            oDeviceDiskInfo = oDeviceDiskInfoList.get(i);
            String strDiskName = oDeviceDiskInfo.getStrStorageName();
            oDeviceFileList = oDeviceDiskInfo.getOFileOnDevList();
            int iCount = oDeviceFileList.size();
            for (int j = 0; j < iCount; ++j) {
                oDeviceFileInfo = oDeviceFileList.get(j);
                String strTmpFileName = strDiskName + oDeviceFileInfo.getFileName();
                if (!strTmpFileName.equals(fileName)) continue;
                oDeviceFileList.remove(oDeviceFileInfo);
                this.m_isDeleteFile = true;
                return;
            }
        }
    }

    public void delAllFile() {
        int iDiskCount = this.m_oDeleteFilePanel.getRootNode().getChildCount();
        for (int i = iDiskCount - 1; i >= 0; --i) {
            TreeTableNode oDiskNode = (TreeTableNode)this.m_oDeleteFilePanel.getRootNode().getChildAt(i);
            int iFileCount = oDiskNode.getChildCount();
            for (int j = iFileCount - 1; j >= 0; --j) {
                TreeTableNode oFileNode = (TreeTableNode)oDiskNode.getChildAt(j);
                oFileNode.removeFromParent();
                if (oDiskNode.getChildCount() != 0) continue;
                oDiskNode.removeFromParent();
            }
        }
        this.m_oDeleteFilePanel.refreshTable();
    }

    public void addoRowVector(Vector oRowVector) {
        this.m_oRowVector.add(oRowVector);
    }

    private void initDeleteDeviceFilePanel() {
        this.m_oDeleteDeviceFilePanel = new DeleteDeviceFilePanel(this.m_oDeviceMemoryInfo, this);
        TitledBorder oStartupCofigPanelTitledBorder = new TitledBorder(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TO_DELETE"));
        this.m_oDeleteDeviceFilePanel.setBorder(oStartupCofigPanelTitledBorder);
        this.m_oDeleteDeviceFilePanel.setSize(new Dimension(465, 370));
        this.m_oDeleteDeviceFilePanel.setMinimumSize(new Dimension(455, 425));
        this.add(this.m_oDeleteDeviceFilePanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
    }

    private void initSelectButtons() {
        this.m_oSelectButton = new JButton();
        this.m_oSelectButton.setPreferredSize(new Dimension(50, 21));
        this.m_oSelectButton.setMinimumSize(new Dimension(50, 21));
        this.m_oSelectButton.setName("DeviceOperation_FileSelectionPanel_oSelectBtn");
        this.m_oSelectButton.setText(">");
        this.m_oSelectButton.setToolTipText(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_SINGLE_BTN_TOOL_TIP"));
        this.m_oSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteDeviceFileDialog.this.selectBtnActionPerformed();
            }
        });
        this.m_oUnselectButton = new JButton();
        this.m_oUnselectButton.setPreferredSize(new Dimension(50, 21));
        this.m_oUnselectButton.setMinimumSize(new Dimension(50, 21));
        this.m_oUnselectButton.setName("DeviceOperation_FileSelectionPanel_oUNSelectBtn");
        this.m_oUnselectButton.setText("<");
        this.m_oUnselectButton.setToolTipText(ResourceManager.getInstance().getResString("PROGRAM_SELECTION_SINGLE_BTN_TOOL_TIP"));
        this.m_oUnselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteDeviceFileDialog.this.deleteBtnActionPerformed();
            }
        });
        this.m_oUnselectButton.setEnabled(false);
        this.add(this.m_oSelectButton, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(160, 465, 10, 10), 0, 0));
        this.add(this.m_oUnselectButton, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(210, 465, 10, 10), 0, 0));
    }

    public JButton getSelectButton() {
        return this.m_oSelectButton;
    }

    public JButton getUnselectButton() {
        return this.m_oUnselectButton;
    }

    private void initDeleteFilePanel() {
        this.m_oDeleteFilePanel = new DeleteFilePanel(this);
        this.oStartupCofigPanelTitledBorder = new TitledBorder(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TO_DELETE_STATUS") + ": " + this.iSelectFileSizes + DCFrameWorkUtil.getLocalizedString("FILE_SIZE_TYPE"));
        this.m_oDeleteFilePanel.setBorder(this.oStartupCofigPanelTitledBorder);
        this.m_oDeleteFilePanel.setSize(new Dimension(350, 370));
        this.m_oDeleteFilePanel.setMinimumSize(new Dimension(329, 425));
        this.add(this.m_oDeleteFilePanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 18, 0, new Insets(10, 515, 0, 0), 0, 0));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void selectBtnActionPerformed() {
        JTree m_oTaskTree = this.m_oDeleteDeviceFilePanel.getTaskTree();
        DCSortableTreeTable ODCSortableTreeTable = this.m_oDeleteDeviceFilePanel.getJTable();
        int[] iSelectedRows = ODCSortableTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        if (iSelectedNodeCount == 0) {
            return;
        }
        try {
            for (int i = 0; i < iSelectedNodeCount; ++i) {
                int iMoveFileSize;
                TreeTableNode treeNode = (TreeTableNode)m_oTaskTree.getPathForRow(iSelectedRows[i]).getLastPathComponent();
                TreeTableRowData oTreeTableRowData = (TreeTableRowData)treeNode.getUserObject();
                Object o = oTreeTableRowData.getUserObject();
                if (o instanceof DeviceFileInfo) {
                    iMoveFileSize = this.m_oDeleteFilePanel.insertFileNode(treeNode, false);
                    this.iSelectFileSizes += iMoveFileSize;
                    TreeNode[] treeNodes = treeNode.getPath();
                    TreeTableNode oParentNode = (TreeTableNode)treeNodes[1];
                    TreeTableRowData oParentRowData = (TreeTableRowData)oParentNode.getUserObject();
                    Object oParntObj = oParentRowData.getUserObject();
                    if (oParntObj instanceof DeviceDiskInfo) {
                        DeviceDiskInfo oParentDiskInfo = (DeviceDiskInfo)oParntObj;
                        oParentDiskInfo.setIStoragekFreeSpaceSize(oParentDiskInfo.getIStoragekFreeSpaceSize() + (long)iMoveFileSize);
                        oParentRowData.setColumnData(0, new TreeTableCellData(oParentDiskInfo.getStorageNameAndSize()));
                    }
                    TreeTableNode oParentTreeNode = (TreeTableNode)treeNode.getParent();
                    treeNode.removeFromParent();
                    this.removeEmptyFileOrNode(oParentTreeNode);
                    continue;
                }
                iMoveFileSize = this.m_oDeleteFilePanel.insertDiskNode(treeNode, false);
                this.iSelectFileSizes += iMoveFileSize;
                TreeTableRowData oParentRowData = (TreeTableRowData)treeNode.getUserObject();
                Object oParntObj = oParentRowData.getUserObject();
                if (oParntObj instanceof DeviceDiskInfo) {
                    DeviceDiskInfo oParentDiskInfo = (DeviceDiskInfo)oParntObj;
                    oParentDiskInfo.setIStoragekFreeSpaceSize(oParentDiskInfo.getIStoragekFreeSpaceSize() + (long)iMoveFileSize);
                    oParentRowData.setColumnData(0, new TreeTableCellData(oParentDiskInfo.getStorageNameAndSize()));
                }
                treeNode.removeAllChildren();
                treeNode.removeFromParent();
            }
            if (this.m_oDeleteFilePanel.getRootNode() != null) {
                this.m_oUnselectButton.setEnabled(true);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        String sSize = oNumberFormat.format(this.iSelectFileSizes);
        this.oStartupCofigPanelTitledBorder.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TO_DELETE_STATUS") + ": " + sSize + DCFrameWorkUtil.getLocalizedString("FILE_SIZE_TYPE"));
        this.m_oDeleteFilePanel.updateUI();
        this.m_oDeleteDeviceFilePanel.getOperationTable().clearSelection();
        this.m_oDeleteDeviceFilePanel.refreshTable();
        this.m_oDeleteFilePanel.refreshTable();
    }

    private void removeEmptyFileOrNode(TreeTableNode treeNode) {
        if (null != treeNode && treeNode.getChildCount() < 1) {
            TreeTableNode oPNode = (TreeTableNode)treeNode.getParent();
            treeNode.removeFromParent();
            this.removeEmptyFileOrNode(oPNode);
        }
    }

    private void deleteBtnActionPerformed() {
        JTree m_oTaskTree = this.m_oDeleteFilePanel.getTaskTree();
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        DCSortableTreeTable ODCSortableTreeTable = this.m_oDeleteFilePanel.getJTable();
        int[] iSelectedRows = ODCSortableTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        if (iSelectedNodeCount == 0) {
            return;
        }
        try {
            for (int i = 0; i < iSelectedNodeCount; ++i) {
                TreeTableNode treeNode = (TreeTableNode)m_oTaskTree.getPathForRow(iSelectedRows[i]).getLastPathComponent();
                TreeTableRowData oTreeTableRowData = (TreeTableRowData)treeNode.getUserObject();
                Object o = oTreeTableRowData.getUserObject();
                if (o instanceof DeviceFileInfo) {
                    TreeTableNode oDiskNode = (TreeTableNode)treeNode.getParent();
                    this.iSelectFileSizes -= this.m_oDeleteDeviceFilePanel.insertFileNode(treeNode, true);
                    treeNode.removeFromParent();
                    this.removeEmptyFileOrNode(oDiskNode);
                    continue;
                }
                this.iSelectFileSizes -= this.m_oDeleteDeviceFilePanel.insertDiskNode(treeNode, true);
                treeNode.removeFromParent();
                treeNode.removeAllChildren();
            }
            List<String> oSelectedFileList = this.m_oDeleteFilePanel.getSelectedFileList();
            if (null == oSelectedFileList || 0 == oSelectedFileList.size()) {
                this.iSelectFileSizes = 0;
                this.m_oUnselectButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            this.m_oUnselectButton.setEnabled(false);
        }
        this.oStartupCofigPanelTitledBorder.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TO_DELETE_STATUS") + ": " + oNumberFormat.format(this.iSelectFileSizes) + DCFrameWorkUtil.getLocalizedString("FILE_SIZE_TYPE"));
        this.m_oDeleteFilePanel.updateUI();
        this.m_oDeleteDeviceFilePanel.refreshTable();
        this.m_oDeleteFilePanel.getOperationTable().clearSelection();
        this.m_oDeleteFilePanel.refreshTable();
    }

    protected boolean actionPerformed() {
        List<String> oSelectedFileList = this.m_oDeleteFilePanel.getSelectedFileList();
        if (null == oSelectedFileList || 0 == oSelectedFileList.size()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("NO_FILE_SELECTED_TO_DELETE"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return false;
        }
        int iConfirm = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("DELETE_FILES_FROM_DEVICE_CONFIRM"), DCFrameWorkUtil.getLocalizedString("WARNING"), 0, 2);
        if (iConfirm != 0) {
            return false;
        }
        this.m_oRowVector = new Vector(2);
        DeleteDeviceFileProgressDlg oProgressDlg = new DeleteDeviceFileProgressDlg(44031, this, oSelectedFileList.size());
        oProgressDlg.resetCounter();
        oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("SAM_DELETE_PROGRESS_DIALOG_TITLE"));
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oProgressDlg.setProgressDlgId(iReqId);
        try {
            TaskSyncCommController.getInstance().deleteFilesFromDevice(iReqId, this.m_oResource, oSelectedFileList);
        }
        catch (DCException e) {
            oProgressDlg.dispose();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return false;
        }
        oProgressDlg.showDetailInfo();
        oProgressDlg.setVisible(true);
        return true;
    }

    public void refleshBtnActionPerformed() {
        JTree m_oTaskTree = this.m_oDeleteFilePanel.getTaskTree();
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        List<String> oSelectedFileList = this.m_oDeleteFilePanel.getSelectedFileList();
        int iSelectedNodeCount = oSelectedFileList.size();
        if (iSelectedNodeCount == 0) {
            return;
        }
        ArrayList<String> successRow = new ArrayList<String>();
        int iResoutCount = this.m_oRowVector.size();
        for (int j = 0; j < iResoutCount; ++j) {
            Vector oVector = (Vector)this.m_oRowVector.get(j);
            String fileName = (String)oVector.get(0);
            ErrorInfo oErrorInfo = (ErrorInfo)oVector.get(2);
            if (0 != oErrorInfo.getErrorCode()) continue;
            successRow.add(fileName);
            this.deleteMemoryInfo(fileName);
        }
        int tempRow = 1;
        if (successRow.size() == 0) {
            DCDebugTracer.trace("DeleteDeviceFileDialog#refleshBtnActionPerformed,successRow.size() == 0,return");
            return;
        }
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            if (successRow.size() == 0) {
                DCDebugTracer.trace("DeleteDeviceFileDialog#refleshBtnActionPerformed,successRow.size() == 0,return");
                break;
            }
            TreePath treePath = m_oTaskTree.getPathForRow(tempRow);
            TreeTableNode treeNode = (TreeTableNode)treePath.getLastPathComponent();
            boolean flag = true;
            while (flag) {
                if (treeNode.isLeaf()) {
                    flag = false;
                    continue;
                }
                treePath = m_oTaskTree.getPathForRow(++tempRow);
                treeNode = (TreeTableNode)treePath.getLastPathComponent();
            }
            TreeTableRowData oTreeTableRowData = (TreeTableRowData)treeNode.getUserObject();
            Object o = oTreeTableRowData.getUserObject();
            if (o instanceof DeviceFileInfo) {
                TreeTableNode oDiskNode = (TreeTableNode)treeNode.getParent();
                DeviceFileInfo oTempFileInfo = (DeviceFileInfo)o;
                for (int k = successRow.size() - 1; k >= 0; --k) {
                    DCDebugTracer.trace("check:" + treeNode);
                    if (!this.matchLeafNode(treeNode, (String)successRow.get(k))) continue;
                    treeNode.removeFromParent();
                    this.iSelectFileSizes -= oTempFileInfo.getFileSize();
                    DCDebugTracer.trace("remove:" + treeNode);
                    successRow.remove(k);
                    break;
                }
                if (oDiskNode.getChildCount() == 0) {
                    oDiskNode.removeFromParent();
                }
            } else {
                this.iSelectFileSizes -= this.m_oDeleteDeviceFilePanel.insertDiskNode(treeNode, true);
                treeNode.removeFromParent();
            }
            ++tempRow;
        }
        this.iSelectFileSizes = this.iSelectFileSizes < 0 ? 0 : this.iSelectFileSizes;
        this.oStartupCofigPanelTitledBorder.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_FILES_TO_DELETE_STATUS") + ": " + oNumberFormat.format(this.iSelectFileSizes) + DCFrameWorkUtil.getLocalizedString("FILE_SIZE_TYPE"));
        this.m_oDeleteFilePanel.updateUI();
        this.m_oDeleteDeviceFilePanel.refreshTable();
        this.m_oDeleteFilePanel.refreshTable();
    }

    private boolean matchLeafNode(TreeTableNode treeNode, String sFileName) {
        boolean bMatch = false;
        if (StringUtils.isNullOrEmptyStr(sFileName) || null == treeNode) {
            return bMatch;
        }
        String[] fileNames = sFileName.split("[/]");
        int iPathLevel = fileNames.length;
        String sTmpFileName = "";
        TreeTableNode oTmpTreeNode = treeNode;
        for (int i = iPathLevel - 1; i >= 0; --i) {
            sTmpFileName = fileNames[i];
            if (sTmpFileName.endsWith("/")) {
                sTmpFileName = sTmpFileName.substring(0, sTmpFileName.length() - 1);
            }
            if (null == oTmpTreeNode) {
                return bMatch;
            }
            TreeTableRowData oTreeTableRowData = (TreeTableRowData)oTmpTreeNode.getUserObject();
            Object o = oTreeTableRowData.getUserObject();
            if (o instanceof DeviceFileInfo) {
                DeviceFileInfo oTempFileInfo = (DeviceFileInfo)o;
                if (!Collator.getInstance().equals(oTempFileInfo.getFileName(), sTmpFileName)) {
                    return bMatch;
                }
            } else if (o instanceof DeviceDiskInfo) {
                DeviceDiskInfo oDiskInfo = (DeviceDiskInfo)o;
                String sDiskName = oDiskInfo.getStrStorageName();
                if (sDiskName.endsWith("/")) {
                    sDiskName = sDiskName.substring(0, sDiskName.length() - 1);
                }
                if (!sDiskName.equals(sTmpFileName)) {
                    return bMatch;
                }
            }
            oTmpTreeNode = (TreeTableNode)oTmpTreeNode.getParent();
        }
        return true;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (this.actionPerformed()) {
            this.refleshBtnActionPerformed();
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_DELETE_NE_FILE";
    }

    public boolean isDeleteFile() {
        return this.m_isDeleteFile;
    }
}

