/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCheckDevMemoryInfo;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryReq;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryResultList;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryRsp;
import com.huawei.dc.common.asndatacenter.AsnDirectory;
import com.huawei.dc.common.asndatacenter.AsnDirectoryList;
import com.huawei.dc.common.asndatacenter.AsnFileOnDevInfo;
import com.huawei.dc.common.asndatacenter.AsnFileOnDevList;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceDiskInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CheckDeviceMemoryUtil
implements ITaskNotificationListener {
    private SimpleProgressDlg m_oValidationProgressDlg = null;
    private boolean m_bCancelPressed = false;
    private Object m_oSyncObj = new Object();
    private AsnDCCheckDevMemoryRsp m_oAsnDCCheckDevMemoryRsp = null;
    private HashMap<Integer, DeviceMemoryInfo> m_oDeviceMemoryInfoMap;
    private HashMap<Integer, List<String>> m_oFileInfoMap = null;
    private FileSelectionDialog m_oModalParent = null;
    private Object m_oSyncObject = new Object();

    public CheckDeviceMemoryUtil(HashMap<Integer, List<String>> oFileInfoMap) {
        this.m_oFileInfoMap = oFileInfoMap;
        this.m_oDeviceMemoryInfoMap = new HashMap();
    }

    public void setM_oModalParent(FileSelectionDialog modalParent) {
        this.m_oModalParent = modalParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, DeviceMemoryInfo> checkDeviceMemory() {
        ValidationResult oValidResult;
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.setCancelPressed(false);
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("CHECK_DEVICE_MEMORY_TITLE"), true, ResourceManager.getInstance().getResString("GETTING_CHECK_DEVICE_MEMORY_TITLE")){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelButtonActionPerformed() {
                CheckDeviceMemoryUtil.this.setCancelPressed(true);
                Object object = CheckDeviceMemoryUtil.this.m_oSyncObj;
                synchronized (object) {
                    CheckDeviceMemoryUtil.this.m_oSyncObj.notifyAll();
                }
            }
        };
        CheckDeviceMemory oCheckDeviceMemory = new CheckDeviceMemory();
        oCheckDeviceMemory.start();
        this.m_oValidationProgressDlg.setVisible(true);
        Object object = this.m_oSyncObject;
        synchronized (object) {
            DCDebugTracer.trace(this.m_oSyncObject + "\t is synchronized Object.");
        }
        if (!this.m_bCancelPressed && 0 != (oValidResult = oCheckDeviceMemory.getValidateResult()).getErrorCode()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oValidResult.getErrorMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
        return this.m_oDeviceMemoryInfoMap;
    }

    public boolean isCancelPressed() {
        return this.m_bCancelPressed;
    }

    public void setCancelPressed(boolean cancelPressed) {
        this.m_bCancelPressed = cancelPressed;
    }

    private ValidationResult getDeviceMemory() {
        ValidationResult oValidationResult = new ValidationResult();
        try {
            this.getMemoryStatusFromServer();
            oValidationResult.setErrorCode(0);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(e.getMessage());
            oValidationResult.setErrorType(0);
        }
        return oValidationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMemoryStatusFromServer() throws DCException {
        Object object = this.m_oSyncObj;
        synchronized (object) {
            AsnDCCheckDevMemoryReq oAsnDCCheckDevMemoryReq = TaskCommUtil.getAsnDCCheckDevMemoryReq(this.m_oFileInfoMap);
            TaskSyncCommController.getInstance().getMemoryInfoFromDevice(oAsnDCCheckDevMemoryReq);
            try {
                this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                this.m_oAsnDCCheckDevMemoryRsp = null;
            }
        }
        if (null == this.m_oAsnDCCheckDevMemoryRsp || null == this.m_oAsnDCCheckDevMemoryRsp.oCheckResultlst) {
            throw new DCException(DCFrameWorkUtil.getLocalizedString("CHECK_DEVICE_MEMORY_REQUEST_FAIL"));
        }
        int iErrorCode = this.m_oAsnDCCheckDevMemoryRsp.oErrorNo.iErrorNo.intValue();
        if (null == this.m_oAsnDCCheckDevMemoryRsp || 0 != iErrorCode && 999293081 != iErrorCode) {
            String strMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            DCDebugTracer.trace("m_oAsnDCCheckDevMemoryRsp.oErrorInfo.iErrorNo:" + iErrorCode + " " + strMsg);
            throw new DCException(iErrorCode, strMsg);
        }
        this.fillDataModelFromAsn();
        if (this.m_bCancelPressed && null != this.m_oDeviceMemoryInfoMap) {
            this.m_oDeviceMemoryInfoMap.clear();
        }
    }

    private void fillDataModelFromAsn() {
        this.m_oDeviceMemoryInfoMap = new HashMap(0);
        AsnDCCheckDevMemoryResultList oAsnDCCheckDevMemoryResultList = this.m_oAsnDCCheckDevMemoryRsp.oCheckResultlst;
        if (null == oAsnDCCheckDevMemoryResultList) {
            return;
        }
        AsnCheckDevMemoryInfo oAsnCheckDevMemoryInfo = null;
        DeviceMemoryInfo oDeviceMemoryInfo = null;
        int iSize = oAsnDCCheckDevMemoryResultList.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnCheckDevMemoryInfo = (AsnCheckDevMemoryInfo)oAsnDCCheckDevMemoryResultList.get(i);
            int iDevID = oAsnCheckDevMemoryInfo.iDeviceID.intValue();
            oDeviceMemoryInfo = this.getDeviceMemoryInfo(oAsnCheckDevMemoryInfo);
            if (oDeviceMemoryInfo.getErrorCode() != 0) {
                String strResource = null;
                String strReason = null;
                Resource oRes = null;
                Vector<Object> oRowData = null;
                this.m_oValidationProgressDlg.dispose();
                String strTitle = DCFrameWorkUtil.getLocalizedString("ERROR");
                String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("FAILURE_REASON"), DCFrameWorkUtil.getLocalizedString("ERROR_INFO")};
                oRowData = new Vector<Object>(3);
                strReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oDeviceMemoryInfo.getErrorCode()));
                oRes = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
                strResource = null != oRes ? oRes.getDeviceName() + '(' + oRes.getDeviceIP() + ')' : String.valueOf(iDevID);
                oRowData.add(strResource);
                oRowData.add(strReason);
                oRowData.add(oDeviceMemoryInfo.getErrorInfo());
                final TaskOperationResultDialog oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
                oOpResultDlg.setMessage(DCFrameWorkUtil.getLocalizedString("OPERATIONFAILED"));
                oOpResultDlg.customizeTableForTelnetError();
                oOpResultDlg.addRowInModel(oRowData);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        oOpResultDlg.setVisible(true);
                    }
                });
                break;
            }
            this.m_oDeviceMemoryInfoMap.put(iDevID, oDeviceMemoryInfo);
        }
    }

    private DeviceMemoryInfo getDeviceMemoryInfo(AsnCheckDevMemoryInfo oAsnCheckDevMemoryInfo) {
        DeviceMemoryInfo oDeviceMemoryInfo = null;
        AsnDirectoryList oDirList = oAsnCheckDevMemoryInfo.oDirList;
        DeviceDiskInfo oDeviceDiskInfo = null;
        ArrayList<DeviceDiskInfo> oDeviceDiskInfoList = null;
        AsnDirectory oAsnDirectory = null;
        oDeviceMemoryInfo = new DeviceMemoryInfo();
        oDeviceMemoryInfo.setDeviceMemoryCheckResult(oAsnCheckDevMemoryInfo.enCheckResult.value);
        if (null != oAsnCheckDevMemoryInfo.oErrorNo) {
            oDeviceMemoryInfo.setErrorCode(oAsnCheckDevMemoryInfo.oErrorNo.iErrorNo.intValue());
            oDeviceMemoryInfo.setErrorInfo(oAsnCheckDevMemoryInfo.oErrorNo);
        }
        oDeviceDiskInfoList = new ArrayList<DeviceDiskInfo>(0);
        int iSize = oDirList.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnDirectory = (AsnDirectory)oDirList.get(i);
            oDeviceDiskInfo = this.getDeviceDiskInfo(oAsnDirectory);
            oDeviceDiskInfoList.add(oDeviceDiskInfo);
        }
        oDeviceMemoryInfo.setDeviceDiskInfoList(oDeviceDiskInfoList);
        return oDeviceMemoryInfo;
    }

    private DeviceDiskInfo getDeviceDiskInfo(AsnDirectory oAsnDirectory) {
        DeviceDiskInfo oDeviceDiskInfo = new DeviceDiskInfo();
        oDeviceDiskInfo.setStrStorageName(new String(oAsnDirectory.strDirectoryName));
        oDeviceDiskInfo.setIStorageSpaceSize(oAsnDirectory.iStorageSpaceSize.longValue() * 1024L);
        oDeviceDiskInfo.setIStoragekFreeSpaceSize(oAsnDirectory.iStorageFreeSpaceSize.longValue() * 1024L);
        AsnFileOnDevList oAsnFileOnDevList = oAsnDirectory.oFilelist;
        oDeviceDiskInfo.setOFileOnDevList(this.getDeviceFileList(new String(oAsnDirectory.strDirectoryName), oAsnFileOnDevList));
        return oDeviceDiskInfo;
    }

    private List<DeviceFileInfo> getDeviceFileList(String strDirectoryName, AsnFileOnDevList oAsnFileOnDevList) {
        ArrayList<DeviceFileInfo> oDeviceFileList = new ArrayList<DeviceFileInfo>(0);
        AsnFileOnDevInfo oAsnFileOnDevInfo = null;
        DeviceFileInfo oDeviceFileInfo = null;
        int iFileSize = oAsnFileOnDevList.size();
        for (int i = 0; i < iFileSize; ++i) {
            oAsnFileOnDevInfo = (AsnFileOnDevInfo)oAsnFileOnDevList.get(i);
            oDeviceFileInfo = new DeviceFileInfo();
            oDeviceFileInfo.setFileName(new String(oAsnFileOnDevInfo.strFileName));
            oDeviceFileInfo.setFileSize(oAsnFileOnDevInfo.iFileSize.intValue());
            oDeviceFileInfo.setStareupFiles(oAsnFileOnDevInfo.bIsStartupFiles);
            oDeviceFileList.add(oDeviceFileInfo);
        }
        return oDeviceFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnDCCheckDevMemoryRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        Object object = this.m_oSyncObj;
        synchronized (object) {
            this.m_oAsnDCCheckDevMemoryRsp = (AsnDCCheckDevMemoryRsp)oEvent.getSource();
            this.m_oSyncObj.notifyAll();
        }
    }

    class CheckDeviceMemory
    extends Thread {
        private ValidationResult m_oResult = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CheckDeviceMemoryUtil.this.m_oSyncObject;
            synchronized (object) {
                this.m_oResult = new ValidationResult();
                this.m_oResult.setErrorCode(0);
                this.m_oResult = CheckDeviceMemoryUtil.this.getDeviceMemory();
                CheckDeviceMemoryUtil.this.m_oValidationProgressDlg.dispose();
                CheckDeviceMemoryUtil.this.m_oValidationProgressDlg = null;
            }
        }

        public ValidationResult getValidateResult() {
            return this.m_oResult;
        }
    }
}

