/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.CheckDeviceMemoryUtil;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryStatusDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionPanel;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigPanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CheckDeviceMemoryButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1023282389071670200L;
    private FileSelectionDialog m_oModalParent = null;
    private JButton m_oCheckMemoryButton = null;
    private THashSet<Resource> m_oResList = null;
    private FileSelectionPanel m_oFileSelectionPanel = null;
    private StartupConfigPanel m_oStartupCofigPanel = null;
    private HashMap<Integer, DeviceMemoryInfo> m_oDeviceMemoryInfoMap = null;
    private DeviceMemoryStatusDialog m_oDeleteDeviceFileDialog = null;
    private int iTaskTypeId;
    private HashMap<Integer, List<String>> m_oFileInfoMap;
    private long firstOpenClientTime = -1L;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckDeviceMemoryButtonPanel other = (CheckDeviceMemoryButtonPanel)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public CheckDeviceMemoryButtonPanel(int taskTypeId) {
        this.iTaskTypeId = taskTypeId;
        this.m_oFileInfoMap = new HashMap();
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initButton();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
    }

    private void initButton() {
        this.m_oCheckMemoryButton = new JButton();
        this.m_oCheckMemoryButton.setText(ResourceManager.getInstance().getResString("CHECK_DEVICE_MEMORY_BUTTON"));
        this.m_oCheckMemoryButton.setName("DeviceOperation_CheckDeviceMemoryButtonPanem_m_oCheckMemoryButton");
        this.m_oCheckMemoryButton.setPreferredSize(new Dimension(180, 22));
        this.m_oCheckMemoryButton.setMnemonic('C');
        this.m_oCheckMemoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckDeviceMemoryButtonPanel.this.checkMemoryOnDevice_ButtonClicked();
            }
        });
        this.add((Component)this.m_oCheckMemoryButton, "Center");
    }

    protected void checkMemoryOnDevice_ButtonClicked() {
        if (!this.validateFileSelection()) {
            return;
        }
        CheckDeviceMemoryUtil checkDevMemoryUtil = new CheckDeviceMemoryUtil(this.m_oFileInfoMap);
        if (null != this.getM_oModalParent()) {
            checkDevMemoryUtil.setM_oModalParent(this.getM_oModalParent());
        }
        this.m_oDeviceMemoryInfoMap = checkDevMemoryUtil.checkDeviceMemory();
        if (this.m_oDeviceMemoryInfoMap.size() > 0 && !checkDevMemoryUtil.isCancelPressed()) {
            this.showDeleteDeviceFileDialog();
        }
    }

    private boolean validateFileSelection() {
        LoadFileInfo[] arrFileInfo = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
        List<LoadFileInfo> oSpecialFileInfoLst = this.m_oStartupCofigPanel.getDeviceLevelLoadConfigParam().getLoadFileInfoList();
        if (null == arrFileInfo || 0 == arrFileInfo.length) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("NO_LOAD_FILE_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return false;
        }
        for (int i = 0; i < arrFileInfo.length; ++i) {
            if (!arrFileInfo[i].getFileName().contains(" ") || !this.m_oFileSelectionPanel.isDMSDevice()) continue;
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return false;
        }
        for (Resource oRes : this.m_oResList) {
            int iDevId = oRes.getDeviceID();
            this.m_oFileInfoMap.put(iDevId, this.getDevLoadFiles(iDevId, arrFileInfo, oSpecialFileInfoLst));
        }
        return true;
    }

    private List<String> getDevLoadFiles(int iDevId, LoadFileInfo[] arrCommonFileInfo, List<LoadFileInfo> oSpecialFileInfoLst) {
        ArrayList<String> oFileLst = new ArrayList<String>();
        for (LoadFileInfo oFileInfo : arrCommonFileInfo) {
            oFileLst.add(oFileInfo.getFileName());
        }
        for (LoadFileInfo oFileInfo : oSpecialFileInfoLst) {
            if (iDevId != oFileInfo.getDeviceId()) continue;
            oFileLst.add(oFileInfo.getFileName());
        }
        return oFileLst;
    }

    public THashSet<Resource> getResList() {
        return this.m_oResList;
    }

    public void setResList(THashSet<Resource> resList) {
        this.m_oResList = resList;
    }

    public void setM_oModalParent(FileSelectionDialog modalParent) {
        this.m_oModalParent = modalParent;
    }

    public FileSelectionDialog getM_oModalParent() {
        return this.m_oModalParent;
    }

    public FileSelectionPanel getFileSelectionPanel() {
        return this.m_oFileSelectionPanel;
    }

    public void setFileSelectionPanel(FileSelectionPanel fileSelectionPanel) {
        this.m_oFileSelectionPanel = fileSelectionPanel;
    }

    public void setStartupConfigPanel(StartupConfigPanel oStartupConfigPanel) {
        this.m_oStartupCofigPanel = oStartupConfigPanel;
    }

    public StartupConfigPanel getStartupConfigPanel() {
        return this.m_oStartupCofigPanel;
    }

    private void showDeleteDeviceFileDialog() {
        if (null == this.m_oDeviceMemoryInfoMap || 0 == this.m_oDeviceMemoryInfoMap.size()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("CHECK_DEVICE_MEMORY_REQUEST_FAIL"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        Iterator<Integer> oDevIDItr = this.m_oDeviceMemoryInfoMap.keySet().iterator();
        DeviceMemoryInfo oDeviceMemoryInfo = null;
        int iFailedCount = 0;
        int iSuccessCount = 0;
        while (oDevIDItr.hasNext()) {
            int iDevID = oDevIDItr.next();
            oDeviceMemoryInfo = this.m_oDeviceMemoryInfoMap.get(iDevID);
            if (2 == oDeviceMemoryInfo.getDeviceMemoryCheckResult()) {
                ++iFailedCount;
                continue;
            }
            ++iSuccessCount;
        }
        if (0 < iFailedCount) {
            this.showMemoryCheckFailedError();
        }
        if (0 < iSuccessCount) {
            this.m_oDeleteDeviceFileDialog = new DeviceMemoryStatusDialog(this.m_oModalParent, this.m_oDeviceMemoryInfoMap, this.m_oFileInfoMap, this.iTaskTypeId);
            this.m_oDeleteDeviceFileDialog.setVisible(true);
        }
    }

    private void showMemoryCheckFailedError() {
        String strTitle = DCFrameWorkUtil.getLocalizedString("ERROR");
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("FAILURE_REASON"), DCFrameWorkUtil.getLocalizedString("ERROR_INFO")};
        TaskOperationResultDialog oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
        oOpResultDlg.setMessage(DCFrameWorkUtil.getLocalizedString("MEMORY_CHECK_FAILURE_RESULT_MSG"));
        oOpResultDlg.customizeTableForTelnetError();
        Iterator<Integer> oDevIDItr = this.m_oDeviceMemoryInfoMap.keySet().iterator();
        DeviceMemoryInfo oDeviceMemoryInfo = null;
        String strResource = null;
        String strReason = null;
        Resource oRes = null;
        Vector<Object> oRowData = null;
        while (oDevIDItr.hasNext()) {
            int iDevID = oDevIDItr.next();
            oRes = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
            strResource = oRes.getDeviceName() + '(' + oRes.getDeviceIP() + ')';
            oDeviceMemoryInfo = this.m_oDeviceMemoryInfoMap.get(iDevID);
            if (2 != oDeviceMemoryInfo.getDeviceMemoryCheckResult()) continue;
            oRowData = new Vector<Object>(3);
            strReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oDeviceMemoryInfo.getErrorCode()));
            oRowData.add(strResource);
            oRowData.add(strReason);
            oRowData.add(oDeviceMemoryInfo.getErrorInfo());
            oOpResultDlg.addRowInModel(oRowData);
        }
        oOpResultDlg.setVisible(true);
    }
}

