/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsoftware;

import com.huawei.dc.common.components.table.renderer.DCTableNumberCellRenderer;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeHelper;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceDiskInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceFileInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BaseDeleteDeviceFilePanel
extends JPanel {
    private static final long serialVersionUID = -9132494232254717915L;
    private DCSortableTreeTable m_oOperationTable = null;
    private DCTreeTableModel m_oTableModel = null;
    private TreeTableNode m_oRootNode = null;
    private JScrollPane m_oScrollPane = null;
    private static final int TABLE_FILE_PATH = 0;
    private JTree m_oTaskTree;
    private String[] m_strColumnNames;
    private Class[] m_arrColumnTypes;
    private boolean[] m_arrSortableColumns;
    private boolean[] m_arrEditableColumns;

    public BaseDeleteDeviceFilePanel(Class[] arrColumnTypes, String[] strColumnNames, boolean[] arrSortableColumns, boolean[] arrEditableColumns) {
        this.m_arrColumnTypes = arrColumnTypes;
        this.m_strColumnNames = strColumnNames;
        this.m_arrSortableColumns = arrSortableColumns;
        this.m_arrEditableColumns = arrEditableColumns;
        this.jbinit();
    }

    private void jbinit() {
        this.initPanel();
        this.initScrollPane();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
    }

    private void initScrollPane() {
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setName("TaskMgmt_UpgradeOpConfigPanel_oTableScrollPane");
        this.m_oScrollPane.setPreferredSize(new Dimension(304, 330));
        this.m_oScrollPane.setMinimumSize(new Dimension(304, 320));
        this.initOperationTable();
        this.m_oScrollPane.setViewportView((Component)((Object)this.m_oOperationTable));
        this.m_oScrollPane.setBackground(this.m_oOperationTable.getBackground());
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected DCSortableTreeTable getOperationTable() {
        return this.m_oOperationTable;
    }

    private void initOperationTable() {
        this.createTreeTableModel();
        this.m_oOperationTable = new DCSortableTreeTable(this.m_oTableModel);
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(2);
        this.m_oOperationTable.setSelectionModel(oTaskSelection);
        this.initializeTreeTable();
        this.customizeOperationTable();
        this.initOperTableLisener();
    }

    protected void initOperTableLisener() {
        this.m_oOperationTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(BaseDeleteDeviceFilePanel.this.getParent(), cur);
            }
        });
    }

    private void initializeTreeTable() {
        this.m_oTaskTree = this.m_oOperationTable.getTree();
        this.m_oTaskTree.setName("TaskMgmt_TaskTablePanelPanel_m_oTaskTree");
        this.m_oOperationTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTaskTree.setShowsRootHandles(true);
        this.m_oTaskTree.setCellRenderer(new MyCellRenderer());
        String strFileSizeColumnName = DCFrameWorkUtil.getLocalizedString("FILE_LIST_TABLE_FILE_SIZE_EN");
        this.m_oOperationTable.getColumn(strFileSizeColumnName).setCellRenderer(new DCTableNumberCellRenderer());
        this.m_oOperationTable.setRowHeight(10);
        this.m_oOperationTable.setShowHorizontalLines(true);
        this.m_oOperationTable.setShowVerticalLines(true);
        this.m_oOperationTable.setColumnSelectionAllowed(false);
        this.m_oOperationTable.setRowSelectionAllowed(true);
    }

    private void createTreeTableModel() {
        this.m_oTableModel = new DCTreeTableModel(this.m_strColumnNames, this.m_arrColumnTypes, this.m_arrSortableColumns, this.m_arrEditableColumns);
        this.m_oRootNode = this.m_oTableModel.getRoot();
    }

    private void customizeOperationTable() {
        this.m_oOperationTable.getTableHeader().setReorderingAllowed(false);
        this.m_oOperationTable.setRowHeight(18);
        this.m_oOperationTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_oOperationTable.getTableHeader().setPreferredSize(new Dimension(this.m_oOperationTable.getSize().width, 18));
    }

    public void populateOperationTableData() {
    }

    public TreeTableNode createDiskNodeInTable(DeviceDiskInfo oDeviceDiskInfo) {
        return null;
    }

    public TreeTableNode createFileNodeInTable(DeviceFileInfo oDeviceFileInfo) {
        return null;
    }

    public TreeTableNode createFileNode(TreeTableNode oFileNode) {
        return null;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != BaseDeleteDeviceFilePanel.this.m_oOperationTable) {
                    BaseDeleteDeviceFilePanel.this.m_oOperationTable.getTableHeader().updateUI();
                    BaseDeleteDeviceFilePanel.this.m_oOperationTable.updateUI();
                    BaseDeleteDeviceFilePanel.this.m_oTaskTree.updateUI();
                    BaseDeleteDeviceFilePanel.this.handleSelectButtonState();
                }
            }
        });
    }

    protected void handleSelectButtonState() {
    }

    public int insertDiskNode(TreeTableNode oDiskNode, boolean bRefreshLeftSize) {
        TreeTableRowData oParentRowData;
        Object oParntObj;
        TreeTableNode m_oFileNode;
        int i;
        int iChildCount;
        int iFileSize = 0;
        TreeTableNode m_oDiskNode = this.isExistDiskNode(oDiskNode);
        boolean isNewNode = false;
        if (m_oDiskNode == null) {
            m_oDiskNode = this.createDiskNode(oDiskNode);
            iChildCount = oDiskNode.getChildCount();
            for (i = 0; i < iChildCount; ++i) {
                m_oFileNode = (TreeTableNode)oDiskNode.getChildAt(i);
                m_oDiskNode.add(this.createFileNode(m_oFileNode));
                TreeTableRowData oTempFileRow = (TreeTableRowData)m_oFileNode.getUserObject();
                DeviceFileInfo oTempFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
                iFileSize += oTempFileInfo.getFileSize();
            }
            isNewNode = true;
            this.getRootNode().add(m_oDiskNode);
        } else {
            iChildCount = oDiskNode.getChildCount();
            for (i = 0; i < iChildCount; ++i) {
                DeviceFileInfo oTempFileInfo;
                TreeTableRowData oTempFileRow;
                TreeTableNode oChild;
                Enumeration<TreeNode> oChildEnum;
                m_oFileNode = (TreeTableNode)oDiskNode.getChildAt(i);
                TreeTableNode oNode = this.createFileNode(m_oFileNode);
                TreeTableNode oExistNode = this.isExistFileNode(oNode, m_oFileNode);
                if (null == oExistNode) {
                    m_oDiskNode.add(oNode);
                    oChildEnum = oNode.children();
                    if (oNode.children().hasMoreElements()) {
                        while (oChildEnum.hasMoreElements()) {
                            oChild = (TreeTableNode)oChildEnum.nextElement();
                            oTempFileRow = (TreeTableRowData)oChild.getUserObject();
                            oTempFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
                            iFileSize += oTempFileInfo.getFileSize();
                        }
                        continue;
                    }
                    TreeTableRowData oTempFileRow2 = (TreeTableRowData)oNode.getUserObject();
                    DeviceFileInfo oTempFileInfo2 = (DeviceFileInfo)oTempFileRow2.getUserObject();
                    iFileSize += oTempFileInfo2.getFileSize();
                    continue;
                }
                oChildEnum = oNode.children();
                while (oChildEnum.hasMoreElements()) {
                    oChild = (TreeTableNode)oChildEnum.nextElement();
                    this.addNode(oExistNode, oChild);
                    oChildEnum = oNode.children();
                    oTempFileRow = (TreeTableRowData)oChild.getUserObject();
                    oTempFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
                    iFileSize += oTempFileInfo.getFileSize();
                }
            }
        }
        TreePath trePath = new TreePath(m_oDiskNode.getPath());
        TreeHelper.expandAll(this.m_oTaskTree, trePath, true);
        if (bRefreshLeftSize && (oParntObj = (oParentRowData = (TreeTableRowData)m_oDiskNode.getUserObject()).getUserObject()) instanceof DeviceDiskInfo) {
            DeviceDiskInfo oParentDiskInfo = (DeviceDiskInfo)oParntObj;
            if (!isNewNode) {
                oParentDiskInfo.setIStoragekFreeSpaceSize(oParentDiskInfo.getIStoragekFreeSpaceSize() - (long)iFileSize);
            }
            oParentRowData.setColumnData(0, new TreeTableCellData(oParentDiskInfo.getStorageNameAndSize()));
        }
        return iFileSize;
    }

    public int insertFileNode(TreeTableNode oFileNode, boolean bRefreshLeftSize) {
        TreeTableRowData oParentRowData;
        Object oParntObj;
        TreeTableNode oDiskNode;
        for (oDiskNode = (TreeTableNode)oFileNode.getParent(); null != oDiskNode && !(((TreeTableRowData)oDiskNode.getUserObject()).getUserObject() instanceof DeviceDiskInfo); oDiskNode = (TreeTableNode)oDiskNode.getParent()) {
        }
        TreeTableNode m_oDiskNode = this.isExistDiskNode(oDiskNode);
        boolean isNewDiskNode = false;
        int iSize = 0;
        if (m_oDiskNode != null) {
            this.insertNode(m_oDiskNode, oFileNode);
        } else {
            isNewDiskNode = true;
            iSize = this.conculateSize(oDiskNode);
            m_oDiskNode = this.createDiskNode(oDiskNode);
            this.insertNode(m_oDiskNode, oFileNode);
            this.getRootNode().add(m_oDiskNode);
        }
        TreeTableRowData oTempFileRow = (TreeTableRowData)oFileNode.getUserObject();
        DeviceFileInfo oTempFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
        TreePath trePath = new TreePath(m_oDiskNode.getPath());
        TreeHelper.expandAll(this.m_oTaskTree, trePath, true);
        int iMoveSize = 0;
        if (oTempFileInfo.isFile()) {
            iMoveSize = oTempFileInfo.getFileSize();
        } else {
            Enumeration<TreeNode> oChildEnum = oFileNode.children();
            while (oChildEnum.hasMoreElements()) {
                DeviceFileInfo oFileInfo;
                TreeTableNode oChild = (TreeTableNode)oChildEnum.nextElement();
                TreeTableRowData oRowData = (TreeTableRowData)oChild.getUserObject();
                Object obj = oRowData.getUserObject();
                if (!(obj instanceof DeviceFileInfo) || !(oFileInfo = (DeviceFileInfo)obj).isFile()) continue;
                iMoveSize += oFileInfo.getFileSize();
            }
        }
        if (bRefreshLeftSize && (oParntObj = (oParentRowData = (TreeTableRowData)m_oDiskNode.getUserObject()).getUserObject()) instanceof DeviceDiskInfo) {
            DeviceDiskInfo oParentDiskInfo = (DeviceDiskInfo)oParntObj;
            if (isNewDiskNode) {
                oParentDiskInfo.setIStoragekFreeSpaceSize(oParentDiskInfo.getIStoragekFreeSpaceSize() + (long)iSize - (long)iMoveSize);
            } else {
                oParentDiskInfo.setIStoragekFreeSpaceSize(oParentDiskInfo.getIStoragekFreeSpaceSize() - (long)iMoveSize);
            }
            oParentRowData.setColumnData(0, new TreeTableCellData(oParentDiskInfo.getStorageNameAndSize()));
        }
        return iMoveSize;
    }

    private int conculateSize(TreeTableNode oNode) {
        int iSize = 0;
        Enumeration<TreeNode> enu = oNode.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            TreeTableNode tmpNode = (TreeTableNode)enu.nextElement();
            TreeTableRowData rowData = (TreeTableRowData)tmpNode.getUserObject();
            if (!(rowData.getUserObject() instanceof DeviceFileInfo)) continue;
            iSize += ((DeviceFileInfo)rowData.getUserObject()).getFileSize();
        }
        return iSize;
    }

    public TreeTableNode createDiskNode(TreeTableNode oDiskNode) {
        return null;
    }

    public TreeTableNode isExistDiskNode(TreeTableNode diskNode) {
        if (null == diskNode) {
            return null;
        }
        TreeTableRowData oTempDiskRow = (TreeTableRowData)diskNode.getUserObject();
        DeviceDiskInfo oTempDeviceDiskInfo = (DeviceDiskInfo)oTempDiskRow.getUserObject();
        String strTempDiskName = oTempDeviceDiskInfo.getStrStorageName();
        int iChildCount = this.getRootNode().getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode oDiskNode = (TreeTableNode)this.getRootNode().getChildAt(i);
            TreeTableRowData oDiskRow = (TreeTableRowData)oDiskNode.getUserObject();
            DeviceDiskInfo oDeviceDiskInfo = (DeviceDiskInfo)oDiskRow.getUserObject();
            String strDiskName = oDeviceDiskInfo.getStrStorageName();
            if (!strTempDiskName.equals(strDiskName)) continue;
            return oDiskNode;
        }
        return null;
    }

    public TreeTableNode isExistFileNode(TreeTableNode fileNode, TreeTableNode srcNode) {
        if (null == fileNode) {
            return null;
        }
        StringBuffer sourceBuf = new StringBuffer();
        TreeNode[] sourceTreeNodes = srcNode.getPath();
        int sourceTreeNodesLength = 0;
        sourceTreeNodesLength = srcNode.getChildCount() == 0 ? sourceTreeNodes.length - 1 : sourceTreeNodes.length;
        for (int i = 0; i < sourceTreeNodesLength; ++i) {
            TreeTableNode sourceTreeNode = (TreeTableNode)sourceTreeNodes[i];
            TreeTableRowData tempSourceTreeNode = (TreeTableRowData)sourceTreeNode.getUserObject();
            if (null == tempSourceTreeNode) continue;
            if (tempSourceTreeNode.getUserObject() instanceof DeviceDiskInfo) {
                DeviceDiskInfo diskInfo = (DeviceDiskInfo)tempSourceTreeNode.getUserObject();
                sourceBuf.append(diskInfo.getStrStorageName());
                continue;
            }
            DeviceFileInfo fileInfo = (DeviceFileInfo)tempSourceTreeNode.getUserObject();
            sourceBuf.append(fileInfo.getFileName());
        }
        TreeTableRowData oTempFileRow = (TreeTableRowData)fileNode.getUserObject();
        DeviceFileInfo oTempDeviceFileInfo = (DeviceFileInfo)oTempFileRow.getUserObject();
        String strTempFileName = oTempDeviceFileInfo.getFileName();
        Enumeration<TreeNode> oChildEnum = this.getRootNode().breadthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            TreeTableNode oChildNode = (TreeTableNode)oChildEnum.nextElement();
            TreeTableRowData oDevFileRow = (TreeTableRowData)oChildNode.getUserObject();
            if (null == oDevFileRow || !(oDevFileRow.getUserObject() instanceof DeviceFileInfo)) continue;
            StringBuffer targetBuf = new StringBuffer();
            DeviceFileInfo oFileInfo = (DeviceFileInfo)oDevFileRow.getUserObject();
            if (!strTempFileName.equals(oFileInfo.getFileName())) continue;
            TreeNode[] targetTreeNodes = oChildNode.getPath();
            for (int i = 0; i < targetTreeNodes.length; ++i) {
                TreeTableNode targetTreeNode = (TreeTableNode)targetTreeNodes[i];
                TreeTableRowData tempTargetTreeNode = (TreeTableRowData)targetTreeNode.getUserObject();
                if (null == tempTargetTreeNode) continue;
                if (tempTargetTreeNode.getUserObject() instanceof DeviceDiskInfo) {
                    DeviceDiskInfo diskInfo = (DeviceDiskInfo)tempTargetTreeNode.getUserObject();
                    targetBuf.append(diskInfo.getStrStorageName());
                    continue;
                }
                DeviceFileInfo fileInfo = (DeviceFileInfo)tempTargetTreeNode.getUserObject();
                targetBuf.append(fileInfo.getFileName());
            }
            if (!sourceBuf.toString().equals(targetBuf.toString())) continue;
            return oChildNode;
        }
        return null;
    }

    public List<String> getSelectedFileList() {
        ArrayList<String> oFileList = new ArrayList<String>(0);
        this.recursionSelectedFile(oFileList, this.getRootNode(), "");
        return oFileList;
    }

    private void recursionSelectedFile(List<String> oFileList, TreeTableNode childNode, String sDiskPath) {
        int iDiskCount = childNode.getChildCount();
        for (int i = 0; i < iDiskCount; ++i) {
            TreeTableNode oDiskNode = (TreeTableNode)childNode.getChildAt(i);
            if (oDiskNode.isLeaf()) {
                TreeTableRowData oFileRow = (TreeTableRowData)oDiskNode.getUserObject();
                DeviceFileInfo oDeviceFileInfo = (DeviceFileInfo)oFileRow.getUserObject();
                if (sDiskPath.endsWith("/")) {
                    oFileList.add(sDiskPath + oDeviceFileInfo.getFileName());
                    continue;
                }
                oFileList.add(sDiskPath + "/" + oDeviceFileInfo.getFileName());
                continue;
            }
            String filePath = sDiskPath + oDiskNode.toString();
            if (!filePath.endsWith("/")) {
                filePath = filePath + "/";
            }
            this.recursionSelectedFile(oFileList, oDiskNode, filePath);
        }
    }

    public TreeTableNode getRootNode() {
        return this.m_oRootNode;
    }

    public JTree getTaskTree() {
        return this.m_oTaskTree;
    }

    public DCSortableTreeTable getJTable() {
        return this.m_oOperationTable;
    }

    private void insertNode(TreeTableNode oDiskNode, TreeTableNode oFileNode) {
        if (null == oDiskNode || null == oFileNode) {
            return;
        }
        this.addSingleNode(oDiskNode, oFileNode);
    }

    private void addSingleNode(TreeTableNode oDiskNode, TreeTableNode oFileNode) {
        TreeTableNode oNode = this.createFileNode(oFileNode);
        TreeTableNode oExistNode = this.isExistFileNode(oNode, oFileNode);
        if (null == oExistNode) {
            oDiskNode.add(oNode);
        } else {
            Enumeration<TreeNode> oChildEnum = oNode.children();
            while (oChildEnum.hasMoreElements()) {
                TreeTableNode oChild = (TreeTableNode)oChildEnum.nextElement();
                this.addNode(oExistNode, oChild);
                oChildEnum = oNode.children();
            }
        }
    }

    private void addNode(TreeTableNode oParentNode, TreeTableNode oSunNode) {
        TreeTableNode oExistNode = this.isExistFileNode(oSunNode, oSunNode);
        if (null == oExistNode) {
            oParentNode.add(oSunNode);
        } else {
            Enumeration<TreeNode> oChildEnum = oSunNode.children();
            while (oChildEnum.hasMoreElements()) {
                TreeTableNode oChild = (TreeTableNode)oChildEnum.nextElement();
                this.addNode(oExistNode, oChild);
                oChildEnum = oSunNode.children();
            }
        }
    }

    class MyCellRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o;
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setIconTextGap(8);
            oLabel.setBorder(BaseDeleteDeviceFilePanel.this.getBorder());
            TreeTableNode node = (TreeTableNode)value;
            if (node == null) {
                return null;
            }
            TreeTableRowData nodeInfo = (TreeTableRowData)node.getUserObject();
            if (nodeInfo != null && (o = nodeInfo.getUserObject()) != null) {
                ImageIcon m_oSelectIcon = null;
                if (o instanceof DeviceDiskInfo) {
                    m_oSelectIcon = ResourceManager.getInstance().getImage("folder.gif");
                } else if (o instanceof DeviceFileInfo) {
                    DeviceFileInfo oDevFileInfo = (DeviceFileInfo)o;
                    m_oSelectIcon = oDevFileInfo.isFile() ? ResourceManager.getInstance().getImage("file.gif") : ResourceManager.getInstance().getImage("folder.gif");
                }
                oLabel.setIcon(m_oSelectIcon);
            }
            if (BaseDeleteDeviceFilePanel.this.m_oOperationTable.isRowSelected(row)) {
                oLabel.setBackground(BaseDeleteDeviceFilePanel.this.m_oOperationTable.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(BaseDeleteDeviceFilePanel.this.m_oOperationTable.getBackground());
                oLabel.setForeground(BaseDeleteDeviceFilePanel.this.m_oOperationTable.getForeground());
            }
            oLabel.setText(value.toString());
            oLabel.setBorder(null);
            return oLabel;
        }
    }
}

