/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view;

import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCLoadSimulationPackageInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDevice;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDeviceList;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoOnBoard;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoOnBoardLst;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageLoadSortRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageToLoad;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.RowData;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SwitchTaskAndAsn;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SimPackageTablePan
extends JPanel {
    private static final long serialVersionUID = 739797464345564541L;
    private JSortTreeTable m_oTaskTreeTable;
    private DCTreeTableModel m_oTaskTreeTableModel;
    private JTree m_oTaskTree;
    private JScrollPane m_oScrollPane;
    private static final int TO_BE_LOAD_COLUMN_INDEX = 5;
    private transient TreeTableNode m_oRootNode;
    private THashSet<Resource> oResourceList;
    private transient AsnDCLoadSimulationPackageInfo loadPackageInfo = null;
    private transient AsnDCSimulationPackageDeviceList oSimulationPackageDeviceList = null;
    private Vector devIdList = new Vector();
    private boolean isViewStatus = false;
    private ITask iTask;
    public static final int MSCC_MAIN_BOARD_TYPE = 1;
    public static final int SSCC_STANDBY_BOARD_TYPE = 2;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private int m_iSelectionType = 2;

    public SimPackageTablePan(ITask iTask, LoadSimPackageTabbedPane oLoadSimPackageTabbedPane) {
        if (iTask.getLoadSimPackageInfo() != null) {
            this.loadPackageInfo = new AsnDCLoadSimulationPackageInfo();
            SwitchTaskAndAsn.getSwitchTaskAndAsn().switchTaskToAsnByLoad(this.loadPackageInfo, iTask);
            this.oSimulationPackageDeviceList = this.loadPackageInfo.oSimulationPackageDeviceList;
        }
        this.iTask = iTask;
        DeviceType oSelectedDeviceType = iTask.getSelectedDeviceType();
        this.oResourceList = oSelectedDeviceType.getResources();
        this.jInit();
        if (this.oSimulationPackageDeviceList != null) {
            this.populateResourceInTable(this.oSimulationPackageDeviceList);
        } else {
            this.populateDeviceInTable();
        }
    }

    private void jInit() {
        this.createTreeTable();
        this.m_oScrollPane = new JScrollPane((Component)((Object)this.m_oTaskTreeTable));
        this.m_oScrollPane.setName("DeviceOperation_SimPackageTablePan_m_oScrollPane");
        this.add(this.m_oScrollPane);
        this.setLayout(new GridLayout());
        this.setFocusable(true);
    }

    private void createTreeTable() {
        this.createTreeTableModel();
        this.m_oTaskTreeTable = new JSortTreeTable(this.m_oTaskTreeTableModel);
        this.m_oTaskTreeTable.setName("DeviceOperation_SimPackageTablePan_m_oTaskTreeTable");
        this.initializeSelectionModel();
        this.initializeTreeTable();
    }

    private void initializeTreeTable() {
        this.m_oTaskTree = this.m_oTaskTreeTable.getTree();
        this.m_oTaskTree.setName("DeviceOperation_SimPackageTablePan_m_oTaskTree");
        this.m_oTaskTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTaskTree.setToggleClickCount(2);
        this.m_oTaskTreeTable.getColumnModel().getColumn(5).setCellRenderer(new OperationSelecCheckBoxRenderer());
        this.m_oTaskTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTaskTreeTable.getSize().width, 28));
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oParseCoulmn = this.m_oTaskTreeTable.getColumnModel().getColumn(5);
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oTaskTreeTable.getTableHeader().getBackground());
        oParseCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        this.m_oTaskTree.setCellRenderer(new MyCellRenderer());
        this.m_oTaskTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oTaskTreeTable.setRowHeight(21);
        this.m_oTaskTreeTable.setShowHorizontalLines(true);
        this.m_oTaskTreeTable.setShowVerticalLines(false);
        this.m_oTaskTreeTable.setColumnSelectionAllowed(false);
        this.m_oTaskTreeTable.setRowSelectionAllowed(true);
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                SimPackageTablePan.this.taskTable_MousePressed(oMouseEvent);
            }
        };
    }

    private void taskTable_MousePressed(MouseEvent oMouseEvent) {
        int iClickedColumn;
        if (this.isViewStatus) {
            return;
        }
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        int selectCount = arrSelectedRows.length;
        if (selectCount != 1) {
            return;
        }
        int arrSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 3 && (iClickedColumn = this.m_oTaskTreeTable.columnAtPoint(oMouseEvent.getPoint())) == 5) {
            CheckBoxOperation operation = nodeInfo.getToBeLoad();
            if (!operation.getIsSelect()) {
                operation.setIsSelect(true);
            } else {
                operation.setIsSelect(false);
            }
        }
        this.m_oTaskTreeTable.updateUI();
    }

    private void initializeSelectionModel() {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(1);
        this.m_oTaskTreeTable.setSelectionModel(oTaskSelection);
    }

    private void createTreeTableModel() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_RESOURCE_NAME"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_RESOURCE_TYPE"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_ORIGINAL_VERSION"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_SOFTWARE_NAME"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_NEW_SOFTWARE_VERSION"), ResourceManager.getInstance().getResString("TASK_TABLE_COLUMN_TO_BE_LOADED")};
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class, String.class, JCheckBox.class};
        boolean[] arrSortableColumns = new boolean[]{false, false, false, false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false, false, false};
        this.m_oTaskTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns, RowData.getMethodNames());
        this.m_oRootNode = this.m_oTaskTreeTableModel.getRoot();
    }

    public void refreshTable() {
        this.updateTableView();
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimPackageTablePan.this.m_oTaskTreeTable.getTableHeader().updateUI();
                SimPackageTablePan.this.m_oTaskTreeTable.updateUI();
            }
        });
    }

    public JSortTreeTable getTaskTreeTable() {
        return this.m_oTaskTreeTable;
    }

    public void populateResourceInTable(AsnDCSimulationPackageDeviceList oSimulationPackageDeviceList) {
        this.oSimulationPackageDeviceList = oSimulationPackageDeviceList;
        this.m_oRootNode.removeAllChildren();
        if (oSimulationPackageDeviceList == null) {
            return;
        }
        this.devIdList.removeAllElements();
        int devResLength = oSimulationPackageDeviceList.size();
        for (int i = 0; i < devResLength; ++i) {
            AsnDCSimulationPackageDevice devRes = (AsnDCSimulationPackageDevice)oSimulationPackageDeviceList.get(i);
            Resource res = this.iTask.getDeviceType().getResource(devRes.iDeviceID.intValue());
            if (null == res) {
                DCDebugTracer.trace("device have been delete in Task  " + devRes.iDeviceID.intValue() + this.iTask.getTaskName());
                continue;
            }
            this.addDevNode(devRes);
        }
        this.expandAll(this.m_oTaskTree, new TreePath(this.m_oRootNode), true);
        this.updateTableView();
    }

    public void deleteDevByTable(Vector deleteDevList) {
        int delDevCount = deleteDevList.size();
        for (int i = 0; i < delDevCount; ++i) {
            int devId = deleteDevList.get(i).hashCode();
            for (int j = 0; j < this.m_oRootNode.getChildCount(); ++j) {
                TreeTableNode devNode = (TreeTableNode)this.m_oRootNode.getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                if (devId != devNodeInfo.getDevId()) continue;
                devNode.removeFromParent();
                --j;
            }
        }
        this.updateTableView();
    }

    public void refreshDevIdList() {
        this.devIdList.removeAllElements();
        this.refreshResourceList();
        Iterator oResItor = this.oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            this.devIdList.add(oResource.getDeviceID());
        }
    }

    public void addDevToTable(AsnDCSimulationPackageLoadSortRsp loadSortRsp, Vector addDevList) {
        int addDevCount = addDevList.size();
        for (int i = 0; i < addDevCount; ++i) {
            int addDevId = addDevList.get(i).hashCode();
            AsnDCSimulationPackageDeviceList oSimulationPackageInfoDeviceLst = loadSortRsp.oSimulationPackageInfoDeviceLst;
            int count = oSimulationPackageInfoDeviceLst.size();
            for (int j = 0; j < count; ++j) {
                AsnDCSimulationPackageDevice devInfo = (AsnDCSimulationPackageDevice)oSimulationPackageInfoDeviceLst.get(j);
                if (addDevId != devInfo.iDeviceID.intValue()) continue;
                this.addDevNode(devInfo);
            }
        }
        this.expandAll(this.m_oTaskTree, new TreePath(this.m_oRootNode), true);
        this.updateTableView();
    }

    private void addDevNode(AsnDCSimulationPackageDevice devInfo) {
        int devId = devInfo.iDeviceID.intValue();
        this.devIdList.add(devId);
        RowData devNodeInfo = new RowData(-1, -1, devInfo, 1);
        Resource oRes = this.getRes(devId);
        if (null != oRes) {
            oRes.setOriginalVersion(new String(devInfo.sOriginalVersion));
        }
        TreeTableNode devNode = new TreeTableNode(devNodeInfo);
        this.m_oRootNode.add(devNode);
        AsnDCSimulationPackageInfoOnBoardLst boardResList = devInfo.oBoardList;
        if (boardResList != null) {
            int boardResLength = boardResList.size();
            for (int j = 0; j < boardResLength; ++j) {
                AsnDCSimulationPackageInfoOnBoard boardRes = (AsnDCSimulationPackageInfoOnBoard)boardResList.get(j);
                AsnDCBoardInfo boardInfo = boardRes.oBoardInfo;
                int slotId = boardInfo.iSlotId.intValue();
                RowData boardNodeInfo = new RowData(devId, -1, boardRes, 2);
                TreeTableNode boardNode = new TreeTableNode(boardNodeInfo);
                devNode.add(boardNode);
                AsnDCSimulationPackageInfoLst packageInfoList = boardRes.oSimulationPackageInfoLst;
                if (packageInfoList == null) continue;
                int packageInfoLength = packageInfoList.size();
                for (int m = 0; m < packageInfoLength; ++m) {
                    AsnDCSimulationPackageToLoad packageInfo = (AsnDCSimulationPackageToLoad)packageInfoList.get(m);
                    RowData fileNodeInfo = new RowData(devId, slotId, packageInfo, 3);
                    TreeTableNode fileNode = new TreeTableNode(fileNodeInfo);
                    boardNode.add(fileNode);
                }
            }
        }
    }

    public void populateDeviceInTable() {
        if (this.oResourceList == null) {
            return;
        }
        this.devIdList.removeAllElements();
        this.m_oRootNode.removeAllChildren();
        Iterator oResItor = this.oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            this.devIdList.add(oResource.getDeviceID());
            RowData devNodeInfo = new RowData(-1, -1, oResource, 4);
            TreeTableNode devNode = new TreeTableNode(devNodeInfo);
            this.m_oRootNode.add(devNode);
        }
        this.expandAll(this.m_oTaskTree, new TreePath(this.m_oRootNode), true);
        this.updateTableView();
    }

    public TreeTableNode getRootNode() {
        return this.m_oRootNode;
    }

    public AsnDCSimulationPackageDeviceList getResourceListRsp() {
        return this.oSimulationPackageDeviceList;
    }

    public Vector getDevIdList() {
        return this.devIdList;
    }

    public void setViewStatus(boolean isViewStatus) {
        this.isViewStatus = isViewStatus;
        if (null != this.m_oCheckBoxHeader) {
            this.m_oCheckBoxHeader.setEnabled(false);
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeTableNode node = (TreeTableNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeTableNode n = (TreeTableNode)e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public void refreshResourceList() {
        DeviceType oSelectedDeviceType = this.iTask.getSelectedDeviceType();
        this.oResourceList = oSelectedDeviceType.getResources();
    }

    private void setCheckBoxStatusOnDevRow() {
        boolean bSelected = false;
        switch (this.m_iSelectionType) {
            case 0: {
                bSelected = false;
                break;
            }
            case 1: {
                bSelected = true;
                break;
            }
            case 2: {
                bSelected = true;
                break;
            }
            default: {
                bSelected = false;
            }
        }
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            int boardCount = devNode.getChildCount();
            for (int j = 0; j < boardCount; ++j) {
                TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(j);
                int fileCount = boardNode.getChildCount();
                for (int l = 0; l < fileCount; ++l) {
                    TreeTableNode fileNode = (TreeTableNode)boardNode.getChildAt(l);
                    RowData fileNodeInfo = (RowData)fileNode.getUserObject();
                    fileNodeInfo.getToBeLoad().setIsSelect(bSelected);
                }
            }
        }
    }

    private void checkHeadStatus() {
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        this.m_oTaskTreeTable.getTableHeader().repaint();
    }

    public int getSelectedType() {
        int iAllPauseEnable = 0;
        int iAlreadySelectedParseCount = 0;
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            int boardCount = devNode.getChildCount();
            for (int j = 0; j < boardCount; ++j) {
                TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(j);
                int fileCount = boardNode.getChildCount();
                for (int l = 0; l < fileCount; ++l) {
                    TreeTableNode fileNode = (TreeTableNode)boardNode.getChildAt(l);
                    RowData fileNodeInfo = (RowData)fileNode.getUserObject();
                    ++iAllPauseEnable;
                    if (!fileNodeInfo.getToBeLoad().getIsSelect()) continue;
                    ++iAlreadySelectedParseCount;
                }
            }
        }
        if (iAllPauseEnable == iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 0;
        }
        if (iAlreadySelectedParseCount == 0) {
            this.m_iSelectionType = 2;
        }
        if (iAllPauseEnable > iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 1;
        }
        return this.m_iSelectionType;
    }

    private Resource getRes(int iDevId) {
        for (Resource oRes : this.oResourceList) {
            if (oRes.getDeviceID() != iDevId) continue;
            return oRes;
        }
        return null;
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof AbstractButton)) {
                return;
            }
            SimPackageTablePan.this.setCheckBoxStatusOnDevRow();
            SimPackageTablePan.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            SimPackageTablePan.this.refreshTable();
        }
    }

    private class OperationSelecCheckBoxRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -5527773485044765540L;

        public OperationSelecCheckBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UIManager.getColor("Table.gridColor")));
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            if (value instanceof CheckBoxOperation) {
                CheckBoxOperation pause = (CheckBoxOperation)value;
                if (pause.getIsShow()) {
                    ImageIcon m_oSelectIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                    if (pause.getIsSelect()) {
                        m_oSelectIcon = ResourceManager.getInstance().getImage("all.gif");
                        this.setIcon(m_oSelectIcon);
                    } else {
                        this.setIcon(m_oSelectIcon);
                    }
                } else {
                    this.setIcon(null);
                    this.setText("");
                }
            } else {
                this.setIcon(null);
                this.setText("");
                this.setBackground(SimPackageTablePan.this.m_oTaskTreeTable.getBackground());
            }
            if (bIsSelected) {
                this.setBackground(SimPackageTablePan.this.m_oTaskTreeTable.getSelectionBackground());
                this.setForeground(SimPackageTablePan.this.m_oTaskTreeTable.getSelectionForeground());
            } else {
                this.setBackground(SimPackageTablePan.this.m_oTaskTreeTable.getBackground());
                this.setForeground(SimPackageTablePan.this.m_oTaskTreeTable.getForeground());
            }
            SimPackageTablePan.this.checkHeadStatus();
            this.updateUI();
            return this;
        }
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 4698044368561382120L;

        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeTableNode node = (TreeTableNode)value;
            RowData nodeInfo = (RowData)node.getUserObject();
            if (nodeInfo != null) {
                ImageIcon m_oSelectIcon = new ImageIcon();
                if (nodeInfo.getNodeType() == 1 || nodeInfo.getNodeType() == 4) {
                    m_oSelectIcon = ResourceManager.getInstance().getNeTypeImage(nodeInfo.getDevId());
                } else if (nodeInfo.getNodeType() == 2) {
                    m_oSelectIcon = ResourceManager.getInstance().getImage("ic_slot_0.gif");
                }
                this.setIcon(m_oSelectIcon);
            }
            this.setText(value.toString());
            return this;
        }
    }
}

