/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.KeyStroke;

public class SimPackageSelectionDialog
extends DCModalDialog {
    private transient LoadSoftwareOperation loadSimuPackageOp;
    private transient LoadSimPackageTabbedPane jTabbedPan;
    private ActionListener m_oEscKeyHandler;
    private KeyStroke m_oEscKeyStroke;
    private ActionListener m_oF1KeyHandler;
    private KeyStroke m_oF1KeyStroke;

    public SimPackageSelectionDialog(LoadSoftwareOperation loadSimuPackageOp, String strTitle) throws DCException {
        this.loadSimuPackageOp = loadSimuPackageOp;
        if (this.loadSimuPackageOp == null) {
            return;
        }
        this.setLayout(null);
        this.jbInit();
        this.setSize(890, 445);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(strTitle);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void jbInit() {
        this.jTabbedPan = new LoadSimPackageTabbedPane(this.loadSimuPackageOp.getOperationData());
        this.jTabbedPan.setName("DeviceOperation_SimPackageSelectionDialog_jTabbedPan");
        this.jTabbedPan.setBounds(12, 10, 860, 358);
        this.initializeOKButton();
        this.initializeCancelButton();
        this.initializeKeyStrokeActions();
        this.getContentPane().add(this.m_oOKBtn);
        this.getContentPane().add(this.m_oCancelBtn);
        this.getContentPane().add(this.jTabbedPan);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initializeKeyStrokeActions() {
        this.m_oEscKeyHandler = this.createActionListenerForEscape();
        this.m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(this.m_oEscKeyStroke, this.m_oEscKeyHandler);
        this.m_oF1KeyHandler = this.createActionListenerForF1();
        this.m_oF1KeyStroke = KeyStroke.getKeyStroke(112, 0);
        this.registerKeyBoardActionFor(this.m_oF1KeyStroke, this.m_oF1KeyHandler);
    }

    private ActionListener createActionListenerForF1() {
        ActionListener oF1KeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimPackageSelectionDialog.this.displayHelp();
            }
        };
        return oF1KeyHandler;
    }

    @Override
    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimPackageSelectionDialog.this.closeDialog();
            }
        };
        return oEscKeyHandler;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    @Override
    protected void oKButton_ActionPerformed() {
        LoadSimPackageInfo m_oLoadSimPackageInfo;
        boolean isSelectLoadFile = false;
        boolean isSelectLoadFilePath = false;
        boolean isUpdateForLoadOperation = true;
        boolean isSelectYes = false;
        isSelectLoadFilePath = this.jTabbedPan.validateLoadFilePath();
        if (isSelectLoadFilePath) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("NO_SELECT_LOAD_PACKAGE_PATH");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        ArrayList<String> noSelectFileNEName = new ArrayList<String>();
        isSelectLoadFile = this.jTabbedPan.fillData(noSelectFileNEName);
        if (isSelectLoadFile) {
            String strErrorMsg = "";
            String strNoSelFileNes = "";
            for (String neName : noSelectFileNEName) {
                if ("".equals(strNoSelFileNes)) {
                    strNoSelFileNes = neName;
                    continue;
                }
                strNoSelFileNes = strNoSelFileNes + "," + neName;
            }
            strErrorMsg = strNoSelFileNes + ResourceManager.getInstance().getResString("NO_SELECT_LOAD_PACKAGE_BOARD");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (this.loadSimuPackageOp.getOperationData().getActivationInfo() != null && this.loadSimuPackageOp.getOperationData().getTemporaryLoadSimPackageInfo() != null) {
            if (!this.jTabbedPan.checkUpdateForLoadOperation()) {
                isUpdateForLoadOperation = false;
            }
            isSelectYes = true;
        }
        if (isUpdateForLoadOperation) {
            this.jTabbedPan.fillTaskData();
            m_oLoadSimPackageInfo = (LoadSimPackageInfo)CloneUtil.getClone(this.loadSimuPackageOp.getOperationData().getLoadSimPackageInfo());
            this.loadSimuPackageOp.getOperationData().setTemporaryLoadSimPackageInfo(m_oLoadSimPackageInfo);
            this.loadSimuPackageOp.setPreviousTargetversion(this.loadSimuPackageOp.getOperationData().getTargetVersion());
            if (isSelectYes) {
                this.loadSimuPackageOp.getOperationData().setUpdateLoadOperation(isUpdateForLoadOperation);
            }
        } else {
            m_oLoadSimPackageInfo = (LoadSimPackageInfo)CloneUtil.getClone(this.loadSimuPackageOp.getOperationData().getTemporaryLoadSimPackageInfo());
            this.loadSimuPackageOp.getOperationData().setLoadSimPackageInfo(m_oLoadSimPackageInfo);
        }
        TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
        if (null != oTaskMgmtOperationSelecPanel) {
            oTaskMgmtOperationSelecPanel.refreshTable();
        }
        this.dispose();
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel;
        if (null == this.loadSimuPackageOp.getOperationData().getLoadSimPackageInfo() && null != (oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel())) {
            oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
        }
        super.cancelButton_ActionPerformed();
    }

    private void initializeOKButton() {
        this.m_oOKBtn.setName("DeviceOperation_SimPackageSelectionDialog_m_oOKBtn");
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.m_oOKBtn.setBounds(708, 380, 80, 22);
        this.m_oOKBtn.setToolTipText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.getRootPane().setDefaultButton(this.m_oOKBtn);
    }

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        strHelpFileName = "HELP_TOPIC_MINIC_LOADSOFT";
        return strHelpFileName;
    }

    private void initializeCancelButton() {
        this.m_oCancelBtn.setName("DeviceOperation_SimPackageSelectionDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.m_oCancelBtn.setBounds(792, 380, 80, 22);
        this.m_oCancelBtn.setToolTipText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
    }

    public LoadSimPackageTabbedPane getTabbedPan() {
        return this.jTabbedPan;
    }
}

