/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.SimPackageTablePan;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.common.BrowseDlg;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SimPackageBrowseDlg
extends BrowseDlg {
    private static final int BROWSEDLG_MODEL_NAME = 1;
    private transient SimPackageTablePan showPackageTbalePan = null;
    private THashSet<Resource> oResourceList;
    private ITask oOperationData;
    private String strSelectedPath = null;
    private String strFileName = null;
    private String strFileType = null;
    private transient LoadSimPackageTabbedPane loadPackageTabbedPan;
    public boolean isClickOk = false;

    public SimPackageBrowseDlg(ITask iTask, LoadSimPackageTabbedPane loadPackageTabbedPan) throws DCException {
        this.loadPackageTabbedPan = loadPackageTabbedPan;
        this.showPackageTbalePan = loadPackageTabbedPan.showPackageTbalePan;
        this.oOperationData = iTask;
        DeviceType oSelectedDeviceType = this.oOperationData.getSelectedDeviceType();
        this.oResourceList = oSelectedDeviceType.getResources();
        String path = loadPackageTabbedPan.getCommonPath();
        if (path != null && !path.equals("")) {
            super.getBrowsePanel().setPathFiled(path, false);
        }
        this.setVisible(true);
    }

    public SimPackageBrowseDlg(ITask iTask, String packagePath) throws DCException {
        super(iTask, packagePath);
        this.oOperationData = iTask;
        this.setVisible(true);
    }

    @Override
    protected void setPath() {
        int targetFileServerType = 0;
        if (null != ((BrowseDlg)this).oOperationData && ((BrowseDlg)this).oOperationData.isThirdPartySupported()) {
            targetFileServerType = 1;
        }
        this.m_strTftpPath = this.m_sysMgr.getBrowseFileDir(targetFileServerType, ((BrowseDlg)this).oOperationData.getThirdPartyServerName());
        if (targetFileServerType == 1) {
            this.setStrThirdFTPIP(this.m_strTftpPath);
        }
    }

    @Override
    public void setFilterFileType() {
        this.filterFileType = ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_MIMIC_PACKAGE");
    }

    @Override
    public void setFileTypeNum() {
        this.fileTypeNum = Integer.parseInt(ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_NUM_MIMIC_PACKAGE"));
    }

    @Override
    protected void okButtonActionPerformed() {
        int iSelectedRow = this.m_oTable.getSelectedRow();
        if (-1 == iSelectedRow) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        DirListNode node = (DirListNode)this.m_oTableModel.getValueAt(iSelectedRow, 1);
        if (node == null) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (node.m_bIsDirectory) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.strSelectedPath = super.getPath();
        this.strFileName = node.m_strName;
        this.strFileType = "";
        if (!this.strSelectedPath.endsWith(this.strFileName)) {
            super.getBrowsePanel().getSelectPath().setText(this.strSelectedPath + "/" + this.strFileName);
        }
        if (null != this.oOperationData.getTargetVersion() && this.oOperationData.getTargetVersion().length() > 0) {
            String strFilePath;
            List<Object> strFilePathLst = new ArrayList<String>();
            if (null != this.oOperationData.getLoadFileInfoListParam()) {
                strFilePathLst = this.oOperationData.getLoadFileInfoListParam().getLoadFileInfoList();
            } else {
                strFilePathLst.add(0, TargetVersionPathGetter.getTargetVersionDir(this.oOperationData.getDeviceType(), this.oOperationData.getTargetVersion(), this.oOperationData));
            }
            for (int index = 0; index < strFilePathLst.size() && (strFilePath = strFilePathLst.get(index).toString()).length() > 0; ++index) {
                if (strFilePath.contains(",")) {
                    strFilePath = strFilePath.substring(0, strFilePath.indexOf(","));
                }
                if (strFilePath.equalsIgnoreCase(this.strSelectedPath)) continue;
                int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("FILEPATH_IS_NOT_TARGETVERSIONFILEPATH"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                if (iConfirm != 0) {
                    return;
                }
                TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
                if (null == oTaskMgmtOperationSelecPanel || this.oOperationData.getTaskTypeId() != 3) break;
                oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
                break;
            }
        }
        super.closeDialog();
        this.isClickOk = true;
    }

    @Override
    public String getPath() {
        DCDebugTracer.trace("SimPackageBrowseDlg getPath");
        return super.getPath();
    }

    public String getFileName() {
        return this.strFileName;
    }

    public void close() {
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        strHelpFileName = ResourceManager.getInstance().getResString("HELP_TOPIC_SELECT_SOFTWARE_FOR_SIMULATION_TASK", "helpmapfile");
        return strHelpFileName;
    }
}

