/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view;

import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDevice;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoOnBoard;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageToLoad;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import com.swimap.iview.commstyle.resource.ResourceMng;

public class RowData {
    private String m_resourceName;
    private int m_devId;
    private int m_nodeType;
    private int m_boardId;
    private String m_boardLabel;
    private String m_softwareName;
    private String m_softwareOldVersion;
    private String m_softwareNewVersion;
    private String m_softwareOriginalVersion = "";
    private String m_softwareUPgradeVersion = "";
    private String m_resourceType = "";
    private int iBoardType;
    private CheckBoxOperation m_toBeLoad = new CheckBoxOperation();
    public static final int NODE_TYPE_IS_DEVICE = 1;
    public static final int NODE_TYPE_IS_BOARD = 2;
    public static final int NODE_TYPE_IS_FILE = 3;
    public static final int NODE_TYPE_IS_RESOURCE = 4;
    private static String[] m_strMethodNames = new String[]{"getResourceName", "getResourceType", "getSoftwareOriginalVersion", "getSoftwareName", "getSoftwareNewVersion", "getToBeLoad"};
    private String m_strClientLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());

    public RowData(int devId, int boardId, Object nodeObject, int nodeType) {
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        if (nodeType == 1) {
            AsnDCSimulationPackageDevice devObject = (AsnDCSimulationPackageDevice)nodeObject;
            this.m_resourceName = new String(devObject.strDeviceName);
            this.m_softwareName = "";
            this.m_softwareOldVersion = "";
            this.m_softwareNewVersion = "";
            this.m_toBeLoad.setIsShow(false);
            this.m_toBeLoad.setIsSelect(false);
            this.m_devId = devObject.iDeviceID.intValue();
            this.m_boardId = -1;
            this.m_nodeType = 1;
            this.m_softwareOriginalVersion = "";
            this.m_softwareUPgradeVersion = new String(devObject.sUpgradeVersion);
        } else if (nodeType == 2) {
            AsnDCSimulationPackageInfoOnBoard boardObject = (AsnDCSimulationPackageInfoOnBoard)nodeObject;
            AsnDCBoardInfo boardInfo = boardObject.oBoardInfo;
            this.m_resourceName = new String(boardInfo.strSlotLabel) + "_" + oDeviceInfoMgr.getBoardNameForT2000(boardInfo.iSlotId.hashCode());
            this.m_boardLabel = new String(boardInfo.strSlotLabel);
            this.m_softwareName = "";
            this.m_softwareOldVersion = "";
            this.m_softwareNewVersion = "";
            this.iBoardType = boardInfo.iBoardType.hashCode();
            this.m_softwareOriginalVersion = new String(boardInfo.sOriginalVersion);
            this.m_softwareUPgradeVersion = new String(boardInfo.sUpgradeVersion);
            String strDisplayName = "";
            if (boardInfo.strBoardType != null) {
                DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(devId);
                strDisplayName = new String(boardInfo.strBoardType);
                strDisplayName = ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), strDisplayName);
            }
            this.m_resourceType = strDisplayName;
            this.m_toBeLoad.setIsShow(false);
            this.m_toBeLoad.setIsSelect(false);
            this.m_devId = devId;
            this.m_boardId = boardInfo.iSlotId.intValue();
            this.m_nodeType = 2;
        } else if (nodeType == 3) {
            AsnDCSimulationPackageToLoad fileObject = (AsnDCSimulationPackageToLoad)nodeObject;
            this.m_resourceName = "";
            this.m_softwareName = new String(fileObject.strFileName);
            this.m_softwareOldVersion = new String(fileObject.strSoftwareOldVersion);
            this.m_softwareNewVersion = new String(fileObject.strSoftwareNewVersion);
            this.m_softwareOriginalVersion = this.m_softwareOldVersion;
            if (this.m_softwareOriginalVersion.length() == 0) {
                this.m_softwareOriginalVersion = "-";
            }
            this.m_toBeLoad.setIsShow(true);
            this.m_toBeLoad.setIsSelect(fileObject.isNeedToLoad);
            this.m_devId = devId;
            this.m_boardId = boardId;
            this.m_nodeType = 3;
        } else {
            Resource resource = (Resource)nodeObject;
            this.m_resourceName = resource.getDeviceName();
            this.m_softwareName = "";
            this.m_softwareOldVersion = "";
            this.m_softwareNewVersion = "";
            this.m_toBeLoad.setIsShow(false);
            this.m_toBeLoad.setIsSelect(false);
            this.m_devId = resource.getDeviceID();
            this.m_boardId = boardId;
            this.m_nodeType = 4;
        }
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public void setResourceType(String m_resourceType) {
        this.m_resourceType = m_resourceType;
    }

    public int getBoardType() {
        return this.iBoardType;
    }

    public void setBoardType(int iBoardType) {
        this.iBoardType = iBoardType;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public void setResourceName(String m_resourceName) {
        this.m_resourceName = m_resourceName;
    }

    public String getBoardLabel() {
        return this.m_boardLabel;
    }

    public void setBoardLabel(String m_boardLabel) {
        this.m_boardLabel = m_boardLabel;
    }

    public int getDevId() {
        return this.m_devId;
    }

    public void setDevId(int m_devId) {
        this.m_devId = m_devId;
    }

    public int getNodeType() {
        return this.m_nodeType;
    }

    public void setNodeType(int m_nodeType) {
        this.m_nodeType = m_nodeType;
    }

    public int getBoardId() {
        return this.m_boardId;
    }

    public void setBoardId(int m_boardId) {
        this.m_boardId = m_boardId;
    }

    public String getSoftwareName() {
        return this.m_softwareName;
    }

    public void setSoftwareName(String m_softwareName) {
        this.m_softwareName = m_softwareName;
    }

    public String getSoftwareOldVersion() {
        return this.m_softwareOldVersion;
    }

    public void setSoftwareOldVersion(String m_softwareOldVersion) {
        this.m_softwareOldVersion = m_softwareOldVersion;
    }

    public String getSoftwareNewVersion() {
        return this.m_softwareNewVersion;
    }

    public void setSoftwareNewVersion(String m_softwareNewVersion) {
        this.m_softwareNewVersion = m_softwareNewVersion;
    }

    public CheckBoxOperation getToBeLoad() {
        return this.m_toBeLoad;
    }

    public static String[] getMethodNames() {
        return m_strMethodNames;
    }

    public String toString() {
        return this.getResourceName();
    }

    public String getSoftwareOriginalVersion() {
        return this.m_softwareOriginalVersion;
    }

    public void setSoftwareOriginalVersion(String runningVersion) {
        this.m_softwareOriginalVersion = runningVersion;
    }

    public String getSoftwareUPgradeVersion() {
        return this.m_softwareUPgradeVersion;
    }

    public void setSoftwareUPgradeVersion(String pgradeVersion) {
        this.m_softwareUPgradeVersion = pgradeVersion;
    }
}

