/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadpatch.view;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ViewLoadPatchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel m_oTableModel;
    private JTable m_oTable;
    private static ResourceManager oResourceManager = ResourceManager.getInstance();
    private final JScrollPane scrollPane;

    public ViewLoadPatchPanel(LoadFileInfoListParam oLoadFileInfoList) {
        this.setLayout(null);
        this.setSize(608, 400);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBounds(22, 30, 578, 327);
        this.add(this.scrollPane);
        int iIndex = 2;
        if (oLoadFileInfoList.isContentTypeRequired()) {
            iIndex = 3;
        }
        String[] arrColNames = new String[iIndex];
        arrColNames[0] = oResourceManager.getResString("SERIAL_NO");
        arrColNames[1] = oResourceManager.getResString("PROGRAM_SELECTION_PROGRAM");
        if (oLoadFileInfoList.isContentTypeRequired()) {
            arrColNames[2] = oResourceManager.getResString("FILE_TYPE");
        }
        this.createTable(arrColNames);
        this.scrollPane.setViewportView(this.m_oTable);
        this.populateDataInTable(oLoadFileInfoList);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private void createTable(String[] arrColNames) {
        this.m_oTableModel = new DefaultTableModel(arrColNames, 0);
        this.m_oTable = new JTable(this.m_oTableModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable.setName("DeviceOperation_ViewLoadPatchPanel_m_oTable");
        this.m_oTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point oPoint = e.getPoint();
                int iRow = ViewLoadPatchPanel.this.m_oTable.rowAtPoint(oPoint);
                int iColumn = ViewLoadPatchPanel.this.m_oTable.columnAtPoint(oPoint);
                String strValue = (String)ViewLoadPatchPanel.this.m_oTableModel.getValueAt(iRow, iColumn);
                ViewLoadPatchPanel.this.m_oTable.setToolTipText(strValue);
            }
        });
    }

    private void populateDataInTable(LoadFileInfoListParam oLoadFileInfoList) {
        int oSizeOfLst = oLoadFileInfoList.getNumberOfFiles();
        Vector<String> oRowDataVec = null;
        String strSequenceNos = null;
        Vector<String> oFileNameVct = new Vector<String>(0);
        for (int i = 0; i < oSizeOfLst; ++i) {
            oRowDataVec = new Vector<String>(3);
            LoadFileInfo oLoadFileInfo = oLoadFileInfoList.getLoadFileInfo(i);
            strSequenceNos = String.valueOf(oLoadFileInfo.getSequenceNo());
            oRowDataVec.add(strSequenceNos);
            oRowDataVec.add(oLoadFileInfo.getFileName());
            if (oLoadFileInfoList.isContentTypeRequired()) {
                oRowDataVec.add(oLoadFileInfo.getContentType().getStrContentType());
            }
            if (oFileNameVct.contains(oLoadFileInfo.getFileName())) continue;
            oFileNameVct.add(oLoadFileInfo.getFileName());
            this.m_oTableModel.addRow(oRowDataVec);
        }
    }
}

