/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadpatch;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.loadpackage.view.PackageBrowseDlg;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.TaskLoadPatchSubOpr;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.view.ViewLoadPatchPanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileSelectionPanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.view.FileTreePanel;
import com.huawei.dc.devicemanagement.model.ContentTypeMgr;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.SoftwareType;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.controller.LoadSoftwareCheckManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.BrowsePanel;
import com.huawei.dc.taskmgmt.view.common.SelectPackagesDlg;
import com.huawei.dc.taskmgmt.view.createtask.IDeviceVersionChangeListener;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LoadPatchOperation
extends OperationAdapter
implements ITaskDeviceOperation,
IDeviceVersionChangeListener {
    private static final long serialVersionUID = 5028864238894651802L;
    private LoadFileInfoListParam m_oLoadParam = new LoadFileInfoListParam();
    private String m_strOperationId = null;
    private boolean m_bIsPauseBeforeCurOp;
    private int m_iOperationId = -1;
    private String m_strOperationDesc = null;
    private String m_strOperationName = null;
    private int m_iDependsOnId = -1;
    private String m_strPreviousTargetVersion = "";
    private List m_oDevDependentLst = null;
    private boolean m_bIselected = false;
    private ITask m_oParentTask;
    private int m_iOperationLevel = -1;
    private IParaList m_oParaList;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char TAB_CHAR = '\t';
    private TaskLoadPatchSubOpr m_oTaskLoadPatchSubOpr = null;
    private transient FileSelectionPanel m_oFileSelectionPanel = null;
    private static final int PATCH = 3;
    private SystemManager m_sysMgr = new SystemManager();
    private transient BrowsePanel browsePan;
    private transient Component oLoadSoftwareView = null;
    private transient SelectPackagesDlg selPackagesDlg;
    private transient Component m_oLoadSimulationPackageView = null;
    private int iInnerTaskTypeId = -1;
    public String m_strTftpPath;
    private int m_iDevID = -1;

    @Override
    public Object getConfiguredPara() {
        return this.m_oLoadParam;
    }

    public List getDependentOperation() {
        return this.m_oDevDependentLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iDependsOnId;
    }

    @Override
    public Component getView(int iContext) {
        if (null == this.m_oParentTask) {
            return null;
        }
        if (this.m_oLoadParam == null) {
            this.m_oLoadParam = new LoadFileInfoListParam();
        }
        DeviceType oDeviceType = this.m_oParentTask.getSelectedDeviceType();
        oDeviceType.setContentTypeMgr(this.updateContentTypeManager());
        this.m_oLoadParam.setDeviceTypeInfoRequired(this.m_oParentTask.isStackDevicePresent(3));
        switch (iContext) {
            case 0: {
                this.oLoadSoftwareView = this.createFileSelectionDialog(oDeviceType);
                break;
            }
            case 1: {
                if (this.m_oParentTask.getDeviceType().getDeviceDomain() == 4) {
                    if (2 == this.m_oParentTask.getTaskTypeId() && ResourceManager.getInstance().isNorthAmericaDevDevType(this.m_oParentTask.getDeviceType().getDeviceTypeID()) && this.m_oParentTask.isThirdPartySupported()) {
                        this.browsePan();
                        break;
                    }
                    this.modifyBrowsePan(oDeviceType);
                    break;
                }
                this.isNotT2000Dev(oDeviceType);
                break;
            }
            case 2: {
                this.oLoadSoftwareView = new ViewLoadPatchPanel(this.m_oLoadParam);
                this.oLoadSoftwareView.setSize(620, 400);
                ViewLoadPatchPanel loadSoftwareView = (ViewLoadPatchPanel)this.oLoadSoftwareView;
                loadSoftwareView.getScrollPane().setBounds(12, 12, 600, 352);
                break;
            }
        }
        return this.oLoadSoftwareView;
    }

    private void browsePan() {
        String filePath = null;
        if (this.m_oLoadParam.getNumberOfFiles() > 0) {
            LoadFileInfo fileInfo = this.m_oLoadParam.getLoadFileInfo(0);
            filePath = fileInfo.getFileName();
        }
        try {
            ExternalFTPInfo[] FTPInfo = this.m_sysMgr.getExternalFTPInfos();
            this.m_strTftpPath = FTPInfo[0].getServerIP();
            this.browsePan = new BrowsePanel(this.m_strTftpPath, ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_MIMIC_PACKAGE"), Integer.parseInt(ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_NUM_MIMIC_PACKAGE")), this.m_oParentTask, null);
            this.browsePan.setBounds(0, 0, 600, 500);
            if (filePath != null && !filePath.equals("")) {
                this.browsePan.setPathFiled(filePath, false);
            }
            this.browsePan.setSelectedPathLabeltBounds(13, 12, 65, 20);
            this.browsePan.setSelectedPathtBounds(80, 12, 480, 20);
            this.browsePan.setUpOneLeveltBounds(564, 12, 30, 20);
            this.browsePan.setTablePaneltBounds(0, 0, 600, 295);
            this.browsePan.setSoftwareSelectTypeLabeltBounds(26, 532, 65, 20);
            this.browsePan.setSelectTypetBounds(82, 532, 777, 20);
            this.oLoadSoftwareView = this.browsePan;
            this.browsePan.setSelectPaneltBounds(10, 39, 590, 330);
            this.browsePan.setTableScrollertBounds(16, 22, 560, 285);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void modifyBrowsePan(DeviceType oDeviceType) {
        String filePath = null;
        String path = null;
        int iLoadFileSize = this.m_oLoadParam.getNumberOfFiles();
        if (iLoadFileSize > 0) {
            LoadFileInfo fileInfo = this.m_oLoadParam.getLoadFileInfo(0);
            filePath = fileInfo.getFileName();
        }
        DCDebugTracer.trace("LoadPatchOperation#modifyBrowsePan#Size:" + iLoadFileSize);
        if (this.browsePan != null && 0 != iLoadFileSize) {
            if (!this.m_oParentTask.getTargetVersion().equals("")) {
                String strPath = "";
                strPath = TargetVersionPathGetter.getTargetVersionDir(oDeviceType, this.m_oParentTask.getTargetVersion(), this.m_oParentTask);
                this.browsePan.setPathFiled(strPath, false);
            }
        } else {
            try {
                path = this.m_sysMgr.getFTSInfo().getRootDirectory();
                this.browsePan = new BrowsePanel(path, ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_MIMIC_PACKAGE"), Integer.parseInt(ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_NUM_MIMIC_PACKAGE")));
                this.browsePan.setBounds(0, 0, 600, 500);
                if (filePath != null && !filePath.equals("")) {
                    this.browsePan.setPathFiled(filePath, false);
                }
                this.browsePan.setSelectedPathLabeltBounds(13, 12, 65, 20);
                this.browsePan.setSelectedPathtBounds(80, 12, 480, 20);
                this.browsePan.setUpOneLeveltBounds(564, 12, 30, 20);
                this.browsePan.setTablePaneltBounds(0, 0, 600, 295);
                this.browsePan.setSoftwareSelectTypeLabeltBounds(26, 532, 65, 20);
                this.browsePan.setSelectTypetBounds(82, 532, 777, 20);
                this.oLoadSoftwareView = this.browsePan;
                this.browsePan.setSelectPaneltBounds(10, 39, 590, 330);
                this.browsePan.setTableScrollertBounds(16, 22, 560, 285);
            }
            catch (DCException ex) {
                DCDebugTracer.trace(ex);
            }
        }
    }

    private void isNotT2000Dev(DeviceType oDeviceType) {
        try {
            this.m_oFileSelectionPanel = new FileSelectionPanel(3, this.m_oLoadParam, this.m_oParentTask, this.getStackDeviceTypeList());
            this.m_oFileSelectionPanel.setContext(1);
            this.m_oFileSelectionPanel.setBounds(9, 4, 602, 375);
            this.m_oFileSelectionPanel.getFileTablePanel().setPreferredSize(new Dimension(311, 150));
            if (null != this.m_oFileSelectionPanel.getFileTreePanel()) {
                this.m_oFileSelectionPanel.getFileTreePanel().setPreferredSize(new Dimension(240, 150));
            }
            boolean bisPatchTask = true;
            TaskMgmtOperationSelecPanel oTaskMgmtOperationPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
            String strTargetVersion = null != this.m_oParentTask.getTargetVersion() ? this.m_oParentTask.getTargetVersion() : oTaskMgmtOperationPanel.getSelectedTragetVersion();
            String strRootPath = this.m_sysMgr.getFTSInfo().getRootDirectory();
            String strFileSeperator = File.separator;
            String strPath = strRootPath + strFileSeperator + DCConstants.SAM_PATH;
            FileTreePanel oFileTreePanel = DCFrameWorkUtil.getFileTreePanel();
            if (null != oFileTreePanel) {
                int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(this.m_oParentTask);
                oFileTreePanel.setIsDMSDevice(iDeviceDomain == 2);
                oFileTreePanel.setSlaveDeviceTypeInfoList(this.getStackDeviceTypeList());
                if (0 == this.m_oLoadParam.getLoadFileInfoList().size()) {
                    oFileTreePanel.setTreePath(strPath, oDeviceType, strTargetVersion, bisPatchTask, true);
                }
            }
            this.oLoadSoftwareView = this.m_oFileSelectionPanel;
        }
        catch (DCException e) {
            DCDebugTracer.trace("DC::LoadPatchOperation::getView::throw exception::" + e.getMessage());
            DCDebugTracer.trace(e);
        }
    }

    protected Component createFileSelectionDialog(DeviceType oDeviceType) {
        boolean bisPatchOperationType = true;
        DCModalDialog oDlg = null;
        if (null == this.m_oLoadParam) {
            return null;
        }
        if (!this.m_strPreviousTargetVersion.equals(this.m_oParentTask.getTargetVersion())) {
            this.m_oLoadParam.getLoadFileInfoList().clear();
        }
        DeviceTypeInfo devTypeInfo = new DeviceTypeInfo();
        devTypeInfo.setDevTypeID(oDeviceType.getDeviceTypeID());
        if (this.m_oParentTask.getDeviceType().getDeviceDomain() == 4) {
            try {
                if (ResourceManager.getInstance().isNorthAmericaDevDevType(devTypeInfo) && this.m_oParentTask.isThirdPartySupported()) {
                    oDlg = new SelectPackagesDlg(this.m_oParentTask, this, this.m_oLoadParam, 2);
                    return oDlg;
                }
                PackageBrowseDlg oSelectDlg = new PackageBrowseDlg(this, this.m_oLoadParam, ResourceManager.getInstance().getResString("LOAD_PACKAGE_DIALOG_TITLE"), this.m_oParentTask);
                oDlg = oSelectDlg;
                if (!this.m_oParentTask.getTargetVersion().equals("")) {
                    String strPath = "";
                    strPath = TargetVersionPathGetter.getTargetVersionDir(oDeviceType, this.m_oParentTask.getTargetVersion(), this.m_oParentTask);
                    oSelectDlg.getBrowsePanel().setPathFiled(strPath, false);
                } else {
                    List<LoadFileInfo> oLoadFileInfoLst;
                    LoadFileInfoListParam oLoadFileInfoListParam = this.m_oParentTask.getLoadFileInfoListParam();
                    if (null != oLoadFileInfoListParam && null != (oLoadFileInfoLst = oLoadFileInfoListParam.getLoadFileInfoList()) && oLoadFileInfoLst.size() == 1) {
                        String strPath = oLoadFileInfoLst.get(0).getFileName();
                        oSelectDlg.getBrowsePanel().setPathFiled(strPath, false);
                    }
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        } else {
            try {
                String strTargetVersion;
                int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(this.m_oParentTask);
                this.m_oFileSelectionPanel = new FileSelectionPanel(3, this.m_oLoadParam, this.m_oParentTask, this.getStackDeviceTypeList());
                this.m_oFileSelectionPanel.setContext(0);
                oDlg = new FileSelectionDialog(this.m_oFileSelectionPanel, this.m_oLoadParam, ResourceManager.getInstance().getResString("LOAD_PATCH_DIALOG_TITLE"), null, this.m_oParentTask);
                ((FileSelectionDialog)oDlg).setIsDMSDevice(iDeviceDomain == 2);
                if (0 != this.m_oLoadParam.getLoadFileInfoList().size()) {
                    return oDlg;
                }
                TaskMgmtOperationSelecPanel oTaskMgmtOperationPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
                oTaskMgmtOperationPanel.addDeviceVersionChangelistener(this);
                if (null != this.m_oParentTask.getTargetVersion()) {
                    strTargetVersion = this.m_oParentTask.getTargetVersion();
                    this.m_strPreviousTargetVersion = this.m_oParentTask.getTargetVersion();
                } else {
                    strTargetVersion = oTaskMgmtOperationPanel.getSelectedTragetVersion();
                }
                String strRootPath = this.m_sysMgr.getFTSInfo().getRootDirectory();
                String strFileSeperator = File.separator;
                String strPath = "";
                strPath = strRootPath.startsWith("/") ? strRootPath + strFileSeperator + DCConstants.SAM_PATH_NOWIN : strRootPath + strFileSeperator + DCConstants.SAM_PATH;
                FileTreePanel oFileTreePanel = DCFrameWorkUtil.getFileTreePanel();
                if (null != oFileTreePanel) {
                    oFileTreePanel.setIsDMSDevice(iDeviceDomain == 2);
                    oFileTreePanel.setSlaveDeviceTypeInfoList(this.getStackDeviceTypeList());
                    oFileTreePanel.setTreePath(strPath, oDeviceType, strTargetVersion, bisPatchOperationType, true);
                }
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCDebugTracer.trace("DC::LoadPatchOperation::createFileSelectionDialog()::throw exception::" + e.getMessage());
            }
        }
        return oDlg;
    }

    private ContentTypeMgr updateContentTypeManager() {
        List parameterValueList;
        int iSize;
        IOperationPara oContentTypeParameter;
        ContentTypeMgr oContentTypeMnger = new ContentTypeMgr();
        SoftwareType oSoftwareType = new SoftwareType();
        if (null != this.m_oParaList && 0 != this.m_oParaList.getNumOfParam() && null != (oContentTypeParameter = this.m_oParaList.getParameter("ContentType")) && 0 < (iSize = (parameterValueList = oContentTypeParameter.getParameterValueList()).size())) {
            for (int iParaValueIndex = 0; iParaValueIndex < iSize; ++iParaValueIndex) {
                String strContentTypeName = ((ParaValue)parameterValueList.get(iParaValueIndex)).getDisplayName();
                int value = ((ParaValue)parameterValueList.get(iParaValueIndex)).getValue();
                String strId = ((ParaValue)parameterValueList.get(iParaValueIndex)).getId();
                oSoftwareType.addContentDataType(value, strContentTypeName, strId);
            }
        }
        oContentTypeMnger.setSoftwareType(oSoftwareType);
        return oContentTypeMnger;
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bIsPauseBeforeCurOp;
    }

    @Override
    public boolean isSelected() {
        return this.m_bIselected;
    }

    public void setDependentOperation(List oDevDependentLst) {
        this.m_oDevDependentLst = oDevDependentLst;
    }

    @Override
    public void setDependsOnOperation(int oDevOpDependsOnId) {
        this.m_iDependsOnId = oDevOpDependsOnId;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean isPauseBeforeCurOp) {
        this.m_bIsPauseBeforeCurOp = isPauseBeforeCurOp;
    }

    @Override
    public void setOperationData(ITask oTask) {
        this.m_oParentTask = oTask;
    }

    public ITask getTaskObj() {
        return this.m_oParentTask;
    }

    @Override
    public void setSelected(boolean isEnabled) {
        this.m_bIselected = isEnabled;
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        boolean bAnyFileSelected = false;
        if (this.m_oParentTask.getDeviceType().getDeviceDomain() == 4) {
            if (this.oLoadSoftwareView instanceof BrowsePanel) {
                BrowsePanel oBrowsePan = (BrowsePanel)this.oLoadSoftwareView;
                String selectFilePath = oBrowsePan.getSelectPath().getText();
                if (selectFilePath != null && selectFilePath.lastIndexOf(".") != -1) {
                    LoadFileInfo selectFile = new LoadFileInfo();
                    selectFile.setFileName(selectFilePath);
                    selectFile.setSequenceNo(1);
                    LoadFileInfo[] selectFileArray = new LoadFileInfo[]{selectFile};
                    this.m_oLoadParam.clearAllFilesFromList();
                    this.m_oLoadParam.addServerFiles(selectFileArray);
                    this.m_oParentTask.setLoadFileInfoListParam(this.m_oLoadParam);
                    bAnyFileSelected = true;
                }
            } else {
                LoadFileInfoListParam ofileInfoParam = this.m_oParentTask.getLoadFileInfoListParam();
                if (null != ofileInfoParam && ofileInfoParam.getLoadFileInfoList() != null && ofileInfoParam.getLoadFileInfoList().size() != 0) {
                    bAnyFileSelected = true;
                }
            }
        } else {
            if (null == this.m_oFileSelectionPanel) {
                oValidationResult = this.checkIfDefaultPatchFilesAvailable();
                return oValidationResult;
            }
            if (1 == this.m_oFileSelectionPanel.getContext()) {
                LoadFileInfo[] arrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
                if (null != arrServerFiles) {
                    for (int count = 0; count < arrServerFiles.length; ++count) {
                        if (!Collator.getInstance().equals(arrServerFiles[count].getFileName().trim(), "")) continue;
                        this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                        oValidationResult.setErrorCode(-1);
                        oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("ENTER_FILE_NAME"));
                        return oValidationResult;
                    }
                }
                if (null != arrServerFiles && 0 < arrServerFiles.length) {
                    arrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
                    this.m_oLoadParam.clearAllFilesFromList();
                    this.m_oLoadParam.addServerFiles(arrServerFiles);
                    List<LoadFileInfo> oFileList = this.m_oLoadParam.getLoadFileInfoList();
                    if (null != oFileList && 0 < oFileList.size()) {
                        bAnyFileSelected = true;
                    }
                }
            } else {
                List<LoadFileInfo> oFileList = this.m_oLoadParam.getLoadFileInfoList();
                if (null != oFileList && 0 < oFileList.size()) {
                    bAnyFileSelected = true;
                }
            }
        }
        if (!bAnyFileSelected) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_PATCH_SELECTED"));
        } else if (this.oLoadSoftwareView instanceof FileSelectionPanel) {
            int iDeviceDomain = DeviceInfoUtil.getDeviceDomain(this.m_oParentTask);
            LoadFileInfo[] oArrServerFiles = this.m_oFileSelectionPanel.getFileTablePanel().getFilesFromTable();
            for (int count = 0; count < oArrServerFiles.length; ++count) {
                if (Collator.getInstance().equals(oArrServerFiles[count].getFileName().trim(), "")) {
                    this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                    oValidationResult.setErrorCode(-1);
                    oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("ENTER_FILE_NAME"));
                    return oValidationResult;
                }
                if (!oArrServerFiles[count].getFileName().contains(" ") || !this.m_oFileSelectionPanel.isDMSDevice()) continue;
                this.m_oFileSelectionPanel.getFileTablePanel().getFileTable().setRowSelectionInterval(count, count);
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("BROWSEDLG_SELECT_FILE_BLANK_SPACE"));
                return oValidationResult;
            }
            if (2 == iDeviceDomain && !this.m_oParentTask.isThirdPartySupported()) {
                LoadFileInfoListParam oLoadParam = new LoadFileInfoListParam();
                for (int i = 0; i < oArrServerFiles.length; ++i) {
                    LoadFileInfo oFileInfo = oArrServerFiles[i];
                    if (!oFileInfo.getContentType().getId().equals("PATCH")) continue;
                    oLoadParam.addServerFile(oArrServerFiles[i]);
                }
                if (0 != oLoadParam.getNumberOfFiles()) {
                    oValidationResult = LoadSoftwareCheckManager.getInstance().validateLoadSoftwareFiles(this.m_oParentTask, oLoadParam);
                }
                this.m_oLoadParam.clearAllFilesFromList();
                this.m_oLoadParam.addServerFiles(oArrServerFiles);
                if (null != this.m_oFileSelectionPanel.getStartupConfigPanel()) {
                    LoadFileInfoListParam oDeviceLoadParam = this.m_oFileSelectionPanel.getStartupConfigPanel().getDeviceLevelLoadConfigParam();
                    List<LoadFileInfo> oDeviceLoadFileList = oDeviceLoadParam.getLoadFileInfoList();
                    this.m_oLoadParam.addDeviceLevelFile(oDeviceLoadFileList);
                }
            } else {
                oValidationResult.setErrorCode(0);
            }
        } else {
            oValidationResult.setErrorCode(0);
        }
        return oValidationResult;
    }

    private ValidationResult checkIfDefaultPatchFilesAvailable() {
        ValidationResult oResult = new ValidationResult();
        String strTargetVersion = this.m_oParentTask.getTargetVersion();
        if (null == strTargetVersion || "".equalsIgnoreCase(strTargetVersion) || this.m_oParentTask.isThirdPartySupported()) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_PATCH_SELECTED"));
            return oResult;
        }
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(this.m_oParentTask.getSelectedDeviceType().getDeviceTypeID(), this.m_oParentTask.getSelectedDeviceType().getDeviceTypeVersionID());
        oSAMFileInfo.setDeviceTypeInfo(oDeviceTypeInfo);
        oSAMFileInfo.setVersion(strTargetVersion);
        boolean isDefaultFilePresent = SAMManager.getInstance().isLoadPatchFilesPresent(oSAMFileInfo);
        if (!isDefaultFilePresent) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_PATCH_SELECTED"));
        }
        return oResult;
    }

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationId;
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setOPerationParaList(IParaList oParaList) {
        this.m_oParaList = oParaList;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOperationId(int iOperationId) {
        this.m_iOperationId = iOperationId;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationId = strOperationId;
    }

    @Override
    public void setOperationLevel(int iOperationLevel) {
        this.m_iOperationLevel = iOperationLevel;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    @Override
    public String toString() {
        StringBuffer strRetVal = new StringBuffer(0);
        List<LoadFileInfo> oFileList = this.m_oLoadParam.getLoadFileInfoList();
        if (null == oFileList || 0 == oFileList.size()) {
            return strRetVal.toString();
        }
        int iFileCount = oFileList.size();
        strRetVal.append(LINE_SEPARATOR);
        strRetVal.append("  ");
        strRetVal.append(ResourceManager.getInstance().getResString("LOAD_PATCH_FILE_LIST"));
        for (int i = 0; i < iFileCount; ++i) {
            LoadFileInfo oFile = oFileList.get(i);
            strRetVal.append("<br>");
            strRetVal.append('\t');
            strRetVal.append(oFile.getAbsoluteFilePath());
        }
        return strRetVal.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_oLoadParam = new LoadFileInfoListParam();
        in.defaultReadObject();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
    }

    @Override
    public void deviceVersionChangeNotification(String strDevVersion) {
        int iConfirm = -1;
        if (!this.isSelected()) {
            return;
        }
        if (this.m_strPreviousTargetVersion.equals(strDevVersion) && this.m_oLoadParam.getNumberOfFiles() > 0) {
            return;
        }
        if (this.m_oParentTask.getTaskTypeId() == 2) {
            if (this.m_oParentTask.getTargetVersion().equals("")) {
                return;
            }
            TaskMgmtOperationSelecPanel taskMgmtOperationSelecPanel = (TaskMgmtOperationSelecPanel)ObjectStore.getInstance().getObjectInstance("TaskMgmtOperationSelectionPanel");
            taskMgmtOperationSelecPanel.setAutoChange(true);
            iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TARGET_VERSION_CHANGE_CONFIRNMATION"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (0 != iConfirm) {
                ComboBoxWithToolTip comboBoxWithToolTip = (ComboBoxWithToolTip)taskMgmtOperationSelecPanel.getTargetVersionComboBox();
                taskMgmtOperationSelecPanel.setAutoChange(true);
                comboBoxWithToolTip.setSelectedIndex(comboBoxWithToolTip.getSelectVerIndex(this.m_strPreviousTargetVersion));
                taskMgmtOperationSelecPanel.setAutoChange(false);
                this.m_oParentTask.setTargetVersion(this.m_strPreviousTargetVersion);
                comboBoxWithToolTip.repaint();
                return;
            }
            taskMgmtOperationSelecPanel.setAutoChange(true);
            this.getView(0).setVisible(true);
            return;
        }
        if (0 != this.m_oLoadParam.getNumberOfFiles()) {
            iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TARGET_VERSION_CHANGE_CONFIRNMATION"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            this.m_oLoadParam.clearAllFilesFromList();
        }
        if (0 != iConfirm) {
            return;
        }
    }

    @Override
    public boolean isConfigReq() {
        return true;
    }

    private List<DeviceTypeInfo> getStackDeviceTypeList() {
        ArrayList<DeviceTypeInfo> oDevTypeInfoLst = new ArrayList<DeviceTypeInfo>(0);
        if (this.m_oParentTask.isStackDevicePresent(3)) {
            THashSet<Resource> oResList = this.m_oParentTask.getDeviceType().getResources();
            Iterator oResItor = oResList.iterator();
            Resource oRes = null;
            while (oResItor.hasNext()) {
                oRes = (Resource)oResItor.next();
                DeviceTypeInfo oDevTypeInfo = oRes.getStackDevTypeInfo();
                if (null == oDevTypeInfo || oDevTypeInfoLst.contains(oDevTypeInfo)) continue;
                oDevTypeInfoLst.add(oDevTypeInfo);
            }
        }
        return oDevTypeInfoLst;
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        this.m_oTaskLoadPatchSubOpr = new TaskLoadPatchSubOpr(this, this.m_oParentTask);
        return this.m_oTaskLoadPatchSubOpr;
    }

    @Override
    public ArrayList getOperationIDnName() {
        ArrayList<Object> oData = new ArrayList<Object>();
        oData.add(this.getOperationName());
        oData.add(this.getOperationId());
        return oData;
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oTaskLoadPatchSubOpr = null;
    }

    public ITask getParentTask() {
        return this.m_oParentTask;
    }

    @Override
    public String getCurrentContext() {
        String sCurrentContext = "";
        if (null == this.m_oParentTask) {
            return "";
        }
        int iTaskTypeID = this.m_oParentTask.getTaskTypeId();
        switch (iTaskTypeID) {
            case 2: {
                sCurrentContext = "HELP_TOPIC_PATCH_U_LOAD_PATCH";
                break;
            }
        }
        return sCurrentContext;
    }

    public void setDevID(int iDevID) {
        this.m_iDevID = iDevID;
    }

    public int getDevID() {
        return this.m_iDevID;
    }

    public void setPreviousTargetversion(String strPreviousTargetversion) {
        this.m_strPreviousTargetVersion = strPreviousTargetversion;
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }
}

