/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loadpackage.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.common.BrowseDlg;
import java.awt.Component;
import java.io.File;
import java.text.Collator;
import java.util.List;

public class PackageBrowseDlg
extends BrowseDlg {
    private static final long serialVersionUID = -2322084249898222836L;
    private LoadFileInfoListParam m_oLoadParam = null;
    private static final int BROWSEDLG_MODEL_NAME = 1;
    private LoadSoftwareOperation loadSimuPackageOp;
    private LoadPatchOperation loadPatchPackageOp;
    private boolean isSimuPackage = true;
    private boolean isClickOk = false;
    private ITask iTask = null;

    public PackageBrowseDlg(ITaskDeviceOperation oTaskOp, LoadFileInfoListParam oLoadParam, String strTitle, ITask oTaskObj) throws DCException {
        super(oTaskObj, null);
        if (oTaskOp instanceof LoadSoftwareOperation) {
            this.loadSimuPackageOp = (LoadSoftwareOperation)oTaskOp;
        } else {
            this.loadPatchPackageOp = (LoadPatchOperation)oTaskOp;
            this.isSimuPackage = false;
        }
        this.m_oLoadParam = oLoadParam;
        this.iTask = oTaskObj;
        this.setTitle(strTitle);
    }

    @Override
    protected void setPath() {
        int targetFileServerType = 0;
        String strThirdPartyServerName = "";
        if (null != this.oOperationData.getThirdPartyServerName() && !"".equals(this.oOperationData.getThirdPartyServerName()) && this.oOperationData.isThirdPartySupported()) {
            targetFileServerType = 1;
            strThirdPartyServerName = this.oOperationData.getThirdPartyServerName();
        }
        this.m_strTftpPath = new SystemManager().getBrowseFileDir(targetFileServerType, strThirdPartyServerName);
    }

    @Override
    public void setFilterFileType() {
        this.filterFileType = ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_PACKAGE");
    }

    @Override
    public void setFileTypeNum() {
        this.fileTypeNum = Integer.parseInt(ResourceManager.getInstance().getResString("FILTER_FILE_TYPE_NUM_PACKAGE"));
    }

    @Override
    protected void okButtonActionPerformed() {
        String path;
        String strFileName;
        int iSelectedRow = this.m_oTable.getSelectedRow();
        if (-1 == iSelectedRow) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        String systemRoot = this.m_sysMgr.getFTSInfo().getRootDirectory();
        String systemSAMRoot = systemRoot + File.separatorChar + "load" + File.separatorChar;
        DirListNode node = (DirListNode)this.m_oTableModel.getValueAt(iSelectedRow, 1);
        if (node == null) {
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE");
            DCOptionPane.showMessageDialog((Component)((Object)this), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (node.m_bIsDirectory) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("BROWSEDLG_SELECT_FILE"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        String strSelectedPath = super.getPath();
        if (!strSelectedPath.endsWith(strFileName = node.m_strName)) {
            super.getBrowsePanel().getSelectPath().setText(strSelectedPath + "/" + strFileName);
        }
        if ((path = super.getPath()).equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_LOAD_FILE_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        TaskMgmtOperationSelecPanel taskMgmtOperationSelecPanel = (TaskMgmtOperationSelecPanel)ObjectStore.getInstance().getObjectInstance("TaskMgmtOperationSelectionPanel");
        ComboBoxWithToolTip comboBoxWithToolTip = null;
        if (taskMgmtOperationSelecPanel != null) {
            comboBoxWithToolTip = (ComboBoxWithToolTip)taskMgmtOperationSelecPanel.getTargetVersionComboBox();
            comboBoxWithToolTip.setName("DeviceOperation_PackageBrowseDlg_comboBoxWithToolTip");
        }
        LoadFileInfo[] fileList = new LoadFileInfo[1];
        if (this.isSimuPackage) {
            this.setSimuPackagePara(systemSAMRoot, path, comboBoxWithToolTip, fileList);
        } else {
            fileList[0] = new LoadFileInfo();
            fileList[0].setSequenceNo(1);
            fileList[0].setFileName(path);
            this.m_oLoadParam.clearAllFilesFromList();
            this.m_oLoadParam.addServerFiles(fileList);
            this.loadPatchPackageOp.getParentTask().setLoadFileInfoListParam(this.m_oLoadParam);
            this.loadPatchPackageOp.setPreviousTargetversion(this.loadPatchPackageOp.getParentTask().getTargetVersion());
        }
        String strTargetVer = "";
        if (null != this.loadSimuPackageOp) {
            strTargetVer = this.loadSimuPackageOp.getOperationData().getTargetVersion();
        } else if (null != this.loadPatchPackageOp) {
            this.iTask = this.loadPatchPackageOp.getTaskObj();
            if (null != this.iTask) {
                strTargetVer = this.iTask.getTargetVersion();
            }
        }
        if (!StringUtils.isNullOrEmptyStr(strTargetVer)) {
            LoadFileInfo oLoadFileInfo;
            String strFilePath;
            LoadFileInfoListParam m_oLoadParamtmp = new LoadFileInfoListParam();
            m_oLoadParamtmp = this.m_oLoadParam;
            List<LoadFileInfo> strFilePathLst = this.m_oLoadParam.getLoadFileInfoList();
            String strTargetFilePath = TargetVersionPathGetter.getTargetVersionDir(this.iTask.getDeviceType(), strTargetVer, this.iTask);
            for (int index = 0; index < strFilePathLst.size() && !StringUtils.isNullOrEmptyStr(strFilePath = (oLoadFileInfo = strFilePathLst.get(index)).getFileName()); ++index) {
                if (strFilePath.contains(",")) {
                    strFilePath = strFilePath.substring(0, strFilePath.indexOf(","));
                }
                if (strFilePath.equalsIgnoreCase(strTargetFilePath)) continue;
                int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("FILEPATH_IS_NOT_TARGETVERSIONFILEPATH"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                if (iConfirm != 0) {
                    return;
                }
                TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
                if (null == oTaskMgmtOperationSelecPanel) break;
                oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
                if (this.m_oLoadParam.getLoadFileInfoList().get(index).getFileName().length() <= 0) {
                    this.m_oLoadParam.addServerFiles(fileList);
                }
                if (null != this.loadSimuPackageOp) {
                    this.loadSimuPackageOp.getOperationData().setLoadFileInfoListParam(m_oLoadParamtmp);
                    break;
                }
                if (null == this.loadPatchPackageOp) break;
                this.loadPatchPackageOp.getParentTask().setLoadFileInfoListParam(m_oLoadParamtmp);
                break;
            }
        }
        this.isClickOk = true;
        this.dispose(true);
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        super.cancelButton_ActionPerformed();
        this.dispose(false);
    }

    private void setSimuPackagePara(String systemSAMRoot, String path, ComboBoxWithToolTip comboBoxWithToolTip, LoadFileInfo[] fileList) {
        if ((this.loadSimuPackageOp.getOperationData().getTaskTypeId() == 5 || this.loadSimuPackageOp.getOperationData().getTaskTypeId() == 12) && this.loadSimuPackageOp.getOperationData().getActivationInfo() != null) {
            if (this.loadSimuPackageOp.getOperationData().getLoadFileInfoListParam() != null) {
                this.m_oLoadParam = this.loadSimuPackageOp.getOperationData().getLoadFileInfoListParam();
                LoadFileInfo fileInfo = this.m_oLoadParam.getLoadFileInfo(0);
                if (!Collator.getInstance().equals(path, fileInfo.getFileName())) {
                    int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOAD_PACKAGE_OPERATION_UPDATE"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                    if (0 == iConfirm) {
                        fileList[0] = new LoadFileInfo();
                        fileList[0].setSequenceNo(1);
                        fileList[0].setFileName(path);
                        fileList[0].setContentType(new ContentType(25, ResourceManager.getInstance().getResString("PACKAGE_FILE")));
                        this.m_oLoadParam.clearAllFilesFromList();
                        this.m_oLoadParam.addServerFiles(fileList);
                        this.loadSimuPackageOp.getOperationData().setLoadFileInfoListParam(this.m_oLoadParam);
                        this.loadSimuPackageOp.setPreviousTargetversion(this.loadSimuPackageOp.getOperationData().getTargetVersion());
                        if (path.indexOf(systemSAMRoot) < 0 && comboBoxWithToolTip != null) {
                            comboBoxWithToolTip.repaint();
                            comboBoxWithToolTip.setSelectedIndex(0);
                        }
                    } else if (comboBoxWithToolTip != null && comboBoxWithToolTip.getSelectedIndex() > 0) {
                        if (fileInfo.getFileName().indexOf(systemSAMRoot) > -1) {
                            if (!this.loadSimuPackageOp.getOperationData().getTargetVersion().endsWith(comboBoxWithToolTip.getSelectedItem().toString())) {
                                comboBoxWithToolTip.setSelectedIndex(comboBoxWithToolTip.getOldSelectIndex());
                            }
                        } else {
                            comboBoxWithToolTip.setSelectedIndex(0);
                        }
                        comboBoxWithToolTip.repaint();
                    }
                }
            }
        } else {
            fileList[0] = new LoadFileInfo();
            fileList[0].setSequenceNo(1);
            fileList[0].setFileName(path);
            fileList[0].setContentType(new ContentType(25, ResourceManager.getInstance().getResString("PACKAGE_FILE")));
            this.m_oLoadParam.clearAllFilesFromList();
            this.m_oLoadParam.addServerFiles(fileList);
            this.loadSimuPackageOp.getOperationData().setLoadFileInfoListParam(this.m_oLoadParam);
            this.loadSimuPackageOp.setPreviousTargetversion(this.loadSimuPackageOp.getOperationData().getTargetVersion());
        }
    }

    @Override
    public String getPath() {
        DCDebugTracer.trace("PackageBrowseDlg getPath");
        return super.getPath();
    }

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        strHelpFileName = ResourceManager.getInstance().getResString("HELP_TOPIC_SELECT_SOFTWARE_FOR_PACKAGE_TASK", "helpmapfile");
        return strHelpFileName;
    }

    public boolean isClickOk() {
        return this.isClickOk;
    }

    public void dispose(boolean bOKButton) {
        TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
        if (null != oTaskMgmtOperationSelecPanel) {
            if (!bOKButton && !TaskInfoUtil.isTargerVerEqualSelectFile(this.iTask)) {
                oTaskMgmtOperationSelecPanel.updateTargetVsnBlank();
            }
            oTaskMgmtOperationSelecPanel.setAutoChange(false);
        }
        super.dispose();
    }
}

