/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loaddata;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ViewLoadDataPanel
extends JPanel {
    private DefaultTableModel m_oTableModel;
    private JTable m_oTable;
    private ITask m_oTaskDataObj = null;
    private ResourceManager oResourceManager = ResourceManager.getInstance();
    private JScrollPane m_oScrollPane;

    public ViewLoadDataPanel(LoadFileInfoListParam oLoadFileInfoList, ITask oTaskDatObj) {
        this.setLayout(null);
        this.setSize(608, 400);
        this.m_oScrollPane = new JScrollPane();
        this.setScrollPaneBounds(22, 30, 578, 327);
        this.add(this.m_oScrollPane);
        this.m_oTaskDataObj = oTaskDatObj;
        Object[] arrColNames = new String[7];
        arrColNames[0] = this.oResourceManager.getResString("SL_NO");
        arrColNames[1] = this.oResourceManager.getResString("DEVICE_NAME");
        arrColNames[2] = this.oResourceManager.getResString("DEVICE_IP");
        arrColNames[3] = this.oResourceManager.getResString("DEVICE_TYPE");
        arrColNames[4] = this.oResourceManager.getResString("CURRENT_VERSION");
        arrColNames[5] = this.oResourceManager.getResString("FILE_NAME");
        if (oLoadFileInfoList.isContentTypeRequired()) {
            arrColNames[6] = this.oResourceManager.getResString("FILE_TYPE");
        }
        this.m_oTableModel = new DefaultTableModel(arrColNames, 0);
        this.m_oTable = new JTable(this.m_oTableModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable.setName("DeviceOperation_ViewLoadDataPanel_m_oTable");
        this.m_oTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point oPoint = e.getPoint();
                int iRow = ViewLoadDataPanel.this.m_oTable.rowAtPoint(oPoint);
                int iColumn = ViewLoadDataPanel.this.m_oTable.columnAtPoint(oPoint);
                String strValue = (String)ViewLoadDataPanel.this.m_oTableModel.getValueAt(iRow, iColumn);
                ViewLoadDataPanel.this.m_oTable.setToolTipText(strValue);
            }
        });
        this.m_oTable.setRowHeight(21);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
        this.m_oScrollPane.setViewportView(this.m_oTable);
        this.populateDataInTable(oLoadFileInfoList);
    }

    void setScrollPaneBounds(int x, int y, int w, int h) {
        this.m_oScrollPane.setBounds(x, y, w, h);
    }

    private void populateDataInTable(LoadFileInfoListParam oLoadFileInfoList) {
        int oSizeOfLstFile = oLoadFileInfoList.getNumberOfFiles();
        DeviceType oDeviceType = this.m_oTaskDataObj.getSelectedDeviceType();
        String strDeviceType = oDeviceType.getDeviceTypeName() + '(' + oDeviceType.getDeviceTypeVersionName() + ')';
        THashSet<Resource> oResourceLst = oDeviceType.getResources();
        Resource[] oRes = (Resource[])oResourceLst.toArray((Object[])new Resource[oResourceLst.size()]);
        Resource oResource = null;
        String strSequenceNos = null;
        Vector<String> oRowDataVec = null;
        LoadFileInfo oLoadFileInfo = null;
        for (int i = 0; i < oSizeOfLstFile; ++i) {
            oRowDataVec = new Vector<String>(5);
            oResource = oRes[i];
            for (int j = 0; j < oSizeOfLstFile; ++j) {
                oLoadFileInfo = oLoadFileInfoList.getLoadFileInfo(j);
                if (oResource.getDeviceID() == oLoadFileInfo.getDeviceId()) break;
            }
            if (null == oLoadFileInfo) {
                DCDebugTracer.trace("Do not found oResource load file info : " + oResource.getDeviceName());
                continue;
            }
            int iSequenceNos = i + 1;
            strSequenceNos = String.valueOf(iSequenceNos);
            oRowDataVec.add(strSequenceNos);
            oRowDataVec.add(oResource.getDeviceName());
            oRowDataVec.add(oResource.getDeviceIP());
            oRowDataVec.add(strDeviceType);
            oRowDataVec.add(oResource.getDeviceVersion());
            if (oLoadFileInfo.isLoadDefaultFile()) {
                oRowDataVec.add(ResourceManager.getInstance().getResString("DEFAULT_FILE"));
            } else {
                oRowDataVec.add(oLoadFileInfo.getFileName());
            }
            if (oLoadFileInfoList.isContentTypeRequired()) {
                oRowDataVec.add(oLoadFileInfo.getContentType().getStrContentType());
            }
            this.m_oTableModel.addRow(oRowDataVec);
        }
    }
}

