/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loaddata;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LoadDataOperationPanel
extends JPanel {
    private static final int FIFTH_COLUMN = 5;
    private static final int FOURTH_COLUMN = 4;
    private static final long serialVersionUID = 1L;
    private boolean m_bIsContentTypeRequired;
    private boolean m_bIsDependentOnUpdate = false;
    private LoadDataOperation m_oLoadDataOperation;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private JScrollPane m_oScrollPane;
    private JTable m_oTable;
    private DefaultTableModel m_oTableModel;
    private String m_strUpgradeType = null;
    private boolean m_isLoadFileFormThirdFTP = false;

    public LoadDataOperationPanel(LoadDataOperation oLoadDataOperation, boolean bIsDependentOnUpdate, boolean isLoadFileFromThirdFTP) {
        this.m_isLoadFileFormThirdFTP = isLoadFileFromThirdFTP;
        this.m_oLoadDataOperation = oLoadDataOperation;
        this.m_bIsDependentOnUpdate = bIsDependentOnUpdate;
        this.m_bIsContentTypeRequired = ((LoadFileInfoListParam)this.m_oLoadDataOperation.getConfiguredPara()).isContentTypeRequired();
        this.setLayout(null);
        this.initScrollPane();
        if (null != this.m_oLoadDataOperation.getOperationData().getTaskContentType()) {
            this.m_strUpgradeType = this.m_oLoadDataOperation.getOperationData().getTaskContentType().getId();
        }
    }

    private void addRow(THashSet<Resource> oResourceList, LoadFileInfoListParam oConfiguredPara, int iIndex) {
        Iterator oResItor = oResourceList.iterator();
        int iFlag = 0;
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (iFlag == iIndex) break;
            oResource = null;
            ++iFlag;
        }
        if (null == oResource) {
            return;
        }
        LoadFileInfo oLoadFileInfo = null;
        if (null != oConfiguredPara.getLoadFileInfoList()) {
            int fileSize = oConfiguredPara.getLoadFileInfoList().size();
            for (int i = 0; i < fileSize; ++i) {
                if (oResource.getDeviceID() != oConfiguredPara.getLoadFileInfoList().get(i).getDeviceId()) continue;
                oLoadFileInfo = oConfiguredPara.getLoadFileInfoList().get(i);
                break;
            }
        } else {
            oLoadFileInfo = oConfiguredPara.getLoadFileInfo(iIndex);
        }
        Vector<Object> oRowData = new Vector<Object>(8);
        oRowData.add(oResource.getDeviceID());
        oRowData.add("" + (iIndex + 1));
        oRowData.add(oResource.getDeviceName());
        oRowData.add(oResource.getDeviceIP());
        oRowData.add(oResource.getDeviceVersion());
        if (this.m_bIsContentTypeRequired) {
            oRowData.add(oLoadFileInfo.getContentType());
        }
        if (!oLoadFileInfo.isLoadDefaultFile()) {
            oRowData.add(oLoadFileInfo.getFileName());
        } else {
            oRowData.add("");
        }
        this.m_oTableModel.addRow(oRowData);
    }

    private void createCellRenderer(JTable oDevTable, int oColNum, int oRowNum) {
        TableCellRenderer cellRenderer = oDevTable.getColumnModel().getColumn(oColNum).getCellRenderer();
        if (cellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)cellRenderer).setToolTipText(oDevTable.getValueAt(oRowNum, oColNum).toString());
        }
    }

    private boolean[] getEditableCol(int iNoOfCol) {
        boolean[] obarrEditableCol = new boolean[iNoOfCol];
        int iIndex = 5;
        if (this.m_bIsContentTypeRequired) {
            obarrEditableCol[iIndex++] = true;
        }
        obarrEditableCol[iIndex++] = true;
        return obarrEditableCol;
    }

    private DefaultListSelectionModel getSelectionModel() {
        DefaultListSelectionModel odevSelection = new DefaultListSelectionModel();
        odevSelection.setSelectionMode(1);
        return odevSelection;
    }

    private Vector getTableHeader() {
        Vector<String> oHeaderNameList = new Vector<String>(8);
        oHeaderNameList.add(this.m_oResMgr.getResString("DEVICE_ID"));
        oHeaderNameList.add(this.m_oResMgr.getResString("LOAD_DATA_SERIAL_NO_COLUMN"));
        oHeaderNameList.add(this.m_oResMgr.getResString("DEVICE_NAME"));
        oHeaderNameList.add(this.m_oResMgr.getResString("LOAD_DATA_DEVICE_IP_COLUMN"));
        oHeaderNameList.add(this.m_oResMgr.getResString("LOAD_DATA_CURRENT_VERSION_COLUMN"));
        if (this.m_bIsContentTypeRequired) {
            oHeaderNameList.add(this.m_oResMgr.getResString("LOAD_DATA_CONTENT_TYPE"));
        }
        oHeaderNameList.add(this.m_oResMgr.getResString("LOAD_DATA_DATA_FILE_COLUMN"));
        return oHeaderNameList;
    }

    private DefaultTableModel getTableModel(Vector oHeaderNameList, final boolean[] oarrEditableCol) {
        return new DefaultTableModel(oHeaderNameList, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return oarrEditableCol[column];
            }
        };
    }

    private void initColumnWidth(JTable oDevTable) {
        oDevTable.getColumnModel().getColumn(0).setMaxWidth(80);
        oDevTable.getColumnModel().getColumn(0).setMinWidth(50);
        oDevTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    }

    private void initContentColRendererAndEditor(TableColumn contentTypeColumn) {
        Object[] oContentTypeValue = ((LoadFileInfoListParam)this.m_oLoadDataOperation.getConfiguredPara()).getContentTypeList();
        ContentTypeCellRenderer oContenetTypeRenderer = new ContentTypeCellRenderer(oContentTypeValue);
        contentTypeColumn.setCellRenderer(oContenetTypeRenderer);
        contentTypeColumn.setCellEditor(new ContentTypeCellEditor(oContentTypeValue));
    }

    private void initContentTypeCol(JTable table, TableColumn contentTypeColumn) {
        this.initContentTypeCombo();
        this.initContentColRendererAndEditor(contentTypeColumn);
    }

    private void initContentTypeCombo() {
    }

    private void initDataModel() {
        ITask oOperationData = this.m_oLoadDataOperation.getOperationData();
        DeviceType oSelectedDeviceType = oOperationData.getSelectedDeviceType();
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        int iSize = oResourceList.size();
        LoadFileInfoListParam configuredPara = (LoadFileInfoListParam)this.m_oLoadDataOperation.getConfiguredPara();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            this.addRow(oResourceList, configuredPara, iIndex);
        }
    }

    private void initHeaderMouseListener(JTable oDevTable) {
        oDevTable.getTableHeader().addMouseMotionListener(this.getMouseAdaptor(oDevTable));
    }

    private MouseMotionAdapter getMouseAdaptor(final JTable oDevTable) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oDevTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    oDevTable.getTableHeader().setToolTipText(oDevTable.getColumnName(oColNum));
                }
            }
        };
    }

    private void initRenderer(JTable oDevTable) {
        int iIndex = 4;
        if (this.m_bIsContentTypeRequired) {
            TableColumn oContentTypeCol = oDevTable.getColumnModel().getColumn(iIndex++);
            this.initContentTypeCol(oDevTable, oContentTypeCol);
        }
        TableColumn oFileNameCol = oDevTable.getColumnModel().getColumn(iIndex);
        oFileNameCol.setCellRenderer(new FileBrowseButtonCellRenderer());
        oFileNameCol.setCellEditor(new FileBrowseButtonCellEditor(iIndex, new JCheckBox(), oDevTable, this.m_bIsContentTypeRequired, this.m_isLoadFileFormThirdFTP));
    }

    private void initScrollPane() {
        Vector oTableHeader = this.getTableHeader();
        boolean[] oarrEditableCol = this.getEditableCol(oTableHeader.size());
        this.m_oTableModel = this.getTableModel(oTableHeader, oarrEditableCol);
        this.m_oTable = this.initTable(this.m_oTableModel);
        this.initHeaderMouseListener(this.m_oTable);
        this.initTableMouseListener(this.m_oTable);
        this.initColumnWidth(this.m_oTable);
        this.initRenderer(this.m_oTable);
        this.initDataModel();
        this.m_oScrollPane = new JScrollPane(this.m_oTable);
        this.m_oScrollPane.setBounds(12, 12, 576, 326);
        this.add(this.m_oScrollPane);
    }

    private JTable initTable(DefaultTableModel oDefaultTableModel) {
        JTable oDevTable = new JTable(oDefaultTableModel);
        oDevTable.setName("DeviceOperation_LoadDataOperationPanel_oDevTable");
        DefaultListSelectionModel odevSelection = this.getSelectionModel();
        oDevTable.setSelectionModel(odevSelection);
        oDevTable.setFocusable(false);
        oDevTable.removeColumn(oDevTable.getColumnModel().getColumn(0));
        oDevTable.setRowSelectionAllowed(false);
        oDevTable.getTableHeader().setReorderingAllowed(false);
        oDevTable.setRowSelectionAllowed(true);
        oDevTable.setRowHeight(21);
        oDevTable.getColumnModel().getColumn(4).setMaxWidth(-1);
        oDevTable.getColumnModel().getColumn(4).setMinWidth(-1);
        oDevTable.getColumnModel().getColumn(4).setPreferredWidth(-1);
        oDevTable.getColumnModel().getColumn(4).setWidth(-1);
        oDevTable.getColumnModel().getColumn(4).setResizable(false);
        return oDevTable;
    }

    private void initTableMouseListener(final JTable oDevTable) {
        oDevTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oDevTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    int oRowNum = oDevTable.rowAtPoint(e.getPoint());
                    LoadDataOperationPanel.this.createCellRenderer(oDevTable, oColNum, oRowNum);
                }
            }
        });
    }

    public boolean isValidFileSelection() {
        if ((5 == this.m_oLoadDataOperation.getDependsOnOperation() || this.m_oLoadDataOperation.isUpdateSelected()) && "DATAFILE".equals(this.m_strUpgradeType)) {
            return true;
        }
        int iRowCount = this.m_oTable.getRowCount();
        int iDataFileColumnIndex = 4;
        if (this.m_bIsContentTypeRequired) {
            ++iDataFileColumnIndex;
        }
        for (int iIndex = 0; iIndex < iRowCount; ++iIndex) {
            String strFileName = (String)this.m_oTable.getValueAt(iIndex, iDataFileColumnIndex);
            String strSelectFileTag = ResourceManager.getInstance().getResString("SELECT_FILE_PATH");
            if (null != strFileName && !"".equals(strFileName.trim()) && !Collator.getInstance().equals(strSelectFileTag, strFileName.trim())) continue;
            return false;
        }
        return true;
    }

    public void refreshTable() {
    }

    private List removeExistingDevFrmList(THashSet<Resource> oResourceLst) {
        this.removeRowsFrmTable(oResourceLst);
        ArrayList oNewDevicesLst = new ArrayList();
        int iSizeOfLst = oResourceLst.size();
        Iterator oResItor = oResourceLst.iterator();
        while (oResItor.hasNext()) {
            oNewDevicesLst.add(oResItor.next());
        }
        int iRowCount = this.m_oTable.getRowCount();
        Integer oDevId = null;
        Resource oResource = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oResource = (Resource)oNewDevicesLst.get(i);
            for (int j = 0; j < iRowCount; ++j) {
                oDevId = (Integer)this.m_oTableModel.getValueAt(j, 0);
                if (oDevId.intValue() != oResource.getDeviceID()) continue;
                oNewDevicesLst.remove(i);
            }
        }
        return oNewDevicesLst;
    }

    private void removeRowsFrmTable(THashSet<Resource> oResourceLst) {
        int iRowCount = this.m_oTable.getRowCount();
        Integer oDevId = null;
        boolean bIsPresent = false;
        Resource oResourceInfo2 = null;
        for (int i = iRowCount - 1; i >= 0; --i) {
            bIsPresent = false;
            oDevId = (Integer)this.m_oTableModel.getValueAt(i, 0);
            for (Resource oResourceInfo2 : oResourceLst) {
                if (oDevId.intValue() != oResourceInfo2.getDeviceID()) continue;
                bIsPresent = true;
                break;
            }
            if (bIsPresent) continue;
            this.m_oTableModel.removeRow(i);
        }
    }

    public void saveFilesToConfigPara() {
        LoadFileInfoListParam oConfiguredPara = (LoadFileInfoListParam)this.m_oLoadDataOperation.getConfiguredPara();
        int numberOfFiles = oConfiguredPara.getNumberOfFiles();
        LoadFileInfo oLoadFileInfo = null;
        String strDefaultFileTag = ResourceManager.getInstance().getResString("DEFAULT_FILE");
        for (int iIndex = 0; iIndex < numberOfFiles; ++iIndex) {
            String strFileName;
            oLoadFileInfo = oConfiguredPara.getLoadFileInfo(iIndex);
            int iFilePathIndex = 4;
            this.m_oTable.getModel();
            if (this.m_bIsContentTypeRequired) {
                ContentType oContentType = (ContentType)this.m_oTable.getValueAt(iIndex, iFilePathIndex);
                oLoadFileInfo.setContentType(oContentType);
                iFilePathIndex = 5;
            }
            if (null == (strFileName = (String)this.m_oTable.getValueAt(iIndex, iFilePathIndex)) || "".equals(strFileName.trim()) || Collator.getInstance().equals(strDefaultFileTag, strFileName.trim())) {
                oLoadFileInfo.setLoadDefaultFile(true);
                continue;
            }
            oLoadFileInfo.setFileName(strFileName);
        }
    }

    private void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadDataOperationPanel.this.m_oTableModel.fireTableDataChanged();
                LoadDataOperationPanel.this.m_oTable.updateUI();
            }
        });
    }

    public void updateTableDataModel(THashSet<Resource> oResourceLst, LoadFileInfoListParam oFileInfoLst) {
        List oResourcesSelected = null;
        oResourcesSelected = this.removeExistingDevFrmList(oResourceLst);
        int iSizeOfLst = oResourcesSelected.size();
        List<LoadFileInfo> oFileLst = oFileInfoLst.getLoadFileInfoList();
        int iNosFiles = oFileLst.size();
        LoadFileInfo oFileInfo = null;
        Resource oResource = null;
        block0: for (int i = 0; i < iSizeOfLst; ++i) {
            oResource = (Resource)oResourcesSelected.get(i);
            for (int j = 0; j < iNosFiles; ++j) {
                oFileInfo = oFileLst.get(j);
                if (oResource.getDeviceID() != oFileInfo.getDeviceId()) continue;
                Vector<Object> oRowData = new Vector<Object>(8);
                oRowData.add(oResource.getDeviceID());
                oRowData.add("" + (this.m_oTable.getRowCount() + 1));
                oRowData.add(oResource.getDeviceName());
                oRowData.add(oResource.getDeviceIP());
                oRowData.add(oResource.getDeviceVersion());
                if (this.m_bIsContentTypeRequired) {
                    oRowData.add(oFileInfo.getContentType());
                }
                if (!oFileInfo.isLoadDefaultFile()) {
                    oRowData.add(oFileInfo.getFileName());
                } else {
                    oRowData.add("");
                }
                this.m_oTableModel.addRow(oRowData);
                continue block0;
            }
        }
        this.updateTable();
    }

    public JTable getTable() {
        return this.m_oTable;
    }

    class FileBrowseButtonCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        FileBrowseButtonCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileBrowseButtonCellEditor oButtoncellEditor = (FileBrowseButtonCellEditor)table.getCellEditor(row, column);
            return oButtoncellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class FileBrowseButtonCellEditor
    extends DefaultCellEditor
    implements IBrowseDlgInterafce {
        private static final long serialVersionUID = 1L;
        private static final int CONTENT_TYPE_MODEL_COLUMN = 5;
        private static final int FILE_NAME__MODEL_COLUMN = 6;
        private boolean m_bIsContentReq;
        private JTable m_devTable;
        private JButton m_oBrowseButton;
        private JPanel m_oButtonPanel;
        private JLabel m_oLabel;
        JPanel m_oPanelComp;
        private JButton m_oResetButton;

        public FileBrowseButtonCellEditor(int iColIndex, JCheckBox checkBox, JTable oTable, boolean bIsContentReq, boolean isBrowseFromThirdFTP) {
            super(checkBox);
            this.m_bIsContentReq = false;
            this.m_oPanelComp = null;
            this.m_devTable = oTable;
            this.m_bIsContentReq = bIsContentReq;
        }

        private void browseDirectory() {
            try {
                FileSelectionBrowseDlg browseDlg = new FileSelectionBrowseDlg(false, false, LoadDataOperationPanel.this.m_isLoadFileFormThirdFTP, "LoadData");
                browseDlg.registBrowseDlgInterface(this);
                browseDlg.setVisible(true);
            }
            catch (DCException e) {
                DCOptionPane.showErrorDialog((Component)LoadDataOperationPanel.this, e.getErrorCode());
            }
        }

        @Override
        public Object getCellEditorValue() {
            String strValue = ResourceManager.getInstance().getResString("DEFAULT_FILE");
            strValue = LoadDataOperationPanel.this.m_bIsContentTypeRequired ? this.m_devTable.getModel().getValueAt(this.m_devTable.getSelectedRow(), 6).toString() : this.m_devTable.getModel().getValueAt(this.m_devTable.getSelectedRow(), 5).toString();
            return strValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final ComboBoxWithToolTip oComboBox = new ComboBoxWithToolTip();
            String strBrowseItem = DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN");
            String strFileName = null;
            strFileName = (LoadDataOperationPanel.this.m_bIsDependentOnUpdate || LoadDataOperationPanel.this.m_oLoadDataOperation.isUpdateSelected()) && "DATAFILE".equals(LoadDataOperationPanel.this.m_strUpgradeType) ? ResourceManager.getInstance().getResString("DEFAULT_FILE") : "";
            oComboBox.addItem(strFileName);
            oComboBox.addItem(strBrowseItem);
            strFileName = "";
            if (null != value && !"".equals(value.toString())) {
                strFileName = (String)value;
                oComboBox.addItem(strFileName);
            }
            if (0 != strFileName.length()) {
                oComboBox.setSelectedItem(strFileName);
            } else {
                oComboBox.setSelectedIndex(0);
            }
            oComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (null != oComboBox && null != oComboBox.getSelectedItem()) {
                        String strToolTip = String.valueOf(oComboBox.getSelectedItem());
                        oComboBox.setToolTipText(strToolTip);
                        if (strToolTip.equalsIgnoreCase(DCFrameWorkUtil.getLocalizedString("RECOVER_BROWSE_BTN"))) {
                            oComboBox.setSelectedIndex(0);
                            FileBrowseButtonCellEditor.this.browseDirectory();
                        } else {
                            FileBrowseButtonCellEditor.this.setFileOrDirectory(strToolTip, "", true);
                        }
                        FileBrowseButtonCellEditor.this.fireEditingStopped();
                    }
                }
            });
            return oComboBox;
        }

        private void initBrowseButton() {
            this.m_oBrowseButton = new JButton();
            this.m_oBrowseButton.setName("DeviceOperation_LoadDataOperationPanel_m_oBrowseButton");
            this.m_oBrowseButton.setOpaque(true);
            this.m_oBrowseButton.setText("...");
            this.m_oBrowseButton.setPreferredSize(new Dimension(15, 17));
            this.m_oBrowseButton.setMaximumSize(new Dimension(15, 17));
            this.m_oBrowseButton.setMinimumSize(new Dimension(15, 17));
            this.m_oBrowseButton.setToolTipText(ResourceManager.getInstance().getResString("BROWSE_TOOLTIP"));
        }

        private void initButtonPanel() {
            this.m_oButtonPanel = new JPanel();
            this.m_oButtonPanel.setLayout(new BorderLayout());
            this.m_oButtonPanel.setPreferredSize(new Dimension(31, 17));
            this.m_oButtonPanel.setMaximumSize(new Dimension(31, 17));
            this.m_oButtonPanel.setMinimumSize(new Dimension(31, 17));
        }

        private void initResetButton() {
            this.m_oResetButton = new JButton();
            this.m_oResetButton.setName("DeviceOperation_LoadDataOperationPanel_m_oResetButton");
            this.m_oResetButton.setOpaque(true);
            this.m_oResetButton.setPreferredSize(new Dimension(15, 17));
            this.m_oResetButton.setMaximumSize(new Dimension(15, 17));
            this.m_oResetButton.setMinimumSize(new Dimension(15, 17));
            this.m_oResetButton.setToolTipText(ResourceManager.getInstance().getResString("RESET_OPTION"));
            ImageIcon clearIcon = ResourceManager.getInstance().getImage("clear.gif");
            this.m_oResetButton.setIcon(clearIcon);
        }

        private void resetFilePath() {
            String strValue = null;
            strValue = (LoadDataOperationPanel.this.m_bIsDependentOnUpdate || LoadDataOperationPanel.this.m_oLoadDataOperation.isUpdateSelected()) && "DATAFILE".equals(LoadDataOperationPanel.this.m_strUpgradeType) ? ResourceManager.getInstance().getResString("DEFAULT_FILE") : ResourceManager.getInstance().getResString("SELECT_FILE_PATH");
            this.setFileOrDirectory(strValue, "", true);
        }

        @Override
        public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
            DCDebugTracer.trace("Load File Path : " + strFilePath);
            int iSelectedColumn = 5;
            if (this.m_bIsContentReq) {
                iSelectedColumn = 6;
            }
            this.m_devTable.getModel().setValueAt(strFilePath, this.m_devTable.getSelectedRow(), iSelectedColumn);
            this.stopCellEditing();
        }
    }

    private class ContentTypeCellEditor
    extends DefaultCellEditor {
        public ContentTypeCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class ContentTypeCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        public ContentTypeCellRenderer(Object[] oContentType) {
            super(oContentType);
            this.setSelectedItem(oContentType[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

