/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.loaddata;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataDlg;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataOperationPanel;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataSubOpr;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.ViewLoadDataPanel;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LoadDataOperation
extends OperationAdapter
implements ITaskDeviceOperation {
    private static final long serialVersionUID = 1L;
    private int m_iOperationId = -1;
    private String m_strOperationName;
    private String m_strOperationIdString;
    private String m_strOperationDesc;
    private boolean m_bIsOPSelected;
    private int m_iOpDependsOnId;
    private List m_oDependentOpLst;
    private boolean m_bIsPauseB4Op;
    private LoadFileInfoListParam m_oLoadDataConfigParam = new LoadFileInfoListParam();
    private boolean m_bIsEnabled = true;
    private ITask m_oParentTask;
    private int m_iOperationLevel;
    private IParaList m_oParaList;
    private int iInnerTaskTypeId = -1;
    private LoadDataSubOpr m_oLoadDataSubOpr = null;
    private transient LoadDataOperationPanel m_oLoadDataOperationPanel = null;

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public Component getView(int context) {
        if (null == this.m_oParentTask) {
            return null;
        }
        Object oLoadView = null;
        boolean bIsDependentOnUpdate = false;
        if (5 == this.m_iOpDependsOnId) {
            bIsDependentOnUpdate = true;
        }
        switch (context) {
            case 0: {
                this.initConfigParam();
                oLoadView = new LoadDataDlg(this, bIsDependentOnUpdate, this.m_oParentTask.isThirdPartySupported());
                break;
            }
            case 1: {
                this.m_oLoadDataConfigParam.addNewDeviceSelected(this.m_oParentTask.getSelectedDeviceType().getResources());
                this.m_oLoadDataOperationPanel = new LoadDataOperationPanel(this, bIsDependentOnUpdate, this.m_oParentTask.isThirdPartySupported());
                this.m_oLoadDataOperationPanel.setBounds(10, 7, 632, 453);
                oLoadView = this.m_oLoadDataOperationPanel;
                break;
            }
            case 2: {
                oLoadView = new ViewLoadDataPanel(this.m_oLoadDataConfigParam, this.m_oParentTask);
                oLoadView.setScrollPaneBounds(22, 22, 576, 337);
                break;
            }
        }
        return oLoadView;
    }

    private void initConfigParam() {
        if (null == this.m_oLoadDataConfigParam) {
            this.m_oLoadDataConfigParam = new LoadFileInfoListParam();
        }
        DeviceType oSelectedDeviceType = this.m_oParentTask.getSelectedDeviceType();
        this.m_oLoadDataConfigParam.setParaList(this.m_oParaList);
        Object[] oarrContentTypeList = this.m_oLoadDataConfigParam.getContentTypeList();
        Object oSelectedContentType = null;
        if (oarrContentTypeList.length > 0) {
            oSelectedContentType = this.getSelectedContentType(oarrContentTypeList);
        }
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        LoadFileInfo oLoadFileInfo = null;
        Resource oResource = null;
        Iterator oResItor = oResourceList.iterator();
        int iIndex = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            oLoadFileInfo = this.getLoadFileInstance();
            oLoadFileInfo.setDeviceId(oResource.getDeviceID());
            oLoadFileInfo.setLoadDefaultFile(true);
            oLoadFileInfo.setSequenceNo(iIndex);
            if (null != oSelectedContentType) {
                oLoadFileInfo.setContentType((ContentType)oSelectedContentType);
            }
            this.m_oLoadDataConfigParam.addServerFile(oLoadFileInfo);
            ++iIndex;
        }
        this.m_oLoadDataConfigParam.upDateTable(oResourceList);
    }

    private Object getSelectedContentType(Object[] oarrContentTypeList) {
        if (null == this.m_oParentTask.getTaskContentType()) {
            return oarrContentTypeList[0];
        }
        int iLength = oarrContentTypeList.length;
        ContentType oTaskContentType = this.m_oParentTask.getTaskContentType();
        ContentType oContentType = null;
        for (int i = 0; i < iLength; ++i) {
            oContentType = (ContentType)oarrContentTypeList[i];
            if (!oContentType.getId().equals(oTaskContentType.getId())) continue;
            return oContentType;
        }
        return oarrContentTypeList[0];
    }

    LoadFileInfo getLoadFileInstance() {
        return new LoadFileInfo();
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bIsPauseB4Op;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean isPauseBeforeCurOp) {
        this.m_bIsPauseB4Op = isPauseBeforeCurOp;
    }

    @Override
    public void setOperationId(int operationId) {
        this.m_iOperationId = operationId;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    public List getDependentOperation() {
        return this.m_oDependentOpLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iOpDependsOnId;
    }

    @Override
    public boolean isSelected() {
        return this.m_bIsOPSelected;
    }

    public void setDependentOperation(List devDependentLst) {
        this.m_oDependentOpLst = devDependentLst;
    }

    @Override
    public void setDependsOnOperation(int devOpDependsOnId) {
        this.m_iOpDependsOnId = devOpDependsOnId;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.m_bIsOPSelected = isSelected;
    }

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationIdString;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationIdString = strOperationId;
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        ValidationResult oResult = new ValidationResult();
        List<LoadFileInfo> oFileList = this.m_oLoadDataConfigParam.getLoadFileInfoList();
        if (5 != this.m_iOpDependsOnId || null != this.m_oParentTask.getTaskContentType() && !"DATAFILE".equals(this.m_oParentTask.getTaskContentType().getId())) {
            boolean bIsValidFileSelection = this.validateIfFilesAreSelected(oResult, oFileList);
            if (!bIsValidFileSelection) {
                oResult.setErrorCode(-1);
                oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_DATA_FILE_SELECTED"));
            }
        } else if (null == oFileList || 0 == oFileList.size()) {
            oResult.setErrorCode(-1);
            oResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_LOAD_DATA_FILE_SELECTED"));
        } else {
            oResult.setErrorCode(0);
        }
        return oResult;
    }

    private boolean validateIfFilesAreSelected(ValidationResult oResult, List oFileList) {
        if ((5 == this.m_iOpDependsOnId || this.isUpdateSelected()) && null != this.m_oParentTask.getTaskContentType() && "DATAFILE".equals(this.m_oParentTask.getTaskContentType().getId())) {
            return true;
        }
        int iNumberOfFiles = this.m_oLoadDataConfigParam.getNumberOfFiles();
        LoadFileInfo oLoadFileInfo = null;
        for (int iIndex = 0; iIndex < iNumberOfFiles; ++iIndex) {
            oLoadFileInfo = this.m_oLoadDataConfigParam.getLoadFileInfo(iIndex);
            String strFileName = oLoadFileInfo.getFileName();
            if (null != strFileName && !"".equals(strFileName.trim()) && !Collator.getInstance().equals(strFileName, ResourceManager.getInstance().getResString("SELECT_FILE_PATH"))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getConfiguredPara() {
        return this.m_oLoadDataConfigParam;
    }

    @Override
    public void setOperationData(ITask oTaskRef) {
        this.m_oParentTask = oTaskRef;
        this.initConfigParam();
    }

    public ITask getOperationData() {
        return this.m_oParentTask;
    }

    @Override
    public String toString() {
        StringBuffer ostrBufOperation = new StringBuffer(128);
        ostrBufOperation.append("<br>");
        DeviceType oSelectedDeviceType = this.m_oParentTask.getSelectedDeviceType();
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        List<LoadFileInfo> oFileList = this.m_oLoadDataConfigParam.getLoadFileInfoList();
        this.appendResourceAndFileInfo(ostrBufOperation, oResourceList, oFileList);
        return ostrBufOperation.toString();
    }

    private void appendResourceAndFileInfo(StringBuffer ostrBufOperation, THashSet<Resource> oResourceList, List oFileList) {
        int iFirstResource = 0;
        LoadFileInfo oLoadFileInfo = null;
        int iSize = oResourceList.size();
        Iterator oResItor = oResourceList.iterator();
        int iResourceIndex = 0;
        while (oResItor.hasNext()) {
            if (iFirstResource != iResourceIndex) {
                ostrBufOperation.append("<br>");
            }
            Resource oResourceObj = (Resource)oResItor.next();
            oLoadFileInfo = (LoadFileInfo)oFileList.get(iResourceIndex);
            ostrBufOperation.append("  ");
            ostrBufOperation.append(ResourceManager.getInstance().getResString("DEVICE_NAME")).append(" : ").append(oResourceObj.getDeviceName());
            ostrBufOperation.append("<br>");
            ostrBufOperation.append("  ");
            ostrBufOperation.append(ResourceManager.getInstance().getResString("DEVICE_IP")).append(" : ").append(oResourceObj.getDeviceIP());
            ostrBufOperation.append("<br>");
            ostrBufOperation.append("  ");
            ostrBufOperation.append(ResourceManager.getInstance().getResString("DEVICE_VERSION")).append(" : ").append(oResourceObj.getDeviceVersion());
            ostrBufOperation.append("<br>");
            if (this.m_oLoadDataConfigParam.isContentTypeRequired()) {
                ostrBufOperation.append("  ");
                ostrBufOperation.append(ResourceManager.getInstance().getResString("LOAD_DATA_CONTENT_TYPE")).append(" : ").append(oLoadFileInfo.getContentType().toString());
                ostrBufOperation.append("<br>");
            }
            ostrBufOperation.append("  ");
            ostrBufOperation.append(ResourceManager.getInstance().getResString("LOAD_DATA_FILE")).append(" : ");
            if (oLoadFileInfo.isLoadDefaultFile()) {
                ostrBufOperation.append(ResourceManager.getInstance().getResString("DEFAULT_FILE"));
            } else {
                ostrBufOperation.append(oLoadFileInfo.getFileName());
            }
            if (iResourceIndex != iSize - 1) {
                ostrBufOperation.append("<br>");
            }
            ++iResourceIndex;
        }
        ostrBufOperation.append("<br>");
    }

    public void updateConfigParaList(ITask oTaskDataObj) {
        this.m_oLoadDataConfigParam.addNewDeviceSelected(oTaskDataObj.getSelectedDeviceType().getResources());
        this.m_oLoadDataConfigParam.upDateTable(oTaskDataObj.getSelectedDeviceType().getResources());
        this.m_oLoadDataOperationPanel.updateTableDataModel(oTaskDataObj.getSelectedDeviceType().getResources(), this.m_oLoadDataConfigParam);
    }

    @Override
    public void setOPerationParaList(IParaList paraList) {
        this.m_oParaList = paraList;
    }

    @Override
    public void setOperationLevel(int operationLevel) {
        this.m_iOperationLevel = operationLevel;
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    public boolean isUpdateSelected() {
        boolean bIsUpdateSelected = false;
        List<ITaskDeviceOperation> supportedOperation = this.m_oParentTask.getSupportedOperation();
        int iSize = supportedOperation.size();
        for (int i = 0; i < iSize; ++i) {
            ITaskDeviceOperation oTaskDeviceOperation = supportedOperation.get(i);
            if (oTaskDeviceOperation.getOperationId() != 5 || !oTaskDeviceOperation.isSelected()) continue;
            bIsUpdateSelected = true;
            break;
        }
        return bIsUpdateSelected;
    }

    @Override
    public boolean isEnabled() {
        return this.m_bIsEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_bIsEnabled = isEnabled;
    }

    @Override
    public boolean isConfigReq() {
        return true;
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        if (null == this.m_oLoadDataSubOpr) {
            this.m_oLoadDataSubOpr = new LoadDataSubOpr();
        }
        return this.m_oLoadDataSubOpr;
    }

    @Override
    public ArrayList getOperationIDnName() {
        ArrayList<Object> oData = null;
        if (this.isSelected()) {
            oData = new ArrayList<Object>();
            oData.add(this.getOperationName());
            oData.add(this.getOperationId());
        }
        return oData;
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oLoadDataSubOpr = null;
    }

    @Override
    public String getCurrentContext() {
        String sCurrentContext = "";
        if (null == this.m_oParentTask) {
            return "";
        }
        int iTaskTypeID = this.m_oParentTask.getTaskTypeId();
        switch (iTaskTypeID) {
            case 0: {
                sCurrentContext = "HELP_TOPIC_SW_U_LOADDATA";
                break;
            }
            case 1: {
                sCurrentContext = "HELP_TOPIC_SW_D_LOADDATA";
                break;
            }
        }
        return sCurrentContext;
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }
}

