/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.customoperation.area;

import com.huawei.dc.common.asndatacenter.AsnGetProgramArea;
import com.huawei.dc.common.asndatacenter.AsnGetProgramAreaLst;
import com.huawei.dc.common.asndatacenter.AsnGetProgramAreaRsp;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.AbstractCustomOperationTab;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperation;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IDeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DevProgramAreaPanel
extends AbstractCustomOperationTab {
    private static final long serialVersionUID = 1235218913560725453L;
    private IDeviceInfo m_oSelectedDevInfo;
    protected JButton m_oQueryBtn;
    private JTextArea m_oAreaInfoTextArea;
    private JScrollPane m_scrollPane;

    public DevProgramAreaPanel() {
        this.setLayout(new BorderLayout());
        this.jInit();
    }

    private void jInit() {
        this.m_oQueryBtn = new JButton(ResourceManager.getInstance().getResString("BUTTON_QUERY_BOARDINFO"));
        this.m_oQueryBtn.setName("com.huawei.dc.devicemanagement.deviceoperation.customoperation.area.DevProgramAreaPanel.m_oQueryBtn");
        Dimension oDefaultDimension = new Dimension(50, 25);
        this.m_oQueryBtn.setBorder(null);
        this.m_oQueryBtn.setPreferredSize(oDefaultDimension);
        this.m_oQueryBtn.setMaximumSize(oDefaultDimension);
        this.m_oQueryBtn.setMinimumSize(oDefaultDimension);
        this.m_oQueryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevProgramAreaPanel.this.doQueryBtnAction();
            }
        });
        JLabel oLabel = new JLabel(ResourceManager.getInstance().getResString("Query_Dev_Area_For_Label_Text"));
        JPanel oBtnPanel = new JPanel();
        oBtnPanel.setLayout(new FlowLayout(0));
        oBtnPanel.add(this.m_oQueryBtn);
        oBtnPanel.add(oLabel);
        this.m_oAreaInfoTextArea = new JTextArea();
        this.m_oAreaInfoTextArea.setName("com.huawei.dc.devicemanagement.deviceoperation.customoperation.area.DevProgramAreaPanel.m_oAreaInfoTextArea");
        this.m_oAreaInfoTextArea.setEditable(false);
        this.m_oAreaInfoTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.m_scrollPane = new JScrollPane(this.m_oAreaInfoTextArea);
        this.m_scrollPane.setVisible(false);
        this.add((Component)oBtnPanel, "North");
        this.add((Component)this.m_scrollPane, "Center");
    }

    @Override
    public int initCustomoperatioTab(IDeviceInfo[] deviceInfos, ICustomOperation operationExecutor) {
        if (null != deviceInfos && 0 < deviceInfos.length) {
            this.m_oSelectedDevInfo = deviceInfos[0];
        }
        return 0;
    }

    @Override
    public void setRefreshBtnState(boolean flag) {
        this.m_oQueryBtn.setEnabled(flag);
    }

    @Override
    public void setSelectedDeviceInfo(IDeviceInfo[] deviceInfo) {
        if (null != deviceInfo && 0 < deviceInfo.length) {
            this.m_oSelectedDevInfo = deviceInfo[0];
        }
    }

    @Override
    public void updateTab() {
    }

    @Override
    public void notifyMessage(ICustomOperationEvent event) {
    }

    private void doQueryBtnAction() {
        if (null != this.m_oSelectedDevInfo) {
            this.m_scrollPane.setVisible(true);
            AsnGetProgramAreaRsp oRsp = DeviceInfoSyncCtrller.getInstance().queryDevAreaInfo(this.m_oSelectedDevInfo.getDevID());
            int iErrCode = oRsp.oErrorNo.iErrorNo.intValue();
            if (0 != iErrCode) {
                this.m_oAreaInfoTextArea.setText(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode)));
            } else {
                StringBuffer sb = new StringBuffer();
                String strSeparatorLine = "----------------------------------";
                String strNewLine = System.getProperty("line.separator");
                AsnGetProgramAreaLst oAreaLst = oRsp.oProgramAreaLst;
                for (int i = 0; i < oAreaLst.size(); ++i) {
                    AsnGetProgramArea oAreaInfo = (AsnGetProgramArea)oAreaLst.get(i);
                    int iBoardId = oAreaInfo.iMainboardID.value;
                    int iProgramArea = oAreaInfo.iProagramActiveArea.value;
                    int iDataArea = oAreaInfo.iDataActiveArea.value;
                    String strAProgramVer = new String(oAreaInfo.strProagramAreaAVersion);
                    String strBProgramVer = new String(oAreaInfo.strProagramAreaBVersion);
                    String strADataVer = new String(oAreaInfo.strDataAreaAVersion);
                    String strBDataVer = new String(oAreaInfo.strDataAreaBVersion);
                    if (0 == iBoardId) {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_MainBoard_Info"));
                    } else {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_StandbyBoard_Info"));
                    }
                    sb.append(strNewLine);
                    sb.append("----------------------------------");
                    sb.append(strNewLine);
                    if (1 == iProgramArea) {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_Current_Program_Area_A"));
                    } else {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_Current_Program_Area_B"));
                    }
                    sb.append(strNewLine);
                    if (1 == iDataArea) {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_Current_Data_Area_A"));
                    } else {
                        sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_Current_Data_Area_B"));
                    }
                    sb.append(strNewLine);
                    sb.append(strNewLine);
                    sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_A_Area_Program_Ver"));
                    sb.append(strAProgramVer);
                    sb.append(strNewLine);
                    sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_B_Area_Program_Ver"));
                    sb.append(strBProgramVer);
                    sb.append(strNewLine);
                    sb.append(strNewLine);
                    sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_A_Area_Data_Ver"));
                    sb.append(strADataVer);
                    sb.append(strNewLine);
                    sb.append(ResourceManager.getInstance().getResString("Query_Dev_Area_For_B_Area_Data_Ver"));
                    sb.append(strBDataVer);
                    sb.append(strNewLine);
                    sb.append("----------------------------------");
                    sb.append(strNewLine);
                    sb.append(strNewLine);
                }
                this.m_oAreaInfoTextArea.setText(sb.toString());
            }
        }
    }

    @Override
    public void notifyEventToCustomerInfoManager(ICustomOperationEvent event) {
    }
}

