/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.customoperation;

import com.huawei.cmf.dc.customoperation.devicetab.DeviceTabModulePanel;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.AbstractCustomOperationDialog;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.AbstractCustomOperationTab;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperation;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEngine;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationInfo;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationResult;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IDeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IOperationPara;
import com.huawei.dc.deviceoperation.DeviceOperationManagerImpl;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.SwingUtilities;

public class CustomOperationEngine
implements ICustomOperationEngine,
IDCObjectDeallocator {
    private static CustomOperationEngine c_oCustomOperationEngine = null;
    private static List m_oNotificationListenerList = null;
    private static Hashtable<ICustomOperationResult, Integer> m_oListernerMap;
    private IDeviceOperationManager oDeviceOpMgr = DeviceOperationManagerImpl.getInstance();
    private String m_strOperationID;
    private IOperationPara[] m_oOperationParas;
    private AbstractCustomOperationDialog m_oAbstractCustomOperationDialog = null;
    private AbstractCustomOperationTab m_oAbstractCustomOperationTab = null;

    private CustomOperationEngine() {
    }

    public static synchronized ICustomOperationEngine getInstance() {
        if (null == c_oCustomOperationEngine) {
            m_oNotificationListenerList = new ArrayList(0);
            c_oCustomOperationEngine = new CustomOperationEngine();
            DCObjectDestructor.getInstance().addObjectForDestructor(c_oCustomOperationEngine);
            m_oListernerMap = new Hashtable();
        }
        return c_oCustomOperationEngine;
    }

    @Override
    public String cancel() {
        if (null == this.m_strOperationID) {
            return ResourceManager.getInstance().getResString("INVALID_CUSTOM_OPERATION_ID");
        }
        if (null == this.m_oOperationParas) {
            return ResourceManager.getInstance().getResString("INVALID_CUSTOM_OPERATION_PARA");
        }
        return this.oDeviceOpMgr.cancelCustomOperation(this.m_strOperationID, this.m_oOperationParas);
    }

    @Override
    public String execute() {
        if (null == this.m_strOperationID) {
            return ResourceManager.getInstance().getResString("INVALID_CUSTOM_OPERATION_ID");
        }
        if (null == this.m_oOperationParas) {
            return ResourceManager.getInstance().getResString("INVALID_CUSTOM_OPERATION_PARA");
        }
        return this.oDeviceOpMgr.executeCustomOperation(this.m_strOperationID, this.m_oOperationParas);
    }

    @Override
    public void setOperationParas(String strOperationID, IOperationPara[] operationParas) {
        this.m_strOperationID = strOperationID;
        this.m_oOperationParas = operationParas;
    }

    @Override
    public void setToNULL() {
        this.m_strOperationID = null;
        this.m_oOperationParas = null;
        c_oCustomOperationEngine = null;
        if (null != m_oNotificationListenerList) {
            m_oNotificationListenerList.clear();
            m_oNotificationListenerList = null;
        }
        if (null != m_oListernerMap) {
            m_oListernerMap.clear();
            m_oListernerMap = null;
        }
    }

    private void onMenuOperation(Class oClassObj, ICustomOperationInfo customOperationInfo, IDeviceInfo[] deviceInfo) {
        Object object = this.getObject(oClassObj);
        if (object instanceof AbstractCustomOperationDialog) {
            this.m_oAbstractCustomOperationDialog = (AbstractCustomOperationDialog)object;
            CustomOperation oCustomOperation = new CustomOperation();
            this.m_oAbstractCustomOperationDialog.initCustomOperationDialog(deviceInfo, oCustomOperation);
            int iDevId = -1;
            if (null != deviceInfo && 0 == deviceInfo.length) {
                iDevId = deviceInfo[0].getDevID();
            }
            this.addCustomOperationListener(this.m_oAbstractCustomOperationDialog, iDevId);
            this.m_oAbstractCustomOperationDialog.showUI();
            this.removeCustomOperationListener(this.m_oAbstractCustomOperationDialog);
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_RESOURCE_INVALID"), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.m_oAbstractCustomOperationDialog = null;
        }
    }

    private String onTabOperation(Class oClassObj, ICustomOperationInfo customOperationInfo, IDeviceInfo[] deviceInfo) {
        Object object = this.getObject(oClassObj);
        String strError = null;
        if (object instanceof AbstractCustomOperationTab) {
            this.m_oAbstractCustomOperationTab = (AbstractCustomOperationTab)object;
            CustomOperation oCustomOperation = new CustomOperation();
            try {
                this.m_oAbstractCustomOperationTab.initCustomoperatioTab(deviceInfo, oCustomOperation);
            }
            catch (Exception e) {
                this.m_oAbstractCustomOperationTab = null;
                return ResourceManager.getInstance().getResString("CUSTOM_OPERATION_OBJECT_INIT_FAILED");
            }
        } else {
            strError = ResourceManager.getInstance().getResString("CUSTOM_OPERATION_RESOURCE_INVALID");
            this.m_oAbstractCustomOperationTab = null;
        }
        return strError;
    }

    private Object getObject(Class oClassObj) {
        Object oNewInstance = null;
        if (null == oClassObj) {
            DCDebugTracer.trace("getObject::oClassObj is null");
            return oNewInstance;
        }
        try {
            oNewInstance = oClassObj.newInstance();
        }
        catch (InstantiationException e) {
            DCDebugTracer.trace("getObject::" + e.getMessage());
            DCDebugTracer.trace("getObject-oClassObj::" + oClassObj);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_OBJECT_INSTANTIATE_EXCEPTION"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            });
        }
        catch (IllegalAccessException e) {
            DCDebugTracer.trace(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_OBJECT_CREATE_ILLEGAL_ACCESS_EXCEPTION"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            });
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_OBJECT_CREATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                }
            });
        }
        return oNewInstance;
    }

    @Override
    public void initCustomDialogOperation(ICustomOperationInfo customOperationInfo, IDeviceInfo[] deviceInfo) {
        String strResourceClass = customOperationInfo.getResourceClass();
        try {
            Class<?> oClassObj = Class.forName(strResourceClass);
            switch (customOperationInfo.getWhereToShow()) {
                case 0: {
                    this.onMenuOperation(oClassObj, customOperationInfo, deviceInfo);
                    break;
                }
                default: {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_UNKNOWN_AVAILABLE_IN_FLAG_IN_XML_FILE"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CUSTOM_OPERATION_RESOURCE_NOT_FOUND"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    @Override
    public ICustomOperationEngine.CustomOpTab initCustomTabOperation(ICustomOperationInfo customOperationInfo, IDeviceInfo[] deviceInfo) {
        String strResourceClass = customOperationInfo.getResourceClass();
        ICustomOperationEngine.CustomOpTab oCustomOpTab = new ICustomOperationEngine.CustomOpTab();
        try {
            Class<?> oClassObj = Class.forName(strResourceClass);
            switch (customOperationInfo.getWhereToShow()) {
                case 1: {
                    oCustomOpTab.strErrorCode = this.onTabOperation(oClassObj, customOperationInfo, deviceInfo);
                    oCustomOpTab.customTab = this.m_oAbstractCustomOperationTab;
                    break;
                }
                default: {
                    oCustomOpTab.strErrorCode = ResourceManager.getInstance().getResString("CUSTOM_OPERATION_UNKNOWN_AVAILABLE_IN_FLAG_IN_XML_FILE");
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            oCustomOpTab.strErrorCode = ResourceManager.getInstance().getResString("CUSTOM_OPERATION_RESOURCE_NOT_FOUND");
        }
        return oCustomOpTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCustomOperationListener(ICustomOperationResult customOperationResult, Integer oDevId) {
        if (null != customOperationResult && !m_oNotificationListenerList.contains(customOperationResult)) {
            List list = m_oNotificationListenerList;
            synchronized (list) {
                m_oNotificationListenerList.add(customOperationResult);
                m_oListernerMap.put(customOperationResult, oDevId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCustomOperationListener(ICustomOperationResult customOperationResult) {
        if (null != customOperationResult && null != m_oNotificationListenerList) {
            List list = m_oNotificationListenerList;
            synchronized (list) {
                m_oNotificationListenerList.remove(customOperationResult);
                if (null != m_oListernerMap) {
                    m_oListernerMap.remove(customOperationResult);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessage(ICustomOperationEvent event) {
        List list = m_oNotificationListenerList;
        synchronized (list) {
            int noOfListener = m_oNotificationListenerList.size();
            for (int index = 0; index < noOfListener; ++index) {
                Object oListenerObj = m_oNotificationListenerList.get(index);
                IDeviceInfo[] deviceInfo = event.getDeviceInfo();
                int iDevId = -1;
                if (null != m_oListernerMap.get(oListenerObj)) {
                    iDevId = m_oListernerMap.get(oListenerObj);
                }
                boolean bIsCurDevId = null != deviceInfo && 1 == deviceInfo.length && deviceInfo[0].getDevID() == iDevId;
                boolean bMatchType = this.isMatchOperationType(oListenerObj.getClass().getSimpleName(), event.getOperationID());
                if (bIsCurDevId && bMatchType) {
                    try {
                        ((ICustomOperationResult)oListenerObj).notifyMessage(event);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                        DCDebugTracer.trace("CustomOperationEngine::notifyMessage::throw exception::" + e.getMessage());
                    }
                }
                if (!(oListenerObj instanceof DeviceTabModulePanel) || !bMatchType) continue;
                ((DeviceTabModulePanel)oListenerObj).setRefreshBtnState(true);
            }
        }
    }

    private boolean isMatchOperationType(String operationName, String sOperID) {
        boolean bMatch = false;
        if ("DevMapProgramPanel".equals(operationName)) {
            bMatch = "GetDeviceMapProgramInfo".equals(sOperID) || "DeleteImage".equals(sOperID) || "BackupImage".equals(sOperID);
        } else if ("DiskSizeInfoPanel".equals(operationName)) {
            bMatch = "GetDiskInfo".equals(sOperID);
        } else if ("LicenceFilePanel".equals(operationName)) {
            bMatch = "GetLicenceFileInfo".equals(sOperID);
        } else if ("ConfFileInfoPanel".equals(operationName)) {
            bMatch = "GetConfFileInfo".equals(sOperID);
        }
        return bMatch;
    }
}

