/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.controller;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceProgressNotify;
import com.huawei.dc.common.asndatacenter.AsnDCProgressNotify;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.IDeviceInfoListener;
import com.huawei.dc.devicemanagement.event.IDeviceInfoNotifier;
import com.huawei.dc.deviceoperation.DeviceOperationManagerImpl;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.IProgressCBDialog;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;

public class DeviceOperationProgressController
implements IProgressCBDialog,
IDeviceInfoNotifier,
IDCObjectDeallocator {
    private IDeviceInfoManager m_oDeviceInfoMgr = null;
    private IDeviceOperationManager m_oDeviceOperationMgr = null;
    private BusyDeviceObjectStore m_oBusyDeviceStore;
    private List m_oListenerList;
    private static DeviceOperationProgressController m_oInstance;
    private long firstOpenClientTime = -1L;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceOperationProgressController other = (DeviceOperationProgressController)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    private DeviceOperationProgressController() {
        DCDebugTracer.trace("create obj DeviceOperationProgressController : " + System.currentTimeMillis());
        this.initializeDeviceInfoManager();
        this.firstOpenClientTime = System.nanoTime();
        this.m_oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        this.m_oDeviceOperationMgr = (IDeviceOperationManager)ObjectStore.getInstance().getObjectInstance("DeviceOperationManager");
        if (null == this.m_oDeviceOperationMgr) {
            DCDebugTracer.trace("DeviceOperationProgressController:1get m_oDeviceOperationMgr is null.");
            this.m_oDeviceOperationMgr = DeviceOperationManagerImpl.getInstance();
        }
        if (null != this.m_oDeviceOperationMgr) {
            this.m_oDeviceOperationMgr.registerNotification(this);
        } else {
            DCDebugTracer.trace("DeviceOperationProgressController:1get m_oDeviceOperationMgr is null.");
        }
        this.m_oListenerList = new ArrayList(0);
    }

    private void initializeDeviceInfoManager() {
        this.m_oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
    }

    @Override
    public void updateDeviceProgress(int iDeviceId, int iProgressPercentage, AsnDCDeviceProgressNotify oProgressNotification, int iFailureReason, String strErrMsg) {
        DeviceInfo oDevice;
        int iOperationType = -1;
        String strOperationName = "";
        int iOperationResultStatus = -1;
        String sOperID = "";
        if (null != oProgressNotification.enDevOperType) {
            iOperationType = oProgressNotification.enDevOperType.value;
            sOperID = "" + iOperationType;
            strOperationName = 33 == oProgressNotification.enDevOperType.value ? ResourceManager.getInstance().getResString(new String(oProgressNotification.strCustomOpId)) : ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + iOperationType);
            if (strOperationName.length() == 0) {
                DCDebugTracer.trace("DC::updateDeviceProgress()-get opername null.iOperationType:|" + iOperationType);
            }
        }
        if (null != oProgressNotification.strCustomOpId) {
            sOperID = DCCommonUtil.convertByteArrayToStr(oProgressNotification.strCustomOpId);
            strOperationName = ResourceManager.getInstance().getResString(sOperID);
            if (strOperationName.length() == 0) {
                String strCustomOpId = new String(oProgressNotification.strCustomOpId);
                DCDebugTracer.trace("DC::updateDeviceProgress()-get opername null.strCustomOpId|" + strCustomOpId);
            }
        }
        if (null != oProgressNotification.oLastOperationState) {
            iOperationResultStatus = oProgressNotification.oLastOperationState.value;
        }
        String failureReason = this.getFailureReasonString(iFailureReason, strErrMsg, iOperationResultStatus);
        if (null == this.m_oDeviceInfoMgr) {
            this.m_oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        }
        if (null == (oDevice = this.m_oDeviceInfoMgr.getDevice(iDeviceId))) {
            DCDebugTracer.trace("DC::DeviceOperationProgressController#updateDeviceProgress-getDevice is null." + iDeviceId);
            return;
        }
        oDevice.getDeviceOperationStatus().setOperationType(iOperationType);
        oDevice.getDeviceOperationStatus().setIOperationResultStatus(iOperationResultStatus);
        DCDebugTracer.trace("[DEVOPPROGRESSCTL] devid=" + iDeviceId + "|operID=" + sOperID + "|iProgressPercentage=" + iProgressPercentage + "iOperationResultStatus->" + iOperationResultStatus);
        this.updateDeviceProgress(iDeviceId, iProgressPercentage, strOperationName, iFailureReason, failureReason, iOperationResultStatus);
        this.updateClientOperations(iDeviceId, iProgressPercentage, oProgressNotification, iFailureReason);
    }

    private void updateClientOperations(int iDeviceId, int iProgressPercentage, AsnDCDeviceProgressNotify oAsnProgressNotification, int iFailureReason) {
        if (100 == iProgressPercentage || -1 != iFailureReason) {
            XFtpManager.getInstance().decrementSftpOPerationCount(iDeviceId);
        }
    }

    public static synchronized DeviceOperationProgressController getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new DeviceOperationProgressController();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeviceProgress(int iDeviceId, int iProgressPercentage, String strOperationName, int iFailureReason, String strFailureReason, int iOperationResultStatus) {
        DeviceInfo oDevice = this.m_oDeviceInfoMgr.getDevice(iDeviceId);
        if (null == oDevice) {
            DCDebugTracer.trace("DC::DeviceOperationProgressController#updateDeviceProgress oDevice is null->" + iDeviceId);
            return;
        }
        OperationStatus oOperationStatus = oDevice.getDeviceOperationStatus();
        oOperationStatus.setOperationName(strOperationName);
        DeviceInfoEvent oEvent = null;
        Object object = DCFrameWorkUtil.getSynchronizedObject();
        synchronized (object) {
            if (-1 != iProgressPercentage) {
                oOperationStatus.setIFailureReason(iFailureReason);
                oOperationStatus.setFailureReason(strFailureReason);
                oOperationStatus.setIOperationResultStatus(iOperationResultStatus);
                this.setOperationProgress(iDeviceId, iProgressPercentage, strOperationName, oOperationStatus);
                this.m_oBusyDeviceStore.addDeviceProgress(iDeviceId, oOperationStatus);
            } else {
                this.m_oBusyDeviceStore.removeDeviceProgress(iDeviceId);
                oOperationStatus.setIsProgress(false);
                oOperationStatus.setIsInitialize(false);
                oOperationStatus.setIFailureReason(iFailureReason);
                oOperationStatus.setIOperationResultStatus(iOperationResultStatus);
                String strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iFailureReason));
                if (null != strFailureReason) {
                    strErrMsg = strFailureReason;
                }
                oOperationStatus.setIFailureReason(iFailureReason);
                oOperationStatus.setFailureReason(strErrMsg);
                oOperationStatus.setOperationName(strOperationName);
                oEvent = new DeviceInfoEvent(oOperationStatus, iDeviceId, 2);
            }
        }
        oDevice.setDeviceOperationStatus(oOperationStatus);
        if (null != oEvent) {
            this.notifyEvent(oEvent);
        }
    }

    private String getFailureReasonString(int iFailureReason, String strErrMsg, int iOperationResultStatus) {
        String failureReason = DeviceInfo.getFailureReasonFromResoureFile(iFailureReason, iOperationResultStatus);
        if (999293081 == iFailureReason) {
            if (null != strErrMsg && strErrMsg.trim().length() > 0) {
                failureReason = strErrMsg;
            }
        } else if (Collator.getInstance().equals(failureReason, BigInteger.valueOf(iFailureReason).toString())) {
            if (null != strErrMsg && strErrMsg.trim().length() > 0) {
                failureReason = strErrMsg + "(" + failureReason + ")";
            }
        } else if (null != strErrMsg && strErrMsg.trim().length() > 0) {
            failureReason = failureReason + ";" + strErrMsg;
        }
        return failureReason;
    }

    private void setOperationProgress(int iDeviceId, int iProgressPercentage, String strOperationName, OperationStatus oOpeartionStatus) {
        DeviceInfoEvent oEvent = new DeviceInfoEvent(oOpeartionStatus, iDeviceId, 2);
        if (100 <= iProgressPercentage) {
            iProgressPercentage = 100;
            oOpeartionStatus.setIsProgress(true);
            oOpeartionStatus.setProgress(iProgressPercentage);
            this.notifyEvent(oEvent);
        } else if (0 <= iProgressPercentage) {
            oOpeartionStatus.setIsProgress(true);
            oOpeartionStatus.setProgress(iProgressPercentage);
            this.notifyEvent(oEvent);
        }
    }

    @Override
    public void updateDeviceProgress(int deviceId, int progressPercentage, AsnDCProgressNotify progressNotification, int failureReason, String strErrMsg) {
    }

    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || TaskEventID.TASK_PROGRESS_NOTIFICATION != oEvent.getTaskEventType() && TaskEventID.RESOURCE_PROGRESS_NOTIFICATION != oEvent.getTaskEventType()) {
            return;
        }
    }

    @Override
    public void setToNULL() {
        this.removeAllNotificationListener();
        m_oInstance = null;
        this.m_oBusyDeviceStore = null;
    }

    private void removeAllNotificationListener() {
        if (null != this.m_oListenerList) {
            while (this.m_oListenerList.size() > 0) {
                this.removeDeviceNotificationListener((IDeviceInfoListener)this.m_oListenerList.get(0));
            }
        }
    }

    @Override
    public void addDeviceNotificationListener(IDeviceInfoListener oListener) {
        if (null != oListener && !this.m_oListenerList.contains(oListener)) {
            this.m_oListenerList.add(oListener);
        }
    }

    @Override
    public void notifyEvent(DeviceInfoEvent oDeviceInfoEvent) {
        int noOfListener = this.m_oListenerList.size();
        for (int index = 0; index < noOfListener; ++index) {
            Object oListenerObj = this.m_oListenerList.get(index);
            if (!(oListenerObj instanceof IDeviceInfoListener)) continue;
            ((IDeviceInfoListener)oListenerObj).onDeviceNotification(oDeviceInfoEvent);
        }
    }

    @Override
    public void removeDeviceNotificationListener(IDeviceInfoListener oListener) {
        if (null != oListener) {
            this.m_oListenerList.remove(oListener);
        }
    }

    public static DeviceOperationProgressController getInstanceObject() {
        return m_oInstance;
    }
}

