/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.controller;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import gnu.trove.TIntObjectHashMap;

public class BusyDeviceObjectStore
implements IDCObjectDeallocator {
    private TIntObjectHashMap m_oBusyDeviceMap = new TIntObjectHashMap(0);
    private static BusyDeviceObjectStore m_oInstance;

    private BusyDeviceObjectStore() {
    }

    public static synchronized BusyDeviceObjectStore getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new BusyDeviceObjectStore();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    @Override
    public void setToNULL() {
        this.removeAllDeviceProgresses();
        m_oInstance = null;
    }

    public void addDeviceProgress(int iDeviceID, OperationStatus oStatus) {
        if (!(null == oStatus || oStatus.getIsProgress() && oStatus.getIOperationResultStatus() != 0)) {
            this.removeDeviceProgress(iDeviceID);
            return;
        }
        DCDebugTracer.trace("addDeviceProgress DevID#" + iDeviceID + "->oStatus#" + oStatus);
        this.m_oBusyDeviceMap.put(Integer.valueOf(iDeviceID).intValue(), (Object)oStatus);
    }

    public void removeDeviceProgress(int iDeviceID) {
        if (null != this.m_oBusyDeviceMap) {
            DCDebugTracer.trace("removeDeviceProgress DevID#" + iDeviceID);
            this.m_oBusyDeviceMap.remove(Integer.valueOf(iDeviceID).intValue());
        }
    }

    public OperationStatus getDeviceProgress(int iDeviceID) {
        return (OperationStatus)this.m_oBusyDeviceMap.get(Integer.valueOf(iDeviceID).intValue());
    }

    public void removeAllDeviceProgresses() {
        if (null != this.m_oBusyDeviceMap) {
            DCDebugTracer.trace("removeAllDeviceProgresses");
            this.m_oBusyDeviceMap.clear();
        }
    }

    public void updateOperationStatusForDevice(DeviceInfo oDevInfo, OperationStatus oOperationStatus) {
        if (oDevInfo != null) {
            oDevInfo.setDeviceOperationStatus(oOperationStatus);
            this.m_oBusyDeviceMap.put(Integer.valueOf(oDevInfo.getDevId()).intValue(), (Object)oOperationStatus);
        }
    }

    public boolean isDeviceOperationInProgress(int iDevId) {
        Integer devID = iDevId;
        if (this.m_oBusyDeviceMap.containsKey(devID.intValue())) {
            OperationStatus tempOperationStatus = (OperationStatus)this.m_oBusyDeviceMap.get(devID.intValue());
            if (tempOperationStatus.toString().equals(ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION"))) {
                DCDebugTracer.trace("isDeviceOperationInProgress DevID#" + devID);
                this.m_oBusyDeviceMap.remove(devID.intValue());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isContainDevInProgress() {
        Object[] objs;
        for (Object obj : objs = this.m_oBusyDeviceMap.getValues()) {
            OperationStatus oOprStatus;
            if (!(obj instanceof OperationStatus) || !(oOprStatus = (OperationStatus)obj).getIsProgress()) continue;
            return true;
        }
        return false;
    }
}

