/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckOperationPanel;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ConfigDetailPanel;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JPanel;

public class ConfigDlg
extends DCModalDialog {
    private static final long serialVersionUID = 6818551255881379684L;
    private static final int DIALOG_WIDTH = 700;
    private static final int DIALOG_HIGHT = 480;
    private ConfigDetailPanel m_oConfigDetailPanel = null;
    private ResourceManager m_resMgr = null;
    private ICheckOperationConfigParam m_checkOpParam;
    private CheckOperationPanel m_oMainPanel = null;
    private ITask m_oTask = null;
    private int iCheckType = -1;

    public ConfigDlg(ITask oTaskInfo, int iCheckType, ICheckOperationConfigParam checkOpParam, boolean bIsTreeEditable, DCModalDialog dlg) {
        super(dlg);
        if (oTaskInfo == null) {
            DCDebugTracer.trace("oTaskInfo is null");
        }
        this.m_oTask = oTaskInfo;
        this.iCheckType = iCheckType;
        if (checkOpParam == null) {
            DCDebugTracer.trace("checkOpParam is null");
            return;
        }
        this.m_checkOpParam = checkOpParam;
        TaskInfoUtil2.removeConfigNode(this.m_oTask, this.m_checkOpParam, "EXTENDCHECK");
        this.m_oMainPanel = new CheckOperationPanel(oTaskInfo, this.m_checkOpParam, bIsTreeEditable, iCheckType);
        this.m_resMgr = ResourceManager.getInstance();
        this.initGUI();
        this.addDialogWindowListener();
    }

    private void initGUI() {
        DCDebugTracer.trace("Entering ConfigDlg.initGUI");
        this.setPreferredSize(new Dimension(700, 480));
        this.setMinimumSize(new Dimension(700, 480));
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_oMainPanel, new GridBagConstraints(0, 0, 6, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(2, 4, 6, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 12, 12), 0, 0));
        DCDebugTracer.trace("Exiting ConfigDlg.initGUI");
    }

    private JPanel getButtonPanel() {
        DCDebugTracer.trace("Entering getButtonPanel");
        JPanel okConfirmPanel = new JPanel();
        okConfirmPanel.setPreferredSize(new Dimension(250, 21));
        okConfirmPanel.setMinimumSize(new Dimension(250, 21));
        GridBagLayout layout = new GridBagLayout();
        okConfirmPanel.setLayout(layout);
        this.m_oOKBtn.setText(this.m_resMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oCancelBtn.setText(this.m_resMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigDlg.this.cancleActionPerformed();
            }
        });
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigDlg.this.onOkButtonClick();
            }
        });
        okConfirmPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 2, 0), 0, 0));
        okConfirmPanel.add((Component)this.m_oOKBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 2, 0), 0, 0));
        okConfirmPanel.add((Component)this.m_oCancelBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 2, 0), 0, 0));
        DCDebugTracer.trace("Exiting getButtonPanel");
        return okConfirmPanel;
    }

    private void onOkButtonClick() {
        ConfigDetailPanel l_detailInfo = this.m_oMainPanel.getConfigDetailPanel();
        boolean isSaveConn = l_detailInfo.saveNodeChangeInfo();
        if (!isSaveConn) {
            return;
        }
        if (!this.m_oMainPanel.isValidCheckItems()) {
            return;
        }
        ConfigTreeNodeInfo oConfigNodeInfo = this.m_oMainPanel.getTreeData();
        oConfigNodeInfo.setbFirstConfigFlag(false);
        this.m_checkOpParam.setConfigTreeNode(oConfigNodeInfo);
        this.closeDialog();
    }

    private void cancleActionPerformed() {
        this.closeDialog();
    }

    @Override
    public void closeDialog() {
        this.m_oMainPanel.getConfigTreePanel().removeDeviceTreeEventListener(this.m_oConfigDetailPanel);
        super.closeDialog();
    }

    @Override
    protected String getCurrentContext() {
        int iTaskTypeID = this.m_oTask.getTaskTypeId();
        switch (iTaskTypeID) {
            case 0: {
                if (this.iCheckType == 0) {
                    return "HELP_TOPIC_SW_U_PRE_CHECK";
                }
                return "HELP_TOPIC_SW_U_POST_CHECK";
            }
            case 1: {
                if (this.iCheckType == 0) {
                    return "HELP_TOPIC_SW_D_PRE_CHECK";
                }
                return "HELP_TOPIC_SW_D_POST_CHECK";
            }
            case 3: {
                if (this.iCheckType == 0) {
                    return "HELP_TOPIC_MINIC_PRE_CHECK";
                }
                return "HELP_TOPIC_MINIC_POST_CHECK";
            }
        }
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }
}

