/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheck;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckRspLst;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckStruct;
import com.huawei.dc.common.configtree.ConfigNodeAttr;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.configtree.ConfigTreePanel;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestPanel;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItem;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemListImportAction;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.swimap.iview.util.XYConstraints;
import com.swimap.iview.util.XYLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConfigDetailPanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = -7988050987588235813L;
    private static final int MAXSIZE = 255;
    private final int USER_DEFINE_MAX_NUM = DCCommonUtil.getConfigMaxNum("USER_DEFINE_CHECK_ITEM_MAX_NUM", 100);
    private Container m_rightPnl;
    private ConfigTreeNodeInfo m_treeNodeInfo = null;
    private JTree m_tree;
    private JButton m_applyCheckButton;
    private ConfigTreePanel m_treePnl = null;
    private ConnectTestPanel m_connectPanel = null;
    private JTextField m_nameField = null;
    private JTextField m_cmdField = null;
    private JTextArea m_desArea = null;
    private ResourceManager m_resMgr = ResourceManager.getInstance();
    private JButton m_addButton;
    private JButton m_importButton;
    private JButton m_delButton;
    private JButton m_applyButton;
    private boolean m_bIsEditable = false;
    private ITask m_oTaskInfo = null;
    private boolean m_bShowCmd = true;
    private JTextField o_fileField = null;
    private JPanel o_filePnl = null;
    private JLabel o_filepath = null;
    private JButton o_selectButton = null;
    private JButton o_clearButton = null;
    private int iContextType = -1;

    public ConfigDetailPanel(ITask oTaskInfo, boolean bIsEditable) {
        this.m_oTaskInfo = oTaskInfo;
        this.initGUI();
        this.m_bShowCmd = this.isShowCmd();
        this.m_bIsEditable = bIsEditable;
    }

    public ConfigDetailPanel(ITask oTaskInfo, boolean bIsEditable, int contextType) {
        this.m_oTaskInfo = oTaskInfo;
        this.initGUI();
        this.m_bShowCmd = this.isShowCmd();
        this.m_bIsEditable = bIsEditable;
        this.iContextType = contextType;
    }

    private void initGUI() {
        DCDebugTracer.trace("Entering ConfigDetailPanal.initGUI");
        this.setLayout(new GridBagLayout());
        TitledBorder oDetailBorder = BorderFactory.createTitledBorder(this.m_resMgr.getResString("DETAILCONFIGINFO"));
        this.setBorder(oDetailBorder);
        this.setPreferredSize(new Dimension(570, 420));
        this.setMinimumSize(new Dimension(570, 420));
        this.m_rightPnl = new JPanel();
        this.m_rightPnl.setName("ConfigDetailPanel_m_rightPnl");
        this.m_rightPnl.setLayout(new BorderLayout());
        this.add((Component)this.m_rightPnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        DCDebugTracer.trace("Exiting ConfigDetailPanal.initGUI");
    }

    private void showDetailInfo() {
        DCDebugTracer.trace("Entering showDetailInfo");
        String l_nodeId = this.m_treeNodeInfo.getNodeID();
        String l_parentNodeId = this.m_treeNodeInfo.getParentID();
        if (l_nodeId.equals("UserDefined") || l_parentNodeId.equals("UserDefined")) {
            this.showUserDetailInfo();
        } else if (l_parentNodeId.equals("Connectivity")) {
            this.showConnectDetailInfo();
        } else if ("EXTENDCHECK".equals(l_nodeId)) {
            this.showExendCheckDtailInfo();
        } else if (null == this.m_treeNodeInfo.getNodeInfoLst() || this.m_treeNodeInfo.getNodeInfoLst().isEmpty()) {
            this.showSimpleDetailInfo();
        } else {
            this.m_rightPnl.removeAll();
        }
        DCDebugTracer.trace("Exiting showDetailInfo");
    }

    private void showSimpleDetailInfo() {
        DCDebugTracer.trace("Entering showSimpleDetailInfo");
        this.m_rightPnl.removeAll();
        JLabel l_nameLabel = new JLabel(this.m_resMgr.getResString("CONFIGNAME"));
        JLabel l_commandLabel = new JLabel(this.m_resMgr.getResString("CONFIGCOMMAND"));
        JLabel l_descLabel = new JLabel(this.m_resMgr.getResString("CONFIGDESC"));
        JLabel l_checkName = new JLabel();
        JLabel l_checkCommand = new JLabel();
        JTextArea l_checkDesc = new JTextArea();
        l_checkDesc.setEditable(false);
        l_checkDesc.setLineWrap(true);
        l_checkDesc.setWrapStyleWord(true);
        l_checkDesc.setFont(l_checkName.getFont());
        l_checkDesc.setBackground(this.getBackground());
        l_commandLabel.setName("showSimpleDetailInfo_l_checkDesc");
        l_nameLabel.setPreferredSize(new Dimension(80, 21));
        l_nameLabel.setMinimumSize(new Dimension(80, 21));
        l_nameLabel.setName("showSimpleDetailInfo_l_nameLabel");
        l_commandLabel.setPreferredSize(new Dimension(80, 21));
        l_commandLabel.setMinimumSize(new Dimension(80, 21));
        l_commandLabel.setName("showSimpleDetailInfo_l_commandLabel");
        ConfigNodeAttr l_nodeAttr = this.m_treeNodeInfo.getConfigNodeAttr();
        String devTypeStr = this.m_oTaskInfo.getDeviceType().getDeviceTypeName();
        if (null != l_nodeAttr) {
            if (l_nodeAttr.getNodeName().trim().isEmpty()) {
                l_checkName.setText(this.m_resMgr.getSpecialResForDMS(devTypeStr, this.m_treeNodeInfo.getNodeID()));
                l_checkName.setToolTipText(this.m_resMgr.getSpecialResForDMS(devTypeStr, this.m_treeNodeInfo.getNodeID()));
            } else {
                l_checkName.setText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getNodeName()));
                l_checkName.setToolTipText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getNodeName()));
            }
            l_checkCommand.setText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getCmd()));
            l_checkCommand.setToolTipText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getCmd()));
            l_checkDesc.setText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getDesc()));
            l_checkDesc.setToolTipText(this.m_resMgr.getSpecialResForDMS(devTypeStr, l_nodeAttr.getDesc()));
        }
        JPanel l_panel = new JPanel();
        l_panel.setLayout((LayoutManager)new XYLayout());
        l_panel.add((Component)l_nameLabel, new XYConstraints(12, 12, 100, 21));
        l_panel.add((Component)l_checkName, new XYConstraints(100, 12, 200, 21));
        if (this.m_bShowCmd) {
            l_panel.add((Component)l_commandLabel, new XYConstraints(12, 45, 100, 21));
            l_panel.add((Component)l_checkCommand, new XYConstraints(100, 45, 200, 21));
            l_panel.add((Component)l_descLabel, new XYConstraints(12, 78, 100, 21));
            l_panel.add((Component)l_checkDesc, new XYConstraints(100, 78, 250, 200));
        } else {
            l_panel.add((Component)l_descLabel, new XYConstraints(12, 45, 100, 21));
            l_panel.add((Component)l_checkDesc, new XYConstraints(100, 45, 200, 21));
        }
        this.m_rightPnl.add((Component)l_panel, "North");
        DCDebugTracer.trace("Entering showSimpleDetailInfo");
    }

    private void showUserDetailInfo() {
        DCDebugTracer.trace("Entering showUserDetailInfo");
        this.m_rightPnl.removeAll();
        JLabel l_nameLabel = new JLabel(this.m_resMgr.getResString("CONFIGNAME"));
        l_nameLabel.setPreferredSize(new Dimension(80, 21));
        l_nameLabel.setMinimumSize(new Dimension(80, 21));
        JLabel l_commandLabel = new JLabel(this.m_resMgr.getResString("CONFIGCOMMAND"));
        l_commandLabel.setPreferredSize(new Dimension(80, 21));
        l_commandLabel.setMinimumSize(new Dimension(80, 21));
        JLabel l_descLabel = new JLabel(this.m_resMgr.getResString("CONFIGDESC"));
        l_descLabel.setPreferredSize(new Dimension(120, 21));
        l_descLabel.setMinimumSize(new Dimension(120, 21));
        this.m_nameField = new JTextField();
        this.m_nameField.setPreferredSize(new Dimension(350, 21));
        this.m_nameField.setMinimumSize(new Dimension(350, 21));
        this.m_nameField.setEditable(true);
        this.m_nameField.setName("ConfigDetailPanel_m_nameField");
        this.m_cmdField = new JTextField();
        this.m_cmdField.setPreferredSize(new Dimension(350, 21));
        this.m_cmdField.setMinimumSize(new Dimension(350, 21));
        this.m_cmdField.setName("ConfigDetailPanel_m_cmdField");
        this.m_desArea = new JTextArea();
        this.m_desArea.setName("ConfigDetailPanel_m_desArea");
        this.m_desArea.setEditable(true);
        this.m_desArea.setLineWrap(true);
        this.m_desArea.setWrapStyleWord(true);
        JScrollPane l_scrollPnl = new JScrollPane(this.m_desArea);
        l_scrollPnl.setPreferredSize(new Dimension(400, 200));
        l_scrollPnl.setMinimumSize(new Dimension(400, 200));
        JPanel l_panel = new JPanel();
        l_panel.setLayout(new GridBagLayout());
        l_panel.add((Component)l_nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(12, 12, 12, 0), 0, 0));
        l_panel.add((Component)this.m_nameField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 12, 50), 0, 0));
        l_panel.add((Component)l_commandLabel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 12, 12, 0), 0, 0));
        l_panel.add((Component)this.m_cmdField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 12, 50), 0, 0));
        l_panel.add((Component)l_descLabel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 12, 12, 12), 0, 0));
        l_panel.add((Component)l_scrollPnl, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 12, 12), 0, 0));
        JPanel l_buttonPnl = this.initButtonPanel();
        this.m_rightPnl.add((Component)l_panel, "Center");
        this.m_rightPnl.add((Component)l_buttonPnl, "South");
        this.setValueForUserDefineComponent();
        this.changeComponentStatus();
        DCDebugTracer.trace("Exiting showUserDetailInfo");
    }

    private void setValueForUserDefineComponent() {
        ConfigNodeAttr l_nodeAttr = this.m_treeNodeInfo.getConfigNodeAttr();
        if (this.m_treeNodeInfo.getParentID().equals("UserDefined") && null != l_nodeAttr) {
            this.m_nameField.setText(l_nodeAttr.getNodeName());
            this.m_nameField.setEditable(false);
            this.m_cmdField.setText(l_nodeAttr.getCmd());
            this.m_desArea.setText(l_nodeAttr.getDesc());
        }
    }

    private void changeComponentStatus() {
        if (!this.m_bIsEditable) {
            this.m_nameField.setEditable(this.m_bIsEditable);
        }
        this.m_cmdField.setEditable(this.m_bIsEditable);
        this.m_desArea.setEditable(this.m_bIsEditable);
    }

    private void showExendCheckDtailInfo() {
        DCDebugTracer.trace("Entering showExendCheckDtailInfo");
        this.o_filePnl = new JPanel();
        this.m_rightPnl.removeAll();
        this.o_filePnl.setLayout((LayoutManager)new XYLayout());
        this.o_filePnl.setPreferredSize(new Dimension(420, 41));
        this.o_filePnl.setMinimumSize(new Dimension(420, 41));
        this.o_filepath = new JLabel(this.m_resMgr.getResString("FILEPATH"));
        this.o_fileField = new JTextField();
        this.o_fileField.setEditable(false);
        this.o_fileField.setText(this.m_treeNodeInfo.getExetendCheckFile());
        this.o_fileField.setToolTipText(this.m_treeNodeInfo.getExetendCheckFile());
        this.o_fileField.setName("Extend_Check_Dtail_File_Field");
        this.o_selectButton = new JButton("...");
        this.o_selectButton.setName("Extend_Check_Dtail_Select_Buttion");
        this.o_clearButton = new JButton(this.m_resMgr.getResString("CLEARBUTTON"));
        this.o_clearButton.setMnemonic('C');
        this.o_clearButton.setName("Extend_Check_Dtail_Clear_Button");
        this.o_selectButton.setActionCommand("SelectExetendCheckFile");
        this.o_clearButton.setActionCommand("ClearExetendCheckContent");
        ActionListener o_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SelectExetendCheckFile")) {
                    ConfigDetailPanel.this.selectExetendCheckFile();
                }
                if (e.getActionCommand().equalsIgnoreCase("ClearExetendCheckContent")) {
                    ConfigDetailPanel.this.o_fileField.setText("");
                    ConfigDetailPanel.this.o_fileField.setToolTipText("");
                    ConfigDetailPanel.this.m_treeNodeInfo.setExetendCheckFile("");
                }
            }
        };
        this.o_selectButton.addActionListener(o_listener);
        this.o_clearButton.addActionListener(o_listener);
        this.o_selectButton.setName("Exend_check_m_selectButton");
        this.o_clearButton.setName("Exend_check_m_clearButton");
        if (this.iContextType == 2) {
            this.o_selectButton.setEnabled(this.m_bIsEditable);
            this.o_clearButton.setEnabled(this.m_bIsEditable);
            this.o_fileField.setEnabled(this.m_bIsEditable);
            this.o_filePnl.add((Component)this.o_filepath, new XYConstraints(12, 12, 120, 21));
            this.o_filePnl.add((Component)this.o_fileField, new XYConstraints(130, 12, 361, 21));
            this.o_filePnl.add((Component)this.o_selectButton, new XYConstraints(492, 12, 20, 21));
            this.o_filePnl.add((Component)this.o_clearButton, new XYConstraints(520, 12, 75, 21));
        } else if (this.iContextType == 1) {
            this.o_filePnl.add((Component)this.o_filepath, new XYConstraints(12, 12, 120, 21));
            this.o_filePnl.add((Component)this.o_fileField, new XYConstraints(130, 12, 361, 21));
            this.o_filePnl.add((Component)this.o_selectButton, new XYConstraints(492, 12, 20, 21));
            this.o_filePnl.add((Component)this.o_clearButton, new XYConstraints(520, 12, 75, 21));
        } else {
            this.o_filePnl.add((Component)this.o_filepath, new XYConstraints(12, 12, 120, 21));
            this.o_filePnl.add((Component)this.o_fileField, new XYConstraints(120, 12, 200, 21));
            this.o_filePnl.add((Component)this.o_selectButton, new XYConstraints(321, 12, 20, 21));
            this.o_filePnl.add((Component)this.o_clearButton, new XYConstraints(347, 12, 75, 21));
        }
        this.m_rightPnl.add((Component)this.o_filePnl, "North");
        DCDebugTracer.trace("Ending showExendCheckDtailInfo");
    }

    private void selectExetendCheckFile() {
        DCDebugTracer.trace("Entering selectExetendCheckFile");
        String strOKButton = this.m_resMgr.getResString("OPENFILE");
        String strOKToolTip = this.m_resMgr.getResString("OPENFILE");
        String strTitle = this.m_resMgr.getResString("SELECT_EXTEDN_CHECK_FILE");
        DCFileChooser oExetendCheckFileChooser = new DCFileChooser();
        oExetendCheckFileChooser.setFileFilter(32);
        oExetendCheckFileChooser.setAcceptAllFileFilterUsed(false);
        oExetendCheckFileChooser.setTitle(strTitle);
        oExetendCheckFileChooser.setApproveButtonText(strOKButton);
        oExetendCheckFileChooser.setApproveButtonToolTipText(strOKToolTip);
        PrintSupportor.setIsFileSelection(false);
        oExetendCheckFileChooser.setApproveButtonMnemonic('I');
        int iReturnVal = -1;
        iReturnVal = oExetendCheckFileChooser.showOpenDialog(this);
        if (0 != iReturnVal) {
            return;
        }
        if (null == oExetendCheckFileChooser.getSelectedFile()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("PRINT_FILENAME_ERROR"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        File file = oExetendCheckFileChooser.getSelectedFile();
        if (file == null) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("FILE_EMPTY"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        if (0x400000L < file.length()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("EXTENDCHECKFILETOOBIGINFO"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        if (0L == file.length()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("FILE_EMPTY"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        DeviceType oDeviceType = this.m_oTaskInfo.getDeviceType();
        String oDevTargetVersion = this.m_oTaskInfo.getTargetVersion();
        AsnDCExtendCheckRspLst oAsnDCExtendCheckRspLst = new AsnDCExtendCheckRspLst();
        try {
            oAsnDCExtendCheckRspLst = DeviceInfoSyncCtrller.getInstance().sendExtendCheckFileToServer(oDeviceType, file, oDevTargetVersion);
        }
        catch (DCException e) {
            this.o_fileField.setText("");
            this.o_fileField.setToolTipText("");
            this.m_treeNodeInfo.setExetendCheckFile("");
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), this.m_resMgr.getResString("WARNING"), 2);
            DCDebugTracer.trace(e.getMessage());
            return;
        }
        ArrayList<AsnDCExtendCheckStruct> oFailExtendCheckList = new ArrayList<AsnDCExtendCheckStruct>(0);
        AsnDCExtendCheckStruct oAsnDCExtendCheckStruct = null;
        int iSize = oAsnDCExtendCheckRspLst.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnDCExtendCheckStruct = (AsnDCExtendCheckStruct)oAsnDCExtendCheckRspLst.get(i);
            int iErrorCode = oAsnDCExtendCheckStruct.oErrorInfo.iErrorNo.intValue();
            if (0 == iErrorCode) continue;
            oFailExtendCheckList.add(oAsnDCExtendCheckStruct);
        }
        if (oFailExtendCheckList.size() > 0) {
            StringBuffer strText = new StringBuffer();
            int i_Size = oFailExtendCheckList.size();
            strText.append("\n");
            for (int i = 0; i < i_Size; ++i) {
                if (i > 0) {
                    strText.append(",\n");
                }
                oAsnDCExtendCheckStruct = (AsnDCExtendCheckStruct)oFailExtendCheckList.get(i);
                AsnDCExtendCheck oAsnDCExtendCheck = oAsnDCExtendCheckStruct.oAsnDCExtendCheck;
                DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(oAsnDCExtendCheck.iDevID.intValue());
                strText.append(oDeviceInfo.getDevName() + "(" + oDeviceInfo.getDevIPAddress() + ")");
            }
            this.o_fileField.setText("");
            this.o_fileField.setToolTipText("");
            this.m_treeNodeInfo.setExetendCheckFile("");
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("EXTENDCHECKFAILED") + strText.toString(), this.m_resMgr.getResString("WARNING"), 2);
        } else {
            String strFileName = oExetendCheckFileChooser.getFullFileName();
            this.o_fileField.setText(strFileName);
            this.o_fileField.setToolTipText(strFileName);
            this.m_treeNodeInfo.setExetendCheckFile(strFileName);
        }
        DCDebugTracer.trace("Ending selectExetendCheckFile");
    }

    private void showConnectDetailInfo() {
        DCDebugTracer.trace("Entering showConnectDetailInfo");
        this.initConnectComponent();
        this.addConnComponentListener();
        JPanel l_conPnl = new JPanel();
        l_conPnl.setLayout(new GridBagLayout());
        l_conPnl.setName("ConfigDetailPanel_l_conPnl");
        l_conPnl.add((Component)this.m_connectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        l_conPnl.add((Component)this.m_applyCheckButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(7, 0, 7, 12), 0, 0));
        this.m_rightPnl.removeAll();
        this.m_rightPnl.add((Component)l_conPnl, "Center");
        this.m_applyCheckButton.setEnabled(this.m_bIsEditable);
        this.m_connectPanel.setContentEditable(this.m_bIsEditable);
        DCDebugTracer.trace("Exiting showConnectDetailInfo");
    }

    private void initConnectComponent() {
        ConnectTestInfo l_conInfo = this.m_treeNodeInfo.getConfigNodeConnInfo();
        int l_devId = l_conInfo.getDeviceId();
        if (null == this.m_connectPanel) {
            this.m_connectPanel = new ConnectTestPanel(l_devId);
        }
        if (null == this.m_applyCheckButton) {
            this.m_applyCheckButton = new JButton();
            this.m_applyCheckButton.setFocusable(false);
            this.m_applyCheckButton.setName("ConfigDetailPanel_m_applyCheckButton");
            this.m_applyCheckButton.setMinimumSize(new Dimension(160, 23));
            this.m_applyCheckButton.setPreferredSize(new Dimension(160, 23));
            this.m_applyCheckButton.setText(this.m_resMgr.getResString("APPLYALL"));
            this.m_applyCheckButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ConfigDetailPanel.this.checkboxActionPerform();
                }
            });
        }
        this.m_connectPanel.initConnInfo(l_conInfo);
    }

    private void addConnComponentListener() {
        JTextArea l_cmdArea = this.m_connectPanel.getCmdTextArea();
        l_cmdArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                ConfigDetailPanel.this.m_applyCheckButton.setSelected(false);
            }
        });
    }

    private void checkboxActionPerform() {
        DCDebugTracer.trace("Entering checkboxActionPerform");
        if (null == this.m_tree) {
            return;
        }
        DefaultMutableTreeNode NodeObj = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)NodeObj.getParent();
        Enumeration<TreeNode> l_children = parentNode.breadthFirstEnumeration();
        ConfigTreeNodeInfo nodeInfo = (ConfigTreeNodeInfo)parentNode.getUserObject();
        Enumeration<TreeNode> child = parentNode.children();
        ConnectTestInfo l_conStruct = this.m_connectPanel.getConnectTestInfo();
        boolean isValid = this.m_connectPanel.testIsValid();
        if (!isValid) {
            return;
        }
        this.m_treePnl.handleSelection(parentNode, nodeInfo, 2, l_children);
        ConfigTreeNodeInfo oTreeNode = null;
        ConnectTestInfo oConnInfo = null;
        while (child.hasMoreElements()) {
            oTreeNode = (ConfigTreeNodeInfo)((DefaultMutableTreeNode)child.nextElement()).getUserObject();
            oConnInfo = oTreeNode.getConfigNodeConnInfo();
            oConnInfo.setCheckContent(l_conStruct.getCheckContent());
            oConnInfo.setCheckMode(l_conStruct.getCheckMode());
        }
        this.m_tree.treeDidChange();
        DCDebugTracer.trace("Exiting checkboxActionPerform");
    }

    private JPanel initButtonPanel() {
        DCDebugTracer.trace("Entering initButtonPanel");
        JPanel m_buttonPanel = new JPanel();
        this.m_importButton = new JButton();
        this.m_importButton.setMaximumSize(new Dimension(81, 21));
        this.m_importButton.setMinimumSize(new Dimension(81, 21));
        this.m_importButton.setPreferredSize(new Dimension(81, 21));
        this.m_importButton.setMnemonic('I');
        this.m_importButton.setText(this.m_resMgr.getResString("IMPORTBUTTON"));
        this.m_importButton.setName("ConfigDetailPanel_m_importButton");
        this.m_addButton = new JButton();
        this.m_addButton.setMaximumSize(new Dimension(81, 21));
        this.m_addButton.setMinimumSize(new Dimension(81, 21));
        this.m_addButton.setPreferredSize(new Dimension(81, 21));
        this.m_addButton.setMnemonic('A');
        this.m_addButton.setText(this.m_resMgr.getResString("ADDBUTTON"));
        this.m_addButton.setName("ConfigDetailPanel_m_addButton");
        this.m_delButton = new JButton();
        this.m_delButton.setMaximumSize(new Dimension(81, 21));
        this.m_delButton.setMinimumSize(new Dimension(81, 21));
        this.m_delButton.setPreferredSize(new Dimension(81, 21));
        this.m_delButton.setMnemonic('D');
        this.m_delButton.setText(this.m_resMgr.getResString("DELETEBUTTON"));
        this.m_delButton.setName("ConfigDetailPanel_m_delButton");
        this.m_applyButton = new JButton();
        this.m_applyButton.setMaximumSize(new Dimension(81, 21));
        this.m_applyButton.setMinimumSize(new Dimension(81, 21));
        this.m_applyButton.setPreferredSize(new Dimension(81, 21));
        this.m_applyButton.setMnemonic('P');
        this.m_applyButton.setText(this.m_resMgr.getResString("APPLYBUTTON"));
        this.m_applyButton.setName("ConfigDetailPanel_m_applyButton");
        m_buttonPanel.setLayout(new GridBagLayout());
        m_buttonPanel.setName("ConfigDetailPanel_m_buttonPanel");
        m_buttonPanel.add(Box.createVerticalStrut(1), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 12, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_importButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 12, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_addButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 12, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_delButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 12, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_applyButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 12, 12), 0, 0));
        this.addButtonListener();
        this.setComponentStatus();
        DCDebugTracer.trace("Exiting initButtonPanel");
        return m_buttonPanel;
    }

    private void setComponentStatus() {
        if (this.m_treeNodeInfo.getParentID().equals("UserDefined")) {
            this.m_nameField.setEditable(false);
            this.m_importButton.setEnabled(false);
            this.m_addButton.setEnabled(false);
            this.m_delButton.setEnabled(true);
            this.m_applyButton.setEnabled(true);
        } else if (this.m_treeNodeInfo.getNodeID().equals("UserDefined")) {
            this.m_importButton.setEnabled(true);
            this.m_addButton.setEnabled(true);
            this.m_delButton.setEnabled(false);
            this.m_applyButton.setEnabled(false);
        }
        if (!this.m_bIsEditable) {
            this.m_importButton.setEnabled(false);
            this.m_addButton.setEnabled(false);
            this.m_delButton.setEnabled(false);
            this.m_applyButton.setEnabled(false);
        }
    }

    private void addButtonListener() {
        String ADD_CMD_STR = "AddAction";
        String DEL_CMD_STR = "DeleteAction";
        String APP_CMD_STR = "ApplyButton";
        ActionListener olistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strCmd = e.getActionCommand();
                if ("AddAction".equalsIgnoreCase(strCmd)) {
                    ConfigDetailPanel.this.addTreeNode();
                } else if ("DeleteAction".equalsIgnoreCase(strCmd)) {
                    ConfigDetailPanel.this.deleteTreeNode();
                } else if ("ApplyButton".equalsIgnoreCase(strCmd)) {
                    ConfigDetailPanel.this.saveUserDetailInfo();
                } else {
                    DCDebugTracer.trace("invaild Cmd : " + strCmd);
                }
            }
        };
        this.m_addButton.setActionCommand("AddAction");
        this.m_addButton.addActionListener(olistener);
        this.m_delButton.setActionCommand("DeleteAction");
        this.m_delButton.addActionListener(olistener);
        this.m_applyButton.addActionListener(olistener);
        this.m_applyButton.setActionCommand("ApplyButton");
        this.m_importButton.addActionListener(new CheckItemListImportAction(this));
    }

    private void addTreeNode() {
        DCDebugTracer.trace("Entering addTreeNode");
        boolean bIsValid = this.validUserDefineCheckItemFormat();
        if (!bIsValid) {
            return;
        }
        ArrayList<CheckItem> checkItemLst = new ArrayList<CheckItem>(1);
        CheckItem oCheckItem = new CheckItem();
        oCheckItem.setDisplayName(this.m_nameField.getText().trim());
        oCheckItem.setCmd(this.m_cmdField.getText().trim());
        oCheckItem.setDescription(this.m_desArea.getText().trim());
        checkItemLst.add(oCheckItem);
        String[] args = new String[]{String.valueOf(this.USER_DEFINE_MAX_NUM)};
        DCErrorCode oDCErrorCode = this.checkUserDefineCheckItemSize(checkItemLst, this.m_resMgr.getResString("ADD_CHECK_EXTEND_MAX_NUMBER", args));
        if (oDCErrorCode.getErrorCode() != 0) {
            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), oDCErrorCode.getErrorMsg());
            return;
        }
        CheckItem checkItem = this.getFirstRepeatCheckItem(checkItemLst);
        if (null != checkItem) {
            args = new String[]{checkItem.getDisplayName() + "-" + checkItem.getCmd()};
            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("ADD_CHECK_ITEM_REPEAT_ERROR", args));
            this.traceUseDefineCheckItem();
            return;
        }
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        Enumeration<TreeNode> child = parentNode.children();
        ConfigTreeNodeInfo l_childInfo = null;
        String l_name = this.m_nameField.getText().trim();
        while (child.hasMoreElements()) {
            l_childInfo = (ConfigTreeNodeInfo)((DefaultMutableTreeNode)child.nextElement()).getUserObject();
            if (!l_childInfo.getConfigNodeAttr().getNodeName().equalsIgnoreCase(l_name)) continue;
            DCOptionPane.showMessageDialog((Component)this, this.m_resMgr.getResString("SAME_NODE_NAME"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        ConfigTreeNodeInfo l_oParentNode = (ConfigTreeNodeInfo)parentNode.getUserObject();
        ConfigTreeNodeInfo oConfigInfo = this.constructTreeNode(l_oParentNode);
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(oConfigInfo);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
        treeModel.insertNodeInto(treeNode, parentNode, parentNode.getChildCount());
        l_oParentNode.getNodeInfoLst().add(oConfigInfo);
        this.m_tree.scrollPathToVisible(new TreePath(treeNode.getPath()));
        this.m_tree.setSelectionPath(new TreePath(treeNode.getPath()));
        this.m_tree.treeDidChange();
        this.m_treePnl.sendNotificationToTreeListeners(treeNode);
        this.updateBtnStatus();
        DCDebugTracer.trace("Exiting addTreeNode");
    }

    public void importCheckItemLstToTree(List<CheckItem> checkItemList) {
        DCDebugTracer.trace("ConfigDetailPanel#importCheckItemLstTreeNode start ");
        DCErrorCode oDCErrorCode = this.verifyUserDefineInfo(checkItemList);
        if (0 != oDCErrorCode.getErrorCode()) {
            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), oDCErrorCode.getErrorMsg());
            DCDebugTracer.traceError("ConfigDetailPanel#importCheckItemLstTreeNode Have Error" + oDCErrorCode.getErrorMsg());
            return;
        }
        DefaultMutableTreeNode treeNode = this.insertCheckItemLst(checkItemList);
        this.m_treePnl.sendNotificationToTreeListeners(treeNode);
        this.updateBtnStatus();
        DCDebugTracer.trace("ConfigDetailPanel#importCheckItemLstTreeNode end.. ");
    }

    private void updateBtnStatus() {
        this.m_addButton.setEnabled(false);
        this.m_importButton.setEnabled(false);
        this.m_delButton.setEnabled(true);
        this.m_applyButton.setEnabled(true);
    }

    private DefaultMutableTreeNode insertCheckItemLst(List<CheckItem> checkItemList) {
        DCDebugTracer.trace("ConfigDetailPanel#inseartCheckItemLst start ");
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        ConfigTreeNodeInfo oParentNode = (ConfigTreeNodeInfo)parentNode.getUserObject();
        ConfigTreeNodeInfo oConfigInfo = null;
        DefaultMutableTreeNode treeNode = null;
        DefaultTreeModel treeModel = null;
        for (CheckItem oCheckItem : checkItemList) {
            oConfigInfo = this.constructTreeNodeByCheckItem(oParentNode, oCheckItem);
            treeNode = new DefaultMutableTreeNode(oConfigInfo);
            treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.insertNodeInto(treeNode, parentNode, parentNode.getChildCount());
            oParentNode.getNodeInfoLst().add(oConfigInfo);
        }
        if (null != treeNode) {
            this.m_tree.scrollPathToVisible(new TreePath(treeNode.getPath()));
            this.m_tree.setSelectionPath(new TreePath(treeNode.getPath()));
            this.m_tree.treeDidChange();
        }
        DCDebugTracer.trace("ConfigDetailPanel#inseartCheckItemLst end.. ");
        return treeNode;
    }

    private DCErrorCode verifyUserDefineInfo(List<CheckItem> checkItemList) {
        DCDebugTracer.trace("ConfigDetailPanel#validUserDefineListInfo start ");
        DCErrorCode oDCErrorCode = new DCErrorCode(0);
        if (checkItemList.isEmpty()) {
            oDCErrorCode.setErrorCode(-1);
            oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("CHECK_ITEM_EMPTY"));
            DCDebugTracer.traceError("ConfigDetailPanel#validUserDefineListInfo : " + oDCErrorCode.getErrorMsg());
            return oDCErrorCode;
        }
        String[] args = new String[]{String.valueOf(this.USER_DEFINE_MAX_NUM)};
        oDCErrorCode = this.checkUserDefineCheckItemSize(checkItemList, this.m_resMgr.getResString("CHECK_EXTEND_MAX_NUMBER", args));
        if (0 != oDCErrorCode.getErrorCode()) {
            DCDebugTracer.traceError("ConfigDetailPanel#validUserDefineListInfo : " + oDCErrorCode.getErrorMsg());
            return oDCErrorCode;
        }
        oDCErrorCode = this.verifyCheckItemFormat(checkItemList);
        if (0 != oDCErrorCode.getErrorCode()) {
            DCDebugTracer.traceError("ConfigDetailPanel#validUserDefineListInfo : " + oDCErrorCode.getErrorMsg());
            return oDCErrorCode;
        }
        CheckItem checkItem = this.getFirstRepeatCheckItem(checkItemList);
        if (null != checkItem) {
            args = new String[]{checkItem.getDisplayName() + "-" + checkItem.getCmd()};
            oDCErrorCode.setErrorCode(-1);
            oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("CHECK_ITEM_REPEAT_ERROR", args));
            DCDebugTracer.traceError("ConfigDetailPanel#validUserDefineListInfo : " + oDCErrorCode.getErrorMsg());
            this.traceUseDefineCheckItem();
            return oDCErrorCode;
        }
        DCDebugTracer.trace("ConfigDetailPanel#verifyUserDefineListInfo end.. ");
        return oDCErrorCode;
    }

    private DCErrorCode checkUserDefineCheckItemSize(List<CheckItem> checkItemList, String errMsg) {
        DCErrorCode oDCErrorCode = new DCErrorCode(0);
        int iCheckItemSize = checkItemList.size();
        if (iCheckItemSize > this.USER_DEFINE_MAX_NUM) {
            oDCErrorCode.setErrorCode(-1);
            oDCErrorCode.setErrorMsg(errMsg);
            return oDCErrorCode;
        }
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        Enumeration<TreeNode> child = parentNode.children();
        int currentSize = 0;
        while (child.hasMoreElements()) {
            ((DefaultMutableTreeNode)child.nextElement()).getUserObject();
            ++currentSize;
        }
        if (currentSize + iCheckItemSize > this.USER_DEFINE_MAX_NUM) {
            oDCErrorCode.setErrorCode(-1);
            oDCErrorCode.setErrorMsg(errMsg);
            return oDCErrorCode;
        }
        return oDCErrorCode;
    }

    private CheckItem getFirstRepeatCheckItem(List<CheckItem> checkItemList) {
        HashSet<CheckItem> checkItemSet = new HashSet<CheckItem>();
        for (CheckItem checkItem : checkItemList) {
            if (checkItemSet.add(checkItem)) continue;
            return checkItem;
        }
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        Enumeration<TreeNode> child = parentNode.children();
        ConfigTreeNodeInfo childInfo = null;
        CheckItem tempCheckItem = null;
        while (child.hasMoreElements()) {
            childInfo = (ConfigTreeNodeInfo)((DefaultMutableTreeNode)child.nextElement()).getUserObject();
            tempCheckItem = new CheckItem();
            tempCheckItem.setCmd(childInfo.getConfigNodeAttr().getCmd());
            tempCheckItem.setDisplayName(childInfo.getConfigNodeAttr().getNodeName());
            if (checkItemSet.add(tempCheckItem)) continue;
            return tempCheckItem;
        }
        return null;
    }

    private CheckItem getCurrFirstRepeatCheckItem() {
        TreePath curSelTreepath = this.m_tree.getSelectionPath();
        DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)curSelTreepath.getLastPathComponent();
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        Enumeration<TreeNode> child = parentNode.children();
        ConfigTreeNodeInfo childInfo = null;
        CheckItem tempCheckItem = null;
        HashSet<CheckItem> checkItemSet = new HashSet<CheckItem>();
        while (child.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)child.nextElement();
            tempCheckItem = new CheckItem();
            if (null != selectionNode && selectionNode.equals(node)) {
                tempCheckItem.setCmd(this.m_cmdField.getText().trim());
                tempCheckItem.setDisplayName(this.m_nameField.getText().trim());
            } else {
                childInfo = (ConfigTreeNodeInfo)node.getUserObject();
                tempCheckItem.setCmd(childInfo.getConfigNodeAttr().getCmd());
                tempCheckItem.setDisplayName(childInfo.getConfigNodeAttr().getNodeName());
            }
            if (checkItemSet.add(tempCheckItem)) continue;
            return tempCheckItem;
        }
        return null;
    }

    public void traceUseDefineCheckItem() {
        DefaultMutableTreeNode parentNode = this.m_treePnl.getNode("UserDefined");
        Enumeration<TreeNode> child = parentNode.children();
        ConfigTreeNodeInfo childInfo = null;
        CheckItem tempCheckItem = null;
        while (child.hasMoreElements()) {
            childInfo = (ConfigTreeNodeInfo)((DefaultMutableTreeNode)child.nextElement()).getUserObject();
            tempCheckItem = new CheckItem();
            tempCheckItem.setCmd(childInfo.getConfigNodeAttr().getCmd());
            tempCheckItem.setDisplayName(childInfo.getConfigNodeAttr().getNodeName());
            DCDebugTracer.trace(tempCheckItem.toString());
        }
    }

    private DCErrorCode verifyCheckItemFormat(List<CheckItem> checkItemList) {
        DCErrorCode oDCErrorCode = new DCErrorCode(0);
        String oDisplayName = null;
        String oCheckCmd = null;
        String oCheckDesc = null;
        for (CheckItem oCheckItem : checkItemList) {
            oDisplayName = oCheckItem.getDisplayName();
            if (StringUtils.isNullOrEmptyStr(oDisplayName)) {
                oDCErrorCode.setErrorCode(-1);
                oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("CHECK_ITEM_NAME_EMPTY"));
                return oDCErrorCode;
            }
            if (oDisplayName.getBytes().length > 255) {
                String[] args = new String[]{this.m_resMgr.getResString("CHECK_ITEM_NAME")};
                oDCErrorCode.setErrorCode(-1);
                oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("ERROR_MORE_THAN_MAX", args));
                return oDCErrorCode;
            }
            oCheckCmd = oCheckItem.getCmd();
            if (StringUtils.isNullOrEmptyStr(oCheckCmd)) {
                oDCErrorCode.setErrorCode(-1);
                oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("CHECK_ITEM_CMD_EMPTY"));
                return oDCErrorCode;
            }
            if (oCheckCmd.getBytes().length > 255) {
                String[] args = new String[]{this.m_resMgr.getResString("CHECK_ITEM_CMD")};
                oDCErrorCode.setErrorCode(-1);
                oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("ERROR_MORE_THAN_MAX", args));
                return oDCErrorCode;
            }
            oCheckDesc = oCheckItem.getDescription();
            if (null == oCheckDesc || oCheckDesc.getBytes().length <= 255) continue;
            String[] args = new String[]{this.m_resMgr.getResString("CHECK_ITEM_DESC")};
            oDCErrorCode.setErrorCode(-1);
            oDCErrorCode.setErrorMsg(this.m_resMgr.getResString("ERROR_MORE_THAN_MAX", args));
            return oDCErrorCode;
        }
        return oDCErrorCode;
    }

    private ConfigTreeNodeInfo constructTreeNodeByCheckItem(ConfigTreeNodeInfo oParentNode, CheckItem oCheckItem) {
        List<ConfigTreeNodeInfo> oNodeList;
        DCDebugTracer.trace("ConfigDetailPanel#constructTreeNodeByCheckItem start ");
        ConfigTreeNodeInfo oConfigInfo = new ConfigTreeNodeInfo();
        ConfigNodeAttr oNodeAttr = new ConfigNodeAttr();
        oNodeAttr.setNodeName(oCheckItem.getDisplayName());
        oNodeAttr.setCmd(oCheckItem.getCmd());
        oNodeAttr.setDesc(oCheckItem.getDescription());
        oConfigInfo.setConfigNodeAttr(oNodeAttr);
        oConfigInfo.setNodeID(oCheckItem.getDisplayName());
        oConfigInfo.setParentID("UserDefined");
        if (2 != oParentNode.getNodeSelectedState()) {
            oConfigInfo.setNodeSelectedState(0);
        }
        if (null != (oNodeList = oParentNode.getNodeInfoLst())) {
            oConfigInfo.setSeqNumber(oNodeList.size() + 1);
        }
        DCDebugTracer.trace("ConfigDetailPanel#constructTreeNodeByCheckItem end.. ");
        return oConfigInfo;
    }

    private ConfigTreeNodeInfo constructTreeNode(ConfigTreeNodeInfo l_oParentNode) {
        List<ConfigTreeNodeInfo> l_nodeList;
        ConfigTreeNodeInfo oConfigInfo = new ConfigTreeNodeInfo();
        ConfigNodeAttr l_nodeAttr = new ConfigNodeAttr();
        l_nodeAttr.setNodeName(this.m_nameField.getText());
        l_nodeAttr.setCmd(this.m_cmdField.getText());
        l_nodeAttr.setDesc(this.m_desArea.getText());
        oConfigInfo.setConfigNodeAttr(l_nodeAttr);
        oConfigInfo.setNodeID(this.m_nameField.getText());
        oConfigInfo.setParentID("UserDefined");
        if (2 != l_oParentNode.getNodeSelectedState()) {
            oConfigInfo.setNodeSelectedState(0);
        }
        if (null != (l_nodeList = l_oParentNode.getNodeInfoLst())) {
            oConfigInfo.setSeqNumber(l_nodeList.size() + 1);
        }
        return oConfigInfo;
    }

    private boolean validUserDefineCheckItemFormat() {
        String name = this.m_nameField.getText().trim();
        String command = this.m_cmdField.getText().trim();
        String description = this.m_desArea.getText().trim();
        if (null == this.m_tree) {
            return false;
        }
        if (name.isEmpty() || command.isEmpty()) {
            DCOptionPane.showMessageDialog((Component)this, this.m_resMgr.getResString("NAME_CMD_EMPTY"), this.m_resMgr.getResString("WARNING"), 2);
            return false;
        }
        if (255 < name.getBytes().length || 255 < command.getBytes().length || 255 < description.getBytes().length) {
            DCOptionPane.showMessageDialog((Component)this, this.m_resMgr.getResString("MORE_THAN_MAX"), this.m_resMgr.getResString("WARNING"), 2);
            return false;
        }
        return true;
    }

    private void deleteTreeNode() {
        DCDebugTracer.trace("Entering deleteTreeNode");
        int l_confirm = DCOptionPane.showConfirmDialog((Component)this, this.m_resMgr.getResString("DELETE_NODE_CONFIRM"), this.m_resMgr.getResString("CONFIRM"), 0);
        if (l_confirm != 0) {
            return;
        }
        TreePath treepath = this.m_tree.getSelectionPath();
        if (null == treepath) {
            return;
        }
        DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
        DefaultMutableTreeNode l_parentNode = (DefaultMutableTreeNode)selectionNode.getParent();
        if (null == l_parentNode) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
        treeModel.removeNodeFromParent(selectionNode);
        this.m_tree.setSelectionPath(new TreePath(l_parentNode.getPath()));
        this.m_addButton.setEnabled(true);
        this.m_delButton.setEnabled(false);
        this.m_applyButton.setEnabled(false);
        List<ConfigTreeNodeInfo> l_nodeList = ((ConfigTreeNodeInfo)l_parentNode.getUserObject()).getNodeInfoLst();
        l_nodeList.remove(selectionNode.getUserObject());
        if (l_nodeList.isEmpty()) {
            this.m_treePnl.handleSelection(l_parentNode, (ConfigTreeNodeInfo)l_parentNode.getUserObject(), 0, null);
        }
        this.m_treePnl.sendNotificationToTreeListeners(l_parentNode);
        DCDebugTracer.trace("Exiting deleteTreeNode");
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
        DCDebugTracer.trace("Entering onTreeNodeSelection");
        Object nodeObject = eventObject.getSource();
        if (!(nodeObject instanceof ConfigTreeNodeInfo)) {
            DCDebugTracer.trace("if (!(nodeObject instanceof ConfigTreeNodeInfo)):Exiting onTreeNodeSelection");
            return;
        }
        ConfigTreeNodeInfo l_currentNode = (ConfigTreeNodeInfo)nodeObject;
        if (null != this.m_treeNodeInfo && l_currentNode.getNodeID().equals(this.m_treeNodeInfo.getNodeID())) {
            DCDebugTracer.trace("if(null != m_treeNodeInfo && l_currentNode.getNodeID().equals(m_treeNodeInfo.getNodeID())):Exiting onTreeNodeSelection");
            return;
        }
        this.saveNodeChangeInfo();
        this.m_treeNodeInfo = (ConfigTreeNodeInfo)nodeObject;
        this.showDetailInfo();
        DCFrameWorkUtil.updateUI(this);
        DCDebugTracer.trace("Exiting onTreeNodeSelection");
    }

    public void setTreePanel(ConfigTreePanel treePnl) {
        DCDebugTracer.trace("Entering setTreePanel");
        this.m_tree = treePnl.getConfigTree();
        this.m_treePnl = treePnl;
        DCDebugTracer.trace("Exiting setTreePanel");
    }

    public boolean saveNodeChangeInfo() {
        DCDebugTracer.trace("Entering saveNodeChangeInfo");
        if (null == this.m_treeNodeInfo) {
            return true;
        }
        String l_parentNodeId = this.m_treeNodeInfo.getParentID();
        if (l_parentNodeId.equals("Connectivity") && !this.saveConnectDetailInfo()) {
            return false;
        }
        DCDebugTracer.trace("Exiting saveNodeChangeInfo");
        return true;
    }

    private void saveUserDetailInfo() {
        DCDebugTracer.trace("Entering saveUserDetailInfo");
        boolean bIsValid = this.validUserDefineCheckItemFormat();
        if (!bIsValid) {
            return;
        }
        CheckItem checkItem = this.getCurrFirstRepeatCheckItem();
        if (null != checkItem) {
            String[] args = new String[]{checkItem.getDisplayName() + "-" + checkItem.getCmd()};
            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("MODIFY_CHECK_ITEM_REPEAT_ERROR", args));
            this.traceUseDefineCheckItem();
            return;
        }
        ConfigNodeAttr l_nodeAttr = new ConfigNodeAttr();
        l_nodeAttr.setNodeName(this.m_nameField.getText());
        l_nodeAttr.setCmd(this.m_cmdField.getText());
        l_nodeAttr.setDesc(this.m_desArea.getText());
        this.m_treeNodeInfo.setConfigNodeAttr(l_nodeAttr);
        DCOptionPane.showMessageDialog((Component)this, this.m_resMgr.getResString("SAVE_SUCCESS"), this.m_resMgr.getResString("INFO"), 1);
        DCDebugTracer.trace("Exiting saveUserDetailInfo");
    }

    public boolean saveConnectDetailInfo() {
        DCDebugTracer.trace("Entering saveConnectDetailInfo");
        if (null != this.m_connectPanel) {
            boolean isValid = this.m_connectPanel.testIsValid();
            if (!isValid) {
                return false;
            }
            ConnectTestInfo l_conStruct = this.m_connectPanel.getConnectTestInfo();
            ConnectTestInfo oNodeConnInfo = this.m_treeNodeInfo.getConfigNodeConnInfo();
            if (null != oNodeConnInfo) {
                oNodeConnInfo.setCheckContent(l_conStruct.getCheckContent());
                oNodeConnInfo.setCheckMode(l_conStruct.getCheckMode());
            }
        }
        DCDebugTracer.trace("Exiting saveConnectDetailInfo");
        return true;
    }

    private boolean isShowCmd() {
        boolean bShowCmd = true;
        if (null == this.m_oTaskInfo) {
            return bShowCmd;
        }
        List<DeviceTypeInfo> oDevTypeLst = this.m_oTaskInfo.getDeviceTypeLst();
        for (DeviceTypeInfo oDevType : oDevTypeLst) {
            if (null == oDevType || !oDevType.isBMSDomain()) continue;
            return false;
        }
        return bShowCmd;
    }
}

