/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.configtree.ConfigCheckTree;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.configtree.ConfigTreePanel;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ConfigDetailPanel;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckOperationPanel
extends JPanel {
    private static final long serialVersionUID = 6818551255881379684L;
    private ConfigTreeNodeInfo m_oConfigTreeNodeInfo = null;
    private ConfigTreePanel m_oConfigTreePanel = null;
    private ConfigDetailPanel m_oConfigDetailPanel = null;
    private ICheckOperationConfigParam m_checkOpParam;
    private boolean m_bIsEditable = true;
    private ITask m_oTaskInfo = null;
    private int iContextType = -1;
    private int iCheckType = 0;

    public CheckOperationPanel(ITask oTaskInfo, ICheckOperationConfigParam oCheckOpParam, boolean bIsTreeEditable, int contextType, int iCheckType) {
        this.m_oTaskInfo = oTaskInfo;
        this.m_checkOpParam = oCheckOpParam;
        if (2 != contextType) {
            TaskInfoUtil2.removeConfigNode(this.m_oTaskInfo, this.m_checkOpParam, "EXTENDCHECK");
        }
        this.m_oConfigTreeNodeInfo = this.m_checkOpParam.getConfigTreeNode();
        this.m_bIsEditable = bIsTreeEditable;
        this.iContextType = contextType;
        this.iCheckType = iCheckType;
        this.initGUI();
    }

    public CheckOperationPanel(ITask oTaskInfo, ICheckOperationConfigParam oCheckOpParam, boolean bIsTreeEditable, int iCheckType) {
        this.m_oTaskInfo = oTaskInfo;
        this.m_checkOpParam = oCheckOpParam;
        this.m_oConfigTreeNodeInfo = this.m_checkOpParam.getConfigTreeNode();
        this.m_bIsEditable = bIsTreeEditable;
        this.iCheckType = iCheckType;
        this.initGUI();
    }

    public ICheckOperationConfigParam getCheckOpParam() {
        return this.m_checkOpParam;
    }

    private void initGUI() {
        DCDebugTracer.trace("Entering CheckOperationPanel.initGUI");
        ConfigTreeNodeInfo temp_ConfigTreeNodeInfo = (ConfigTreeNodeInfo)CloneUtil.getClone(this.m_oConfigTreeNodeInfo);
        if (this.iCheckType == 1) {
            List<ConfigTreeNodeInfo> l_nodeList = temp_ConfigTreeNodeInfo.getNodeInfoLst();
            int iSize = l_nodeList.size();
            for (int i = 0; i < iSize; ++i) {
                ConfigTreeNodeInfo nodeInfo = l_nodeList.get(i);
                if (!"EXTENDCHECK".equals(nodeInfo.getNodeID())) continue;
                l_nodeList.remove(i);
                this.m_oConfigTreeNodeInfo.getNodeInfoLst().get(i).setNodeSelectedState(2);
                this.m_oConfigTreeNodeInfo.getNodeInfoLst().get(i).setExetendCheckFile("");
            }
        }
        this.m_oConfigTreeNodeInfo = temp_ConfigTreeNodeInfo;
        this.m_oConfigTreePanel = new ConfigTreePanel(this.m_oConfigTreeNodeInfo, this.m_bIsEditable, this.m_oTaskInfo);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_oConfigTreePanel, new GridBagConstraints(0, 0, 2, 1, 0.1, 1.0, 13, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.getConfigDetailPanel(), new GridBagConstraints(2, 0, 6, 1, 1.0, 1.0, 17, 1, new Insets(12, 0, 0, 12), 0, 0));
        this.addActionListner();
        DCDebugTracer.trace("Exiting CheckOperationPanel.initGUI");
    }

    private void addActionListner() {
        this.m_oConfigTreePanel.addDeviceTreeEventListener(this.m_oConfigDetailPanel);
    }

    public ConfigDetailPanel getConfigDetailPanel() {
        DCDebugTracer.trace("Entering CheckOperationPanel.getConfigDetailPanel");
        this.m_oConfigDetailPanel = new ConfigDetailPanel(this.m_oTaskInfo, this.m_bIsEditable, this.iContextType);
        this.m_oConfigDetailPanel.setTreePanel(this.m_oConfigTreePanel);
        DCDebugTracer.trace("Exiting CheckOperationPanel.getConfigDetailPanel");
        return this.m_oConfigDetailPanel;
    }

    public ConfigTreePanel getConfigTreePanel() {
        return this.m_oConfigTreePanel;
    }

    public int updateData() {
        int iRtnValue = -1;
        boolean bSuccess = this.m_oConfigDetailPanel.saveConnectDetailInfo();
        ConfigTreeNodeInfo oConfigTreeNodeInfo = TaskCommUtil.getConnectivityNode(this.m_checkOpParam);
        if (null != oConfigTreeNodeInfo) {
            TaskCommUtil.addDeviceToTreeNode(oConfigTreeNodeInfo, this.m_oTaskInfo);
            this.m_oConfigTreeNodeInfo = this.m_checkOpParam.getConfigTreeNode();
            if (bSuccess) {
                this.removeAll();
                this.initGUI();
            }
        }
        this.m_checkOpParam.setConfigTreeNode(this.getTreeData());
        this.m_oConfigTreePanel.removeDeviceTreeEventListener(this.m_oConfigDetailPanel);
        if (!bSuccess) {
            return 2;
        }
        return iRtnValue;
    }

    public ConfigTreeNodeInfo getTreeData() {
        DefaultMutableTreeNode l_treeRoot = this.m_oConfigTreePanel.getConfigTree().getRootNode();
        ConfigTreeNodeInfo l_treeNode = (ConfigTreeNodeInfo)l_treeRoot.getUserObject();
        int iSize = this.m_oConfigTreeNodeInfo.getNodeInfoLst().size();
        block0: for (int i = 0; i < iSize; ++i) {
            int jSize = l_treeNode.getNodeInfoLst().size();
            ConfigTreeNodeInfo m_oTreeNode = this.m_oConfigTreeNodeInfo.getNodeInfoLst().get(i);
            for (int j = 0; j < jSize; ++j) {
                ConfigTreeNodeInfo l_oTreeNode = l_treeNode.getNodeInfoLst().get(j);
                if (!m_oTreeNode.getNodeID().equals(l_oTreeNode.getNodeID())) continue;
                this.m_oConfigTreeNodeInfo.getNodeInfoLst().set(i, l_oTreeNode);
                continue block0;
            }
        }
        return this.m_oConfigTreeNodeInfo;
    }

    public boolean isValidCheckItems() {
        DefaultMutableTreeNode l_treeRoot = this.m_oConfigTreePanel.getConfigTree().getRootNode();
        ConfigTreeNodeInfo l_treeNode = (ConfigTreeNodeInfo)l_treeRoot.getUserObject();
        if (l_treeNode == null) {
            return false;
        }
        if (2 == l_treeNode.getNodeSelectedState()) {
            DCOptionPane.showWarningDialog(this, ResourceManager.getInstance().getResString("SELECTEDONEITEM"));
            return false;
        }
        Enumeration<TreeNode> l_children = l_treeRoot.children();
        DefaultMutableTreeNode l_childNode = null;
        ConfigTreeNodeInfo l_nodeObj = null;
        List<ConfigTreeNodeInfo> l_childList = null;
        while (l_children.hasMoreElements()) {
            l_childNode = (DefaultMutableTreeNode)l_children.nextElement();
            l_nodeObj = (ConfigTreeNodeInfo)l_childNode.getUserObject();
            if (2 == l_nodeObj.getNodeSelectedState()) continue;
            if (l_nodeObj.getNodeID().equals("Connectivity")) {
                return this.isConnValid(l_childNode);
            }
            if (l_nodeObj.getNodeID().equals("UserDefined") && (null == (l_childList = l_nodeObj.getNodeInfoLst()) || null != l_childList && 0 == l_childList.size())) {
                DCOptionPane.showWarningDialog(this, ResourceManager.getInstance().getResString("USER_DEFINE_INVALID"));
                this.selectedTreeNode(l_childNode);
                return false;
            }
            if (!"EXTENDCHECK".equals(l_nodeObj.getNodeID()) || !StringUtils.isNullOrEmptyStr(l_nodeObj.getExetendCheckFile())) continue;
            DCOptionPane.showWarningDialog(this, ResourceManager.getInstance().getResString("EXETEND_CHECK_INVALID"));
            this.selectedTreeNode(l_childNode);
            return false;
        }
        return true;
    }

    private void selectedTreeNode(DefaultMutableTreeNode oNode) {
        ConfigCheckTree l_tree = this.m_oConfigTreePanel.getConfigTree();
        l_tree.scrollPathToVisible(new TreePath(oNode.getPath()));
        l_tree.setSelectionPath(new TreePath(oNode.getPath()));
        l_tree.treeDidChange();
        this.m_oConfigTreePanel.sendNotificationToTreeListeners(oNode);
    }

    private boolean isConnValid(DefaultMutableTreeNode oChildNode) {
        Enumeration<TreeNode> l_leafNode = oChildNode.children();
        DefaultMutableTreeNode l_leafChild = null;
        ConfigTreeNodeInfo l_leafObj = null;
        while (l_leafNode.hasMoreElements()) {
            l_leafChild = (DefaultMutableTreeNode)l_leafNode.nextElement();
            l_leafObj = (ConfigTreeNodeInfo)l_leafChild.getUserObject();
            if (l_leafObj.getNodeSelectedState() == 2 || !l_leafObj.getConfigNodeConnInfo().getCheckContent().equals("")) continue;
            DCOptionPane.showWarningDialog(this, ResourceManager.getInstance().getResString("CONNCTIVITY_INVALID"));
            this.selectedTreeNode(l_leafChild);
            return false;
        }
        return true;
    }
}

