/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import java.util.List;

public abstract class CheckOperationAdapter
extends OperationAdapter {
    private static final long serialVersionUID = -4338104761637843311L;

    public void configTreeNodeInfo(ICheckOperationConfigParam aCheckParam, ITask aParentTask, boolean isCreate) {
        DeviceType l_devType = aParentTask.getDeviceType();
        if (null == l_devType) {
            return;
        }
        ConfigTreeNodeInfo l_treeInfo = aCheckParam.getConfigTreeNode();
        if (null == l_treeInfo) {
            return;
        }
        String rootStr = ResourceManager.getInstance().getResString("CheckItem");
        l_treeInfo.setNodeID(rootStr);
        l_treeInfo.getConfigNodeAttr().setNodeName(rootStr);
        if (!isCreate) {
            return;
        }
        List<ConfigTreeNodeInfo> l_nodeList = l_treeInfo.getNodeInfoLst();
        if (null == l_nodeList) {
            return;
        }
        for (ConfigTreeNodeInfo configTreeNodeInfo : l_nodeList) {
            if (configTreeNodeInfo.getNodeID().indexOf("Connectivity") == -1) continue;
            TaskCommUtil.addDeviceToTreeNode(configTreeNodeInfo, aParentTask);
            break;
        }
        if (l_treeInfo.isbFirstConfigFlag() && 4 == l_devType.getDeviceDomain()) {
            this.setNodeSelected(l_treeInfo);
        }
        if (4 != l_devType.getDeviceDomain()) {
            return;
        }
        for (ConfigTreeNodeInfo configTreeNodeInfo : l_nodeList) {
            if (configTreeNodeInfo.getNodeID().indexOf("UPGRADE_FEASIBILITY") == -1 && configTreeNodeInfo.getParentID().indexOf("UPGRADE_FEASIBILITY") == -1) continue;
            configTreeNodeInfo.setNodeSelectable(false);
        }
    }

    protected int getConnectivitySelCount(ICheckOperationConfigParam aCheckParam) {
        int selCount = 0;
        ConfigTreeNodeInfo oConfigTreeNodeInfo = TaskCommUtil.getConnectivityNode(aCheckParam);
        if (null == oConfigTreeNodeInfo) {
            return selCount;
        }
        List<ConfigTreeNodeInfo> allNodeList = oConfigTreeNodeInfo.getNodeInfoLst();
        for (ConfigTreeNodeInfo configTreeNodeInfo : allNodeList) {
            if (0 != configTreeNodeInfo.getNodeSelectedState() && 1 != configTreeNodeInfo.getNodeSelectedState()) continue;
            ++selCount;
        }
        return selCount;
    }

    protected boolean isConnSelectApplyAll(ICheckOperationConfigParam aCheckParam) {
        boolean isApplyAll = false;
        ConfigTreeNodeInfo oConfigTreeNodeInfo = TaskCommUtil.getConnectivityNode(aCheckParam);
        if (null == oConfigTreeNodeInfo) {
            return isApplyAll;
        }
        List<ConfigTreeNodeInfo> allNodeList = oConfigTreeNodeInfo.getNodeInfoLst();
        int size = allNodeList.size();
        int iSelCount = 0;
        for (ConfigTreeNodeInfo configTreeNodeInfo : allNodeList) {
            if (0 != configTreeNodeInfo.getNodeSelectedState() && 1 != configTreeNodeInfo.getNodeSelectedState()) continue;
            ++iSelCount;
        }
        if (size > 0 && size == iSelCount) {
            if (size == 1) {
                isApplyAll = true;
                return isApplyAll;
            }
            ConfigTreeNodeInfo configTreeNodeInfo = allNodeList.get(0);
            ConnectTestInfo conTestInfo = configTreeNodeInfo.getConfigNodeConnInfo();
            String content = conTestInfo.getCheckContent();
            int sameCount = 0;
            for (int i = 1; i < size; ++i) {
                configTreeNodeInfo = allNodeList.get(i);
                conTestInfo = configTreeNodeInfo.getConfigNodeConnInfo();
                if (!content.equals(conTestInfo.getCheckContent())) continue;
                ++sameCount;
            }
            if (size == sameCount + 1) {
                isApplyAll = true;
            }
        }
        return isApplyAll;
    }

    public abstract boolean isSelectAnyCheckItem();

    protected boolean isConnConfigAll(ICheckOperationConfigParam aCheckParam) {
        boolean isConfigAll = false;
        ConfigTreeNodeInfo oConfigTreeNodeInfo = TaskCommUtil.getConnectivityNode(aCheckParam);
        if (null == oConfigTreeNodeInfo) {
            return isConfigAll;
        }
        List<ConfigTreeNodeInfo> allNodeList = oConfigTreeNodeInfo.getNodeInfoLst();
        int size = allNodeList.size();
        int iSelCount = 0;
        for (ConfigTreeNodeInfo configTreeNodeInfo : allNodeList) {
            if (0 != configTreeNodeInfo.getNodeSelectedState() && 1 != configTreeNodeInfo.getNodeSelectedState()) continue;
            ++iSelCount;
        }
        isConfigAll = size == iSelCount;
        return isConfigAll;
    }

    protected boolean isSelectConnectivity(ICheckOperationConfigParam aCheckParam) {
        boolean isSel = false;
        ConfigTreeNodeInfo oConfigTreeNodeInfo = TaskCommUtil.getConnectivityNode(aCheckParam);
        if (null == oConfigTreeNodeInfo) {
            return isSel;
        }
        return 0 == oConfigTreeNodeInfo.getNodeSelectedState() || 1 == oConfigTreeNodeInfo.getNodeSelectedState();
    }

    private void setNodeSelected(ConfigTreeNodeInfo oConfigInfo) {
        if (null == oConfigInfo || oConfigInfo.getNodeInfoLst() == null) {
            return;
        }
        oConfigInfo.setNodeSelectedState(0);
        int sonNodeSize = oConfigInfo.getNodeInfoLst().size();
        for (int i = 0; i < sonNodeSize; ++i) {
            ConfigTreeNodeInfo cfgInfo = oConfigInfo.getNodeInfoLst().get(i);
            if ("EXTENDCHECK".equals(cfgInfo.getNodeID())) {
                cfgInfo.setNodeSelectedState(2);
                oConfigInfo.setNodeSelectedState(1);
                continue;
            }
            cfgInfo.setNodeSelectedState(0);
        }
    }

    public abstract int getConnectivitySelCount();

    public abstract boolean isConnConfigAll();

    public abstract boolean isSelectConnectivity();
}

