/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItem;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemCSVFileParser;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemExcFileParser;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemListParseResult;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ConfigDetailPanel;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckItemFileParser;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class CheckItemListImportAction
extends AbstractAction {
    private final ResourceManager oResMgr = ResourceManager.getInstance();
    private static final long serialVersionUID = 5274734556321731865L;
    private ConfigDetailPanel reference = null;
    private transient ICheckItemFileParser checkFilePaser = null;
    private boolean isWinSys = StringUtils.isWinSystem();

    public CheckItemListImportAction(ConfigDetailPanel reference) {
        this.reference = reference;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DCDebugTracer.trace("CheckItemListImportAction#actionPerformed start");
        File selectFile = this.getSelectCheckItemFile();
        if (null == selectFile) {
            DCDebugTracer.traceWarning("CheckItemListImportAction#actionPerformed select CheckItem File is empty! cancel operation ");
            return;
        }
        CheckItemListParseResult oCheckItemListParseResult = this.checkFilePaser.parseFile(selectFile);
        if (!oCheckItemListParseResult.isParseSucc()) {
            DCDebugTracer.traceWarning("CheckItemListImportAction#actionPerformed  parse select tempate have error.");
            return;
        }
        boolean bContainSameCheckItem = false;
        List<CheckItem> oCheckItemLst = oCheckItemListParseResult.getChkItemList();
        ArrayList<String> oArrayList = new ArrayList<String>();
        String strDisplayName = null;
        for (int i = 0; i < oCheckItemLst.size(); ++i) {
            CheckItem oCheckItem = oCheckItemLst.get(i);
            strDisplayName = oCheckItem.getDisplayName();
            if (oArrayList.contains(strDisplayName)) {
                bContainSameCheckItem = true;
                String[] args = new String[]{oCheckItem.getDisplayName() + "-" + oCheckItem.getCmd()};
                DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ADD_CHECK_ITEM_REPEAT_ERROR", args));
                break;
            }
            if (null == strDisplayName) continue;
            oArrayList.add(strDisplayName);
        }
        if (!bContainSameCheckItem) {
            this.reference.importCheckItemLstToTree(oCheckItemListParseResult.getChkItemList());
        }
        DCDebugTracer.trace("CheckItemListImportAction#actionPerformed end..");
    }

    private File getSelectCheckItemFile() {
        DCDebugTracer.trace("CheckItemListImportAction#getSelectCheckItemFile start");
        DCFileChooser oDCFileChooser = new DCFileChooser();
        if (this.isWinSys) {
            oDCFileChooser.setFileFilter(8);
            this.checkFilePaser = new CheckItemExcFileParser();
        } else {
            oDCFileChooser.setFileFilter(2);
            this.checkFilePaser = new CheckItemCSVFileParser();
        }
        oDCFileChooser.setAcceptAllFileFilterUsed(false);
        oDCFileChooser.setTitle(this.oResMgr.getResString("IMPORT"));
        oDCFileChooser.setApproveButtonText(this.oResMgr.getResString("OPENFILE"));
        oDCFileChooser.setApproveButtonToolTipText(this.oResMgr.getResString("OPENFILE"));
        PrintSupportor.setIsFileSelection(false);
        int iReturnVal = oDCFileChooser.showOpenDialog(this.reference);
        if (0 != iReturnVal) {
            DCDebugTracer.traceWarning("CheckItemListImportAction#getSelectCheckItemFile iReturnVal is not ok,select file empty " + iReturnVal);
            return null;
        }
        DCDebugTracer.trace("CheckItemListImportAction#getSelectCheckItemFile end..");
        return oDCFileChooser.getSelectedFile();
    }
}

