/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItem;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemListParseResult;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckItemFileParser;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class CheckItemExcFileParser
implements ICheckItemFileParser {
    private static final int CHECK_CMD_COLUMN = 1;
    private static final int CHECK_DESC_COLUMN = 2;
    private static final int CHECK_DESC_INFO = 3;
    private static final int CHECK_NAME_COLUMN = 0;
    private static final String EXC_POSTFIX = ".XLS";
    private static final int TOTAL_COLUMN = 4;
    private CheckItemListParseResult chekItemParseResult = new CheckItemListParseResult();

    private void boxCheckItems(Sheet sheet) {
        DCDebugTracer.trace("CheckItemExcFileParser#boxCheckItems start");
        int rowNum = sheet.getRows();
        CheckItem oCheckItem = null;
        String displayName = null;
        String cmd = null;
        String desc = null;
        int iCellLenth = -1;
        for (int i = 1; i < rowNum; ++i) {
            Cell[] cell = sheet.getRow(i);
            iCellLenth = cell.length;
            if (iCellLenth <= 0) {
                DCDebugTracer.traceWarning("CheckItemExcFileParser#boxCheckItems() empty Line " + i);
                continue;
            }
            displayName = "";
            if (0 < iCellLenth) {
                displayName = cell[0].getContents();
            }
            cmd = "";
            if (1 < iCellLenth) {
                cmd = cell[1].getContents();
            }
            if (StringUtils.isNullOrEmptyStr(displayName) && StringUtils.isNullOrEmptyStr(cmd)) {
                DCDebugTracer.traceWarning("CheckItemExcFileParser#boxCheckItems() format error check Item  Line num " + i);
                continue;
            }
            oCheckItem = new CheckItem();
            oCheckItem.setDisplayName(displayName.trim());
            oCheckItem.setCmd(cmd.trim());
            desc = "";
            if (2 < iCellLenth) {
                desc = cell[2].getContents();
            }
            oCheckItem.setDescription(desc.trim());
            this.chekItemParseResult.addCheckItem(oCheckItem);
        }
        DCDebugTracer.trace("CheckItemExcFileParser#boxCheckItems end..");
    }

    private boolean checkHeader(Cell[] cells) {
        DCDebugTracer.trace("CheckItemExcFileParser#checkHeader start");
        boolean isHeaderCorrect = true;
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_NAME").equals(cells[0].getContents())) {
            isHeaderCorrect = false;
            DCDebugTracer.traceError("CheckItemExcFileParser#checkHeader end.. : CHECK_ITEM_NAME error");
            return isHeaderCorrect;
        }
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_CMD").equals(cells[1].getContents())) {
            isHeaderCorrect = false;
            DCDebugTracer.traceError("CheckItemExcFileParser#checkHeader end.. : CHECK_ITEM_CMD error");
            return isHeaderCorrect;
        }
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_DESC").equals(cells[2].getContents())) {
            isHeaderCorrect = false;
            DCDebugTracer.traceError("CheckItemExcFileParser#checkHeader end.. : CHECK_ITEM_DESC error");
            return isHeaderCorrect;
        }
        DCDebugTracer.trace("CheckItemExcFileParser#checkHeader end.. : file Header Correct");
        return isHeaderCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckItemListParseResult parseFile(File excelFile) {
        block14: {
            DCDebugTracer.trace("CheckItemExcFileParser#parseFile start");
            DCDebugTracer.trace("File name : " + excelFile.getName());
            String fileName = excelFile.getName();
            if (!fileName.toUpperCase(ResourceMng.getInstance().getLocale()).endsWith(EXC_POSTFIX)) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_FILE_FORMAT"));
                DCDebugTracer.traceError("CheckItemExcFileParser#parseFile() file Name : " + fileName);
                this.chekItemParseResult.setErrorCode(-1);
                return this.chekItemParseResult;
            }
            Workbook workbook = null;
            try {
                workbook = Workbook.getWorkbook((File)excelFile);
                Sheet[] sheet = workbook.getSheets();
                if (sheet.length > 0 && sheet[0].getColumns() >= 4) {
                    if (!this.checkHeader(sheet[0].getRow(0))) {
                        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_TEMPLATE_ERROR"));
                        DCDebugTracer.traceError("CheckItemExcFileParser#parseFile() select file Header error, File path : " + excelFile.getPath());
                        this.chekItemParseResult.setErrorCode(-1);
                        CheckItemListParseResult checkItemListParseResult = this.chekItemParseResult;
                        return checkItemListParseResult;
                    }
                    this.boxCheckItems(sheet[0]);
                    break block14;
                }
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_TEMPLATE_ERROR"));
                DCDebugTracer.traceError("CheckItemExcFileParser#parseFile()  sheet.length > 0 && sheet[0].getColumns() >= TOTAL_COLUMN ");
                this.chekItemParseResult.setErrorCode(-1);
                CheckItemListParseResult checkItemListParseResult = this.chekItemParseResult;
                return checkItemListParseResult;
            }
            catch (BiffException e) {
                this.chekItemParseResult.setErrorCode(-1);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_CHECK_ITEM_FILE"));
                DCDebugTracer.trace((Exception)((Object)e));
            }
            catch (FileNotFoundException e) {
                this.chekItemParseResult.setErrorCode(-1);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_CHECK_ITEM_FILE_NOT_FOUND"));
                DCDebugTracer.trace(e);
            }
            catch (IOException e) {
                this.chekItemParseResult.setErrorCode(-1);
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_CHECK_ITEM_FILE_MEMERY_LACK"));
                DCDebugTracer.trace(e);
            }
            finally {
                if (null != workbook) {
                    workbook.close();
                }
            }
        }
        DCDebugTracer.trace("CheckItemExcFileParser#parseFile end.. : size " + this.chekItemParseResult.size());
        return this.chekItemParseResult;
    }
}

