/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.checkoperation;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItem;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckItemListParseResult;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckItemFileParser;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CheckItemCSVFileParser
implements ICheckItemFileParser {
    private static final int CHECK_CMD_COLUMN = 1;
    private static final int CHECK_DESC_COLUMN = 2;
    private static final int CHECK_NAME_COLUMN = 0;
    private static final String CSV_POSTFIX = ".CSV";
    private CheckItemListParseResult chekItemParseResult = new CheckItemListParseResult();

    private void boxCheckItem(BufferedReader oBufferedReader) throws IOException {
        CheckItem oCheckItem = null;
        String strLine = oBufferedReader.readLine();
        int iCellLenth = -1;
        String displayName = null;
        String cmd = null;
        String desc = null;
        while (null != strLine) {
            String[] items = strLine.split(",");
            iCellLenth = items.length;
            if (iCellLenth <= 0) {
                DCDebugTracer.traceWarning("CheckItemCSVFileParser#boxCheckItem() format error check Item : " + strLine);
                strLine = oBufferedReader.readLine();
                continue;
            }
            displayName = "";
            if (0 < iCellLenth) {
                displayName = items[0].trim();
            }
            cmd = "";
            if (1 < iCellLenth) {
                cmd = items[1].trim();
            }
            if (StringUtils.isNullOrEmptyStr(displayName) && StringUtils.isNullOrEmptyStr(cmd)) {
                DCDebugTracer.traceWarning("CheckItemCSVFileParser#boxCheckItems() format error check Item " + strLine);
                strLine = oBufferedReader.readLine();
                continue;
            }
            oCheckItem = new CheckItem();
            oCheckItem.setDisplayName(displayName);
            oCheckItem.setCmd(cmd);
            desc = "";
            if (2 < iCellLenth) {
                desc = items[2].trim();
            }
            oCheckItem.setDescription(desc);
            this.chekItemParseResult.addCheckItem(oCheckItem);
            strLine = oBufferedReader.readLine();
        }
    }

    private boolean checkCSVFileHeader(String strLine) {
        DCDebugTracer.trace("CheckItemCSVFileParser#checkCSVFileHeader() strat");
        boolean isHeaderCorrect = true;
        if (null == strLine) {
            isHeaderCorrect = false;
            DCDebugTracer.traceError("CheckItemCSVFileParser#checkCSVFileHeader() select file is empty!");
            return isHeaderCorrect;
        }
        String[] header = strLine.split(",");
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_NAME").equals(header[0])) {
            DCDebugTracer.traceError("CheckItemCSVFileParser#checkCSVFileHeader() end.. CHECK_ITEM_NAME error : " + header[0]);
            isHeaderCorrect = false;
            return isHeaderCorrect;
        }
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_CMD").equals(header[1])) {
            DCDebugTracer.traceError("CheckItemCSVFileParser#checkCSVFileHeader() end.. CHECK_ITEM_CMD error : " + header[1]);
            isHeaderCorrect = false;
            return isHeaderCorrect;
        }
        if (!DCFrameWorkUtil.getLocalizedString("CHECK_ITEM_DESC").equals(header[2])) {
            DCDebugTracer.traceError("CheckItemCSVFileParser#checkCSVFileHeader() end.. CHECK_ITEM_DESC error: " + header[2]);
            isHeaderCorrect = false;
            return isHeaderCorrect;
        }
        DCDebugTracer.trace("CheckItemCSVFileParser#checkCSVFileHeader() end.. file Header Correct");
        return isHeaderCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckItemListParseResult parseFile(File file) {
        DCDebugTracer.trace("CheckItemCSVFileParser#parseFile start");
        DCDebugTracer.trace("File name : " + file.getName());
        String fileName = file.getName();
        if (!fileName.toUpperCase(ResourceMng.getInstance().getLocale()).endsWith(CSV_POSTFIX)) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_FILE_FORMAT"));
            DCDebugTracer.traceError("CheckItemCSVFileParser#parseFile() File name : " + fileName);
            this.chekItemParseResult.setErrorCode(-1);
            return this.chekItemParseResult;
        }
        FileInputStream oInputStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        try {
            String encoding = null;
            encoding = FileUtil.isUTF8File(file.getPath()) ? FileUtil.getUTF8Encoding() : FileUtil.getSystemEncoding();
            oInputStream = new FileInputStream(file);
            oFileReader = new InputStreamReader((InputStream)oInputStream, encoding);
            oBufferedReader = new BufferedReader(oFileReader);
            String strLine = oBufferedReader.readLine();
            if (!this.checkCSVFileHeader(strLine)) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_TEMPLATE_ERROR"));
                DCDebugTracer.traceError("CheckItemCSVFileParser#parseFile() select file Header error, File path : " + file.getPath());
                this.chekItemParseResult.setErrorCode(-1);
                CheckItemListParseResult checkItemListParseResult = this.chekItemParseResult;
                return checkItemListParseResult;
            }
            this.boxCheckItem(oBufferedReader);
        }
        catch (FileNotFoundException e) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_CHECK_ITEM_FILE_NOT_FOUND"));
            this.chekItemParseResult.setErrorCode(-1);
            DCDebugTracer.trace(e);
        }
        catch (IOException e) {
            this.chekItemParseResult.setErrorCode(-1);
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage());
            DCDebugTracer.trace(e);
        }
        finally {
            try {
                if (null != oBufferedReader) {
                    oBufferedReader.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
        DCDebugTracer.trace("CheckItemCSVFileParser#parseFile end.. size" + this.chekItemParseResult.size());
        return this.chekItemParseResult;
    }
}

