/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.asndatacenter.AsnResourceProgressInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.SubOperationObject;
import com.huawei.dc.taskmgmt.model.SubOprCheckItemDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TaskBackupSubOpr
implements ITaskSubOperation,
Serializable {
    private static final long serialVersionUID = 1L;
    private SubOprCheckItemDetails m_oSubOprCheckItemDetails = null;
    private ITaskDeviceOperation m_oTaskDevOp = null;
    private ContentConfigParam m_oBackupConfigParam = null;
    int m_iOprStatus = -1;
    int m_iResDomain = -1;

    public TaskBackupSubOpr(TaskBackupOperation oOperation) {
        this.m_oTaskDevOp = oOperation;
        this.m_oSubOprCheckItemDetails = new SubOprCheckItemDetails();
        this.addTaskOprNode();
        this.addTaskSubOprNode();
    }

    private void addTaskOprNode() {
        HashMap<String, SubOperationObject> oNodeList = this.m_oSubOprCheckItemDetails.getNodeList();
        ArrayList<String> oOrderList = this.m_oSubOprCheckItemDetails.getOrderList();
        SubOperationObject oSubOperationObject = new SubOperationObject();
        oSubOperationObject.setParentID("");
        oSubOperationObject.setNodeID(ResourceManager.getInstance().getResString("BACKUP"));
        oNodeList.put(oSubOperationObject.getParentID() + oSubOperationObject.getNodeID(), oSubOperationObject);
        oOrderList.add(oSubOperationObject.getParentID() + oSubOperationObject.getNodeID());
        this.m_oSubOprCheckItemDetails.setNodeList(oNodeList);
        this.m_oSubOprCheckItemDetails.setOrderList(oOrderList);
    }

    private void addTaskSubOprNode() {
        HashMap<String, SubOperationObject> oNodeList = this.m_oSubOprCheckItemDetails.getNodeList();
        ArrayList<String> oOrderList = this.m_oSubOprCheckItemDetails.getOrderList();
        this.m_oBackupConfigParam = (ContentConfigParam)this.m_oTaskDevOp.getConfiguredPara();
        List<ContentType> oContentTypeList = this.m_oBackupConfigParam.getSelectedContentType();
        int iContentTypeCount = 0;
        if (null != oContentTypeList) {
            iContentTypeCount = oContentTypeList.size();
            SubOperationObject oSubOperationObject = null;
            String oRoot = ResourceManager.getInstance().getResString("BACKUP");
            String oNode = "";
            ContentType oContentType = null;
            for (int i = 0; i < iContentTypeCount; ++i) {
                oSubOperationObject = new SubOperationObject();
                oContentType = oContentTypeList.get(i);
                if (null == oContentType) continue;
                oNode = oContentType.getStrContentType();
                oSubOperationObject.setParentID(oRoot);
                oSubOperationObject.setNodeID(oNode);
                oSubOperationObject.getOprNodeAttributes().setContentTypeID(oContentType.getContentTypeCode());
                oSubOperationObject.getOprNodeAttributes().setStatus(0);
                oNodeList.put(oRoot + oContentType.getContentTypeCode(), oSubOperationObject);
                oOrderList.add(oRoot + oContentType.getContentTypeCode());
            }
        }
        this.m_oSubOprCheckItemDetails.setNodeList(oNodeList);
        this.m_oSubOprCheckItemDetails.setOrderList(oOrderList);
    }

    @Override
    public SubOprCheckItemDetails getSubOprObject() {
        return this.m_oSubOprCheckItemDetails;
    }

    @Override
    public void updateSubOprDetails(Object oObj) {
        if (null == oObj) {
            return;
        }
        AsnTaskDevOpInfo oAsnTaskDevOpInfo = null;
        if (oObj instanceof AsnTaskDevOpInfo) {
            oAsnTaskDevOpInfo = (AsnTaskDevOpInfo)oObj;
            this.m_iOprStatus = oAsnTaskDevOpInfo.enOpStatus.value;
        } else if (oObj instanceof AsnResourceProgressInfo) {
            oAsnTaskDevOpInfo = new AsnTaskDevOpInfo();
            oAsnTaskDevOpInfo.oOprStartTime = ((AsnResourceProgressInfo)oObj).oOprStartTime;
            oAsnTaskDevOpInfo.oOprEndTime = ((AsnResourceProgressInfo)oObj).oOprEndTime;
            oAsnTaskDevOpInfo.enOpStatus = ((AsnResourceProgressInfo)oObj).enStatus;
            this.m_iOprStatus = oAsnTaskDevOpInfo.enOpStatus.value;
            oAsnTaskDevOpInfo.stErrorInfo = ((AsnResourceProgressInfo)oObj).oAsnDCErrorCodeInfo;
            oAsnTaskDevOpInfo.enOpResult = ((AsnResourceProgressInfo)oObj).enResult;
            oAsnTaskDevOpInfo.oFileLst = ((AsnResourceProgressInfo)oObj).oFileLst;
        }
        this.m_oSubOprCheckItemDetails.setDomain(this.m_iResDomain);
        this.m_oSubOprCheckItemDetails.updateSubOprDetails(oAsnTaskDevOpInfo, "", ResourceManager.getInstance().getResString("BACKUP"), 2);
    }

    @Override
    public int getOprStatus() {
        return this.m_iOprStatus;
    }

    @Override
    public boolean hasCheckItems() {
        return true;
    }

    @Override
    public boolean mustShowData() {
        return true;
    }

    @Override
    public void setDomain(int iDomain) {
        this.m_iResDomain = iDomain;
    }
}

