/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.backup.BackUpDlg;
import com.huawei.dc.devicemanagement.deviceoperation.backup.BackupPanel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.BackupViewPanel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentTypeCfgDlg;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentTypeCfgPanel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupSubOpr;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TaskBackupOperation
extends OperationAdapter
implements ITaskDeviceOperation,
Serializable {
    private static final long serialVersionUID = 1L;
    private ContentConfigParam m_oBackupConfigParam = new ContentConfigParam(this.m_oParaList);
    private TitledBorder oTitledBorder = null;
    private String m_strOperationId = null;
    private int m_iOperationId = -1;
    private String m_strOperationDesc = null;
    private String m_strOperationName = null;
    private int m_iDependsOnId = -1;
    private List m_DevDependentLst = null;
    private boolean m_bIselected = false;
    private Border oborder = null;
    private boolean m_bIsContentTypeRequired = false;
    private ITask m_oParentTask;
    private boolean m_bIsPauseB4Op = false;
    private IParaList m_oParaList = null;
    private int m_iOperationLevel;
    private boolean bHasOpenConfigDlg = false;
    private int iInnerTaskTypeId = -1;
    private ITaskSubOperation m_oBackupTaskSubOpr = null;

    @Override
    public Object getConfiguredPara() {
        return this.m_oBackupConfigParam;
    }

    public void setConfiguredPara(ContentConfigParam oBackupConfigParam) {
        this.m_oBackupConfigParam = oBackupConfigParam;
    }

    public List getDependentOperation() {
        return this.m_DevDependentLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iDependsOnId;
    }

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public Component getView(int context) {
        boolean bContansCluster;
        Component oBackupView = null;
        boolean isSupportTelnet = false;
        if (this.m_oParentTask.isDMSDomain()) {
            isSupportTelnet = this.m_oParentTask.getDeviceType().isUpgradeModeSupportedByAllDevices(4096);
        }
        if (bContansCluster = TaskInfoUtil.isContainsClusterNE(this.m_oParentTask)) {
            return this.getNotTelnetBackupView(context, oBackupView);
        }
        if (isSupportTelnet) {
            return this.getTelnetBackupView(context, oBackupView);
        }
        return this.getNotTelnetBackupView(context, oBackupView);
    }

    private Component getNotTelnetBackupView(int context, Component oBackupView) {
        switch (context) {
            case 0: {
                ContentTypeCfgDlg oContentTypeDlg = new ContentTypeCfgDlg(this.m_oBackupConfigParam, this.m_oParentTask.getTaskContentType());
                oContentTypeDlg.getContentCfgPanel().setName(ResourceManager.getInstance().getResString("BACKUP_SETTING"));
                oContentTypeDlg.setTitle(ResourceManager.getInstance().getResString("BACKUP_SETTING"));
                oContentTypeDlg.setSize(326, 185);
                this.oTitledBorder = new TitledBorder(this.oborder, ResourceManager.getInstance().getResString("CONTENT_TYPE1"));
                oContentTypeDlg.getContentCfgPanel().setBorder(this.oTitledBorder);
                oBackupView = oContentTypeDlg;
                break;
            }
            case 1: {
                ContentTypeCfgPanel oContentCfgPanel = new ContentTypeCfgPanel(this.m_oBackupConfigParam, this.m_oParentTask.getTaskContentType());
                this.oTitledBorder = new TitledBorder(this.oborder, ResourceManager.getInstance().getResString("SELECT_CONTENT_TYPE_FOR_BACKUP_SETTING"));
                oContentCfgPanel.setBorder(this.oTitledBorder);
                this.setBoundsForCheckOpView(oContentCfgPanel, 1);
                oBackupView = oContentCfgPanel;
                break;
            }
            case 2: {
                ContentTypeCfgPanel oContentCfgPanel1 = new ContentTypeCfgPanel(this.m_oBackupConfigParam, this.m_oParentTask.getTaskContentType()){

                    @Override
                    public void initComponents(JPanel panel) {
                        JLabel contentTypeLabel = new JLabel();
                        contentTypeLabel.setName("DeviceOperation_ContentTypeCfgPanel_contentTypeLabel");
                        contentTypeLabel.setBounds(8, 31, 125, 20);
                        contentTypeLabel.setText(ResourceManager.getInstance().getResString("CONTENT_TYPE0"));
                        panel.add(contentTypeLabel);
                        panel.setBounds(6, 18, 250, 78);
                        JLabel contentLabel = new JLabel();
                        contentLabel.setBounds(92, 31, 100, 20);
                        panel.add(contentLabel);
                        List<ContentType> oContentConfig = this.m_oContentConfigParam.getSelectedContentType();
                        if (null != oContentConfig) {
                            contentLabel.setText(oContentConfig.get(0).getStrContentType());
                        }
                    }
                };
                this.oTitledBorder = new TitledBorder(this.oborder, ResourceManager.getInstance().getResString("CONTENT_TYPE_FOR_BACKUP_SETTING"));
                oContentCfgPanel1.setBorder(this.oTitledBorder);
                this.setBoundsForCheckOpView(oContentCfgPanel1, 2);
                oBackupView = oContentCfgPanel1;
                break;
            }
        }
        return oBackupView;
    }

    private Component getTelnetBackupView(int context, Component oBackupView) {
        BackUpDlg l_backUpDlg = null;
        switch (context) {
            case 0: {
                l_backUpDlg = new BackUpDlg(this.m_oBackupConfigParam, this.m_oParentTask.isThirdPartySupported());
                ((DCModalDialog)l_backUpDlg).setTitle(ResourceManager.getInstance().getResString("BACKUP_SETTING"));
                oBackupView = l_backUpDlg;
                this.bHasOpenConfigDlg = true;
                break;
            }
            case 1: {
                this.m_oBackupConfigParam.setFirstBackup(false);
                this.updateBackupConfigParamForFTP(this.m_oBackupConfigParam);
                oBackupView = new BackupPanel(this.m_oBackupConfigParam, this.isSelected(), this.m_oParentTask.isThirdPartySupported());
                ((Component)oBackupView).setBounds(12, 12, 595, 360);
                ((BackupPanel)oBackupView).setScrollPaneBounds(12, 12, 595, 360);
                ((Component)oBackupView).setForeground(Color.BLUE);
                break;
            }
            case 2: {
                oBackupView = new BackupViewPanel(this.m_oBackupConfigParam, this.m_oParentTask.getTaskContentType(), this.m_oParentTask.isThirdPartySupported());
                ((Component)oBackupView).setBounds(12, 12, 595, 360);
                ((BackupViewPanel)oBackupView).setScrollPaneBounds(12, 12, 595, 360);
                break;
            }
            default: {
                DCDebugTracer.trace(" TaskBackupOperation#getTelnetBackupView error context : " + context);
            }
        }
        return oBackupView;
    }

    private void updateBackupConfigParamForFTP(ContentConfigParam oBackupCfParam) {
        if (this.m_oParentTask.isThirdPartySupported()) {
            Object[] oContentTypeArray = oBackupCfParam.getContentTypeList();
            ContentType oContentType = null;
            for (int i = 0; i < oContentTypeArray.length; ++i) {
                oContentType = (ContentType)oContentTypeArray[i];
                if (Collator.getInstance().equals(oContentType.getId(), "Log") || Collator.getInstance().equals(oContentType.getId(), "Trap")) {
                    oContentType.setSelected(false);
                    oContentType.setEnabled(false);
                }
                oContentType.setDestination("BackupFolder");
                oContentTypeArray[i] = oContentType;
            }
        }
    }

    private void setBoundsForCheckOpView(Component oContentCfgPanel, int iType) {
        if (this.iInnerTaskTypeId == 3 || this.iInnerTaskTypeId == 5 || this.iInnerTaskTypeId == 4 || this.iInnerTaskTypeId == 12 || this.iInnerTaskTypeId == 13) {
            if (iType == 1) {
                oContentCfgPanel.setBounds(279, 90, 330, 104);
            } else if (iType == 2) {
                oContentCfgPanel.setBounds(279, 130, 330, 104);
            }
        } else {
            oContentCfgPanel.setBounds(160, 130, 330, 104);
        }
    }

    @Override
    public boolean isSelected() {
        return this.m_bIselected;
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bIsPauseB4Op;
    }

    @Override
    public void setSelected(boolean isEnabled) {
        this.m_bIselected = isEnabled;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean isPauseBeforeCurOp) {
        this.m_bIsPauseB4Op = isPauseBeforeCurOp;
    }

    @Override
    public void setOperationId(int operationId) {
        this.m_iOperationId = operationId;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationId;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationId = strOperationId;
    }

    public void setDependentOperation(List devDependentLst) {
        this.m_DevDependentLst = devDependentLst;
    }

    @Override
    public void setDependsOnOperation(int devOpDependsOnId) {
        this.m_iDependsOnId = devOpDependsOnId;
    }

    public boolean getHasOpenConfigDlg() {
        return this.bHasOpenConfigDlg;
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        List<ContentType> oContentList;
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("OPERATION_SUCCESS"));
        if (!this.m_oBackupConfigParam.isContentTypeRequired()) {
            return oValidationResult;
        }
        boolean isSupportTelnet = false;
        if (this.m_oParentTask.isDMSDomain()) {
            isSupportTelnet = this.m_oParentTask.getDeviceType().isUpgradeModeSupportedByAllDevices(4096);
        }
        if (isSupportTelnet && this.m_oBackupConfigParam.isInitBackup()) {
            ArrayList<ContentType> l_selectedList = new ArrayList<ContentType>();
            Object[] l_contentList = this.m_oBackupConfigParam.getContentTypeList();
            if (!this.getHasOpenConfigDlg()) {
                this.setDefaultContentType(l_selectedList, l_contentList);
            } else {
                for (int i = 0; i < l_contentList.length; ++i) {
                    if (!((ContentType)l_contentList[i]).isEnabled() || !((ContentType)l_contentList[i]).isSelected()) continue;
                    l_selectedList.add((ContentType)l_contentList[i]);
                }
                if (l_selectedList.size() == 0) {
                    this.setDefaultContentType(l_selectedList, l_contentList);
                }
            }
            this.m_oBackupConfigParam.setSelectedContentType(l_selectedList);
        }
        if (null == (oContentList = this.m_oBackupConfigParam.getSelectedContentType()) || 0 == oContentList.size()) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("SELECTED_ONE_FILE"));
        }
        return oValidationResult;
    }

    private void setDefaultContentType(List<ContentType> l_selectedList, Object[] l_contentList) {
        if (this.iInnerTaskTypeId == 2) {
            l_selectedList.add(ParamUtil.getInstance().getContentType(l_contentList, "PATCH"));
        } else if (l_contentList.length <= 1) {
            if (l_contentList[0] instanceof ContentType) {
                ContentType oTempContentType = (ContentType)l_contentList[0];
                l_selectedList.add(oTempContentType);
            }
        } else {
            l_selectedList.add(ParamUtil.getInstance().getContentType(l_contentList, "STARTUPCONF"));
        }
    }

    @Override
    public String toString() {
        String strOperation = null;
        this.m_bIsContentTypeRequired = this.m_oBackupConfigParam.isContentTypeRequired();
        strOperation = System.getProperty("line.separator") + "  " + ResourceManager.getInstance().getResString("CONTENT_TYPE") + " : ";
        if (this.m_bIsContentTypeRequired) {
            strOperation = strOperation + this.m_oBackupConfigParam.getSelectedContentType();
        } else {
            String BlankSpace = "  ";
            StringBuffer strBuffer = new StringBuffer(0);
            strBuffer.append(System.getProperty("line.separator"));
            strBuffer.append("  ");
            strBuffer.append(ResourceManager.getInstance().getResString("NO_CONFIGURATION_REQUIRED"));
            strOperation = strBuffer.toString();
        }
        return strOperation;
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    @Override
    public void setOPerationParaList(IParaList paraList) {
        this.m_oParaList = paraList;
        this.m_oBackupConfigParam.setParaList(this.m_oParaList);
    }

    public IParaList getOPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setOperationLevel(int operationLevel) {
        this.m_iOperationLevel = operationLevel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
    }

    @Override
    public boolean isConfigReq() {
        return this.m_oBackupConfigParam.isContentTypeRequired();
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        this.m_oBackupTaskSubOpr = new TaskBackupSubOpr(this);
        return this.m_oBackupTaskSubOpr;
    }

    @Override
    public List getOperationIDnName() {
        ArrayList<Object> oData = null;
        if (this.isSelected()) {
            oData = new ArrayList<Object>();
            oData.add(this.getOperationName());
            oData.add(this.getOperationId());
        }
        return oData;
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oBackupTaskSubOpr = null;
    }

    @Override
    public String getCurrentContext() {
        String sCurrentContext = "";
        if (null == this.m_oParentTask) {
            return "";
        }
        int iTaskTypeID = this.iInnerTaskTypeId;
        switch (iTaskTypeID) {
            case 0: {
                sCurrentContext = "HELP_TOPIC_SW_U_BACKUP";
                break;
            }
            case 1: {
                sCurrentContext = "HELP_TOPIC_SW_D_BACKUP";
                break;
            }
            case 3: {
                sCurrentContext = "HELP_TOPIC_MINIC_BACKUP";
                break;
            }
            case 4: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_U_BACKUP";
                break;
            }
            case 13: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_D_BACKUP";
                break;
            }
            case 5: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_U_BACKUP";
                break;
            }
            case 12: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_D_BACKUP";
                break;
            }
        }
        return sCurrentContext;
    }

    @Override
    public void setOperationData(ITask oTaskRef) {
        this.m_oParentTask = oTaskRef;
        this.setInnerTaskTypeId(this.m_oParentTask.getTaskTypeId());
        int innerId = TaskInfoUtil.getInnerTaskTypeIDByTaskObj(this.m_oParentTask);
        if (-1 != innerId) {
            this.setInnerTaskTypeId(innerId);
        }
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }
}

