/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.components.dialog.fileselection.SelectDestinationPanel;
import com.huawei.dc.common.components.table.renderer.SimpleTableCellRenderer;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.CommonUtil;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupController;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.util.TableProgressCellRenderer;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.standalone.IManualOperation;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ManualDeviceBackupDlg
extends DCModalDialog
implements IUpdateDestinationListener {
    private static final long serialVersionUID = 1L;
    private ManualBackupTableModel m_oBackupModel = null;
    private JTable m_oBackupTable = null;
    private InternalLocalMsg oInternalmsg = null;
    private boolean m_bSaveOption = false;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private boolean m_isProgressColAdded = false;
    private static final int DEVICE_NAME = 1;
    private static final int IP_ADDRESS = 2;
    private static final int BACKUP_SAVE_BEFORE_OPTION = 4;
    private static final int BACKUP_PROGRESS = 5;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private int m_iNoSaveSelectedRows = 0;
    private int m_iSelectionType = 2;
    private IManualOperation m_oManualOperation;
    private ComboBoxWithToolTip[] m_oContentType;
    public ManualBackupTableModel oBackupModel;
    public ManualBackupController m_oManualBackupController;
    public ComboBoxWithToolTip[] oContentType;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private boolean[] m_arrIsContentTypeRequired;
    private boolean m_bIsContentTypeRequired = false;
    private boolean m_bIsBackupToClientRequired = false;
    private boolean[] m_arrIsSaveBeforeBackupRequired;
    private boolean m_bIsSaveBeforeBackupRequired = false;
    private boolean m_bIsSupportExternalFTP = true;
    private DCFilePathTextField m_textField;
    private JButton m_oButton;
    private JButton m_oContentTypeSamebtn;
    private String m_clientpath;
    private boolean m_bFlagindex;
    private String strpath;
    public boolean m_oFlag = false;
    private JCheckBox m_oRowchkBox;
    private DeviceInfo[] m_arrDeviceInfo = null;
    private boolean m_backupServerPrivilege = true;
    private boolean m_backupClientPrivilege = false;
    private boolean m_backupThirdPrivilege = false;
    private HashMap<DeviceInfo, IOperation> m_oDevOperationMap;
    private int m_iSupportSaveBeforeBackupRowCount = 0;
    private JPanel m_oBackupLocationPanel;
    private SelectDestinationPanel m_oSelectDestinationPanel;
    private JPanel m_oSelectFilePanel;
    private JPanel m_oButtonPanel;
    private final String BACKUP_TABLE_SAVE_BEFORE_BACKUP = this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP");

    public ManualDeviceBackupDlg(HashMap<DeviceInfo, IOperation> oDevOperationMap, IManualOperation oManualOperation) {
        super(DCFrameWorkUtil.getMainFrame());
        this.m_oDevOperationMap = oDevOperationMap;
        this.m_oManualOperation = oManualOperation;
        if (null == this.m_oManualOperation) {
            this.m_isProgressColAdded = true;
        }
        this.setMinimumSize(new Dimension(595, 375));
        this.setSize(595, 375);
        this.setTitle(ResourceManager.getInstance().getResString("BACKUP_DIALOG_TITLE"));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(true);
        this.getContentPane().setLayout(new BorderLayout(0, 3));
        this.checkUserPrivilege();
        this.initializeDate();
        this.initializeDialog();
    }

    public void updateDeviceBackupResult(String deviceId, int result) {
        CommonUtil.updateDeviceBackupResult(this.oInternalmsg, deviceId, result);
    }

    private void checkUserPrivilege() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_backupServerPrivilege = true;
            this.m_backupClientPrivilege = true;
            this.m_backupThirdPrivilege = true;
            return;
        }
        this.m_backupServerPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43823);
        this.m_backupClientPrivilege = this.m_backupServerPrivilege && DCFrameWorkUtil.hasUserOperationPrivilege(43866);
        this.m_backupThirdPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44095);
    }

    private void initializeDate() {
        int iSize = this.m_oDevOperationMap.size();
        this.m_arrDeviceInfo = new DeviceInfo[iSize];
        this.m_oContentType = new ComboBoxWithToolTip[iSize];
        this.m_arrIsContentTypeRequired = new boolean[iSize];
        this.m_arrIsSaveBeforeBackupRequired = new boolean[iSize];
        Set<DeviceInfo> oDevInfoSet = this.m_oDevOperationMap.keySet();
        Iterator<DeviceInfo> devInfoItr = oDevInfoSet.iterator();
        int i = 0;
        while (devInfoItr.hasNext()) {
            DeviceInfo oDevInfo;
            this.m_arrDeviceInfo[i] = oDevInfo = devInfoItr.next();
            ManualBackupOperation backupOpr = (ManualBackupOperation)this.m_oDevOperationMap.get(oDevInfo);
            ManualBackupConfigParam configPara = backupOpr.getConfigParam();
            if (!this.m_bIsContentTypeRequired) {
                this.m_bIsContentTypeRequired = configPara.isContentTypeRequired();
            }
            this.m_arrIsContentTypeRequired[i] = configPara.isContentTypeRequired();
            if (!this.m_bIsBackupToClientRequired) {
                this.m_bIsBackupToClientRequired = configPara.isBackupToClientRequired();
            }
            if (!this.m_bIsSaveBeforeBackupRequired) {
                this.m_bIsSaveBeforeBackupRequired = configPara.isSaveBeforeBackupRequired();
            }
            this.m_arrIsSaveBeforeBackupRequired[i] = configPara.isSaveBeforeBackupRequired();
            if (this.m_arrIsSaveBeforeBackupRequired[i]) {
                ++this.m_iSupportSaveBeforeBackupRowCount;
            }
            this.m_oContentType[i] = new ComboBoxWithToolTip();
            List contentTypeLst = configPara.getContentTypeList();
            for (int j = 0; j < contentTypeLst.size(); ++j) {
                this.m_oContentType[i].addItem(contentTypeLst.get(j));
            }
            if (this.m_bIsSupportExternalFTP) {
                this.m_bIsSupportExternalFTP = configPara.isBackupToExternalFTPRequired();
            }
            ++i;
        }
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_bIsBackupToClientRequired = false;
        }
    }

    private void initializeDialog() {
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.initializeBackupLocationPanel();
        this.initializeTable();
        this.createCheckBoxForBackupSaveBeforeOption();
        this.removeNotSupportedComponent();
        this.initButtons();
        this.rootPane.setDefaultButton(this.m_oOKBtn);
    }

    private void initializeBackupLocationPanel() {
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BorderLayout(0, 2));
        this.m_oBackupLocationPanel = new JPanel();
        this.m_oBackupLocationPanel.setLayout(new GridBagLayout());
        this.m_oSelectDestinationPanel = new SelectDestinationPanel(ResourceManager.getInstance().getResString("BACKUP_OPTION_LBL"), this.m_bIsBackupToClientRequired, this.m_bIsSupportExternalFTP);
        this.m_oSelectDestinationPanel.addUpdateDestinationListener(this);
        GridBagConstraints gridBagConst = new GridBagConstraints();
        gridBagConst.weightx = 0.001;
        gridBagConst.gridx = 0;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 1;
        gridBagConst.fill = 2;
        gridBagConst.anchor = 17;
        gridBagConst.insets = new Insets(10, 10, 0, 10);
        this.m_oBackupLocationPanel.add((Component)this.m_oSelectDestinationPanel, gridBagConst);
        this.m_oSelectFilePanel = new JPanel();
        this.m_oSelectFilePanel.setLayout(new BorderLayout());
        this.m_oSelectFilePanel.setBackground(Color.RED);
        this.m_textField = new DCFilePathTextField();
        this.m_textField.setName("DeviceOperation_ManualBackupDlg_m_textField");
        this.m_textField.setEditable(false);
        this.m_oSelectFilePanel.add((Component)this.m_textField, "Center");
        this.m_oButton = new JButton();
        this.m_oButton.setName("DeviceOperation_ManualBackupDlg_m_oButton");
        this.m_oButton.setText(this.m_oResMgr.getResString("BROWSE_DIALOG"));
        this.m_oButton.setToolTipText(this.m_oResMgr.getResString("BROWSE_TOOLTIP_STRING"));
        this.m_oButton.setMinimumSize(new Dimension(21, 21));
        this.m_oButton.setPreferredSize(new Dimension(21, 21));
        this.m_oButton.setMaximumSize(new Dimension(21, 21));
        this.m_oButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualDeviceBackupDlg.this.onClientButtonClick();
            }
        });
        this.m_oSelectFilePanel.add((Component)this.m_oButton, "East");
        this.m_oSelectFilePanel.setVisible(false);
        gridBagConst.weightx = 1.0;
        gridBagConst.gridx = 1;
        gridBagConst.gridy = 0;
        gridBagConst.gridwidth = 5;
        gridBagConst.anchor = 17;
        gridBagConst.insets = new Insets(10, 0, 0, 10);
        this.m_oBackupLocationPanel.add((Component)this.m_oSelectFilePanel, gridBagConst);
        this.m_oContentTypeSamebtn = new JButton();
        this.m_oContentTypeSamebtn.setMnemonic('t');
        this.m_oContentTypeSamebtn.setText(this.m_oResMgr.getResString("SAME_AS_FIRST_CONTENT_TYPE_BTN"));
        this.m_oContentTypeSamebtn.setFocusable(false);
        this.m_oContentTypeSamebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualDeviceBackupDlg.this.contentTypeButtonActionPerformed();
            }
        });
        this.m_oContentTypeSamebtn.setMinimumSize(new Dimension(200, 21));
        this.m_oContentTypeSamebtn.setPreferredSize(new Dimension(200, 21));
        this.m_oContentTypeSamebtn.setMaximumSize(new Dimension(200, 21));
        tmpPanel.add((Component)this.m_oBackupLocationPanel, "North");
        JPanel oBtnPanel = new JPanel();
        oBtnPanel.setLayout(new FlowLayout(2));
        oBtnPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        oBtnPanel.add(this.m_oContentTypeSamebtn);
        tmpPanel.add((Component)oBtnPanel, "South");
        if (this.m_bIsBackupToClientRequired || this.m_bIsSupportExternalFTP) {
            this.getContentPane().add((Component)tmpPanel, "North");
        } else {
            this.getContentPane().add(Box.createVerticalStrut(12), "North");
        }
    }

    private void initializeTable() {
        this.m_oBackupModel = new ManualBackupTableModel(this.m_oDevOperationMap);
        this.m_oManualBackupController = new ManualBackupController(this.m_arrDeviceInfo, this, this.m_oManualOperation, this.m_oBackupModel);
        this.m_oBackupTable = new JTable(this.m_oBackupModel);
        this.m_oBackupTable.setName("DeviceOperation_ManualDeviceBackupDlg_m_oBackupTable");
        this.m_oBackupTable.setRowHeight(21);
        this.m_oBackupTable.getColumnModel().getColumn(4).setMinWidth(80);
        this.m_oBackupTable.getTableHeader().setReorderingAllowed(false);
        this.m_oBackupTable.getTableHeader().setPreferredSize(new Dimension(this.m_oBackupTable.getSize().width, 28));
        DefaultListSelectionModel oTableRowSelection = new DefaultListSelectionModel();
        oTableRowSelection.setSelectionMode(1);
        this.m_oBackupTable.setSelectionModel(oTableRowSelection);
        this.m_oBackupTable.setSelectionMode(0);
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP"));
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, this.m_bIsSaveBeforeBackupRequired, this, this.m_oBackupTable.getTableHeader().getBackground());
        this.m_oCheckBoxHeader.doClick();
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        this.setTooltipForTableHeader();
        this.addListenerToTable();
        this.setCellReanderAndEditor();
        JScrollPane backupTableScrPan = new JScrollPane(this.m_oBackupTable);
        this.getContentPane().add(Box.createHorizontalStrut(12), "West");
        this.getContentPane().add((Component)backupTableScrPan, "Center");
        this.getContentPane().add(Box.createHorizontalStrut(12), "East");
    }

    private void setCellReanderAndEditor() {
        SimpleTableCellRenderer tableCellRenderer = new SimpleTableCellRenderer();
        this.m_oBackupTable.getColumnModel().getColumn(1).setCellRenderer(tableCellRenderer);
        this.m_oBackupTable.getColumnModel().getColumn(2).setCellRenderer(tableCellRenderer);
        if (this.m_bIsContentTypeRequired) {
            this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("PROGRAM_SELECTION_CONTENT_TYPE")).setCellRenderer(new ContentTypeColumnRederer());
            this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("PROGRAM_SELECTION_CONTENT_TYPE")).setCellEditor(new ContentTypeColumnEditor(this.m_oContentType[0]));
        }
        if (this.m_bIsSaveBeforeBackupRequired) {
            this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP")).setCellRenderer(new SaveBeforeBackupCellRener());
        }
        if (this.m_isProgressColAdded) {
            this.m_oBackupTable.getColumnModel().getColumn(5).setCellRenderer(new TableProgressCellRenderer());
        }
    }

    public void removeNotSupportedComponent() {
        if (!this.m_isProgressColAdded) {
            this.m_oBackupTable.removeColumn(this.m_oBackupTable.getColumnModel().getColumn(5));
        }
        if (!this.m_bIsSaveBeforeBackupRequired) {
            this.m_oBackupTable.removeColumn(this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP")));
        }
        if (!this.m_bIsContentTypeRequired) {
            this.m_oBackupTable.removeColumn(this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("PROGRAM_SELECTION_CONTENT_TYPE")));
        }
        this.m_oBackupTable.removeColumn(this.m_oBackupTable.getColumn(this.m_oResMgr.getResString("NE_ID")));
        if (this.m_bIsBackupToClientRequired && this.m_backupClientPrivilege && !this.m_backupServerPrivilege) {
            this.m_oSelectDestinationPanel.setSelectedDestination(IUpdateDestinationListener.DESTINATION_NMS_CLIENT);
        }
        if (this.m_bIsBackupToClientRequired && this.m_backupThirdPrivilege && !this.m_backupClientPrivilege && !this.m_backupServerPrivilege) {
            this.m_oSelectDestinationPanel.setSelectedDestination(IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER);
        }
    }

    public boolean isProgressColPresent() {
        return this.m_isProgressColAdded;
    }

    private void setTooltipForTableHeader() {
        this.m_oBackupTable.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int colNum = ManualDeviceBackupDlg.this.m_oBackupTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (colNum > -1) {
                    if (ManualDeviceBackupDlg.this.m_oBackupTable.getColumnName(colNum).equals(ManualDeviceBackupDlg.this.BACKUP_TABLE_SAVE_BEFORE_BACKUP)) {
                        ManualDeviceBackupDlg.this.m_oBackupTable.getTableHeader().setToolTipText(ManualDeviceBackupDlg.this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP_TOOLTIP"));
                    } else {
                        ManualDeviceBackupDlg.this.m_oBackupTable.getTableHeader().setToolTipText(ManualDeviceBackupDlg.this.m_oBackupTable.getColumnName(colNum));
                    }
                }
            }
        });
    }

    private void createCheckBoxForBackupSaveBeforeOption() {
        this.m_oRowchkBox = new JCheckBox();
        this.m_oRowchkBox.setPreferredSize(new Dimension(10, 10));
        this.m_oRowchkBox.setMaximumSize(new Dimension(10, 10));
        this.m_oRowchkBox.setPreferredSize(new Dimension(10, 10));
        this.m_oRowchkBox.setSelected(true);
        this.m_oRowchkBox.setBackground(this.m_oBackupTable.getBackground());
        this.m_oBackupTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.m_oRowchkBox));
        this.m_oBackupTable.getColumnModel().getColumn(4).setMinWidth(45);
        DCFrameWorkUtil.updateUI(this.m_oRowchkBox);
        this.m_oRowchkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent es) {
                int rowSelected = ManualDeviceBackupDlg.this.m_oBackupTable.getSelectedRow();
                if (!ManualDeviceBackupDlg.this.m_oRowchkBox.isSelected()) {
                    ManualDeviceBackupDlg.this.m_iNoSaveSelectedRows--;
                    ManualDeviceBackupDlg.this.m_oBackupModel.setValueAt("false", rowSelected, 4);
                    ManualDeviceBackupDlg.this.m_oRowchkBox.setSelected(false);
                    ManualDeviceBackupDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
                } else {
                    ManualDeviceBackupDlg.this.m_iNoSaveSelectedRows++;
                    ManualDeviceBackupDlg.this.m_oBackupModel.setValueAt("true", rowSelected, 4);
                    ManualDeviceBackupDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
                }
                DCFrameWorkUtil.updateUI(ManualDeviceBackupDlg.this.m_oBackupTable.getTableHeader());
            }
        });
    }

    @Override
    protected void oKButton_ActionPerformed() {
        this.m_oManualBackupController.startButtonActionPerformed();
    }

    private void initButtons() {
        this.m_oButtonPanel = new JPanel();
        this.m_oButtonPanel.setLayout(new FlowLayout(2));
        this.m_oOKBtn.setText(this.m_oResMgr.getResString("BACKUP_START_BUTTON"));
        this.m_oOKBtn.setMnemonic('S');
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oCancelBtn.setText(this.m_oResMgr.getResString("BACKUP_CLOSE_BUTTON"));
        this.m_oCancelBtn.setName("DeviceOperation_ManualDeviceBackupDlg_m_oCancelBtn");
        this.m_oOKBtn.setName("DeviceOperation_ManualDeviceBackupDlg_m_oOKBtn");
        this.m_oButtonPanel.add(this.m_oOKBtn);
        this.m_oButtonPanel.add(this.m_oCancelBtn);
        this.m_oButtonPanel.add(Box.createHorizontalStrut(2));
        this.getContentPane().add((Component)this.m_oButtonPanel, "South");
    }

    public int rowsSelectedForSave() {
        this.m_iSelectionType = this.m_iNoSaveSelectedRows == this.m_iSupportSaveBeforeBackupRowCount ? 0 : (this.m_iNoSaveSelectedRows < this.m_iSupportSaveBeforeBackupRowCount && this.m_iNoSaveSelectedRows != 0 ? 1 : 2);
        return this.m_iSelectionType;
    }

    private void setCheckBox() {
        int iRowCount = this.m_oBackupModel.getRowCount();
        this.m_iNoSaveSelectedRows = !this.m_bSaveOption ? 0 : this.m_iSupportSaveBeforeBackupRowCount;
        for (int i = 0; i < iRowCount; ++i) {
            Boolean val = this.m_bSaveOption;
            if (!this.m_arrIsSaveBeforeBackupRequired[i]) {
                val = Boolean.FALSE;
            }
            this.m_oBackupModel.setValueAt(val, i, 4);
        }
    }

    @Override
    public void closeDialog() {
        DCDebugTracer.trace("ManualDeviceBackupDlg closeDialog");
        super.closeDialog();
    }

    @Override
    public void doCleanUp() {
        this.getContentPane().removeAll();
        if (null != this.m_oManualBackupController) {
            this.m_oManualBackupController.doCleanUp();
            this.m_oManualBackupController = null;
        }
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        if (this.m_isProgressColAdded) {
            if (DCFrameWorkUtil.getDCModuleManager().isHaveOpenedDC()) {
                return;
            }
            DCFrameWorkUtil.getSecurityManager().doLogOut();
            XFtpManager.getInstance().clientOpCleanUp();
            DCFrameWorkUtil.shutDown();
            BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
            if (commManager != null) {
                commManager.stopShakeHand();
            }
            DCFrameWorkUtil.defaultCursor();
        }
        this.cleeanupFields();
    }

    private void cleeanupFields() {
        this.m_oBackupModel = null;
        this.m_oBackupTable = null;
        this.m_oCheckBoxHeader = null;
        this.m_oContentType = null;
        this.oBackupModel = null;
        if (null != this.m_oManualBackupController) {
            this.m_oManualBackupController = null;
        }
        this.oContentType = null;
        this.m_oResMgr = null;
        this.m_textField = null;
        this.m_oButton = null;
        this.m_clientpath = null;
        this.strpath = null;
        this.m_oRowchkBox = null;
        this.m_arrDeviceInfo = null;
    }

    private void addListenerToTable() {
        this.m_oBackupTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ManualDeviceBackupDlg.this.m_oOKBtn.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ManualDeviceBackupDlg.this.m_oOKBtn.doClick();
                } else if (e.getKeyCode() == 112) {
                    ManualDeviceBackupDlg.this.displayHelp();
                }
            }
        });
        this.m_oBackupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                int iRowNos = ManualDeviceBackupDlg.this.m_oBackupTable.getSelectedRow();
                ManualDeviceBackupDlg.this.m_oBackupTable.setRowSelectionInterval(iRowNos, iRowNos);
                ManualDeviceBackupDlg.this.m_oBackupTable.setColumnSelectionInterval(0, 0);
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
                int iRowNos = ManualDeviceBackupDlg.this.m_oBackupTable.getSelectedRow();
                ManualDeviceBackupDlg.this.m_oBackupTable.setRowSelectionInterval(iRowNos, iRowNos);
                ManualDeviceBackupDlg.this.m_oBackupTable.setColumnSelectionInterval(0, 0);
            }
        });
        this.m_oBackupTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int iRowCount = ManualDeviceBackupDlg.this.m_oBackupTable.getSelectedRow();
                ManualDeviceBackupDlg.this.m_oBackupTable.editCellAt(iRowCount, 4);
            }
        });
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_MANUAL_BACKUP_OPERATION";
    }

    void btnEnableDisable() {
        this.btnEnable();
        this.m_oCheckBoxHeader.setIsProgressDisplayed(false);
        this.m_oBackupModel.setIsProgressDisplayed(false);
    }

    void btnEnable() {
        this.m_oOKBtn.setEnabled(true);
    }

    void btnFalse() {
        if (null != this.m_oOKBtn) {
            this.m_oOKBtn.setEnabled(false);
        }
    }

    void btnEnableAndProgress() {
        if (null != this.m_oOKBtn) {
            this.m_oOKBtn.setEnabled(false);
        }
        this.m_oCheckBoxHeader.setIsProgressDisplayed(true);
        this.m_oBackupModel.setIsProgressDisplayed(true);
    }

    public boolean isSaveBeforeBackupRequired() {
        return this.m_bIsSaveBeforeBackupRequired;
    }

    public boolean isContentTypeRequired() {
        return this.m_bIsContentTypeRequired;
    }

    public boolean isBackupToClientRequired() {
        return this.m_bIsBackupToClientRequired;
    }

    public boolean getButton() {
        return this.m_bFlagindex;
    }

    public SelectDestinationPanel getBackupDestination() {
        return this.m_oSelectDestinationPanel;
    }

    private void onClientButtonClick() {
        String sDefaultCatalog;
        int iReturnVal;
        this.m_bFlagindex = true;
        this.setIndex(this.m_bFlagindex);
        DCFileChooser m_oFileChooser = new DCFileChooser();
        m_oFileChooser.setFileSelectionMode(1);
        m_oFileChooser.setTitle(ResourceManager.getInstance().getResString("BACK_UP_TO_CLIENT_SELECT_DLG_TITLE"));
        m_oFileChooser.setApproveButtonText(this.m_oResMgr.getResString("OK"));
        m_oFileChooser.setApproveButtonMnemonic('O');
        m_oFileChooser.setControlButtonsAreShown(true);
        m_oFileChooser.setAcceptAllFileFilterUsed(true);
        String s = System.getProperty("iview.filechooser.defaultpath");
        if (s != null && s.length() != 0) {
            File file = new File(s);
            m_oFileChooser.setCurrentDirectory(file.getAbsoluteFile());
        }
        if ((iReturnVal = m_oFileChooser.showDialog(this.getContentPane(), ResourceManager.getInstance().getResString("OK"))) == 0) {
            m_oFileChooser.setCurrentDirectory(new File(ConfigurationInfo.getInstance().getAbsoluteBaseDirectory()));
            this.m_textField.setText(m_oFileChooser.getSelectedFile().getAbsolutePath());
            this.strpath = m_oFileChooser.getSelectedFile().getAbsolutePath();
            this.setPath(this.strpath);
        }
        if (!"".equals(sDefaultCatalog = this.m_textField.getText())) {
            try {
                File f = new File(sDefaultCatalog);
                m_oFileChooser.setCurrentDirectory(f);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
        m_oFileChooser.validate();
    }

    private int findIndexSameAsSelected(int iRow, String strContentTypeName) {
        if (iRow < this.m_oBackupModel.getRowCount()) {
            ComboBoxWithToolTip oComboBox = this.m_oContentType[iRow];
            int iCount = oComboBox.getItemCount();
            for (int i = 0; i < iCount; ++i) {
                ContentType oContentType = (ContentType)oComboBox.getItemAt(i);
                if (!strContentTypeName.equals(oContentType.getStrContentType())) continue;
                return i;
            }
        }
        return -1;
    }

    void contentTypeButtonActionPerformed() {
        if (null == this.m_oContentType) {
            return;
        }
        int iFirstSelectIndex = this.m_oContentType[0].getSelectedIndex();
        String strContentTypeName = this.m_oContentType[0].getSelectedItem().toString();
        int iRowCount = this.m_oBackupModel.getRowCount();
        int iDevTypeId = this.m_arrDeviceInfo[0].getDeviceTypeInfo().getDevTypeID();
        for (int i = 1; i < iRowCount; ++i) {
            if (null == this.m_oContentType[i] || null == this.m_arrDeviceInfo[i].getDeviceTypeInfo()) continue;
            if (iDevTypeId == this.m_arrDeviceInfo[i].getDeviceTypeInfo().getDevTypeID()) {
                this.m_oContentType[i].setSelectedIndex(iFirstSelectIndex);
                continue;
            }
            int index = this.findIndexSameAsSelected(i, strContentTypeName);
            if (0 > index) continue;
            this.m_oContentType[i].setSelectedIndex(index);
        }
        this.m_oBackupTable.repaint();
    }

    private void setIndex(boolean flagindex) {
        this.m_oFlag = flagindex;
    }

    public boolean getButtonFlag() {
        return this.m_oFlag;
    }

    public void setPath(String strpath) {
        this.m_clientpath = strpath;
    }

    public String getPath() {
        return this.m_clientpath;
    }

    public ComboBoxWithToolTip[] getContentType() {
        return this.m_oContentType;
    }

    public int getContentTypeId(int row, String sContentType) {
        int iContentTypeItemCount = this.m_oContentType[row].getItemCount();
        for (int index = 0; index < iContentTypeItemCount; ++index) {
            ContentType oContentType = (ContentType)this.m_oContentType[row].getItemAt(index);
            if (!sContentType.startsWith(oContentType.getStrContentType())) continue;
            return oContentType.getContentTypeCode();
        }
        return -1;
    }

    @Override
    public void updateDestination(String strDestination) throws DCException {
        DCDebugTracer.trace("ManualDeviceBackupDlg#updateDestination:" + strDestination);
        if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(strDestination)) {
            if (!this.m_backupServerPrivilege || !this.m_backupClientPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_BACKUP_TO_CLIENT"));
            }
            this.m_oSelectFilePanel.setVisible(true);
        } else if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
            if (!this.m_backupServerPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_BACKUP_TO_SERVER"));
            }
            this.m_oSelectFilePanel.setVisible(false);
        } else if (IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER.equals(strDestination)) {
            if (!this.m_backupThirdPrivilege) {
                throw new DCException(ResourceManager.getInstance().getResString("NO_PRIVILEGE_BACKUP_TO_THIRD_FTP"));
            }
            this.m_oSelectFilePanel.setVisible(false);
        } else {
            this.m_oSelectFilePanel.setVisible(false);
        }
    }

    @Override
    public void updateExternalFTPName(String strExternalFTPIP) {
        DCDebugTracer.trace("don't need to handle.");
    }

    public void setoInternalmsg(InternalLocalMsg oInternalmsg) {
        this.oInternalmsg = oInternalmsg;
        if (this.oInternalmsg.data instanceof List) {
            HashMap<Integer, Integer> devOptResult = new HashMap<Integer, Integer>();
            List oDevInfoLst = (List)oInternalmsg.data;
            int iSizeOfLst = oDevInfoLst.size();
            for (int i = 0; i < iSizeOfLst; ++i) {
                Object[] oDevInfo = (Object[])oDevInfoLst.get(i);
                devOptResult.put((Integer)oDevInfo[1], -1);
            }
            this.oInternalmsg.data = devOptResult;
        }
    }

    public InternalLocalMsg getoInternalmsg() {
        return this.oInternalmsg;
    }

    private class SaveBeforeBackupCellRener
    implements TableCellRenderer {
        private SaveBeforeBackupCellRener() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            if (ManualDeviceBackupDlg.this.m_arrIsSaveBeforeBackupRequired[iRow]) {
                return this.disableCheckBoxForsaveDevices(table, value, iRow);
            }
            JLabel label = new JLabel("--");
            label.setPreferredSize(new Dimension(10, 21));
            label.setMaximumSize(new Dimension(10, 21));
            label.setPreferredSize(new Dimension(10, 21));
            if (isSelected) {
                label.setBackground(table.getSelectionBackground());
            } else {
                label.setBackground(table.getBackground());
            }
            return label;
        }

        private Component disableCheckBoxForsaveDevices(JTable table, Object value, int iRow) {
            JCheckBox chkBox = new JCheckBox();
            chkBox.setPreferredSize(new Dimension(10, 21));
            chkBox.setMaximumSize(new Dimension(10, 21));
            chkBox.setPreferredSize(new Dimension(10, 21));
            chkBox.setBackground(table.getBackground());
            chkBox.setSelected((Boolean)value);
            return chkBox;
        }
    }

    private class ContentTypeColumnEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 739922674803241151L;

        ContentTypeColumnEditor(ComboBoxWithToolTip oComboBox) {
            super(oComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return ManualDeviceBackupDlg.this.m_oContentType[row];
        }
    }

    private class ContentTypeColumnRederer
    implements TableCellRenderer {
        private ContentTypeColumnRederer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ManualDeviceBackupDlg.this.m_arrIsContentTypeRequired[row]) {
                ManualDeviceBackupDlg.this.m_oContentType[row].setBackground(table.getBackground());
                return ManualDeviceBackupDlg.this.m_oContentType[row];
            }
            JLabel label = new JLabel("--");
            label.setBackground(table.getBackground());
            return label;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (null != ManualDeviceBackupDlg.this.m_oOKBtn && !ManualDeviceBackupDlg.this.m_oOKBtn.isEnabled()) {
                return;
            }
            if (source instanceof AbstractButton) {
                if (0 == ManualDeviceBackupDlg.this.m_iSelectionType) {
                    ManualDeviceBackupDlg.this.m_bSaveOption = false;
                } else if (2 == ManualDeviceBackupDlg.this.m_iSelectionType || 1 == ManualDeviceBackupDlg.this.m_iSelectionType) {
                    ManualDeviceBackupDlg.this.m_bSaveOption = true;
                }
            } else {
                return;
            }
            ManualDeviceBackupDlg.this.setCheckBox();
            ManualDeviceBackupDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        }
    }
}

