/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class ManualBackupTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3726662864658942691L;
    private static final int m_iDeviceId = 0;
    private static final int m_iDevicename = 1;
    private static final int m_iDeviceip = 2;
    private static final int m_iDeviceFileType = 3;
    private static final int m_iDeviceSaveBeforeBackUp = 4;
    private static final int m_iDeviceProgressStatus = 5;
    private Object[][] values;
    private boolean m_bIsProgressDisp = false;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private ManualBackupConfigParam[] m_backupConfigParas;
    private String[] m_oBackUpTableColumns = new String[]{this.m_oResMgr.getResString("NE_ID"), this.m_oResMgr.getResString("DEVICE_NAME"), this.m_oResMgr.getResString("BACKUP_TABLE_DEVICEIPADDRESS"), this.m_oResMgr.getResString("PROGRAM_SELECTION_CONTENT_TYPE"), this.m_oResMgr.getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP"), this.m_oResMgr.getResString("DEVICEINFOPAN_TABLE_DEVICESTATE")};

    public ManualBackupTableModel(DeviceInfo[] arrDeviceInfo, ComboBoxWithToolTip[] arrContentType) {
        this.values = new Object[arrDeviceInfo.length][this.m_oBackUpTableColumns.length];
        this.populateData(arrDeviceInfo, arrContentType);
    }

    public ManualBackupTableModel(HashMap<DeviceInfo, IOperation> oDevOperationMap) {
        this.values = new Object[oDevOperationMap.size()][this.m_oBackUpTableColumns.length];
        this.populateData(oDevOperationMap);
    }

    private void populateData(DeviceInfo[] arrDeviceInfo, ComboBoxWithToolTip[] arrContentType) {
        for (int i = 0; i < arrDeviceInfo.length; ++i) {
            DeviceInfo oDeviceInfo = arrDeviceInfo[i];
            for (int j = 0; j < this.m_oBackUpTableColumns.length; ++j) {
                if (0 == j) {
                    this.values[i][j] = oDeviceInfo.getDevId();
                    continue;
                }
                if (1 == j) {
                    this.values[i][j] = oDeviceInfo.getDevName();
                    continue;
                }
                if (2 == j) {
                    this.values[i][j] = oDeviceInfo.getDevIPAddress();
                    continue;
                }
                if (3 == j) {
                    this.values[i][j] = arrContentType[0];
                    continue;
                }
                if (4 == j) {
                    this.values[i][j] = Boolean.FALSE;
                    continue;
                }
                if (5 == j) {
                    this.values[i][j] = this.m_oResMgr.getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
                    continue;
                }
                DCDebugTracer.trace("DC::" + this.getClass() + ".populateData(can't find column)");
            }
        }
    }

    private void populateData(HashMap<DeviceInfo, IOperation> oDevOperationMap) {
        Set<DeviceInfo> oDevInfoSet = oDevOperationMap.keySet();
        this.m_backupConfigParas = new ManualBackupConfigParam[oDevOperationMap.size()];
        Iterator<DeviceInfo> devInfoItr = oDevInfoSet.iterator();
        int i = 0;
        while (devInfoItr.hasNext()) {
            DeviceInfo oDevInfo = devInfoItr.next();
            ManualBackupOperation backupOpr = (ManualBackupOperation)oDevOperationMap.get(oDevInfo);
            this.m_backupConfigParas[i] = backupOpr.getConfigParam();
            for (int j = 0; j < this.m_oBackUpTableColumns.length; ++j) {
                if (0 == j) {
                    this.values[i][j] = oDevInfo.getDevId();
                    continue;
                }
                if (1 == j) {
                    this.values[i][j] = oDevInfo.getDevName();
                    continue;
                }
                if (2 == j) {
                    this.values[i][j] = oDevInfo.getDevIPAddress();
                    continue;
                }
                if (3 == j) {
                    this.values[i][j] = this.m_backupConfigParas[i].getContentTypeList().get(0);
                    continue;
                }
                if (4 == j) {
                    this.values[i][j] = Boolean.FALSE;
                    continue;
                }
                if (5 != j) continue;
                this.values[i][j] = this.m_oResMgr.getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
            }
            ++i;
        }
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public int getColumnCount() {
        return this.m_oBackUpTableColumns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.values[row][column] = aValue;
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public String getColumnName(int column) {
        return this.m_oBackUpTableColumns[column];
    }

    public void setIsProgressDisplayed(boolean bProgressDisplayed) {
        this.m_bIsProgressDisp = bProgressDisplayed;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.m_bIsProgressDisp && 4 == column) {
            return false;
        }
        if (null != this.m_backupConfigParas) {
            if (3 == column) {
                return this.m_backupConfigParas[row].isContentTypeRequired();
            }
            if (column == 4) {
                return this.m_backupConfigParas[row].isSaveBeforeBackupRequired();
            }
        } else {
            return column == 3 || column == 4;
        }
        return false;
    }
}

