/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceProgressNotify;
import com.huawei.dc.common.asndatacenter.AsnDCManualBackupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCManualBackupReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCProgressNotify;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.components.dialog.fileselection.SelectDestinationPanel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualBackupTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualDeviceBackupDlg;
import com.huawei.dc.deviceoperation.DevOpObjectStore;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.IProgressCBDialog;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.IBaseDevInfoMgr;
import com.huawei.dc.framework.StClientFileTransInfo;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.standalone.IManualOperation;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public class ManualBackupController
implements IProgressCBDialog {
    private static final int BACKUP_PROGRESS = 5;
    private static final long serialVersionUID = 1L;
    private static final int BACKUP_SNMP_DEVID = 0;
    private static final int BACKUP_SAVE_BEFORE_OPTION = 4;
    private ManualDeviceBackupDlg m_oBackupDialog;
    private IBaseDevInfoMgr m_deviceInfoManager;
    private IDeviceOperationManager m_deviceOperationMgr;
    private ManualBackupTableModel m_oBackUpTableModel;
    private IManualOperation m_oManualOperation;
    private HashMap m_oOperationTypeMap = null;
    ArrayList m_busyDeviceIDVec = new ArrayList(0);
    private DeviceInfo[] m_arrDevInfo;

    ManualBackupController(DeviceInfo[] arrDevInfo, ManualDeviceBackupDlg oBackupDlg, IManualOperation oManualOperation, ManualBackupTableModel oManualBackupTableModel) {
        this.m_arrDevInfo = arrDevInfo;
        this.m_deviceOperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        if (null != this.m_deviceOperationMgr) {
            this.m_deviceOperationMgr.registerNotification(this);
        }
        this.m_oBackupDialog = oBackupDlg;
        this.m_oManualOperation = oManualOperation;
        this.m_deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        this.m_oBackUpTableModel = oManualBackupTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startButtonActionPerformed() {
        Object object = DCFrameWorkUtil.getSynchronizedObject();
        synchronized (object) {
            SelectDestinationPanel oDestinationPanel = this.m_oBackupDialog.getBackupDestination();
            String strDestination = oDestinationPanel.getDestination();
            if ((!this.m_oBackupDialog.getButtonFlag() || null == this.m_oBackupDialog.getPath()) && IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(strDestination)) {
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oBackupDialog), ResourceManager.getInstance().getResString("BACK_UP_TO_CLIENT_SELECT_PATH"));
                return;
            }
            ArrayList m_oDevIDForBusyDev = new ArrayList(0);
            this.m_busyDeviceIDVec.clear();
            AsnDCManualBackupReq asnDevInfoListWithUserID = new AsnDCManualBackupReq();
            asnDevInfoListWithUserID.iUserId = BigInteger.valueOf(DCFrameWorkUtil.getUserId());
            this.populateRequestForSave(asnDevInfoListWithUserID);
            asnDevInfoListWithUserID.strServerName = oDestinationPanel.getExternalFTPServerName().getBytes();
            AsnDCOpertionRsp oAsnOpertionRsp = new AsnDCOpertionRsp();
            int iOperationType = -1;
            if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
                oAsnOpertionRsp = this.m_deviceOperationMgr.manualBackup(asnDevInfoListWithUserID, 0);
                iOperationType = 3;
            } else if (IUpdateDestinationListener.DESTINATION_EXTERNAL_FTP_SERVER.equals(strDestination)) {
                oAsnOpertionRsp = this.m_deviceOperationMgr.manualBackup(asnDevInfoListWithUserID, 0);
                iOperationType = 46;
            } else if (this.m_oBackupDialog.isBackupToClientRequired()) {
                this.backuptoClientResponse();
                oAsnOpertionRsp = this.m_deviceOperationMgr.manualBackup(asnDevInfoListWithUserID, 1);
                iOperationType = 4;
            }
            this.m_oOperationTypeMap = this.getOperationType(this.m_arrDevInfo, iOperationType);
            if (null == oAsnOpertionRsp) {
                this.m_oBackupDialog.dispose();
            } else {
                if (0 != oAsnOpertionRsp.oErrorInfo.iErrorNo.intValue()) {
                    DCOptionPane.showMessageDialog((Component)((Object)this.m_oBackupDialog), oAsnOpertionRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
                    this.m_oBackupDialog.closeDialog();
                } else {
                    if (null != this.m_oManualOperation) {
                        this.m_oBackupDialog.closeDialog();
                    }
                    if (null == this.m_oManualOperation) {
                        this.updateBackupTable(m_oDevIDForBusyDev, oAsnOpertionRsp, this.m_busyDeviceIDVec, this.m_oOperationTypeMap);
                    } else {
                        this.updateOperationStatusInDeviceTable(this.m_arrDevInfo, this.m_oOperationTypeMap);
                    }
                }
                if (4 == iOperationType && null != this.m_arrDevInfo) {
                    int iNosDevices = this.m_arrDevInfo.length;
                    for (int i = 0; i < iNosDevices; ++i) {
                        StClientFileTransInfo oClientInfoObj = new StClientFileTransInfo();
                        oClientInfoObj.m_iOperationType = 0;
                        XFtpManager.getInstance().incrementSftpOPerationCount(this.m_arrDevInfo[i].getDevId(), oClientInfoObj);
                    }
                }
            }
            if (null != this.m_oBackupDialog) {
                this.m_oBackupDialog.btnEnableAndProgress();
            }
        }
    }

    private void updateOperationStatusInDeviceTable(DeviceInfo[] arrDeviceInfo, HashMap oDevIdOpTypeMap) {
        if (null == arrDeviceInfo) {
            return;
        }
        int iDevIDs = arrDeviceInfo.length;
        Integer oOpType = null;
        if (null != this.m_oManualOperation) {
            for (int i = 0; i < iDevIDs; ++i) {
                oOpType = (Integer)oDevIdOpTypeMap.get(arrDeviceInfo[i].getDevId());
                this.m_oManualOperation.setOperationStartedStatusForDevice(arrDeviceInfo[i], oOpType);
            }
        }
    }

    private void populateRequestForSave(AsnDCManualBackupReq asnDevInfoListWithUserID) {
        int iRows = this.m_oBackUpTableModel.getRowCount();
        for (int j = 0; j < iRows; ++j) {
            int iDeviceId = Integer.parseInt(this.m_oBackUpTableModel.getValueAt(j, 0).toString());
            AsnDCManualBackupInfo asnDcManualBackupInfo = new AsnDCManualBackupInfo();
            asnDcManualBackupInfo.iDeviceID = BigInteger.valueOf(iDeviceId);
            if (this.m_oBackupDialog.isSaveBeforeBackupRequired()) {
                asnDcManualBackupInfo.bSaveBeforeBackup = (Boolean)this.m_oBackUpTableModel.getValueAt(j, 4);
                asnDcManualBackupInfo._bSaveBeforeBackup = (Boolean)this.m_oBackUpTableModel.getValueAt(j, 4);
            }
            if (this.m_oBackupDialog.isContentTypeRequired()) {
                String sSelecteItem = this.m_oBackupDialog.getContentType()[j].getSelectedItem().toString();
                int iContentTypeCode = this.m_oBackupDialog.getContentTypeId(j, sSelecteItem);
                asnDcManualBackupInfo.iContentType = BigInteger.valueOf(iContentTypeCode);
            }
            asnDevInfoListWithUserID.oManualBackupInfo.add((Object)asnDcManualBackupInfo);
        }
    }

    private int updateBackupTable(ArrayList m_oDevIDForBusyDev, AsnDCOpertionRsp oAsnOpertionRsp, ArrayList m_busyDeviceIDVec, HashMap iTempOprTypeArr) {
        int m_iDeviceBusyErrorCode = oAsnOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (m_iDeviceBusyErrorCode == 0 && null != this.m_arrDevInfo) {
            int iTotalDevices = this.m_arrDevInfo.length;
            for (int i = 0; i < iTotalDevices; ++i) {
                if (m_oDevIDForBusyDev.contains(this.m_arrDevInfo[i].getDevId())) continue;
                OperationStatus oOperationStatus = new OperationStatus();
                oOperationStatus.setOperationType((Integer)iTempOprTypeArr.get(this.m_arrDevInfo[i].getDevId()));
                oOperationStatus.setIsProgress(true);
                oOperationStatus.setProgress(0);
                this.m_oBackUpTableModel.setValueAt(oOperationStatus, i, 5);
                String strDevId = this.m_oBackUpTableModel.getValueAt(i, 0).toString();
                if (m_busyDeviceIDVec.contains(strDevId)) continue;
                m_busyDeviceIDVec.add(strDevId);
            }
            this.m_oBackupDialog.btnFalse();
        }
        return m_iDeviceBusyErrorCode;
    }

    protected HashMap getOperationType(DeviceInfo[] arrDeviceinfo, int iOperationType) {
        int j = 0;
        int iRow = -1;
        int iOprType = iOperationType;
        HashMap<Integer, Integer> oOprTypeMap = new HashMap<Integer, Integer>();
        int iRowCount = this.m_oBackUpTableModel.getRowCount();
        int i = 0;
        while (i < arrDeviceinfo.length) {
            if (arrDeviceinfo[i].getDevId() != Integer.parseInt(this.m_oBackUpTableModel.getValueAt(j, 0).toString())) {
                if (++j < iRowCount) continue;
                break;
            }
            iRow = j;
            if (-1 != iRow && ((Boolean)this.m_oBackUpTableModel.getValueAt(j++, 4)).booleanValue()) {
                iOprType = 15;
            }
            oOprTypeMap.put(arrDeviceinfo[i].getDevId(), iOprType);
            iOprType = iOperationType;
            ++i;
        }
        return oOprTypeMap;
    }

    public void backuptoClientResponse() {
        String strPath = this.m_oBackupDialog.getPath();
        DevOpObjectStore o_devOpObjectStore = DevOpObjectStore.getInstance();
        int iNosDevices = this.m_arrDevInfo.length;
        for (int deviceIndex = 0; deviceIndex < iNosDevices; ++deviceIndex) {
            o_devOpObjectStore.putObjectInstance(this.m_arrDevInfo[deviceIndex].getDevId(), strPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceProgress(int aDeviceId, int aProgressPercentage, AsnDCDeviceProgressNotify progressNotification, int aFailureReason, String strErrorMsg) {
        DCDebugTracer.trace("DC::ManualBackupController#updateDeviceProgress start");
        Object object = DCFrameWorkUtil.getSynchronizedObject();
        synchronized (object) {
            int operationType = progressNotification.enDevOperType.value;
            if (!this.m_oBackupDialog.isProgressColPresent()) {
                DCDebugTracer.trace("DC::ManualBackupController#updateDeviceProgress end isProgressColPresent false");
                return;
            }
            if (3 == operationType || 46 == operationType || 4 == operationType || 15 == operationType && this.isSaveSelected(aDeviceId)) {
                OperationStatus operationStatus = new OperationStatus();
                operationStatus.setOperationType(operationType);
                int len = this.m_arrDevInfo.length;
                for (int i = 0; i < len; ++i) {
                    if (aDeviceId != this.m_arrDevInfo[i].getDevId()) continue;
                    String strDevId = String.valueOf(aDeviceId);
                    if (-1 != aProgressPercentage) {
                        if (100 <= aProgressPercentage) {
                            String strSuccess = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
                            operationStatus.setIsProgress(false);
                            operationStatus.setIsInitialize(false);
                            operationStatus.setIFailureReason(0);
                            operationStatus.setFailureReason(strSuccess);
                            this.m_oBackUpTableModel.setValueAt(operationStatus, i, 5);
                            if (null != this.m_oOperationTypeMap && this.isSaveSelected(aDeviceId)) {
                                this.m_oOperationTypeMap.remove(aDeviceId);
                            }
                            this.m_busyDeviceIDVec.remove(strDevId);
                            this.m_oBackupDialog.updateDeviceBackupResult(strDevId, aFailureReason);
                            XFtpManager.getInstance().decrementSftpOPerationCount(aDeviceId);
                            continue;
                        }
                        if (0 > aProgressPercentage) continue;
                        if (!this.m_busyDeviceIDVec.contains(strDevId)) {
                            this.m_busyDeviceIDVec.add(strDevId);
                        }
                        operationStatus.setIsProgress(true);
                        operationStatus.setProgress(aProgressPercentage);
                        this.m_oBackUpTableModel.setValueAt(operationStatus, i, 5);
                        continue;
                    }
                    if (null != this.m_oOperationTypeMap && this.isSaveSelected(aDeviceId)) {
                        this.m_oOperationTypeMap.remove(aDeviceId);
                    }
                    this.m_busyDeviceIDVec.remove(strDevId);
                    this.m_oBackupDialog.updateDeviceBackupResult(strDevId, aFailureReason);
                    XFtpManager.getInstance().decrementSftpOPerationCount(aDeviceId);
                    String failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(aFailureReason));
                    if (null != strErrorMsg) {
                        failureReason = strErrorMsg;
                    }
                    operationStatus.setIsProgress(false);
                    operationStatus.setIsInitialize(false);
                    operationStatus.setIFailureReason(aFailureReason);
                    operationStatus.setFailureReason(failureReason);
                    this.m_oBackUpTableModel.setValueAt(operationStatus, i, 5);
                }
                if (0 == this.m_busyDeviceIDVec.size()) {
                    if (0 != aFailureReason || 15 != operationType) {
                        this.m_oBackupDialog.btnEnableDisable();
                    }
                } else {
                    this.m_oBackupDialog.btnEnableAndProgress();
                }
            }
        }
        DCDebugTracer.trace("DC::ManualBackupController#updateDeviceProgress end..");
    }

    private boolean isSaveSelected(int iDeviceId) {
        boolean bIsSaveSelected = false;
        Object oObject = this.m_oOperationTypeMap.get(iDeviceId);
        Integer oOperationType = null;
        if (oObject instanceof Integer) {
            oOperationType = (Integer)oObject;
        }
        if (null != oOperationType && 15 == oOperationType) {
            bIsSaveSelected = true;
        }
        return bIsSaveSelected;
    }

    @Override
    public void updateDeviceProgress(int aDeviceId, int aProgressPercentage, AsnDCProgressNotify progressNotification, int aFailureReason, String strErrorMsg) {
    }

    public void doCleanUp() {
        this.m_oBackupDialog = null;
        this.m_deviceInfoManager = null;
        if (null != this.m_deviceOperationMgr) {
            this.m_deviceOperationMgr.unRegisterNotification(this);
            this.m_deviceOperationMgr = null;
        }
        this.m_oBackUpTableModel = null;
        this.m_busyDeviceIDVec = null;
    }
}

