/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.util.ArrayList;
import java.util.List;

public class ManualBackupConfigParam
implements IOperationConfigPara {
    private static final long serialVersionUID = 1L;
    private IParaList m_oParaList;
    private IOperationPara m_oContentTypeParameter;
    private IOperationPara m_oBackUptoClientParameter;
    private IOperationPara m_oBackuptoExternalFTPParameter;
    private IOperationPara m_oSaveB4BackUpParameter;
    private boolean m_bIsContentTypeRequired = false;
    private boolean m_bIsBackupToClientRequired = false;
    private boolean m_bIsBackupToExternalFTPRequired = false;
    private boolean m_bIsSaveBeforeBackupRequired = false;
    private ContentType m_oSelectedContentType = null;
    private List m_oContentTypeList = new ArrayList(4);

    public ManualBackupConfigParam() {
        this.initParam();
    }

    @Override
    public IParaList getParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setParaList(IParaList paraList) {
        this.m_oParaList = paraList;
        this.initParam();
    }

    private void initParam() {
        if (null != this.m_oParaList && 0 != this.m_oParaList.getNumOfParam()) {
            this.m_oContentTypeParameter = this.m_oParaList.getParameter("ContentType");
            this.initContentTypeParam();
            this.m_oBackUptoClientParameter = this.m_oParaList.getParameter("BackupToClient");
            this.initBackupToClientParam();
            this.m_oBackuptoExternalFTPParameter = this.m_oParaList.getParameter("BackupToExternalFTP");
            if (null != this.m_oBackuptoExternalFTPParameter) {
                this.m_bIsBackupToExternalFTPRequired = this.m_oBackuptoExternalFTPParameter.isRequired();
            }
            this.m_oSaveB4BackUpParameter = this.m_oParaList.getParameter("SaveBeforeBackup");
            this.initSaveBeforeBackupParam();
        }
    }

    private void initSaveBeforeBackupParam() {
        if (null != this.m_oSaveB4BackUpParameter) {
            this.m_bIsSaveBeforeBackupRequired = this.m_oSaveB4BackUpParameter.isRequired();
        }
    }

    private void initBackupToClientParam() {
        if (null != this.m_oBackUptoClientParameter) {
            this.m_bIsBackupToClientRequired = this.m_oBackUptoClientParameter.isRequired();
        }
    }

    private void initContentTypeParam() {
        if (null != this.m_oContentTypeParameter) {
            this.m_bIsContentTypeRequired = this.m_oContentTypeParameter.isRequired();
            this.initContentParaList();
        }
    }

    private void initContentParaList() {
        List parameterValueList = this.m_oContentTypeParameter.getParameterValueList();
        int iSize = parameterValueList.size();
        this.m_oContentTypeList.clear();
        if (0 < iSize) {
            ParaValue oParaValue = (ParaValue)parameterValueList.get(0);
            this.m_oSelectedContentType = new ContentType(oParaValue.getValue(), oParaValue.getDisplayName());
            for (int iParaValueIndex = 0; iParaValueIndex < iSize; ++iParaValueIndex) {
                oParaValue = (ParaValue)parameterValueList.get(iParaValueIndex);
                this.m_oContentTypeList.add(new ContentType(oParaValue.getValue(), oParaValue.getDisplayName()));
            }
        }
    }

    public boolean isContentTypeRequired() {
        return this.m_bIsContentTypeRequired;
    }

    public boolean isBackupToClientRequired() {
        return this.m_bIsBackupToClientRequired;
    }

    public boolean isBackupToExternalFTPRequired() {
        return this.m_bIsBackupToExternalFTPRequired;
    }

    public boolean isSaveBeforeBackupRequired() {
        return this.m_bIsSaveBeforeBackupRequired;
    }

    public ContentType getSelectedContentType() {
        return this.m_oSelectedContentType;
    }

    public List getContentTypeList() {
        return this.m_oContentTypeList;
    }
}

