/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContentTypeCfgPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ContentConfigParam m_oContentConfigParam = null;
    private ComboBoxWithToolTip comboBox;
    private JLabel contentTypeLabel;
    private ResourceManager m_oResourceManager;
    private ArrayList<ContentType> m_oSelectedContentType = new ArrayList();
    private ContentType m_oTaskContentType;

    public ContentTypeCfgPanel(ContentConfigParam oConfigParam, ContentType oTaskContentType) {
        this.m_oContentConfigParam = oConfigParam;
        this.m_oResourceManager = ResourceManager.getInstance();
        this.m_oTaskContentType = oTaskContentType;
        JPanel panel = this.initPanel();
        if (this.m_oContentConfigParam.isContentTypeRequired()) {
            this.initComponents(panel);
        } else {
            this.contentTypeLabel = new JLabel();
            this.contentTypeLabel.setBounds(8, 15, 250, 47);
            this.contentTypeLabel.setText(this.m_oResourceManager.getResString("DEFAULT_VALUE_SELECTION"));
            panel.add(this.contentTypeLabel);
        }
    }

    private JPanel initPanel() {
        this.setLayout(null);
        this.setBounds(200, 120, 500, 139);
        JPanel panel = new JPanel();
        panel.setName("DeviceOperation_ContentTypeCfgDlg_panel");
        panel.setFocusCycleRoot(true);
        panel.setLayout(null);
        panel.setBounds(5, 15, 260, 74);
        this.add(panel);
        return panel;
    }

    protected void initComponents(JPanel panel) {
        this.contentTypeLabel = new JLabel();
        this.contentTypeLabel.setBounds(20, 31, 120, 20);
        this.contentTypeLabel.setText(this.m_oResourceManager.getResString("CONTENT_TYPE0"));
        panel.add(this.contentTypeLabel);
        this.comboBox = new ComboBoxWithToolTip();
        this.comboBox.setName("DeviceOperation_ContentTypeCfgDlg_comboBox");
        this.comboBox.setBounds(108, 31, 130, 20);
        panel.add(this.comboBox);
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.getContentType(this.m_oContentConfigParam.getContentTypeList())));
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentTypeCfgPanel.this.storeSelectedObj();
            }
        });
        List<ContentType> oContentConfig = this.m_oContentConfigParam.getSelectedContentType();
        if (null != oContentConfig) {
            this.comboBox.setSelectedItem(oContentConfig.get(0));
        }
    }

    private Object[] getContentType(Object[] arrContentType) {
        if (null == this.m_oTaskContentType) {
            return arrContentType;
        }
        Object[] arrSelecContentType = new Object[1];
        ContentType oContentType = null;
        for (int i = 0; i < arrContentType.length; ++i) {
            oContentType = (ContentType)arrContentType[i];
            if (!oContentType.getId().equals(this.m_oTaskContentType.getId())) continue;
            arrSelecContentType[0] = oContentType;
            return arrSelecContentType;
        }
        return arrContentType;
    }

    private void storeSelectedObj() {
        if (-1 != this.comboBox.getSelectedIndex()) {
            this.m_oSelectedContentType.clear();
            this.m_oSelectedContentType.add((ContentType)this.comboBox.getSelectedItem());
        }
    }

    public void onComboSelection() {
        if (null != this.m_oSelectedContentType) {
            this.m_oContentConfigParam.setSelectedContentType(this.m_oSelectedContentType);
        }
    }
}

