/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.util.ArrayList;
import java.util.List;

public class ContentConfigParam
implements IOperationConfigPara {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "ContentType";
    private List<ContentType> m_oSelectedContentType = null;
    private Object[] m_oContentTypeList = null;
    private List<Integer> m_iContentType = null;
    private IParaList m_oParaList;
    private IOperationPara m_oContentTypeParameter;
    private boolean m_bIsContentTypeRequired;
    private boolean m_isInitBackup = true;

    public ContentConfigParam(IParaList paraList) {
        this.m_oParaList = paraList;
        this.m_oSelectedContentType = new ArrayList<ContentType>();
        this.m_iContentType = new ArrayList<Integer>();
        this.initContentType(this.m_oParaList);
    }

    private void initContentType(IParaList oParaList) {
        this.m_oContentTypeList = ParamUtil.getInstance().getContentTypeList(oParaList);
        if (null != oParaList && 0 != oParaList.getNumOfParam()) {
            this.m_oContentTypeParameter = oParaList.getParameter(CONTENT_TYPE);
            if (null != this.m_oContentTypeParameter) {
                this.m_bIsContentTypeRequired = this.m_oContentTypeParameter.isRequired();
                if (this.m_bIsContentTypeRequired) {
                    this.m_oContentTypeList = ParamUtil.getInstance().getContentTypeList(this.m_oContentTypeParameter);
                    if (null != this.m_oContentTypeList && 0 < this.m_oContentTypeList.length) {
                        this.m_oSelectedContentType.add((ContentType)this.m_oContentTypeList[0]);
                        this.m_iContentType.add(this.m_oSelectedContentType.get(0).getContentTypeCode());
                    }
                }
            }
        }
    }

    public List<ContentType> getSelectedContentType() {
        int iSize = this.m_oContentTypeList.length;
        ContentType oContentType = null;
        ArrayList<ContentType> oTempList = new ArrayList<ContentType>(0);
        for (int i = 0; i < iSize; ++i) {
            oContentType = (ContentType)this.m_oContentTypeList[i];
            if (!this.m_oSelectedContentType.contains(oContentType)) continue;
            oTempList.add(oContentType);
        }
        this.m_oSelectedContentType = oTempList;
        return this.m_oSelectedContentType;
    }

    public List<ContentType> getSelectAll() {
        int iSize = this.m_oContentTypeList.length;
        ContentType oContentType = null;
        ArrayList<ContentType> oTempList = new ArrayList<ContentType>(0);
        for (int i = 0; i < iSize; ++i) {
            oContentType = (ContentType)this.m_oContentTypeList[i];
            oTempList.add(oContentType);
        }
        this.m_oSelectedContentType = oTempList;
        return this.m_oSelectedContentType;
    }

    public List<ContentType> getUnselectAll() {
        this.m_oSelectedContentType = new ArrayList<ContentType>(0);
        return this.m_oSelectedContentType;
    }

    public void setSelectedContentType(List<ContentType> selectedContentType) {
        if (null != selectedContentType && !selectedContentType.isEmpty()) {
            this.m_oSelectedContentType = selectedContentType;
            this.m_iContentType.clear();
            for (int i = 0; i < selectedContentType.size(); ++i) {
                if (null == selectedContentType.get(i)) continue;
                this.m_iContentType.add(selectedContentType.get(i).getContentTypeCode());
            }
        }
    }

    public void clearContentTypes() {
        this.m_oSelectedContentType.clear();
        this.m_iContentType.clear();
    }

    public Object[] getContentTypeList() {
        return this.m_oContentTypeList;
    }

    public void setSelectedContentTypeId(List<Integer> iContentTypeIdLst) {
        if (null == iContentTypeIdLst || iContentTypeIdLst.isEmpty()) {
            return;
        }
        ArrayList<ContentType> l_selTypeList = new ArrayList<ContentType>();
        ContentType l_selType = null;
        for (int i = 0; i < iContentTypeIdLst.size(); ++i) {
            l_selType = ParamUtil.getInstance().getContentType(this.getContentTypeList(), iContentTypeIdLst.get(i));
            l_selTypeList.add(l_selType);
        }
        this.setSelectedContentType(l_selTypeList);
    }

    public void setSelectedContentTypeId(int iContentTypeId) {
        if (-1 == iContentTypeId) {
            return;
        }
        ContentType l_selType = ParamUtil.getInstance().getContentType(this.getContentTypeList(), iContentTypeId);
        this.setSelectedInfo(l_selType);
    }

    public void setSelectedContentTypeId(String strContentTypeId) {
        if (null == strContentTypeId) {
            return;
        }
        ContentType l_selType = ParamUtil.getInstance().getContentType(this.getContentTypeList(), strContentTypeId);
        this.setSelectedInfo(l_selType);
    }

    public void setSelectedInfo(ContentType l_selType) {
        if (l_selType == null) {
            return;
        }
        ArrayList<ContentType> l_selTypeList = new ArrayList<ContentType>();
        l_selTypeList.add(l_selType);
        if (!l_selTypeList.isEmpty()) {
            this.setSelectedContentType(l_selTypeList);
        }
    }

    public List<Integer> getSelectedContentTypeId() {
        return this.m_iContentType;
    }

    @Override
    public void setParaList(IParaList paraList) {
        this.m_oParaList = paraList;
        this.initContentType(this.m_oParaList);
    }

    public boolean isContentTypeRequired() {
        return this.m_bIsContentTypeRequired;
    }

    public void setContentTypeRequired(boolean isContentTypeRequired) {
        this.m_bIsContentTypeRequired = isContentTypeRequired;
    }

    @Override
    public IParaList getParaList() {
        return this.m_oParaList;
    }

    public boolean isInitBackup() {
        return this.m_isInitBackup;
    }

    public void setFirstBackup(boolean isInitBackup) {
        this.m_isInitBackup = isInitBackup;
    }
}

