/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class BackupViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ContentConfigParam m_oContentConfigParam = null;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private JTable m_oBackTable = null;
    private static final int ROWHIGHT = 21;
    private int TABLE_FILE_NAME = 0;
    private int TABLE_FILE_PATH = 1;
    private JScrollPane m_oScrollPane = null;
    boolean isSelectThridFTP = false;

    public BackupViewPanel(ContentConfigParam oConfigParam, ContentType oTaskContentType, boolean isSelThridFtp) {
        this.isSelectThridFTP = isSelThridFtp;
        this.m_oContentConfigParam = oConfigParam;
        this.m_oResourceManager = ResourceManager.getInstance();
        this.setLayout(new BorderLayout());
        this.initTablePanel();
    }

    public void setScrollPaneBounds(int x, int y, int iWidth, int iHeight) {
        this.m_oScrollPane.setBounds(x, y, iWidth, iHeight);
    }

    private void initTablePanel() {
        Object[] arrColNames = new String[]{this.m_oResourceManager.getResString("FILENAMEHEADER"), this.m_oResourceManager.getResString("PATHHEADER")};
        List<ContentType> oSelContentTypeList = this.m_oContentConfigParam.getSelectedContentType();
        int iSize = -1;
        if (null != oSelContentTypeList) {
            iSize = oSelContentTypeList.size();
            if (0 == iSize) {
                return;
            }
            Object[][] oTableValues = new Object[iSize][2];
            ContentType oContentType = null;
            for (int i = 0; i < iSize; ++i) {
                oContentType = oSelContentTypeList.get(i);
                oContentType.setContentType(this.m_oResourceManager.getResString(oContentType.getStrContentType()));
                oTableValues[i][0] = oContentType;
                if (this.isSelectThridFTP) {
                    oContentType.setDestination("BackupFolder");
                }
                oTableValues[i][1] = this.m_oResourceManager.getResString(oContentType.getDestination());
            }
            this.m_oBackTable = new JTable(oTableValues, arrColNames){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.initTableColSize();
            this.m_oBackTable.setRowHeight(21);
            this.m_oBackTable.setRowSelectionAllowed(true);
            this.m_oBackTable.setSelectionMode(2);
            this.m_oBackTable.setFocusable(false);
            this.m_oScrollPane = new JScrollPane(this.m_oBackTable);
            this.add(this.m_oScrollPane);
        }
    }

    private void initTableColSize() {
        this.m_oBackTable.getColumnModel().getColumn(this.TABLE_FILE_NAME).setPreferredWidth(300);
        this.m_oBackTable.getColumnModel().getColumn(this.TABLE_FILE_PATH).setPreferredWidth(300);
    }
}

