/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BackupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ContentConfigParam m_oContentConfigParam = null;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private JTable m_oBackTable = null;
    private static final int ROWHIGHT = 21;
    private static final int TABLE_FILE_NAME = 0;
    private static final int TABLE_FILE_PATH = 1;
    private JScrollPane m_oScrollPane = null;
    private boolean m_bIsOprSelected = true;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private int m_iSelectionType = 0;
    private boolean isSelectThridFtp = false;

    public BackupPanel(ContentConfigParam oConfigParam, boolean bIsOprSelected, boolean isSelThridFtp) {
        this.isSelectThridFtp = isSelThridFtp;
        this.m_oContentConfigParam = oConfigParam;
        this.m_oResourceManager = ResourceManager.getInstance();
        this.setLayout(new BorderLayout());
        this.m_bIsOprSelected = bIsOprSelected;
        this.initTablePanel();
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        this.refreshTable();
    }

    public void setScrollPaneBounds(int x, int y, int iWidth, int iHeight) {
        this.m_oScrollPane.setBounds(x, y, iWidth, iHeight);
    }

    public List<ContentType> getSelectedContentTypeList() {
        return this.m_oContentConfigParam.getSelectedContentType();
    }

    public ContentConfigParam getSelectedContentType() {
        return this.m_oContentConfigParam;
    }

    private void initTablePanel() {
        DCDebugTracer.trace("Entering initTablePanel");
        Object[] l_contentTypeList = this.m_oContentConfigParam.getContentTypeList();
        if (null == l_contentTypeList || 0 == l_contentTypeList.length) {
            return;
        }
        boolean l_isInit = this.m_oContentConfigParam.isInitBackup();
        boolean bFlag = false;
        List<ContentType> l_conTypeLst = null;
        if (l_isInit) {
            bFlag = true;
        } else if (!l_isInit && !this.m_bIsOprSelected) {
            bFlag = true;
        }
        l_conTypeLst = this.getContentTypeList(l_contentTypeList, bFlag);
        if (l_isInit || !l_isInit && !this.m_bIsOprSelected) {
            this.m_oContentConfigParam.setSelectedContentType(l_conTypeLst);
        }
        this.initBackupTable(l_conTypeLst);
        this.customizeFileTypeCheckBox();
        DCDebugTracer.trace("Exiting initTablePanel");
    }

    private void initBackupTable(List<ContentType> oConTypeLst) {
        if (null == oConTypeLst) {
            return;
        }
        int l_contentCount = oConTypeLst.size();
        Object[] l_ColNames = new String[]{this.m_oResourceManager.getResString("FILENAMEHEADER"), this.m_oResourceManager.getResString("PATHHEADER")};
        Object[][] l_values = new Object[l_contentCount][2];
        int i = 0;
        String value = null;
        for (ContentType oContentType : oConTypeLst) {
            l_values[i][0] = oContentType;
            if (this.isSelectThridFTP()) {
                if (i == 0) {
                    value = this.m_oResourceManager.getResString(oContentType.getDestination());
                }
                l_values[i][1] = value;
            } else {
                l_values[i][1] = this.m_oResourceManager.getResString(oContentType.getDestination());
            }
            ++i;
        }
        this.m_oBackTable = new JTable(l_values, l_ColNames);
        this.m_oBackTable.setRowHeight(21);
        this.m_oBackTable.getColumnModel().getColumn(0).setCellRenderer(new BackupCheckBoxRenderer());
        this.m_oBackTable.getColumnModel().getColumn(0).setCellEditor(new BackupCheckBoxEditor());
        this.m_oBackTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.m_oBackTable.getColumnModel().getColumn(1).setCellRenderer(new BackupDestRenderer());
        this.m_oBackTable.getColumnModel().getColumn(1).setCellEditor(new BackupCellEditor());
        this.m_oBackTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.m_oBackTable.getTableHeader().setReorderingAllowed(false);
        this.m_oBackTable.getTableHeader().setPreferredSize(new Dimension(this.m_oBackTable.getSize().width, 28));
        this.m_oBackTable.setRowSelectionAllowed(true);
        this.m_oBackTable.setSelectionMode(2);
        this.m_oBackTable.setFocusable(true);
        this.m_oBackTable.setName("BackUpDlg_m_oBackTable");
        this.m_oScrollPane = new JScrollPane(this.m_oBackTable);
        this.add(this.m_oScrollPane);
    }

    private List<ContentType> getContentTypeList(Object[] l_contentTypeList, boolean bFlag) {
        ContentType l_contentType = null;
        ArrayList<ContentType> l_conTypeLst = new ArrayList<ContentType>();
        if (null == l_contentTypeList) {
            return l_conTypeLst;
        }
        int coutentLeg = l_contentTypeList.length;
        for (int i = 0; i < coutentLeg; ++i) {
            l_contentType = (ContentType)l_contentTypeList[i];
            l_contentType.setContentType(this.m_oResourceManager.getResString(l_contentType.getStrContentType()));
            if (!l_contentType.isEnabled()) {
                l_contentType.setSelected(false);
            } else {
                l_contentType.setSelected(false);
                this.setDefaultSelected(l_contentType);
            }
            l_conTypeLst.add(l_contentType);
        }
        return l_conTypeLst;
    }

    private void setDefaultSelected(ContentType oContentType) {
        DCDebugTracer.trace("Entering setDefaultSelected");
        if (!this.m_bIsOprSelected) {
            return;
        }
        List<ContentType> oSelContentTypeList = this.m_oContentConfigParam.getSelectedContentType();
        if (null == oSelContentTypeList) {
            return;
        }
        for (ContentType contentType : oSelContentTypeList) {
            if (contentType.getContentTypeCode() != oContentType.getContentTypeCode()) continue;
            oContentType.setSelected(true);
        }
        if (this.isSelectThridFTP() && (oContentType.getId().equals("Log") || oContentType.getId().equals("Trap"))) {
            oContentType.setSelected(false);
            oContentType.setEnabled(false);
        }
        DCDebugTracer.trace("Exiting setDefaultSelected");
    }

    private boolean isSelectThridFTP() {
        return CreateTaskDialog.isProxied() || this.isSelectThridFtp;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != BackupPanel.this.m_oBackTable) {
                    BackupPanel.this.m_oBackTable.getTableHeader().updateUI();
                    BackupPanel.this.m_oBackTable.getTableHeader().repaint();
                    BackupPanel.this.m_oBackTable.updateUI();
                    BackupPanel.this.m_oBackTable.repaint();
                }
            }
        });
    }

    private void customizeFileTypeCheckBox() {
        TableColumn oSaveCoulmn = this.addCheckBoxToHeader(true);
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
    }

    private TableColumn addCheckBoxToHeader(boolean bSetHeader) {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oBackTable.getColumnModel().getColumn(0);
        this.m_oBackTable.getTableHeader().setPreferredSize(new Dimension(this.m_oBackTable.getSize().width, 28));
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, bSetHeader, this, this.m_oBackTable.getTableHeader().getBackground());
        return oSaveCoulmn;
    }

    private void setCheckBox(boolean bChecked) {
        int iRowCount = this.m_oBackTable.getRowCount();
        for (int i = 0; i < iRowCount; ++i) {
            ContentType oContentTypeInfo = (ContentType)this.m_oBackTable.getModel().getValueAt(i, 0);
            if (this.isSelectThridFTP()) {
                if (oContentTypeInfo.getId().equals("Log") || oContentTypeInfo.getId().equals("Trap")) {
                    oContentTypeInfo.setSelected(false);
                    continue;
                }
                oContentTypeInfo.setSelected(bChecked);
                continue;
            }
            oContentTypeInfo.setSelected(bChecked);
        }
    }

    public int parseIsSelect() {
        int iRowCount = this.m_oBackTable.getRowCount();
        int iSelectAll = 0;
        int iDoNotSelect = 0;
        int iNotEnable = 0;
        for (int i = 0; i < iRowCount; ++i) {
            ContentType oContentTypeInfo = (ContentType)this.m_oBackTable.getModel().getValueAt(i, 0);
            if (oContentTypeInfo.isEnabled()) {
                if (oContentTypeInfo.isSelected()) {
                    ++iSelectAll;
                    continue;
                }
                ++iDoNotSelect;
                continue;
            }
            ++iNotEnable;
        }
        this.m_iSelectionType = iRowCount == iSelectAll + iNotEnable ? 0 : (iRowCount == iDoNotSelect + iNotEnable ? 2 : (this.isSelectThridFTP() && iSelectAll == iRowCount - 2 ? 0 : 1));
        return this.m_iSelectionType;
    }

    public int getSelectionType() {
        return this.m_iSelectionType;
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean bChecked;
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                bChecked = false;
                if (0 == BackupPanel.this.m_iSelectionType) {
                    bChecked = false;
                } else if (2 == BackupPanel.this.m_iSelectionType || 1 == BackupPanel.this.m_iSelectionType) {
                    bChecked = true;
                }
            } else {
                return;
            }
            BackupPanel.this.setCheckBox(bChecked);
            BackupPanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            BackupPanel.this.refreshTable();
        }
    }

    private class BackupDestRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4342738243381306155L;

        private BackupDestRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean bSelected, boolean focus, int iRowNo, int iCcolNo) {
            this.setForeground(Color.black);
            this.setBackground(BackupPanel.this.m_oBackTable.getBackground());
            if (null != value) {
                this.setText(value.toString());
                this.setToolTipText(value.toString());
            } else {
                this.setText(null);
                this.setToolTipText(null);
            }
            ContentType oContentTypeInfo = (ContentType)BackupPanel.this.m_oBackTable.getModel().getValueAt(iRowNo, 0);
            if (!oContentTypeInfo.isEnabled()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    private class BackupCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -4852562362222707749L;

        private BackupCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean bSelected, int iRowNo, int iCcolNo) {
            return oTable;
        }

        @Override
        public boolean isCellEditable(EventObject arg0) {
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            int selectRow = BackupPanel.this.m_oBackTable.getSelectedRow();
            return BackupPanel.this.m_oBackTable.getModel().getValueAt(selectRow, 1).toString();
        }
    }

    private class BackupCheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox m_oOpSelecCheckBox = new JCheckBox();
        private ContentType m_oContentTypeInfo = null;
        private boolean m_bIsSelected = true;

        public BackupCheckBoxEditor() {
            this.m_oOpSelecCheckBox.addActionListener(this);
            this.m_oOpSelecCheckBox.setFocusable(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean bSelected, int iRowNo, int iColNo) {
            ContentType oContentTypeInfo = (ContentType)oTable.getModel().getValueAt(iRowNo, 0);
            this.m_bIsSelected = oContentTypeInfo.isSelected();
            this.m_oOpSelecCheckBox.setName("chk_" + BackupPanel.this.m_oResourceManager.getResString(oContentTypeInfo.getStrContentType()));
            this.m_oOpSelecCheckBox.setText(BackupPanel.this.m_oResourceManager.getResString(oContentTypeInfo.getStrContentType()));
            this.m_oOpSelecCheckBox.setSelected(this.m_bIsSelected);
            this.m_oOpSelecCheckBox.setEnabled(oContentTypeInfo.isEnabled());
            this.m_oOpSelecCheckBox.setForeground(Color.black);
            this.m_oOpSelecCheckBox.setBackground(BackupPanel.this.m_oBackTable.getBackground());
            return this.m_oOpSelecCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            int iSelectRow = BackupPanel.this.m_oBackTable.getSelectedRow();
            this.m_oContentTypeInfo = (ContentType)BackupPanel.this.m_oBackTable.getModel().getValueAt(iSelectRow, 0);
            this.m_oOpSelecCheckBox.setText(BackupPanel.this.m_oResourceManager.getResString(this.m_oContentTypeInfo.getStrContentType()));
            this.m_oOpSelecCheckBox.setSelected(this.m_oContentTypeInfo.isSelected());
            this.m_oOpSelecCheckBox.setEnabled(this.m_oContentTypeInfo.isEnabled());
            return this.m_oContentTypeInfo;
        }

        @Override
        public void actionPerformed(ActionEvent oArg) {
            this.m_bIsSelected = !this.m_bIsSelected;
            int iSelectRow = BackupPanel.this.m_oBackTable.getSelectedRow();
            this.m_oContentTypeInfo = (ContentType)BackupPanel.this.m_oBackTable.getModel().getValueAt(iSelectRow, 0);
            if (!this.m_oContentTypeInfo.isEnabled()) {
                this.fireEditingStopped();
                BackupPanel.this.refreshTable();
                return;
            }
            this.m_oContentTypeInfo.setSelected(this.m_bIsSelected);
            this.m_oOpSelecCheckBox.setSelected(this.m_bIsSelected);
            if (this.m_bIsSelected) {
                List<ContentType> oList = BackupPanel.this.m_oContentConfigParam.getSelectedContentType();
                oList.add(this.m_oContentTypeInfo);
                BackupPanel.this.m_oContentConfigParam.setSelectedContentType(oList);
            } else {
                List<ContentType> oList = BackupPanel.this.m_oContentConfigParam.getSelectedContentType();
                if (null == oList) {
                    return;
                }
                ArrayList<ContentType> oNewList = new ArrayList<ContentType>();
                for (ContentType contentType : oList) {
                    if (this.m_oContentTypeInfo.getId().equals(contentType.getId())) continue;
                    oNewList.add(contentType);
                }
                if (!oNewList.isEmpty()) {
                    BackupPanel.this.m_oContentConfigParam.setSelectedContentType(oNewList);
                } else {
                    BackupPanel.this.m_oContentConfigParam.clearContentTypes();
                }
            }
            this.fireEditingStopped();
            BackupPanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            BackupPanel.this.refreshTable();
        }
    }

    private class BackupCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private BackupCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object oValue, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            ContentType oContentTypeInfo = (ContentType)BackupPanel.this.m_oBackTable.getModel().getValueAt(iRow, 0);
            this.setForeground(Color.black);
            this.setBackground(BackupPanel.this.m_oBackTable.getBackground());
            if (null != oValue) {
                this.setText(oValue.toString());
                this.setToolTipText(oValue.toString());
            } else {
                this.setText(null);
                this.setToolTipText(null);
            }
            this.setSelected(oContentTypeInfo.isSelected());
            this.setEnabled(oContentTypeInfo.isEnabled());
            return this;
        }
    }
}

