/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.backup;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.backup.BackupPanel;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;

public class BackUpDlg
extends DCModalDialog
implements ActionListener {
    private static final String CLOSE_ACTION_CMD = "CloseAction";
    private static final String SAVE_ACTION_CMD = "SaveAction";
    private static final long serialVersionUID = -8198010309483262393L;
    private BackupPanel m_backPanel = null;
    private JPanel m_buttonPnl = null;
    private final ContentConfigParam m_configPara;
    private final ResourceManager m_resMgr = ResourceManager.getInstance();

    public BackUpDlg(ContentConfigParam oConfigParam, boolean isSelThridFtp) {
        this.m_configPara = oConfigParam;
        this.m_backPanel = new BackupPanel((ContentConfigParam)CloneUtil.getClone(this.m_configPara), true, isSelThridFtp);
        this.m_backPanel.setPreferredSize(new Dimension(300, 250));
        this.m_backPanel.setMinimumSize(new Dimension(300, 250));
        this.initButtonPanel();
        this.setLayout(new GridBagLayout());
        this.add(this.m_backPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 12, 12), 0, 0));
        this.add(this.m_buttonPnl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.setSize(330, 340);
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void initButtonPanel() {
        DCDebugTracer.trace("Entering initButtonPanel");
        this.m_buttonPnl = new JPanel();
        this.m_oOKBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(this.m_resMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(this.m_resMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oOKBtn.setActionCommand(SAVE_ACTION_CMD);
        this.m_oOKBtn.addActionListener(this);
        this.m_oCancelBtn.setActionCommand(CLOSE_ACTION_CMD);
        this.m_oCancelBtn.addActionListener(this);
        this.m_buttonPnl.setPreferredSize(new Dimension(300, 21));
        this.m_buttonPnl.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_buttonPnl.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_buttonPnl.add(this.m_oOKBtn);
        this.m_buttonPnl.add(this.m_oCancelBtn);
        DCDebugTracer.trace("Exiting initButtonPanel");
    }

    public void okActionPerformed() {
        boolean isNoneSelected;
        List<ContentType> l_selectedList = this.m_backPanel.getSelectedContentTypeList();
        int selectionType = this.m_backPanel.getSelectionType();
        boolean bl = isNoneSelected = 2 == selectionType;
        if (null == l_selectedList || l_selectedList.isEmpty() || isNoneSelected) {
            DCOptionPane.showErrorDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SELECTED_ONE_FILE"));
            return;
        }
        for (int i = l_selectedList.size() - 1; i >= 0; --i) {
            if (l_selectedList.get(i).isSelected()) continue;
            l_selectedList.remove(i);
        }
        this.m_configPara.setSelectedContentType(l_selectedList);
        this.m_configPara.setFirstBackup(false);
        this.dispose();
    }

    public void closeActionPerformed() {
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_UPGRADE_DOWNGRADE_BACKUP_OPERATION";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SAVE_ACTION_CMD.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.okActionPerformed();
        }
        if (CLOSE_ACTION_CMD.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.closeActionPerformed();
        }
    }
}

