/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.RowData;
import com.huawei.dc.taskmgmt.view.common.NewGroupPanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class NewGroupDlg
extends NewGroupPanel {
    private static final long serialVersionUID = -7360115545858250066L;
    private Vector dataList = new Vector();
    private ActionListener m_oEscKeyHandler;

    public NewGroupDlg(Vector dataList) {
        this.dataList = dataList;
        Vector groupList = (Vector)dataList.get(0);
        JTextField text = super.getGroupNameText();
        text.setName("DeviceOperation_NewGroupDlg_text");
        text.setText(ResourceManager.getInstance().getResString("GROUP") + (groupList.size() + 1));
        this.populateDataInTable();
        this.setVisible(true);
    }

    private void populateDataInTable() {
        RowData devicesNodeInfo = new RowData(-1, null, 3, "");
        TreeTableNode devicesNode = new TreeTableNode(devicesNodeInfo);
        TreeTableNode rootNode = super.getRootNode();
        rootNode.add(devicesNode);
        Vector devList = (Vector)this.dataList.get(1);
        for (int i = 0; i < devList.size(); ++i) {
            TreeTableNode devNode = (TreeTableNode)devList.get(i);
            devicesNode.add(devNode);
        }
        super.updateTableView();
    }

    @Override
    public String[] getStrColumnNamesByTree() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("CURRENT_GROUP")};
        return strColumnNames;
    }

    @Override
    public String[] getStrColumnNamesByTable() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("DEVICE_IP_FOR_PACKAGE_TASK")};
        return strColumnNames;
    }

    @Override
    public Class[] getArrColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        return arrColumnTypes;
    }

    @Override
    public String[] getMethodBoardTreeNames() {
        return RowData.getMethodBoardTreeName();
    }

    @Override
    public boolean[] getArrSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false};
        return arrSortableColumns;
    }

    @Override
    public boolean[] getArrEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false};
        return arrEditableColumns;
    }

    @Override
    public String getRightTitle() {
        return ResourceManager.getInstance().getResString("DEVICE_TREE_PACKAGE_UPDATE_TASK");
    }

    @Override
    public String getLeftTitle() {
        return ResourceManager.getInstance().getResString("SELECTED_DEVICES");
    }

    @Override
    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RowData nodeInfo = (RowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon;
            if (!nodeInfo.getIsSelect()) {
                if (nodeInfo.getNodeType() == 3) {
                    int deviceCount = node.getChildCount();
                    boolean allNotSelected = true;
                    for (int i = 0; i < deviceCount; ++i) {
                        TreeTableNode devNode = (TreeTableNode)node.getChildAt(i);
                        RowData devNodeInfo = (RowData)devNode.getUserObject();
                        if (!devNodeInfo.getIsSelect()) continue;
                        allNotSelected = false;
                        break;
                    }
                    m_oSelectIcon = !allNotSelected ? ResourceManager.getInstance().getImage("part.gif") : ResourceManager.getInstance().getImage("noneselect.gif");
                } else {
                    m_oSelectIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                }
            } else {
                m_oSelectIcon = ResourceManager.getInstance().getImage("all.gif");
            }
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    @Override
    public void tree_MousePressed(MouseEvent oMouseEvent) {
        int x = oMouseEvent.getX();
        int arrSelectedRow = super.getTreeTable().getSelectedRow();
        if (arrSelectedRow < 0) {
            return;
        }
        int iClickedColumn = super.getTreeTable().columnAtPoint(oMouseEvent.getPoint());
        if (iClickedColumn == 0) {
            TreePath oTreePath = super.getTreeTable().getTree().getPathForRow(arrSelectedRow);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            RowData nodeInfo = (RowData)oNode.getUserObject();
            if (nodeInfo.getNodeType() == 2 ? x < 40 || x > 53 : nodeInfo.getNodeType() == 3 && (x < 19 || x > 35)) {
                return;
            }
            if (!nodeInfo.getIsSelect()) {
                if (nodeInfo.getNodeType() == 2) {
                    this.addNodeToTable(nodeInfo);
                    nodeInfo.setIsSelect(true);
                    this.checkSelectNodeByDevices();
                } else {
                    this.addAllNodeToTable(oNode);
                    nodeInfo.setIsSelect(true);
                }
            } else if (nodeInfo.getNodeType() == 2) {
                this.removeNodeByTable(nodeInfo);
                nodeInfo.setIsSelect(false);
                this.checkSelectNodeByDevices();
            } else {
                this.removeAllNodeByTable(oNode);
                nodeInfo.setIsSelect(false);
            }
            super.getTreeTable().updateUI();
        }
    }

    private void checkSelectNodeByDevices() {
        boolean isSelectAllNode = true;
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode devicesNode = (TreeTableNode)rootNode.getChildAt(0);
        RowData devicesNodeInfo = (RowData)devicesNode.getUserObject();
        int count = devicesNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)devicesNode.getChildAt(i);
            RowData nodeInfo = (RowData)node.getUserObject();
            if (nodeInfo.getIsSelect()) continue;
            isSelectAllNode = false;
            break;
        }
        if (isSelectAllNode) {
            devicesNodeInfo.setIsSelect(true);
        } else {
            devicesNodeInfo.setIsSelect(false);
        }
    }

    private void addAllNodeToTable(TreeTableNode oNode) {
        int count = oNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)oNode.getChildAt(i);
            RowData nodeInfo = (RowData)node.getUserObject();
            if (nodeInfo.getIsSelect()) continue;
            nodeInfo.setIsSelect(true);
            this.addNodeToTable(nodeInfo);
        }
    }

    private void removeAllNodeByTable(TreeTableNode oNode) {
        int count = oNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)oNode.getChildAt(i);
            RowData nodeInfo = (RowData)node.getUserObject();
            if (!nodeInfo.getIsSelect()) continue;
            nodeInfo.setIsSelect(false);
            this.removeNodeByTable(nodeInfo);
        }
    }

    private void addNodeToTable(RowData nodeInfo) {
        Vector<String> data = new Vector<String>();
        String resourceName = nodeInfo.getResourceName();
        String devIp = nodeInfo.getDevIp();
        data.add(resourceName);
        data.add(devIp);
        super.getSelectTableModel().addRow(data);
    }

    private void removeNodeByTable(RowData nodeInfo) {
        int count = super.getSelectTableModel().getRowCount();
        for (int i = 0; i < count; ++i) {
            String devIp = (String)super.getSelectTableModel().getValueAt(i, 1);
            String devName = (String)super.getSelectTableModel().getValueAt(i, 0);
            if (!devIp.equals(nodeInfo.getDevIp()) || !devName.equals(nodeInfo.getResourceName())) continue;
            super.getSelectTableModel().removeRow(i);
            break;
        }
    }

    @Override
    public void okButtonActionPerfromed() {
        int rowCount = super.getSelectTableModel().getRowCount();
        if (rowCount < 1) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NEW_GROUP_DOESNOT_DATA"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        Vector groupList = (Vector)this.dataList.get(0);
        RowData newGroupNodeInfo = new RowData(groupList.size() + 1, null, 1, null);
        TreeTableNode newGroupNode = new TreeTableNode(newGroupNodeInfo);
        groupList.add(newGroupNode);
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode devicesNode = (TreeTableNode)rootNode.getChildAt(0);
        int count = devicesNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode devNode = (TreeTableNode)devicesNode.getChildAt(i);
            RowData devNodeInfo = (RowData)devNode.getUserObject();
            if (!devNodeInfo.getIsSelect()) continue;
            devNodeInfo.setGroupId(newGroupNodeInfo.getGroupId());
            devNodeInfo.setIsSelect(false);
        }
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupDlg.this.cancelButtonActionPerfromed();
            }
        };
        return oEscKeyHandler;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    @Override
    protected void closeDialog() {
        this.cancelButtonActionPerfromed();
    }

    @Override
    public void cancelButtonActionPerfromed() {
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode devicesNode = (TreeTableNode)rootNode.getChildAt(0);
        int count = devicesNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode devNode = (TreeTableNode)devicesNode.getChildAt(i);
            RowData devNodeInfo = (RowData)devNode.getUserObject();
            if (!devNodeInfo.getIsSelect()) continue;
            devNodeInfo.setIsSelect(false);
        }
        super.cancelButtonActionPerfromed();
    }

    @Override
    public void setTreeNodeVisibleBySearchContent(String strKeyWord) {
    }
}

