/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view;

import com.huawei.dc.common.asndatacenter.AsnDCActivationGroup;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupSeqOf;
import com.huawei.dc.common.asndatacenter.AsnDCActivationInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.NewGroupDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.RowData;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.GroupTablePanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;

public class GroupingTablePanel
extends GroupTablePanel {
    private THashSet<Resource> resources = null;
    private Vector dataList = new Vector();
    private boolean m_bUpButtonPressed = false;
    private boolean m_bDownButtonPressed = false;
    private boolean m_bRemoveGroupNodeToUpNode = false;

    public GroupingTablePanel(ActivationConfigPara m_oActivateConfigPara, DeviceType oSelectedDeviceType) {
        this.resources = oSelectedDeviceType.getResources();
        List elementInfoList = m_oActivateConfigPara.getElementInfoLst();
        List<ActivationGroupInfo> groupInfoList = m_oActivateConfigPara.getActivateGroupInfoLst();
        if (elementInfoList != null && groupInfoList != null && groupInfoList.size() > 0 && elementInfoList.size() > 0) {
            this.populateDeviceInTable(elementInfoList, groupInfoList);
        }
    }

    private void populateDeviceInTable(List elementInfoList, List groupInfoList) {
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = groupInfoList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = (ActivationGroupInfo)groupInfoList.get(i);
            RowData groupNodeInfo = new RowData(oActivateGroupInfo.getGroupId(), null, 1, null);
            TreeTableNode groupNode = new TreeTableNode(groupNodeInfo);
            rootNode.add(groupNode);
            int devCount = elementInfoList.size();
            for (int j = 0; j < devCount; ++j) {
                ActivationElementInfo oElementInfo = (ActivationElementInfo)elementInfoList.get(j);
                if (oActivateGroupInfo.getGroupId() != oElementInfo.getGroupId()) continue;
                Resource oResource = oElementInfo.getResource();
                RowData devNodeInfo = new RowData(oElementInfo.getGroupId(), oResource, 2, oResource.getDeviceType());
                TreeTableNode devNode = new TreeTableNode(devNodeInfo);
                groupNode.add(devNode);
            }
        }
        if (this.getRootNode().getChildCount() == 1 && this.getRootNode().getChildAt(0).getChildCount() == 1) {
            this.setNewButtonEnable(false);
        } else {
            this.setNewButtonEnable(true);
        }
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    @Override
    public void populateDeviceInTable(AsnDCDefaultActiveGroupRsp oDefaultActivateGroupRsp, THashSet<Resource> resourceList) {
        TreeTableNode rootNode = super.getRootNode();
        rootNode.removeAllChildren();
        AsnDCActivationGroupLst asnActivateGroupLst = oDefaultActivateGroupRsp.oActiveGroupLst;
        int iGroupCount = asnActivateGroupLst.size();
        for (int i = 0; i < iGroupCount; ++i) {
            AsnDCActivationGroup asnActivateGroupInfo = (AsnDCActivationGroup)asnActivateGroupLst.get(i);
            int iGroupId = asnActivateGroupInfo.iGroupId.intValue();
            RowData groupNodeInfo = new RowData(iGroupId, null, 1, null);
            TreeTableNode groupNode = new TreeTableNode(groupNodeInfo);
            rootNode.add(groupNode);
            AsnDCActivationGroupSeqOf asnDevInfoLst = asnActivateGroupInfo.oActivationInfoLst;
            int iDevCount = asnDevInfoLst.size();
            for (int j = 0; j < iDevCount; ++j) {
                AsnDCActivationInfo asnActivateDevInfo = (AsnDCActivationInfo)asnDevInfoLst.get(j);
                int iDevId = asnActivateDevInfo.iDeviceId.intValue();
                Iterator oResIterator = resourceList.iterator();
                Resource oResource = null;
                while (oResIterator.hasNext() && iDevId != (oResource = (Resource)oResIterator.next()).getDeviceID()) {
                    oResource = null;
                }
                if (null == oResource) continue;
                RowData devNodeInfo = new RowData(iGroupId, oResource, 2, oResource.getDeviceType());
                TreeTableNode devNode = new TreeTableNode(devNodeInfo);
                groupNode.add(devNode);
            }
        }
        if (this.getRootNode().getChildCount() == 1 && this.getRootNode().getChildAt(0).getChildCount() == 1) {
            this.setNewButtonEnable(false);
        } else {
            this.setNewButtonEnable(true);
        }
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    @Override
    public void populateDeviceInTable(THashSet<Resource> resourceList) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Resource p1 = (Resource)o1;
                Resource p2 = (Resource)o2;
                String p1Str = p1.getDeviceName();
                String p2Str = p2.getDeviceName();
                int iReturnValue = Collator.getInstance().compare(p1Str, p2Str);
                return iReturnValue;
            }
        };
        Object[] oRes = resourceList.toArray();
        Arrays.sort(oRes, comp);
        TreeTableNode rootNode = super.getRootNode();
        rootNode.removeAllChildren();
        int count = oRes.length;
        for (int i = 0; i < count; ++i) {
            Resource resource = (Resource)oRes[i];
            RowData groupNodeInfo = new RowData(i + 1, null, 1, null);
            TreeTableNode groupNode = new TreeTableNode(groupNodeInfo);
            rootNode.add(groupNode);
            RowData devNodeInfo = new RowData(i + 1, resource, 2, resource.getDeviceType());
            TreeTableNode devNode = new TreeTableNode(devNodeInfo);
            groupNode.add(devNode);
        }
        if (this.getRootNode().getChildCount() == 1 && this.getRootNode().getChildAt(0).getChildCount() == 1) {
            this.setNewButtonEnable(false);
        } else {
            this.setNewButtonEnable(true);
        }
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    public List getactivateElementInfoLst() {
        ArrayList<ActivationElementInfo> activateElememtInfoList = new ArrayList<ActivationElementInfo>(0);
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        for (int i = 0; i < groupCount; ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            int devCount = groupNode.getChildCount();
            for (int j = 0; j < devCount; ++j) {
                ActivationElementInfo oElementInfo = new ActivationElementInfo();
                TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                oElementInfo.setGroupId(devNodeInfo.getGroupId());
                oElementInfo.setResource((Resource)devNodeInfo.getObject());
                oElementInfo.setSelected(true);
                oElementInfo.setSequenceId(j + 1);
                activateElememtInfoList.add(oElementInfo);
            }
        }
        return activateElememtInfoList;
    }

    public List getActivateGroupInfoLst() {
        ArrayList<ActivationGroupInfo> activateGroupInfoList = new ArrayList<ActivationGroupInfo>(0);
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        for (int i = 0; i < groupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = new ActivationGroupInfo();
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            RowData groupNodeInfo = (RowData)groupNode.getUserObject();
            oActivateGroupInfo.setGroupId(groupNodeInfo.getGroupId());
            oActivateGroupInfo.setGroupName(groupNodeInfo.getResourceName());
            if (activateGroupInfoList.contains(oActivateGroupInfo)) continue;
            activateGroupInfoList.add(oActivateGroupInfo);
        }
        return activateGroupInfoList;
    }

    @Override
    public String[] getMethodNames() {
        return RowData.getMethodName();
    }

    @Override
    public String[] getColumnNames() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("RESOURCE_TYPE"), ResourceManager.getInstance().getResString("DEVICE_IP_FOR_PACKAGE_TASK"), ResourceManager.getInstance().getResString("DEVICE_VERSION_FOR_PACKAGE_TASK")};
        return strColumnNames;
    }

    @Override
    public Class[] getColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class};
        return arrColumnTypes;
    }

    @Override
    public boolean[] getSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false, false, false};
        return arrSortableColumns;
    }

    @Override
    public boolean[] getEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false};
        return arrEditableColumns;
    }

    @Override
    public void upLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
        this.m_bUpButtonPressed = true;
        this.m_bDownButtonPressed = false;
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2) {
            this.upLeafNodeToNextNode(oNode, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_BOARD_ACCESS_UP"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void upLeafNodeToNextNode(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = this.locationByRoot(parentNode, super.getRootNode());
        TreeTableNode fatherLastNode = (TreeTableNode)super.getRootNode().getChildAt(location - 1);
        oNode.removeFromParent();
        fatherLastNode.add(oNode);
        RowData fatherLastNodeInfo = (RowData)fatherLastNode.getUserObject();
        RowData oNodeInfo = (RowData)oNode.getUserObject();
        oNodeInfo.setGroupId(fatherLastNodeInfo.getGroupId());
        if (parentNode.isLeaf()) {
            parentNode.removeFromParent();
            this.changesGroupName(location, super.getRootNode());
        }
    }

    @Override
    public void downLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = true;
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2) {
            this.downLeafNodeToNextNode(oNode, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_BOARD_ACCESS_UP"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void downLeafNodeToNextNode(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = this.locationByRoot(parentNode, super.getRootNode());
        TreeTableNode fatherLastNode = (TreeTableNode)super.getRootNode().getChildAt(location + 1);
        oNode.removeFromParent();
        fatherLastNode.add(oNode);
        RowData fatherLastNodeInfo = (RowData)fatherLastNode.getUserObject();
        RowData oNodeInfo = (RowData)oNode.getUserObject();
        oNodeInfo.setGroupId(fatherLastNodeInfo.getGroupId());
        if (parentNode.isLeaf()) {
            parentNode.removeFromParent();
            this.changesGroupName(location, super.getRootNode());
        }
    }

    @Override
    public void newButtonAction() {
        this.getDataInfoByNewGroup();
        new NewGroupDlg(this.dataList);
        this.populateNewGroupInTable();
        super.expandAll(super.getTaskTree(), new TreePath(super.getRootNode()), true);
        super.updateTableView();
    }

    private void populateNewGroupInTable() {
        TreeTableNode rootNode = super.getRootNode();
        rootNode.removeAllChildren();
        Vector groupList = (Vector)this.dataList.get(0);
        Vector devList = (Vector)this.dataList.get(1);
        for (int i = 0; i < groupList.size(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)groupList.get(i);
            RowData groupNodeInfo = (RowData)groupNode.getUserObject();
            rootNode.add(groupNode);
            for (int j = 0; j < devList.size(); ++j) {
                TreeTableNode devNode = (TreeTableNode)devList.get(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                if (devNodeInfo.getGroupId() != groupNodeInfo.getGroupId()) continue;
                groupNode.add(devNode);
            }
        }
        this.removeLeafNode();
    }

    private void removeLeafNode() {
        TreeTableNode rootNode = super.getRootNode();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            if (!groupNode.isLeaf()) continue;
            groupNode.removeFromParent();
            this.changesGroupName(i, rootNode);
            --i;
        }
    }

    private void getDataInfoByNewGroup() {
        this.dataList.removeAllElements();
        TreeTableNode rootNode = super.getRootNode();
        Vector<TreeTableNode> groupList = new Vector<TreeTableNode>();
        Vector<TreeTableNode> devList = new Vector<TreeTableNode>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            RowData groupNodeInfo = (RowData)groupNode.getUserObject();
            RowData groupNodeInfoCopy = (RowData)CloneUtil.getClone(groupNodeInfo);
            TreeTableNode groupNodeCopy = new TreeTableNode(groupNodeInfoCopy);
            groupList.add(groupNodeCopy);
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                RowData devpNodeInfo = (RowData)devNode.getUserObject();
                RowData devNodeInfoCopy = (RowData)CloneUtil.getClone(devpNodeInfo);
                TreeTableNode devNodeCopy = new TreeTableNode(devNodeInfoCopy);
                devList.add(devNodeCopy);
            }
        }
        this.dataList.add(groupList);
        this.dataList.add(devList);
    }

    @Override
    public void removeGroupNode(TreeTableNode oNode, TreeTableNode parentNode) {
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 1) {
            int location = this.locationByRoot(oNode, parentNode);
            this.moveGroupNode(location, parentNode, oNode, this.m_bRemoveGroupNodeToUpNode);
            this.changesGroupName(location, parentNode);
        } else {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("ONLY_GROUP_ACCESS_DELETE"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private int locationByRoot(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = 0;
        int childCount = 0;
        RowData nodeInfo = (RowData)oNode.getUserObject();
        childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeTableNode brotherNode = (TreeTableNode)parentNode.getChildAt(i);
            RowData brotherNodeInfo = (RowData)brotherNode.getUserObject();
            if (brotherNodeInfo.getGroupId() != nodeInfo.getGroupId()) continue;
            location = i;
            break;
        }
        return location;
    }

    private void moveGroupNode(int location, TreeTableNode parentNode, TreeTableNode oNode, boolean isToUp) {
        int i;
        Vector<TreeTableNode> nodeList = new Vector<TreeTableNode>();
        int nowLocation = isToUp ? location - 1 : location + 1;
        TreeTableNode lastNode = (TreeTableNode)parentNode.getChildAt(nowLocation);
        for (i = 0; i < oNode.getChildCount(); ++i) {
            TreeTableNode childNode = (TreeTableNode)oNode.getChildAt(i);
            RowData childNodeInfo = (RowData)childNode.getUserObject();
            childNodeInfo.setGroupId(location);
            nodeList.add(childNode);
        }
        for (i = 0; i < nodeList.size(); ++i) {
            lastNode.add((TreeTableNode)nodeList.get(i));
        }
        oNode.removeFromParent();
    }

    private void changesGroupName(int location, TreeTableNode parentNode) {
        int count = parentNode.getChildCount();
        for (int i = location; i < count && i >= 0; ++i) {
            TreeTableNode childNode = (TreeTableNode)parentNode.getChildAt(i);
            RowData childNodeInfo = (RowData)childNode.getUserObject();
            childNodeInfo.setGroupId(i + 1);
            int devCount = childNode.getChildCount();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)childNode.getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                devNodeInfo.setGroupId(i + 1);
            }
            childNodeInfo.setResourceName(ResourceManager.getInstance().getResString("GROUP") + (i + 1));
        }
    }

    @Override
    public void rowToRowTow(int row, int mousePressedRow) {
        TreePath oTreeReleasedPath;
        TreeTableNode oNodeReleased;
        RowData nodeReleasedInfo;
        int groupIdReleased;
        if (row == mousePressedRow || mousePressedRow == -1) {
            return;
        }
        TreePath oTreePressedPath = this.getTaskTreeTable().getTree().getPathForRow(mousePressedRow);
        TreeTableNode oNodePress = (TreeTableNode)oTreePressedPath.getLastPathComponent();
        RowData nodePressedInfo = (RowData)oNodePress.getUserObject();
        int groupIdPressed = nodePressedInfo.getGroupId();
        if (groupIdPressed == (groupIdReleased = (nodeReleasedInfo = (RowData)(oNodeReleased = (TreeTableNode)(oTreeReleasedPath = this.getTaskTreeTable().getTree().getPathForRow(row)).getLastPathComponent()).getUserObject()).getGroupId())) {
            return;
        }
        TreeTableNode rootNode = super.getRootNode();
        TreeTableNode groupNodeReleased = (TreeTableNode)rootNode.getChildAt(groupIdReleased - 1);
        oNodePress.removeFromParent();
        groupNodeReleased.add(oNodePress);
        nodePressedInfo.setGroupId(groupIdReleased);
        TreeTableNode groupNodePressed = (TreeTableNode)rootNode.getChildAt(groupIdPressed - 1);
        if (groupNodePressed.isLeaf()) {
            groupNodePressed.removeFromParent();
            this.changesGroupName(groupIdPressed - 1, rootNode);
        }
        super.updateTableView();
    }

    @Override
    public void exchangeGroups(int iRow, int iMousePressedRow) {
        String strSrcGrpName = "";
        TreePath oTreePressedPath = this.getTaskTreeTable().getTree().getPathForRow(iMousePressedRow);
        TreeTableNode oNodePress = (TreeTableNode)oTreePressedPath.getLastPathComponent();
        RowData nodePressedInfo = (RowData)oNodePress.getUserObject();
        strSrcGrpName = nodePressedInfo.getGroupName();
        int groupIdPressed = nodePressedInfo.getGroupId();
        TreePath oTreeReleasedPath = this.getTaskTreeTable().getTree().getPathForRow(iRow);
        TreeTableNode oNodeReleased = (TreeTableNode)oTreeReleasedPath.getLastPathComponent();
        RowData nodeReleasedInfo = (RowData)oNodeReleased.getUserObject();
        int groupIdReleased = nodeReleasedInfo.getGroupId();
        if (nodePressedInfo.getNodeType() != nodeReleasedInfo.getNodeType()) {
            return;
        }
        if (1 != nodeReleasedInfo.getNodeType()) {
            return;
        }
        if (groupIdPressed == groupIdReleased) {
            return;
        }
        nodePressedInfo.setResourceName(nodeReleasedInfo.getGroupName());
        nodePressedInfo.setGroupId(groupIdReleased);
        int iSrcGrpChildCnt = oNodePress.getChildCount();
        TreeTableNode oSrcChildNode = null;
        RowData oSrcChildData = null;
        for (int i = 0; i < iSrcGrpChildCnt; ++i) {
            oSrcChildNode = (TreeTableNode)oNodePress.getChildAt(i);
            oSrcChildData = (RowData)oSrcChildNode.getUserObject();
            oSrcChildData.setGroupId(groupIdReleased);
        }
        nodeReleasedInfo.setResourceName(strSrcGrpName);
        nodeReleasedInfo.setGroupId(groupIdPressed);
        int iDstGrpChildCnt = oNodeReleased.getChildCount();
        TreeTableNode oDstChildNode = null;
        RowData oDstChildData = null;
        for (int i = 0; i < iDstGrpChildCnt; ++i) {
            oDstChildNode = (TreeTableNode)oNodeReleased.getChildAt(i);
            oDstChildData = (RowData)oDstChildNode.getUserObject();
            oDstChildData.setGroupId(groupIdPressed);
        }
        super.updateTableView();
    }

    @Override
    public void setButtonStatus() {
        try {
            TreePath oTreePath;
            TreeTableNode oNode;
            RowData nodeInfo;
            if (super.getRootNode().getChildCount() == 1 && super.getRootNode().getChildAt(0).getChildCount() == 1) {
                return;
            }
            if (super.getRootNode().getChildCount() == 1) {
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setDeleteButtonEnable(false);
                this.setNewButtonEnable(true);
                return;
            }
            int[] arrSelectedRows = super.getTaskTreeTable().getSelectedRows();
            int selectCount = arrSelectedRows.length;
            if (selectCount < 1) {
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setNewButtonEnable(true);
                this.setDeleteButtonEnable(false);
                return;
            }
            int arrSelectedRow = super.getTaskTreeTable().getSelectedRow();
            int groupCount = super.getRootNode().getChildCount();
            if (this.m_bDownButtonPressed) {
                ++arrSelectedRow;
            }
            if (this.m_bUpButtonPressed) {
                --arrSelectedRow;
            }
            if ((nodeInfo = (RowData)(oNode = (TreeTableNode)(oTreePath = super.getTaskTreeTable().getTree().getPathForRow(arrSelectedRow)).getLastPathComponent()).getUserObject()).getNodeType() == 1) {
                if (nodeInfo.getGroupId() >= groupCount) {
                    this.isRemoveGroupNodeToUpNode(true);
                    this.setDeleteButtonEnable(true);
                } else {
                    this.isRemoveGroupNodeToUpNode(false);
                    this.setDeleteButtonEnable(true);
                }
                this.setUpButtonEnable(false);
                this.setDownButtonEnable(false);
                this.setNewButtonEnable(true);
            } else {
                if (nodeInfo.getGroupId() == 1 || selectCount != 1) {
                    this.setUpButtonEnable(false);
                } else {
                    this.setUpButtonEnable(true);
                }
                if (nodeInfo.getGroupId() == groupCount || selectCount != 1) {
                    this.setDownButtonEnable(false);
                } else {
                    this.setDownButtonEnable(true);
                }
                this.setDeleteButtonEnable(false);
                this.setNewButtonEnable(true);
            }
        }
        catch (Exception e) {
            this.setUpButtonEnable(false);
            this.setDownButtonEnable(false);
            this.setDeleteButtonEnable(false);
            this.setNewButtonEnable(true);
        }
    }

    @Override
    public void deleteButtonAction() {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        super.deleteButtonAction();
    }

    @Override
    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RowData nodeInfo = (RowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon;
            if (nodeInfo.getNodeType() == 1) {
                m_oSelectIcon = ResourceManager.getInstance().getImage("folderopen.gif");
            } else {
                int iDevID = nodeInfo.getDevId();
                m_oSelectIcon = ResourceManager.getInstance().getNeTypeImage(iDevID);
            }
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    public void deleteDevByTable(Vector deleteDevList) {
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        int count = deleteDevList.size();
        for (int l = 0; l < count; ++l) {
            int devId = deleteDevList.get(l).hashCode();
            for (int i = 0; i < groupCount; ++i) {
                TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
                int devCount = groupNode.getChildCount();
                for (int j = 0; j < devCount; ++j) {
                    TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                    RowData devNodeInfo = (RowData)devNode.getUserObject();
                    if (devId != devNodeInfo.getDevId()) continue;
                    devNode.removeFromParent();
                    j = devCount;
                    i = groupCount;
                }
            }
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            if (!groupNode.isLeaf()) continue;
            groupNode.removeFromParent();
            this.changesGroupName(i, rootNode);
            --i;
        }
        super.updateTableView();
    }

    public void addDevToTable(List oResourcesLst, Vector addDevList) {
        TreeTableNode rootNode = super.getRootNode();
        int groupCount = rootNode.getChildCount();
        int count = addDevList.size();
        for (int l = 0; l < count; ++l) {
            int devId = addDevList.get(l).hashCode();
            RowData newGroupNodeInfo = new RowData(groupCount + l + 1, null, 1, null);
            TreeTableNode newGroupNode = new TreeTableNode(newGroupNodeInfo);
            rootNode.add(newGroupNode);
            TreeTableNode newDevNode = this.createDevNode(devId, oResourcesLst, groupCount + 1 + l);
            newGroupNode.add(newDevNode);
        }
        super.updateTableView();
    }

    public TreeTableNode createDevNode(int devId, List oResources, int groupId) {
        TreeTableNode devNode = null;
        int count = oResources.size();
        for (int i = 0; i < count; ++i) {
            Resource resource = (Resource)oResources.get(i);
            if (resource.getDeviceID() != devId) continue;
            RowData devNodeInfo = new RowData(groupId, resource, 2, resource.getDeviceType());
            devNode = new TreeTableNode(devNodeInfo);
        }
        return devNode;
    }

    @Override
    public void taskTable_KeyPressed(KeyEvent e) {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        super.taskTable_KeyPressed(e);
    }

    @Override
    public void taskTable_MouseReleased(MouseEvent oMouseEvent) {
        this.m_bUpButtonPressed = false;
        this.m_bDownButtonPressed = false;
        super.taskTable_MouseReleased(oMouseEvent);
    }

    private void isRemoveGroupNodeToUpNode(boolean bValue) {
        this.m_bRemoveGroupNodeToUpNode = bValue;
    }
}

