/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view;

import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupForDevLevelReq;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskTypeEnum;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.AutoProgressDlgForOptix;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.GroupingTablePanel;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.ProgressBar;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.GroupingAtivePanel;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;

public class GroupingActiveForDevPan
extends GroupingAtivePanel {
    private static final long serialVersionUID = 8108774078139440039L;
    private DeviceType oSelectedDeviceType;
    private ActivationConfigPara m_oActivateConfigPara;
    private Vector addDevList;
    private Vector devListForAdd;
    private Vector deleteDevList;
    private Vector devListForDel;
    private Vector devIdList = new Vector();

    public GroupingActiveForDevPan(ActivationConfigPara m_oActivateConfigPara, ITask task, int taskType) {
        super(task, m_oActivateConfigPara, taskType);
        this.m_oActivateConfigPara = m_oActivateConfigPara;
        if (m_oActivateConfigPara.isTimeSelected()) {
            TimeDateFormatUtil.switchLocalCalendar((Calendar)m_oActivateConfigPara.getActivationUTCTime());
            this.setStartTime(m_oActivateConfigPara.getActivationUTCTime());
        }
        this.updateSelectedDeviceType(task);
        THashSet<Resource> oResources = this.oSelectedDeviceType.getResources();
        Iterator oResItor = oResources.iterator();
        Resource resource = null;
        while (oResItor.hasNext()) {
            resource = (Resource)oResItor.next();
            this.devIdList.add(resource.getDeviceID());
        }
        this.createGroupTablePan();
    }

    @Override
    public void createGroupTablePan() {
        this.groupTablePan = new GroupingTablePanel(this.m_oActivateConfigPara, this.oSelectedDeviceType);
        this.groupTablePan.setName("DeviceOperation_GroupingActiveForDevPan_groupTablePan");
        this.setOrderJLabelPlaceForDevLevel();
        super.setTablePanForDevLevel();
    }

    public void updateActivationConfigSelec() {
        this.m_oActivateConfigPara.setElementInfoLst(((GroupingTablePanel)this.groupTablePan).getactivateElementInfoLst());
        this.m_oActivateConfigPara.setActivateGroupInfoLst(((GroupingTablePanel)this.groupTablePan).getActivateGroupInfoLst());
        this.m_oActivateConfigPara.setActivationTypeRequired(this.isSelForceParallelActive());
        ParaValue paraValue = new ParaValue();
        paraValue.setId("GroupActivation");
        paraValue.setDisplayName(ResourceManager.getInstance().getResString("ACTIVATION_MODE_GROUP"));
        this.m_oActivateConfigPara.setSelectedActivationMode(paraValue);
        if (this.getActivateTime() == null) {
            this.m_oActivateConfigPara.setIsTimeSelected(false);
        } else {
            this.m_oActivateConfigPara.setIsTimeSelected(true);
            this.m_oActivateConfigPara.setActivationUTCTime(this.getActivateTime());
        }
        if (this.isSelForceParallelActive()) {
            ActivationType activationType = new ActivationType();
            ParaValue oParaValue = new ParaValue();
            oParaValue.setId("OSSU");
            oParaValue.setValue(1);
            activationType.setParaValue(oParaValue);
            this.m_oActivateConfigPara.setSelectedActivateType(activationType);
        } else {
            this.m_oActivateConfigPara.setSelectedActivateType(null);
        }
    }

    @Override
    public void activeGroupButtonAction() {
        this.getGroupInfoForDevLevelTaskRsp(this.oSelectedDeviceType.getResources());
    }

    public void updateGroupingConfiguration(THashSet<Resource> oResources) {
        boolean isUpdataForDel = this.isDeleteDevice(oResources);
        boolean isUpdataForAdd = this.isAddDevice(oResources);
        if (isUpdataForDel) {
            this.deleteDevByTable();
        }
        if (isUpdataForAdd) {
            this.addDevToTable();
            this.getGroupInfoForDevLevelTaskRsp(oResources);
        }
    }

    private void deleteDevByTable() {
        this.devIdList = this.devListForDel;
        if (this.deleteDevList.size() > 0) {
            ((GroupingTablePanel)this.groupTablePan).deleteDevByTable(this.deleteDevList);
        }
    }

    private void addDevToTable() {
        this.devIdList = this.devListForAdd;
    }

    private boolean isDeleteDevice(THashSet<Resource> oResourcesLst) {
        boolean isUpdate = false;
        this.deleteDevList = new Vector();
        this.devListForDel = new Vector();
        int devCount = this.devIdList.size();
        for (int i = 0; i < devCount; ++i) {
            boolean isExistDev = false;
            int devId = this.devIdList.get(i).hashCode();
            for (Resource devInfo : oResourcesLst) {
                if (devId != devInfo.getDeviceID()) continue;
                isExistDev = true;
                break;
            }
            if (!isExistDev) {
                this.deleteDevList.add(devId);
                isUpdate = true;
                continue;
            }
            this.devListForDel.add(devId);
        }
        return isUpdate;
    }

    private boolean isAddDevice(THashSet<Resource> oResourcesLst) {
        boolean isUpdate = false;
        this.addDevList = new Vector();
        this.devListForAdd = new Vector();
        Iterator oResItor = oResourcesLst.iterator();
        Resource newDevInfo = null;
        while (oResItor.hasNext()) {
            boolean isExistDev = false;
            newDevInfo = (Resource)oResItor.next();
            int newDevId = newDevInfo.getDeviceID();
            this.devListForAdd.add(newDevId);
            int devCount = this.devIdList.size();
            for (int j = 0; j < devCount; ++j) {
                int devId = this.devIdList.get(j).hashCode();
                if (newDevId != devId) continue;
                isExistDev = true;
            }
            if (isExistDev) continue;
            this.addDevList.add(newDevId);
            isUpdate = true;
        }
        return isUpdate;
    }

    private void startProcessBar() {
        this.m_oprogressDlg = new AutoProgressDlgForOptix(this, ResourceManager.getInstance().getResString("GET_DEFAULT_ACTIVATION_GROUP_PROGRESS_DLG_TITLE"));
        this.m_oprogressDlg.setCanCencleEnable(!this.isHasWarn());
        int devCount = this.devIdList.size();
        this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg, devCount);
        this.m_oProgressbar.setThreadStop(false);
        this.m_oProgressbar.setName("DeviceOperation_ActivationPackagePanel_m_oProgressbar");
        this.m_oProgressbar.start();
    }

    public AsnDCDefaultActiveGroupRsp getGroupInfoForDevLevelTaskRsp(THashSet<Resource> resourceList) {
        this.activeGroupRspTemp = new AsnDCDefaultActiveGroupRsp();
        if (1 < resourceList.size()) {
            if (this.m_oTask.getIsOffLineTask()) {
                this.groupTablePan.populateDeviceInTable(resourceList);
            } else {
                AsnDCDefaultActiveGroupForDevLevelReq req = new AsnDCDefaultActiveGroupForDevLevelReq();
                Iterator oResItor = resourceList.iterator();
                Resource devInfo = null;
                while (oResItor.hasNext()) {
                    devInfo = (Resource)oResItor.next();
                    BigInteger devId = BigInteger.valueOf(devInfo.getDeviceID());
                    req.arrDeviceIds.add((Object)devId);
                }
                req.enTaskType = new AsnTaskTypeEnum(this.m_oTask.getTaskTypeId());
                req.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
                this.startProcessBar();
                TaskAsynCommController.getInstance().getGroupInfoForDevLevelTaskRsp(req, this);
                this.groupTablePan.populateDeviceInTable(this.activeGroupRspTemp, resourceList);
            }
        } else {
            this.groupTablePan.populateDeviceInTable(resourceList);
        }
        return this.activeGroupRspTemp;
    }

    public void updateSelectedDeviceType(ITask oTask) {
        this.oSelectedDeviceType = oTask.getSelectedDeviceType();
    }

    public void updateConfSendtoBoardChk(ITask oTask) {
        JCheckBox oCheckBox = this.getConfSendtoBoardChk();
        if (null != oCheckBox && null != oTask) {
            oCheckBox.setEnabled(true);
            oCheckBox.setSelected(this.m_oActivateConfigPara.isConfSendToBoard());
            this.updateConfSendtoBoardChkByTask(oTask);
        }
    }
}

