/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.huawei.dc.taskmgmt.view.common.NewGroupPanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class NewGroupDlg
extends NewGroupPanel {
    private Vector dataList;
    private int groupCount;
    private Vector newGroupList = new Vector();
    private Vector groupList;
    private Vector devList;
    private Vector boardList;
    private boolean m_bIsCancelPressed = false;
    private boolean isSimTask;
    private static final int RESOURCE_NAME_COLUMN = 0;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private int m_iSelectionType = 2;
    private int m_iNoOfFilesSelected = 0;
    private JSortTreeTable m_oSortTreeTable = this.getTreeTable();
    protected CheckBoxHeader m_oCheckBoxHeader = null;

    public NewGroupDlg(Vector dataList, int groupCount, boolean isHaveManualGroup) {
        this.addKeyWordFilter();
        this.dataList = dataList;
        this.isSimTask = isHaveManualGroup;
        this.groupCount = isHaveManualGroup ? groupCount : groupCount + 1;
        JTextField text = super.getGroupNameText();
        text.setName("ActivationPackage_NewGroupDlg_text");
        text.setText(ResourceManager.getInstance().getResString("GROUP") + this.groupCount);
        this.initializeKeyStrokeActions();
        this.addCheckBoxHeader();
        this.populateDataInTable(null);
    }

    private void addCheckBoxHeader() {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oResName = this.m_oSortTreeTable.getColumnModel().getColumn(0);
        this.m_oSortTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oSortTreeTable.getSize().width, 28));
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oSortTreeTable.getTableHeader().getBackground(), 0);
        oResName.setHeaderRenderer(this.m_oCheckBoxHeader);
    }

    @Override
    public void okButtonActionPerfromed() {
        if (this.newGroupList.size() < 1) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("Error_Code_909"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            return;
        }
        RowData newGroupInfo = new RowData(this.groupCount, -1, "", null, 1);
        TreeTableNode newGroupNode = new TreeTableNode(newGroupInfo);
        if (this.isSimTask) {
            this.groupList.add(this.groupCount - 1, newGroupNode);
        } else {
            this.groupList.add(newGroupNode);
        }
        for (int i = 0; i < this.devList.size(); ++i) {
            TreeTableNode devNode = (TreeTableNode)this.devList.get(i);
            RowData devNodeInfo = (RowData)devNode.getUserObject();
            if (!devNodeInfo.getIsSelect()) continue;
            devNodeInfo.setIsSelect(false);
        }
        int boardCount = this.boardList.size();
        for (int i = 0; i < boardCount; ++i) {
            TreeTableNode boardNode = (TreeTableNode)this.boardList.get(i);
            RowData boardNodeInfo = (RowData)boardNode.getUserObject();
            if (!boardNodeInfo.getIsSelect()) continue;
            boardNodeInfo.setGroupId(this.groupCount);
            boardNodeInfo.setIsSelect(false);
        }
        this.dataList.removeAllElements();
        this.dataList.add(this.groupList);
        this.dataList.add(this.devList);
        this.dataList.add(this.boardList);
        this.dispose();
    }

    private void initializeKeyStrokeActions() {
        ActionListener m_oEscKeyHandler = this.createActionListenerForEscape();
        KeyStroke m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(m_oEscKeyStroke, m_oEscKeyHandler);
    }

    @Override
    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupDlg.this.cancelButtonActionPerfromed();
            }
        };
        return oEscKeyHandler;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    @Override
    public void cancelButtonActionPerfromed() {
        this.setCancelPressed(true);
        super.cancelButtonActionPerfromed();
    }

    @Override
    public String[] getStrColumnNamesByTree() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("CURRENT_GROUP")};
        return strColumnNames;
    }

    @Override
    public String[] getStrColumnNamesByTable() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("BOARD_NALE"), ResourceManager.getInstance().getResString("BOARD_TYPE_T2000")};
        return strColumnNames;
    }

    @Override
    public Class[] getArrColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        return arrColumnTypes;
    }

    @Override
    public String[] getMethodBoardTreeNames() {
        String[] methodNames = RowData.getMethodBoardTreeNames();
        return methodNames;
    }

    @Override
    public boolean[] getArrEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false};
        return arrEditableColumns;
    }

    @Override
    public boolean[] getArrSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false};
        return arrSortableColumns;
    }

    @Override
    public String getRightTitle() {
        return ResourceManager.getInstance().getResString("BORAD_TREE");
    }

    @Override
    public String getLeftTitle() {
        return ResourceManager.getInstance().getResString("SELECTED_BOARDS");
    }

    private void populateDataInTable(String strKeyWord) {
        this.removeAllChildren();
        this.groupList = (Vector)this.dataList.get(0);
        this.devList = (Vector)this.dataList.get(1);
        this.boardList = (Vector)this.dataList.get(2);
        Vector<TreeTableNode> devVec = new Vector<TreeTableNode>();
        for (int i = 0; i < this.devList.size(); ++i) {
            TreeTableNode devNodeBase = (TreeTableNode)this.devList.get(i);
            RowData devNodeBaseInfo = (RowData)devNodeBase.getUserObject();
            boolean isExist = false;
            for (int j = 0; j < devVec.size(); ++j) {
                TreeTableNode devNode = (TreeTableNode)devVec.get(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                if (devNodeBaseInfo.getDeviceId() != devNodeInfo.getDeviceId()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            devVec.add(devNodeBase);
            super.getRootNode().add(devNodeBase);
        }
        int devCount = super.getRootNode().getChildCount();
        block2: for (int i = 0; i < this.boardList.size(); ++i) {
            TreeTableNode boardNode = (TreeTableNode)this.boardList.get(i);
            RowData boardNodeInfo = (RowData)boardNode.getUserObject();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)super.getRootNode().getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                if (boardNodeInfo.getDeviceId() != devNodeInfo.getDeviceId() || this.bNeedToFilter(boardNodeInfo.toString(), strKeyWord)) continue;
                devNode.add(boardNode);
                continue block2;
            }
        }
        this.updateBoardTree(devCount);
        this.updateTableView();
    }

    private void updateBoardTree(int devCount) {
        for (int i = devCount - 1; i >= 0; --i) {
            TreeTableNode devNode = (TreeTableNode)super.getRootNode().getChildAt(i);
            if (devNode.getChildCount() != 0) continue;
            super.getRootNode().remove(i);
        }
    }

    private void removeAllChildren() {
        TreeTableNode oTreeTableNode = super.getRootNode();
        for (int i = 0; i < oTreeTableNode.getChildCount(); ++i) {
            TreeTableNode oChildTreeTableNode = (TreeTableNode)oTreeTableNode.getChildAt(i);
            oChildTreeTableNode.removeAllChildren();
        }
        oTreeTableNode.removeAllChildren();
    }

    @Override
    public void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RowData nodeInfo = (RowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon = null;
            if (!nodeInfo.getIsSelect()) {
                if (nodeInfo.getNodeType() == 3) {
                    m_oSelectIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                } else {
                    int boardCount = node.getChildCount();
                    boolean allNotSelected = true;
                    for (int i = 0; i < boardCount; ++i) {
                        TreeTableNode boardNode = (TreeTableNode)node.getChildAt(i);
                        RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                        if (!boardNodeInfo.getIsSelect()) continue;
                        allNotSelected = false;
                        break;
                    }
                    m_oSelectIcon = !allNotSelected ? ResourceManager.getInstance().getImage("part.gif") : ResourceManager.getInstance().getImage("noneselect.gif");
                }
            } else {
                m_oSelectIcon = ResourceManager.getInstance().getImage("all.gif");
            }
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }

    public void removeDataToTable(TreeTableNode node) {
        RowData nodeInfo = (RowData)node.getUserObject();
        boolean isExist = this.isExistInList(nodeInfo);
        if (isExist) {
            this.newGroupList.remove(node);
            int count = super.getSelectTableModel().getRowCount();
            for (int i = 0; i < count; ++i) {
                if (!super.getSelectTableModel().getValueAt(i, 0).equals(nodeInfo.getDevName()) || !super.getSelectTableModel().getValueAt(i, 1).equals(nodeInfo.getResourceName()) || !super.getSelectTableModel().getValueAt(i, 2).equals(nodeInfo.getResourceType())) continue;
                super.getSelectTableModel().removeRow(i);
                break;
            }
        }
    }

    public void addDataToTable(TreeTableNode node) {
        RowData nodeInfo = (RowData)node.getUserObject();
        boolean isExist = this.isExistInList(nodeInfo);
        if (!isExist) {
            this.newGroupList.add(node);
            Vector<Object> data = new Vector<Object>();
            data.add(nodeInfo.getDevName());
            data.add(nodeInfo.getResourceName());
            data.add(nodeInfo.getResourceType());
            data.add(nodeInfo);
            super.getSelectTableModel().addRow(data);
        }
    }

    private boolean isExistInList(RowData nodeInfo) {
        int count = this.newGroupList.size();
        boolean isExist = false;
        for (int i = 0; i < count; ++i) {
            TreeTableNode baseNode = (TreeTableNode)this.newGroupList.get(i);
            RowData baseNodeInfo = (RowData)baseNode.getUserObject();
            if (baseNodeInfo.getGroupId() != nodeInfo.getGroupId() || baseNodeInfo.getDeviceId() != nodeInfo.getDeviceId() || baseNodeInfo.getBoardId() != nodeInfo.getBoardId()) continue;
            isExist = true;
        }
        return isExist;
    }

    @Override
    public void tree_MousePressed(MouseEvent oMouseEvent) {
        int x = oMouseEvent.getX();
        int arrSelectedRow = super.getTreeTable().getSelectedRow();
        if (arrSelectedRow < 0) {
            return;
        }
        TreePath oTreePath = super.getTreeTable().getTree().getPathForRow(arrSelectedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 2 && (x < 19 || x > 35)) {
            return;
        }
        if (nodeInfo.getNodeType() == 3 && (x < 39 || x > 55)) {
            return;
        }
        if (!nodeInfo.getIsSelect()) {
            if (nodeInfo.getNodeType() == 2) {
                int count = oNode.getChildCount();
                for (int i = 0; i < count; ++i) {
                    TreeTableNode boardNode = (TreeTableNode)oNode.getChildAt(i);
                    RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                    boardNodeInfo.setIsSelect(true);
                    this.addDataToTable(boardNode);
                }
                nodeInfo.setIsSelect(true);
            } else {
                nodeInfo.setIsSelect(true);
                this.addDataToTable(oNode);
                this.checkSelectAllChildBYDev(oNode);
            }
        } else if (nodeInfo.getNodeType() == 2) {
            int count = oNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                TreeTableNode boardNode = (TreeTableNode)oNode.getChildAt(i);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                boardNodeInfo.setIsSelect(false);
                this.removeDataToTable(boardNode);
            }
            nodeInfo.setIsSelect(false);
        } else {
            nodeInfo.setIsSelect(false);
            this.removeDataToTable(oNode);
            TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
            RowData parentNodeInfo = (RowData)parentNode.getUserObject();
            parentNodeInfo.setIsSelect(false);
        }
        super.getTreeTable().updateUI();
        this.handleResNameItemChange(false);
    }

    private void checkSelectAllChildBYDev(TreeTableNode oNode) {
        boolean isSelectAll = true;
        TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
        RowData parentNodeInfo = (RowData)parentNode.getUserObject();
        int boardCount = parentNode.getChildCount();
        for (int i = 0; i < boardCount; ++i) {
            TreeTableNode boardNode = (TreeTableNode)parentNode.getChildAt(i);
            RowData boardNodeInfo = (RowData)boardNode.getUserObject();
            if (boardNodeInfo.getIsSelect()) continue;
            isSelectAll = false;
        }
        if (isSelectAll) {
            parentNodeInfo.setIsSelect(true);
        }
    }

    public void setCancelPressed(boolean bIsCancelPressed) {
        this.m_bIsCancelPressed = bIsCancelPressed;
    }

    public boolean isCancelPressed() {
        return this.m_bIsCancelPressed;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    public void setTreeNodeVisibleBySearchContent(String strKeyWord) {
        this.populateDataInTable(strKeyWord);
        super.getTreeTable().updateUI();
        this.handleResNameItemChange(false);
    }

    private boolean bNeedToFilter(String strBoardName, String strKeyWord) {
        if (null == strKeyWord) {
            return false;
        }
        return !strBoardName.contains(strKeyWord);
    }

    public int getHeardStatus() {
        int iRowCount = super.getRootNode().getChildCount();
        this.m_iSelectionType = 0 == iRowCount ? 2 : (this.m_iNoOfFilesSelected == iRowCount ? 0 : (this.m_iNoOfFilesSelected < iRowCount && this.m_iNoOfFilesSelected != 0 ? 1 : 2));
        return this.m_iSelectionType;
    }

    private void handleResNameItemChange(boolean bALLChange) {
        boolean bAllSelect = false;
        if (0 == this.m_iSelectionType) {
            bAllSelect = false;
        } else if (1 == this.m_iSelectionType || 2 == this.m_iSelectionType) {
            bAllSelect = true;
        }
        this.setHeadStatus(0, bAllSelect, bALLChange);
    }

    private void setHeadStatus(int iColumn, boolean bAllSelect, boolean bALLChange) {
        TreeTableNode oTreeTableNode = super.getRootNode();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = 0;
        if (bALLChange) {
            iTotalCount = oTreeTableNode.getChildCount();
            for (int index = 0; index < iTotalCount; ++index) {
                TreeTableNode oNode = (TreeTableNode)oTreeTableNode.getChildAt(index);
                RowData nodeInfo = (RowData)oNode.getUserObject();
                if (bAllSelect) {
                    iSelectCount = this.selNode(iSelectCount, oNode, nodeInfo);
                    continue;
                }
                iNotSupportCount = this.deSelNode(iNotSupportCount, oNode, nodeInfo);
            }
            this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
        } else {
            this.checkHeaderStatus(oTreeTableNode);
        }
        this.m_oCheckBoxHeader.updateIcon(this.m_iSelectionType);
    }

    private void checkHeaderStatus(TreeTableNode oTreeTableNode) {
        boolean isSelectAll = true;
        boolean isAllDeSelect = true;
        for (int index = 0; index < oTreeTableNode.getChildCount(); ++index) {
            TreeTableNode oChildTreeTableNode = (TreeTableNode)oTreeTableNode.getChildAt(index);
            int iChildCnt = oChildTreeTableNode.getChildCount();
            for (int i = 0; i < iChildCnt; ++i) {
                TreeTableNode boardNode = (TreeTableNode)oChildTreeTableNode.getChildAt(i);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                if (!boardNodeInfo.getIsSelect()) {
                    isSelectAll = false;
                    continue;
                }
                if (!boardNodeInfo.getIsSelect() || !isAllDeSelect) continue;
                isAllDeSelect = false;
            }
        }
        this.m_iSelectionType = isSelectAll ? 0 : (isAllDeSelect ? 2 : 1);
    }

    private int deSelNode(int iNotSupportCount, TreeTableNode oNode, RowData nodeInfo) {
        ++iNotSupportCount;
        if (nodeInfo.getNodeType() == 2) {
            int count = oNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                TreeTableNode boardNode = (TreeTableNode)oNode.getChildAt(i);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                boardNodeInfo.setIsSelect(false);
                this.removeDataToTable(boardNode);
            }
            nodeInfo.setIsSelect(false);
        } else {
            nodeInfo.setIsSelect(false);
            this.removeDataToTable(oNode);
            TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
            RowData parentNodeInfo = (RowData)parentNode.getUserObject();
            parentNodeInfo.setIsSelect(false);
        }
        return iNotSupportCount;
    }

    private int selNode(int iSelectCount, TreeTableNode oNode, RowData nodeInfo) {
        ++iSelectCount;
        if (nodeInfo.getNodeType() == 2) {
            int count = oNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                TreeTableNode boardNode = (TreeTableNode)oNode.getChildAt(i);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                boardNodeInfo.setIsSelect(true);
                this.addDataToTable(boardNode);
            }
            nodeInfo.setIsSelect(true);
        } else {
            nodeInfo.setIsSelect(true);
            this.addDataToTable(oNode);
            this.checkSelectAllChildBYDev(oNode);
        }
        return iSelectCount;
    }

    private void initHeadStatus(int iColumn, int iSelCount, int iUnSupportCount, int iTotalCount) {
        switch (iColumn) {
            case 0: {
                if (iUnSupportCount == iTotalCount) {
                    this.m_iSelectionType = 2;
                    break;
                }
                if (iSelCount == iTotalCount || iSelCount + iUnSupportCount == iTotalCount) {
                    this.m_iSelectionType = 0;
                    break;
                }
                if (iSelCount < iTotalCount && iSelCount != 0) {
                    this.m_iSelectionType = 1;
                    break;
                }
                this.m_iSelectionType = 2;
                break;
            }
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof CheckBoxHeader)) {
                return;
            }
            int iColumnIndex = ((CheckBoxHeader)source).getColumn();
            switch (iColumnIndex) {
                case 0: {
                    NewGroupDlg.this.handleResNameItemChange(true);
                    break;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewGroupDlg.this.m_oSortTreeTable.repaint();
                    NewGroupDlg.this.m_oSortTreeTable.getTableHeader().repaint();
                }
            });
        }
    }
}

