/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GroupTreeTablePanelHelper {
    private static final int NODE_TYPE_IS_DEVICE = 2;
    private static final int NODE_TYPE_IS_GROUP = 1;

    public static void changesGroupName(int iGroupID, TreeTableNode parentNode) {
        int count = parentNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode childNode = (TreeTableNode)parentNode.getChildAt(i);
            RowData childNodeInfo = (RowData)childNode.getUserObject();
            int iOldGroupID = childNodeInfo.getGroupId();
            if (Short.MAX_VALUE == iOldGroupID || iOldGroupID <= iGroupID) continue;
            int iNewGroupID = iOldGroupID - 1;
            int devCount = childNode.getChildCount();
            childNodeInfo.setGroupId(iNewGroupID);
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)childNode.getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                devNodeInfo.setGroupId(iNewGroupID);
                int boardCount = devNode.getChildCount();
                for (int l = 0; l < boardCount; ++l) {
                    TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(l);
                    RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                    boardNodeInfo.setGroupId(iNewGroupID);
                }
            }
            childNodeInfo.setResourceName(ResourceManager.getInstance().getResString("GROUP") + iNewGroupID);
        }
    }

    public static void deleteBoardByTable(Vector deleteBoardList, TreeTableNode rootNode) {
        int delBoardCount = deleteBoardList.size();
        block0: for (int i = 0; i < delBoardCount; ++i) {
            Vector boardInfo = (Vector)deleteBoardList.get(i);
            int delDevId = boardInfo.get(0).hashCode();
            int boardId = boardInfo.get(1).hashCode();
            boolean isDelete = false;
            int groupCount = rootNode.getChildCount();
            for (int j = 0; j < groupCount; ++j) {
                TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(j);
                int devCount = groupNode.getChildCount();
                for (int l = 0; l < devCount; ++l) {
                    TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(l);
                    RowData devNodeInfo = (RowData)devNode.getUserObject();
                    if (delDevId != devNodeInfo.getDeviceId() || !(isDelete = GroupTreeTablePanelHelper.deleteBoardNode(boardId, devNode))) continue;
                    if (!devNode.isLeaf()) break;
                    devNode.removeFromParent();
                    break;
                }
                if (!isDelete) continue;
                if (!groupNode.isLeaf()) continue block0;
                groupNode.removeFromParent();
                int iGroupID = ((RowData)groupNode.getUserObject()).getGroupId();
                GroupTreeTablePanelHelper.changesGroupName(iGroupID, rootNode);
                continue block0;
            }
        }
    }

    public static boolean deleteBoardNode(int boardId, TreeTableNode devNode) {
        boolean isDeleteBoard = false;
        int boardCount = devNode.getChildCount();
        for (int i = 0; i < boardCount; ++i) {
            TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(i);
            RowData boardObject = (RowData)boardNode.getUserObject();
            if (boardId != boardObject.getBoardId()) continue;
            boardNode.removeFromParent();
            isDeleteBoard = true;
            return isDeleteBoard;
        }
        return isDeleteBoard;
    }

    public static void deleteDevByTable(Vector deleteDevList, TreeTableNode rootNode) {
        int delDevCount = deleteDevList.size();
        for (int i = 0; i < delDevCount; ++i) {
            int delDevId = deleteDevList.get(i).hashCode();
            block1: for (int j = 0; j < rootNode.getChildCount(); ++j) {
                TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(j);
                int devCount = groupNode.getChildCount();
                for (int l = 0; l < devCount; ++l) {
                    TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(l);
                    RowData devNodeInfo = (RowData)devNode.getUserObject();
                    if (delDevId != devNodeInfo.getDeviceId()) continue;
                    devNode.removeFromParent();
                    if (!groupNode.isLeaf()) continue block1;
                    groupNode.removeFromParent();
                    int iGroupID = ((RowData)groupNode.getUserObject()).getGroupId();
                    GroupTreeTablePanelHelper.changesGroupName(iGroupID, rootNode);
                    continue block1;
                }
            }
        }
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeTableNode node = (TreeTableNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeTableNode n = (TreeTableNode)e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    GroupTreeTablePanelHelper.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public static ResourceProgressInfo getProgressInfo(int iDevID, int iSlotID, ITask m_oTask) {
        ResourceProgressInfo oProgressInfo = null;
        DeviceType oTmpDevType = m_oTask.getTemporaryDevType();
        if (null != oTmpDevType) {
            THashSet<Resource> oResourceLst = oTmpDevType.getResources();
            Iterator oResItor = oResourceLst.iterator();
            Resource oResource = null;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                if (null == oResource || oResource.getDeviceID() != iDevID || oResource.getSlotId() != iSlotID) continue;
                oProgressInfo = oResource.getProgressInfo();
                break;
            }
        }
        return oProgressInfo;
    }

    public static int locationByRoot(TreeTableNode oNode, TreeTableNode parentNode) {
        int location = 0;
        int childCount = 0;
        RowData nodeInfo = (RowData)oNode.getUserObject();
        childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TreeTableNode brotherNode = (TreeTableNode)parentNode.getChildAt(i);
            RowData brotherNodeInfo = (RowData)brotherNode.getUserObject();
            if (brotherNodeInfo.getGroupId() != nodeInfo.getGroupId()) continue;
            location = i;
            break;
        }
        return location;
    }

    public static void moveBoardNode(int location, TreeTableNode oNode, TreeTableNode parentNode, TreeTableNode rootNode, boolean isContainsManualResInTask) {
        RowData oNodeInfo;
        int i;
        TreeTableNode oGroupNode = (TreeTableNode)parentNode.getParent();
        TreeTableNode oRootNode = (TreeTableNode)oGroupNode.getParent();
        TreeTableNode oDestGroupNode = (TreeTableNode)oRootNode.getChildAt(location);
        int iDestGroupID = ((RowData)oDestGroupNode.getUserObject()).getGroupId();
        int count = oDestGroupNode.getChildCount();
        RowData parentNodeInfo = (RowData)parentNode.getUserObject();
        int deviceId = parentNodeInfo.getDeviceId();
        int iGroupCount = rootNode.getChildCount();
        block0: for (i = 0; i < count; ++i) {
            TreeTableNode node = (TreeTableNode)oDestGroupNode.getChildAt(i);
            RowData nodeInfo = (RowData)node.getUserObject();
            if (deviceId != nodeInfo.getDeviceId()) continue;
            oNodeInfo = (RowData)oNode.getUserObject();
            if (isContainsManualResInTask) {
                if (iGroupCount == location + 1) {
                    oNodeInfo.setGroupId(Short.MAX_VALUE);
                } else {
                    oNodeInfo.setGroupId(iDestGroupID);
                }
            } else {
                oNodeInfo.setGroupId(iDestGroupID);
            }
            int boradCount = node.getChildCount();
            for (int j = 0; j < boradCount; ++j) {
                TreeTableNode boardNode = (TreeTableNode)node.getChildAt(j);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                if (boardNodeInfo.getBoardId() > oNodeInfo.getBoardId()) {
                    node.insert(oNode, j);
                    break block0;
                }
                if (j != boradCount - 1) continue;
                node.add(oNode);
                break block0;
            }
            break;
        }
        if (i >= count) {
            RowData devNodeInfo = new RowData(location + 1, parentNodeInfo.getDeviceId(), parentNodeInfo.getDevName(), parentNodeInfo, 2);
            TreeTableNode devNode = new TreeTableNode(devNodeInfo);
            oNodeInfo = (RowData)oNode.getUserObject();
            if (isContainsManualResInTask) {
                iDestGroupID = ((RowData)oDestGroupNode.getUserObject()).getGroupId() == Short.MAX_VALUE ? Short.MAX_VALUE : location + 1;
            }
            oNodeInfo.setGroupId(iDestGroupID);
            int size = oDestGroupNode.getChildCount();
            for (int f = 0; f < size; ++f) {
                TreeTableNode node = (TreeTableNode)oDestGroupNode.getChildAt(f);
                RowData nodeInfo = (RowData)node.getUserObject();
                if (nodeInfo.getOrder() > devNodeInfo.getOrder()) {
                    ((RowData)devNode.getUserObject()).setGroupId(iDestGroupID);
                    oDestGroupNode.insert(devNode, f);
                    break;
                }
                if (f != size - 1) continue;
                ((RowData)devNode.getUserObject()).setGroupId(iDestGroupID);
                oDestGroupNode.add(devNode);
                break;
            }
            if (0 == size) {
                ((RowData)devNode.getUserObject()).setGroupId(iDestGroupID);
                oDestGroupNode.add(devNode);
            }
            devNode.add(oNode);
        }
    }

    public static void moveDeviceNode(int location, JTree oJTree, TreeTableNode oNode, TreeTableNode parentNode, TreeTableNode rootNode, boolean isContainsManualResInTask) {
        TreeTableNode oRootNode = (TreeTableNode)parentNode.getParent();
        TreeTableNode oDestGroupNode = (TreeTableNode)oRootNode.getChildAt(location);
        int iDestGroupID = ((RowData)oDestGroupNode.getUserObject()).getGroupId();
        RowData oDeviceNode = (RowData)oNode.getUserObject();
        int iDeviceId = oDeviceNode.getDeviceId();
        int iGroupCount = oDestGroupNode.getChildCount();
        boolean isDestDeviceNodeExist = false;
        for (int i = 0; i < iGroupCount; ++i) {
            TreeTableNode node = (TreeTableNode)oDestGroupNode.getChildAt(i);
            RowData oDevNodeInfo = (RowData)node.getUserObject();
            if (iDeviceId != oDevNodeInfo.getDeviceId()) continue;
            isDestDeviceNodeExist = true;
            while (oNode.getChildCount() > 0) {
                Enumeration<TreeNode> oChildEnum = oNode.breadthFirstEnumeration();
                while (oChildEnum.hasMoreElements()) {
                    TreeTableNode oBoardNode = (TreeTableNode)oChildEnum.nextElement();
                    if (((RowData)oBoardNode.getUserObject()).getNodeType() == 2) continue;
                    GroupTreeTablePanelHelper.moveBoardNode(location, oBoardNode, oNode, rootNode, isContainsManualResInTask);
                }
            }
        }
        if (!isDestDeviceNodeExist) {
            Enumeration<TreeNode> oChildEnum = oNode.breadthFirstEnumeration();
            while (oChildEnum.hasMoreElements()) {
                TreeTableNode oBoardNode = (TreeTableNode)oChildEnum.nextElement();
                RowData oNodeInfo = (RowData)oBoardNode.getUserObject();
                oNodeInfo.setGroupId(iDestGroupID);
            }
            oDestGroupNode.add(oNode);
            TreePath trePath = new TreePath(oNode.getPath());
            GroupTreeTablePanelHelper.expandAll(oJTree, trePath, true);
        }
    }

    public static void moveGroupNode(int location, TreeTableNode parentNode, TreeTableNode oNode) {
        Vector<TreeTableNode> nodeList = new Vector<TreeTableNode>();
        TreeTableNode lastNode = (TreeTableNode)parentNode.getChildAt(location);
        while (oNode.getChildCount() > 0) {
            TreeTableNode m_oNode;
            RowData m_oNodeInfo;
            int m;
            int j;
            TreeTableNode childNode = (TreeTableNode)oNode.getChildAt(0);
            RowData childNodeInfo = (RowData)childNode.getUserObject();
            int deviceId = childNodeInfo.getDeviceId();
            int count = lastNode.getChildCount();
            for (j = 0; j < count; ++j) {
                int l;
                TreeTableNode childLastNode = (TreeTableNode)lastNode.getChildAt(j);
                RowData childLastNodeInfo = (RowData)childLastNode.getUserObject();
                if (deviceId != childLastNodeInfo.getDeviceId()) continue;
                nodeList.removeAllElements();
                int grandChildCount = childNode.getChildCount();
                for (l = 0; l < grandChildCount; ++l) {
                    TreeTableNode grandChildNode = (TreeTableNode)childNode.getChildAt(l);
                    RowData grandChildNodeInfo = (RowData)grandChildNode.getUserObject();
                    grandChildNodeInfo.setGroupId(location);
                    nodeList.add(grandChildNode);
                }
                for (l = 0; l < childLastNode.getChildCount(); ++l) {
                    TreeTableNode grandLastChildNode = (TreeTableNode)childLastNode.getChildAt(l);
                    nodeList.add(grandLastChildNode);
                }
                childNode.removeFromParent();
                Comparator comp = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        TreeTableNode p1 = (TreeTableNode)o1;
                        RowData p1Info = (RowData)p1.getUserObject();
                        TreeTableNode p2 = (TreeTableNode)o2;
                        RowData p2Info = (RowData)p2.getUserObject();
                        if (p1Info.getBoardId() > p2Info.getBoardId()) {
                            return 1;
                        }
                        return 0;
                    }
                };
                Collections.sort(nodeList, comp);
                childLastNode.removeAllChildren();
                for (int x = 0; x < nodeList.size(); ++x) {
                    childLastNode.add((TreeTableNode)nodeList.get(x));
                }
                break;
            }
            if (j < count) continue;
            childNode.removeFromParent();
            for (m = 0; m < lastNode.getChildCount() && (m_oNodeInfo = (RowData)(m_oNode = (TreeTableNode)lastNode.getChildAt(m)).getUserObject()).getOrder() <= childNodeInfo.getOrder(); ++m) {
            }
            lastNode.insert(childNode, m);
            childNodeInfo.setGroupId(location);
            int boardCount = childNode.getChildCount();
            for (int n = 0; n < boardCount; ++n) {
                TreeTableNode boardNode = (TreeTableNode)childNode.getChildAt(n);
                RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                boardNodeInfo.setGroupId(location);
            }
        }
        oNode.removeFromParent();
    }

    public static void refreshGroupLstInfo(RowData oRowData, boolean bSelect, ITask oTask) {
        int groupId = oRowData.getGroupId();
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        if (null != oActiveInfo) {
            Vector<ActiveGroupInfo> activeGroupList = oActiveInfo.getGroupList();
            ActiveGroupInfo oGroupInfo = null;
            int iGroupSize = activeGroupList.size();
            for (int i = 0; i < iGroupSize; ++i) {
                oGroupInfo = activeGroupList.get(i);
                if (groupId != oGroupInfo.getGroupId()) continue;
                if (bSelect) {
                    oGroupInfo.setIsPause(1);
                    continue;
                }
                oGroupInfo.setIsPause(0);
            }
        }
    }

    public static void setCellRenderer(JLabel label, Object value) {
        TreeTableNode node = (TreeTableNode)value;
        RowData nodeInfo = (RowData)node.getUserObject();
        if (nodeInfo != null) {
            ImageIcon m_oSelectIcon;
            if (nodeInfo.getNodeType() == 1) {
                m_oSelectIcon = ResourceManager.getInstance().getImage("folderopen.gif");
            } else if (nodeInfo.getNodeType() == 2) {
                int iDevID = nodeInfo.getDeviceId();
                m_oSelectIcon = ResourceManager.getInstance().getNeTypeImage(iDevID);
            } else {
                m_oSelectIcon = nodeInfo.getResetType() == 4 || nodeInfo.getResetType() == 5 ? ResourceManager.getInstance().getImage("ic_slot_" + nodeInfo.getResetType() + ".gif") : ResourceManager.getInstance().getImage("ic_slot_0.gif");
            }
            label.setIcon(m_oSelectIcon);
        }
        label.setText(value.toString());
    }
}

