/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view;

import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupReq;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultGroupActivateForDiffusionReq;
import com.huawei.dc.common.asndatacenter.AsnDCLoadSimulationPackageInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskTypeEnum;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.AutoProgressDlgForOptix;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.GroupTreeTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.ProgressBar;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SwitchTaskAndAsn;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.GroupingAtivePanel;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ActivationPackagePanel
extends GroupingAtivePanel {
    private static final long serialVersionUID = 1737927558489253345L;
    private ITask iTask;
    AsnDCDefaultActiveGroupRsp activeGroupRsp;
    private transient ActiveInfo oActiveInfo = null;
    private DeviceType oSelectedDeviceType = null;
    private THashSet<Resource> oResourceList = null;
    private Vector deleteDevList = new Vector();
    private Vector addDevList = new Vector();
    private static int PAUSE_BEFORE_CRRENT_GROUP_INDEX_DIFFUSION_TASK = 3;
    private static int PAUSE_BEFORE_CRRENT_GROUP_INDEX_SIMULATION_TASK = 3;
    private String strLoadPackagePath = "";

    public ActivationPackagePanel(ITask iTask, int taskType) {
        this(iTask, taskType, taskType);
    }

    public ActivationPackagePanel(ITask iTask, int iContext, int taskType) {
        super(taskType);
        this.iTask = iTask;
        this.oSelectedDeviceType = iTask.getSelectedDeviceType();
        this.oResourceList = this.oSelectedDeviceType.getResources();
        if (iTask.getActivationInfo() != null) {
            this.oActiveInfo = iTask.getActivationInfo();
            if (iTask.getTaskTypeId() == 5 || iTask.getTaskTypeId() == 12) {
                LoadFileInfoListParam loadPackageList = iTask.getLoadFileInfoListParam();
                LoadFileInfo fileList = loadPackageList.getLoadFileInfo(0);
                this.strLoadPackagePath = fileList.getFileName();
            } else {
                this.strLoadPackagePath = iTask.getLoadAllPath(0, iTask.getLoadSimPackageInfo());
            }
            this.oActiveInfo.setLoadPackagePath(this.strLoadPackagePath);
            this.startTime = this.oActiveInfo.getStartTime();
            if (null != this.startTime) {
                TimeDateFormatUtil.switchLocalCalendar((Calendar)this.startTime);
                this.setStartTime(this.startTime);
            }
            if (!this.oActiveInfo.getFilePath().equals("")) {
                this.filePath = this.oActiveInfo.getFilePath();
                this.setFilePath(this.filePath);
            }
        }
        this.createGroupTablePan();
        if ((iTask.getTaskTypeId() == 5 || iTask.getTaskTypeId() == 12) && iContext == 1) {
            this.groupTablePan.addBoardCheckOutToPanel();
        }
        if (0 == iContext) {
            this.updateStatisticTable(iTask.getActivationInfo());
        }
    }

    @Override
    public void createGroupTablePan() {
        this.groupTablePan = new GroupTreeTablePanel(this.oActiveInfo, this.iTask);
        if (this.iTask.getTaskTypeId() == 5 || this.iTask.getTaskTypeId() == 12) {
            this.groupTablePan.getTaskTreeTable().getColumnModel().getColumn(2).setMinWidth(0);
            this.groupTablePan.getTaskTreeTable().getColumnModel().getColumn(2).setPreferredWidth(0);
            this.groupTablePan.getTaskTreeTable().getColumnModel().getColumn(2).setMaxWidth(0);
            this.groupTablePan.setPauseBeforeCurrentGroupIndex(PAUSE_BEFORE_CRRENT_GROUP_INDEX_DIFFUSION_TASK);
        } else {
            this.groupTablePan.setPauseBeforeCurrentGroupIndex(PAUSE_BEFORE_CRRENT_GROUP_INDEX_SIMULATION_TASK);
        }
        this.setOrderJLabelPlaceForBoardLevel();
        if (this.iTask.getTaskTypeId() == 3) {
            super.setTablePanForSimBoardLevel();
        } else {
            super.setTablePanForBoardLevel();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivationPackagePanel.this.groupTablePan.updateUI();
            }
        });
    }

    @Override
    public void activeGroupButtonAction() {
        DeviceType oSelectedDeviceType = this.iTask.getSelectedDeviceType();
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        ValidationResult validate = super.validateFilePath();
        if (validate.getErrorCode() != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), validate.getErrorMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.activeGroupRsp = this.iTask.getTaskTypeId() == 5 || this.iTask.getTaskTypeId() == 12 ? this.getGroupInfoForDiffusionTaskRsp(oResourceList) : this.getGroupInfoRsp(oResourceList);
        if (this.activeGroupRsp == null) {
            return;
        }
        if (this.activeGroupRsp != null) {
            AsnDCActivationGroupLst activeGroupList = this.activeGroupRsp.oActiveGroupLst;
            this.addManualActivateGroup(activeGroupList);
            AsnDCActivationGroupInfo oAsnDCActivationGroupInfo = new AsnDCActivationGroupInfo();
            oAsnDCActivationGroupInfo.oActiveGroupLst = activeGroupList;
            SwitchTaskAndAsn.getSwitchTaskAndAsn().switchAsnToTaskByActive(oAsnDCActivationGroupInfo, this.iTask);
            Vector<ActiveGroupInfo> activeGroupInfoList = this.iTask.getActivationInfo().getGroupList();
            for (ActiveGroupInfo activeGroupInfo : activeGroupInfoList) {
                activeGroupInfo.setIsPause(1);
            }
            this.iTask.getActivationInfo().setLoadPackagePath(this.strLoadPackagePath);
            ((GroupTreeTablePanel)this.groupTablePan).populateDeviceInTable(this.iTask.getActivationInfo());
            if (this.iTask.getTaskTypeId() == 3) {
                this.updateStatisticTable(this.iTask.getActivationInfo());
            }
        }
    }

    private AsnDCDefaultActiveGroupRsp getGroupInfoForDiffusionTaskRsp(THashSet<Resource> resourceList) {
        AsnDCDefaultGroupActivateForDiffusionReq req = new AsnDCDefaultGroupActivateForDiffusionReq();
        Iterator oResItor = resourceList.iterator();
        Resource devInfo = null;
        while (oResItor.hasNext()) {
            devInfo = (Resource)oResItor.next();
            BigInteger devId = BigInteger.valueOf(devInfo.getDeviceID());
            req.arrDeviceIds.add((Object)devId);
        }
        req.enTaskType = new AsnTaskTypeEnum(this.iTask.getTaskTypeId());
        if (super.getSelectFileCheckBoc().isSelected()) {
            req.strGroupFilePath = super.getFileTextField().getText().getBytes();
        }
        LoadFileInfoListParam loadPackageList = this.iTask.getLoadFileInfoListParam();
        LoadFileInfo fileList = loadPackageList.getLoadFileInfo(0);
        this.strLoadPackagePath = fileList.getFileName();
        req.strPkgDiffutionFilePath = this.strLoadPackagePath.getBytes();
        req.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        this.activeGroupRspTemp = new AsnDCDefaultActiveGroupRsp();
        this.startProcessBar();
        TaskAsynCommController.getInstance().getGroupInfoForDiffusionTaskRsp(req, this);
        return this.activeGroupRspTemp;
    }

    private AsnDCDefaultActiveGroupRsp getGroupInfoRsp(THashSet<Resource> resourceList) {
        AsnDCDefaultActiveGroupReq groupReq = new AsnDCDefaultActiveGroupReq();
        Iterator oResItor = resourceList.iterator();
        Resource devInfo = null;
        while (oResItor.hasNext()) {
            devInfo = (Resource)oResItor.next();
            BigInteger devId = BigInteger.valueOf(devInfo.getDeviceID());
            groupReq.arrDeviceIds.add((Object)devId);
        }
        groupReq.enTaskType = new AsnTaskTypeEnum(this.iTask.getTaskTypeId());
        groupReq.strGroupFilePath = super.getSelectFileCheckBoc().isSelected() ? super.getFileTextField().getText().getBytes() : "".getBytes();
        AsnDCLoadSimulationPackageInfo oSimulationPackage = new AsnDCLoadSimulationPackageInfo();
        SwitchTaskAndAsn.getSwitchTaskAndAsn().switchTaskToAsnByLoad(oSimulationPackage, this.iTask);
        groupReq.oSimulationPackage = oSimulationPackage;
        this.strLoadPackagePath = this.iTask.getLoadAllPath(0, this.iTask.getLoadSimPackageInfo());
        groupReq.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        this.activeGroupRspTemp = new AsnDCDefaultActiveGroupRsp();
        this.startProcessBar();
        TaskAsynCommController.getInstance().getGroupInfoForSimulationPkgTask(groupReq, this);
        return this.activeGroupRspTemp;
    }

    private void startProcessBar() {
        this.m_oprogressDlg = new AutoProgressDlgForOptix(this, ResourceManager.getInstance().getResString("GET_DEFAULT_ACTIVATION_GROUP_PROGRESS_DLG_TITLE_WITH_PROGRESS"));
        this.m_oprogressDlg.setCanCencleEnable(!this.isHasWarn());
        DeviceType oSelectedDeviceType = this.iTask.getSelectedDeviceType();
        THashSet<Resource> oResourceList = oSelectedDeviceType.getResources();
        int devCount = oResourceList.size();
        this.m_oProgressbar = new ProgressBar(this.m_oprogressDlg, devCount);
        this.m_oProgressbar.setThreadStop(false);
        this.m_oProgressbar.setName("DeviceOperation_ActivationPackagePanel_m_oProgressbar");
        this.m_oProgressbar.start();
    }

    public void updateGroupingConfigurationForDiffusion() {
        if (this.groupTablePan.getRootNode().getChildCount() == 0) {
            return;
        }
        boolean isUpdataLoadPackage = this.isUpdataLoadPackage();
        boolean isUpdataForDel = false;
        boolean isUpdataForAdd = false;
        if (!isUpdataLoadPackage) {
            isUpdataForDel = this.isDeleteDeviceForDiffusion();
            isUpdataForAdd = this.isAddDeviceForDiffusion();
        }
        if (isUpdataLoadPackage || isUpdataForDel || isUpdataForAdd) {
            this.setHasWarn(false);
            this.activeGroupButtonAction();
            this.fillData();
        }
    }

    public boolean isDeleteDeviceForDiffusion() {
        this.refreshResourceList();
        boolean isUpdate = false;
        this.deleteDevList.removeAllElements();
        TreeTableNode oRoot = this.groupTablePan.getRootNode();
        int groupCount = oRoot.getChildCount();
        for (int i = 0; i < groupCount; ++i) {
            TreeTableNode groupNode = (TreeTableNode)oRoot.getChildAt(i);
            int devCount = groupNode.getChildCount();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                RowData devObject = (RowData)devNode.getUserObject();
                boolean isExistDev = false;
                Iterator oResItor = this.oResourceList.iterator();
                Resource devInfo = null;
                while (oResItor.hasNext()) {
                    devInfo = (Resource)oResItor.next();
                    if (devObject.getDeviceId() != devInfo.getDeviceID()) continue;
                    isExistDev = true;
                    break;
                }
                if (isExistDev) continue;
                this.addDevIdToDeleteList(devObject.getDeviceId());
                isUpdate = true;
            }
        }
        return isUpdate;
    }

    public boolean isAddDeviceForDiffusion() {
        this.refreshResourceList();
        boolean isUpdate = false;
        this.addDevList.removeAllElements();
        TreeTableNode oRoot = this.groupTablePan.getRootNode();
        Iterator oResItor = this.oResourceList.iterator();
        Resource devInfo = null;
        while (oResItor.hasNext()) {
            boolean isAdd = true;
            devInfo = (Resource)oResItor.next();
            int groupCount = oRoot.getChildCount();
            for (int j = 0; j < groupCount; ++j) {
                TreeTableNode groupNode = (TreeTableNode)oRoot.getChildAt(j);
                int devCount = groupNode.getChildCount();
                for (int l = 0; l < devCount; ++l) {
                    TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(l);
                    RowData devObject = (RowData)devNode.getUserObject();
                    if (devObject.getDeviceId() != devInfo.getDeviceID()) continue;
                    isAdd = false;
                    break;
                }
                if (!isAdd) break;
            }
            if (!isAdd) continue;
            this.addDevList.add(devInfo.getDeviceID());
            isUpdate = true;
        }
        return isUpdate;
    }

    public void updateGroupingConfiguration() {
        if (this.groupTablePan.getRootNode().getChildCount() == 0) {
            return;
        }
        if (this.iTask.isUpdateLoadOperation()) {
            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PATH_UPDATE_WARNING_FOR_GROUPING"), true);
            this.setHasWarn(true);
            this.activeGroupButtonAction();
            this.fillData();
        }
        this.iTask.setUpdateLoadOperation(false);
        LoadSimPackageInfo m_oLoadSimPackageInfo = (LoadSimPackageInfo)CloneUtil.getClone(this.iTask.getLoadSimPackageInfo());
        this.iTask.setTemporaryLoadSimPackageInfo(m_oLoadSimPackageInfo);
    }

    public boolean isUpdataLoadPackage() {
        String loadPackagePath = "";
        if (this.iTask.getTaskTypeId() == 5 || this.iTask.getTaskTypeId() == 12) {
            LoadFileInfoListParam loadPackageList = this.iTask.getLoadFileInfoListParam();
            LoadFileInfo fileList = loadPackageList.getLoadFileInfo(0);
            loadPackagePath = fileList.getFileName();
        } else {
            this.strLoadPackagePath = this.iTask.getLoadAllPath(0, this.iTask.getLoadSimPackageInfo());
        }
        return !Collator.getInstance().equals(this.strLoadPackagePath, loadPackagePath);
    }

    public void refreshResourceList() {
        this.oSelectedDeviceType = this.iTask.getSelectedDeviceType();
        this.oResourceList = this.oSelectedDeviceType.getResources();
    }

    private void addDevIdToDeleteList(int devId) {
        boolean isExist = false;
        int deleteListCount = this.deleteDevList.size();
        for (int i = 0; i < deleteListCount; ++i) {
            int deviceId = this.deleteDevList.get(i).hashCode();
            if (devId != deviceId) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.deleteDevList.add(devId);
        }
    }

    public void fillData() {
        ActiveInfo activeInfo = new ActiveInfo();
        TreeTableNode rootNode = this.groupTablePan.getRootNode();
        int groupCount = rootNode.getChildCount();
        if (groupCount == 0) {
            return;
        }
        Vector<ActiveGroupInfo> groupList = new Vector<ActiveGroupInfo>();
        for (int i = 0; i < groupCount; ++i) {
            TreeTableNode groupNode = (TreeTableNode)rootNode.getChildAt(i);
            RowData groupNodeInfo = (RowData)groupNode.getUserObject();
            ActiveGroupInfo groupInfo = new ActiveGroupInfo();
            groupInfo.setGroupId(groupNodeInfo.getGroupId());
            if (groupNodeInfo.getPause().getIsSelect()) {
                groupInfo.setIsPause(1);
            } else {
                groupInfo.setIsPause(0);
            }
            int devCount = groupNode.getChildCount();
            Vector<ActiveDevInfo> devList = new Vector<ActiveDevInfo>();
            for (int j = 0; j < devCount; ++j) {
                TreeTableNode devNode = (TreeTableNode)groupNode.getChildAt(j);
                RowData devNodeInfo = (RowData)devNode.getUserObject();
                ActiveDevInfo devInfo = new ActiveDevInfo();
                devInfo.setDevId(devNodeInfo.getDeviceId());
                devInfo.setOrder(devNodeInfo.getOrder());
                devInfo.setDevName(devNodeInfo.getDevName());
                int boardCount = devNode.getChildCount();
                Vector<ActiveBoardInfo> boardList = new Vector<ActiveBoardInfo>();
                for (int l = 0; l < boardCount; ++l) {
                    TreeTableNode boardNode = (TreeTableNode)devNode.getChildAt(l);
                    RowData boardNodeInfo = (RowData)boardNode.getUserObject();
                    ActiveBoardInfo boardInfo = new ActiveBoardInfo();
                    boardInfo.setSlotId(boardNodeInfo.getBoardId());
                    boardInfo.setSlotLabel(boardNodeInfo.getBoardLabel());
                    boardInfo.setBoardType(boardNodeInfo.getBoardType());
                    if (boardNodeInfo.getIsDeleteDatabase()) {
                        boardInfo.setIsDeleteDatabase(1);
                    } else {
                        boardInfo.setIsDeleteDatabase(0);
                    }
                    boardInfo.setActiveDeviceMode(boardNodeInfo.getIsInterruptService());
                    boardInfo.setResourceType(boardNodeInfo.getResourceType());
                    boardList.add(boardInfo);
                }
                devInfo.setBoardList(boardList);
                devList.add(devInfo);
            }
            groupInfo.setActivationInfoLst(devList);
            groupList.add(groupInfo);
        }
        activeInfo.setGroupList(groupList);
        if (super.getActiveTimeCheckBoc().isSelected()) {
            activeInfo.setStartTime(this.oStartimeCal);
        }
        if (super.getSelectFileCheckBoc().isSelected() && super.getPath() != null) {
            activeInfo.setFilePath(super.getPath());
        }
        activeInfo.setLoadPackagePath(this.strLoadPackagePath);
        this.iTask.setActivationInfo(activeInfo);
        if (this.iTask.getTaskTypeId() == 5 || this.iTask.getTaskTypeId() == 12) {
            this.createTemporaryDevType();
        }
    }

    private void createTemporaryDevType() {
        DeviceType devType = this.iTask.getTemporaryDevType();
        THashSet oResHs = new THashSet();
        ActiveInfo activeInfo = this.iTask.getActivationInfo();
        Vector<ActiveGroupInfo> groupList = activeInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            Vector devList = groupInfo.getActivationInfoLst();
            int deviceCount = devList.size();
            for (int j = 0; j < deviceCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int l = 0; l < boardCount; ++l) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    Resource resource = new Resource();
                    resource.setDeviceID(devInfo.getDevId());
                    IDeviceInfoManager devInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
                    DeviceInfo deviceInfo = devInfoManager.getDevice(devInfo.getDevId());
                    resource.setDeviceIP(deviceInfo.getDevIPAddress());
                    resource.setDeviceName(devInfo.getDevName());
                    resource.setDeviceVersion(deviceInfo.getDevVersion().getDevVersion());
                    resource.setFrameId(0);
                    resource.setSlotId(boardInfo.getSlotId());
                    oResHs.add((Object)resource);
                }
            }
        }
        devType.setResources((THashSet<Resource>)oResHs);
        this.iTask.setTemporaryDevType(devType);
    }

    public void updateActivateTable() {
        this.groupTablePan.updateTableView();
    }

    private void addManualActivateGroup(AsnDCActivationGroupLst activeGroupList) {
    }
}

